$.browser.chrome = /chrome/.test(navigator.userAgent.toLowerCase());

!function(a){"use strict";function b(a,c){if(!(this instanceof b)){var d=new b(a,c);return d.open(),d}this.id=b.id++,this.setup(a,c),this.chainCallbacks(b._callbackChain)}if("undefined"==typeof a)return void("console"in window&&window.console.info("Too much lightness, Featherlight needs jQuery."));var c=[],d=function(b){return c=a.grep(c,function(a){return a!==b&&a.$instance.closest("body").length>0})},e=function(a,b){var c={},d=new RegExp("^"+b+"([A-Z])(.*)");for(var e in a){var f=e.match(d);if(f){var g=(f[1]+f[2].replace(/([A-Z])/g,"-$1")).toLowerCase();c[g]=a[e]}}return c},f={keyup:"onKeyUp",resize:"onResize"},g=function(c){a.each(b.opened().reverse(),function(){return c.isDefaultPrevented()||!1!==this[f[c.type]](c)?void 0:(c.preventDefault(),c.stopPropagation(),!1)})},h=function(c){if(c!==b._globalHandlerInstalled){b._globalHandlerInstalled=c;var d=a.map(f,function(a,c){return c+"."+b.prototype.namespace}).join(" ");a(window)[c?"on":"off"](d,g)}};b.prototype={constructor:b,namespace:"featherlight",targetAttr:"data-featherlight",variant:null,resetCss:!1,background:null,openTrigger:"click",closeTrigger:"click",filter:null,root:"body",openSpeed:250,closeSpeed:250,closeOnClick:"background",closeOnEsc:!0,closeIcon:"&#10005;",loading:"",persist:!1,otherClose:null,beforeOpen:a.noop,beforeContent:a.noop,beforeClose:a.noop,afterOpen:a.noop,afterContent:a.noop,afterClose:a.noop,onKeyUp:a.noop,onResize:a.noop,type:null,contentFilters:["jquery","image","html","ajax","iframe","text"],setup:function(b,c){"object"!=typeof b||b instanceof a!=!1||c||(c=b,b=void 0);var d=a.extend(this,c,{target:b}),e=d.resetCss?d.namespace+"-reset":d.namespace,f=a(d.background||['<div class="'+e+"-loading "+e+'">','<div class="'+e+'-content">','<span class="'+e+"-close-icon "+d.namespace+'-close">',d.closeIcon,"</span>",'<div class="'+d.namespace+'-inner">'+d.loading+"</div>","</div>","</div>"].join("")),g="."+d.namespace+"-close"+(d.otherClose?","+d.otherClose:"");return d.$instance=f.clone().addClass(d.variant),d.$instance.on(d.closeTrigger+"."+d.namespace,function(b){var c=a(b.target);("background"===d.closeOnClick&&c.is("."+d.namespace)||"anywhere"===d.closeOnClick||c.closest(g).length)&&(d.close(b),b.preventDefault())}),this},getContent:function(){if(this.persist!==!1&&this.$content)return this.$content;var b=this,c=this.constructor.contentFilters,d=function(a){return b.$currentTarget&&b.$currentTarget.attr(a)},e=d(b.targetAttr),f=b.target||e||"",g=c[b.type];if(!g&&f in c&&(g=c[f],f=b.target&&e),f=f||d("href")||"",!g)for(var h in c)b[h]&&(g=c[h],f=b[h]);if(!g){var i=f;if(f=null,a.each(b.contentFilters,function(){return g=c[this],g.test&&(f=g.test(i)),!f&&g.regex&&i.match&&i.match(g.regex)&&(f=i),!f}),!f)return"console"in window&&window.console.error("Featherlight: no content filter found "+(i?' for "'+i+'"':" (no target specified)")),!1}return g.process.call(b,f)},setContent:function(b){var c=this;return(b.is("iframe")||a("iframe",b).length>0)&&c.$instance.addClass(c.namespace+"-iframe"),c.$instance.removeClass(c.namespace+"-loading"),c.$instance.find("."+c.namespace+"-inner").not(b).slice(1).remove().end().replaceWith(a.contains(c.$instance[0],b[0])?"":b),c.$content=b.addClass(c.namespace+"-inner"),c},open:function(b){var d=this;if(d.$instance.hide().appendTo(d.root),!(b&&b.isDefaultPrevented()||d.beforeOpen(b)===!1)){b&&b.preventDefault();var e=d.getContent();if(e)return c.push(d),h(!0),d.$instance.fadeIn(d.openSpeed),d.beforeContent(b),a.when(e).always(function(a){d.setContent(a),d.afterContent(b)}).then(d.$instance.promise()).done(function(){d.afterOpen(b)})}return d.$instance.detach(),a.Deferred().reject().promise()},close:function(b){var c=this,e=a.Deferred();return c.beforeClose(b)===!1?e.reject():(0===d(c).length&&h(!1),c.$instance.fadeOut(c.closeSpeed,function(){c.$instance.detach(),c.afterClose(b),e.resolve()})),e.promise()},chainCallbacks:function(b){for(var c in b)this[c]=a.proxy(b[c],this,a.proxy(this[c],this))}},a.extend(b,{id:0,autoBind:"[data-featherlight]",defaults:b.prototype,contentFilters:{jquery:{regex:/^[#.]\w/,test:function(b){return b instanceof a&&b},process:function(b){return this.persist!==!1?a(b):a(b).clone(!0)}},image:{regex:/\.(png|jpg|jpeg|gif|tiff|bmp|svg)(\?\S*)?$/i,process:function(b){var c=this,d=a.Deferred(),e=new Image,f=a('<img src="'+b+'" alt="" class="'+c.namespace+'-image" />');return e.onload=function(){f.naturalWidth=e.width,f.naturalHeight=e.height,d.resolve(f)},e.onerror=function(){d.reject(f)},e.src=b,d.promise()}},html:{regex:/^\s*<[\w!][^<]*>/,process:function(b){return a(b)}},ajax:{regex:/./,process:function(b){var c=a.Deferred(),d=a("<div></div>").load(b,function(a,b){"error"!==b&&c.resolve(d.contents()),c.fail()});return c.promise()}},iframe:{process:function(b){var c=new a.Deferred,d=a("<iframe/>").hide().attr("src",b).css(e(this,"iframe")).on("load",function(){c.resolve(d.show())}).appendTo(this.$instance.find("."+this.namespace+"-content"));return c.promise()}},text:{process:function(b){return a("<div>",{text:b})}}},functionAttributes:["beforeOpen","afterOpen","beforeContent","afterContent","beforeClose","afterClose"],readElementConfig:function(b,c){var d=this,e=new RegExp("^data-"+c+"-(.*)"),f={};return b&&b.attributes&&a.each(b.attributes,function(){var b=this.name.match(e);if(b){var c=this.value,g=a.camelCase(b[1]);if(a.inArray(g,d.functionAttributes)>=0)c=new Function(c);else try{c=a.parseJSON(c)}catch(h){}f[g]=c}}),f},extend:function(b,c){var d=function(){this.constructor=b};return d.prototype=this.prototype,b.prototype=new d,b.__super__=this.prototype,a.extend(b,this,c),b.defaults=b.prototype,b},attach:function(b,c,d){var e=this;"object"!=typeof c||c instanceof a!=!1||d||(d=c,c=void 0),d=a.extend({},d);var f,g=d.namespace||e.defaults.namespace,h=a.extend({},e.defaults,e.readElementConfig(b[0],g),d);return b.on(h.openTrigger+"."+h.namespace,h.filter,function(g){var i=a.extend({$source:b,$currentTarget:a(this)},e.readElementConfig(b[0],h.namespace),e.readElementConfig(this,h.namespace),d),j=f||a(this).data("featherlight-persisted")||new e(c,i);"shared"===j.persist?f=j:j.persist!==!1&&a(this).data("featherlight-persisted",j),i.$currentTarget.blur(),j.open(g)}),b},current:function(){var a=this.opened();return a[a.length-1]||null},opened:function(){var b=this;return d(),a.grep(c,function(a){return a instanceof b})},close:function(a){var b=this.current();return b?b.close(a):void 0},_onReady:function(){var b=this;b.autoBind&&(a(b.autoBind).each(function(){b.attach(a(this))}),a(document).on("click",b.autoBind,function(c){c.isDefaultPrevented()||"featherlight"===c.namespace||(c.preventDefault(),b.attach(a(c.currentTarget)),a(c.target).trigger("click.featherlight"))}))},_callbackChain:{onKeyUp:function(b,c){return 27===c.keyCode?(this.closeOnEsc&&a.featherlight.close(c),!1):b(c)},onResize:function(a,b){if(this.$content.naturalWidth){var c=this.$content.naturalWidth,d=this.$content.naturalHeight;this.$content.css("width","").css("height","");var e=Math.max(c/parseInt(this.$content.parent().css("width"),10),d/parseInt(this.$content.parent().css("height"),10));e>1&&this.$content.css("width",""+c/e+"px").css("height",""+d/e+"px")}return a(b)},afterContent:function(a,b){var c=a(b);return this.onResize(b),c}}}),a.featherlight=b,a.fn.featherlight=function(a,c){return b.attach(this,a,c)},a(document).ready(function(){b._onReady()})}(jQuery);
(function(){var a,b,c,d,e,f,g,h,i;if(c={version:"2.3.3",name:"jQuery-runner"},g=this.jQuery||this.Zepto||this.$,!g||!g.fn)throw new Error("["+c.name+"] jQuery or jQuery-like library is required for this plugin to work");e={},d=function(a){return(10>a?"0":"")+a},i=1,f=function(){return"runner"+i++},h=function(a,b){return a["r"+b]||a["webkitR"+b]||a["mozR"+b]||a["msR"+b]||function(a){return setTimeout(a,30)}}(this,"equestAnimationFrame"),b=function(a,b){var c,e,f,g,h,i,j,k,l,m,n;for(b=b||{},k=[36e5,6e4,1e3,10],i=["",":",":","."],h="",g="",f=b.milliseconds,e=k.length,l=0,0>a&&(a=Math.abs(a),h="-"),c=m=0,n=k.length;n>m;c=++m)j=k[c],l=0,a>=j&&(l=Math.floor(a/j),a-=l*j),(l||c>1||g)&&(c!==e-1||f)&&(g+=(g?i[c]:"")+d(l));return h+g},a=function(){function a(b,c,d){var h;return this instanceof a?(this.items=b,h=this.id=f(),this.settings=g.extend({},this.settings,c),e[h]=this,b.each(function(a,b){g(b).data("runner",h)}),this.value(this.settings.startAt),void((d||this.settings.autostart)&&this.start())):new a(b,c,d)}return a.prototype.running=!1,a.prototype.updating=!1,a.prototype.finished=!1,a.prototype.interval=null,a.prototype.total=0,a.prototype.lastTime=0,a.prototype.startTime=0,a.prototype.lastLap=0,a.prototype.lapTime=0,a.prototype.settings={autostart:!1,countdown:!1,stopAt:null,startAt:0,milliseconds:!0,format:null},a.prototype.value=function(a){this.items.each(function(b){return function(c,d){var e;c=g(d),e=c.is("input")?"val":"text",c[e](b.format(a))}}(this))},a.prototype.format=function(a){var c;return c=this.settings.format,(c=g.isFunction(c)?c:b)(a,this.settings)},a.prototype.update=function(){var a,b,c,d,e;this.updating||(this.updating=!0,c=this.settings,e=g.now(),d=c.stopAt,a=c.countdown,b=e-this.lastTime,this.lastTime=e,a?this.total-=b:this.total+=b,null!==d&&(a&&this.total<=d||!a&&this.total>=d)&&(this.total=d,this.finished=!0,this.stop(),this.fire("runnerFinish")),this.value(this.total),this.updating=!1)},a.prototype.fire=function(a){this.items.trigger(a,this.info())},a.prototype.start=function(){var a;this.running||(this.running=!0,(!this.startTime||this.finished)&&this.reset(),this.lastTime=g.now(),a=function(b){return function(){b.running&&(b.update(),h(a))}}(this),h(a),this.fire("runnerStart"))},a.prototype.stop=function(){this.running&&(this.running=!1,this.update(),this.fire("runnerStop"))},a.prototype.toggle=function(){this.running?this.stop():this.start()},a.prototype.lap=function(){var a,b;return b=this.lastTime,a=b-this.lapTime,this.settings.countdown&&(a=-a),(this.running||a)&&(this.lastLap=a,this.lapTime=b),b=this.format(this.lastLap),this.fire("runnerLap"),b},a.prototype.reset=function(a){var b;a&&this.stop(),b=g.now(),"number"!=typeof this.settings.startAt||this.settings.countdown||(b-=this.settings.startAt),this.startTime=this.lapTime=this.lastTime=b,this.total=this.settings.startAt,this.value(this.total),this.finished=!1,this.fire("runnerReset")},a.prototype.info=function(){var a;return a=this.lastLap||0,{running:this.running,finished:this.finished,time:this.total,formattedTime:this.format(this.total),startTime:this.startTime,lapTime:a,formattedLapTime:this.format(a),settings:this.settings}},a}(),g.fn.runner=function(b,d,f){var h,i;switch(b||(b="init"),"object"==typeof b&&(f=d,d=b,b="init"),h=this.data("runner"),i=h?e[h]:!1,b){case"init":new a(this,d,f);break;case"info":if(i)return i.info();break;case"reset":i&&i.reset(d);break;case"lap":if(i)return i.lap();break;case"start":case"stop":case"toggle":if(i)return i[b]();break;case"version":return c.version;default:g.error("["+c.name+"] Method "+b+" does not exist")}return this},g.fn.runner.format=b}).call(this);

var syAjaxRunning = false;

$(document).ajaxStart(function(){
	syAjaxRunning = true;
});

$(document).ajaxStop(function(){
	syAjaxRunning = false;
});

$(document).ajaxError(function(event, jqxhr, settings, thrownError) {
	if (jqxhr.status == 403){
		window.location = "/expirationPassed?api="+settings.url+"&from="+window.location.href;
	}
});


// e.g. "anystring".capitalize()   #=> Anystring
String.prototype.capitalize = function() {
  return this.charAt(0).toUpperCase() + this.slice(1);
};

String.prototype.replaceAt = function(index, character) {
    return this.substr(0, index) + character + this.substr(index+1);
};

// e.g. "result".pluralize(2)   #=> results
String.prototype.pluralize = function(count) {
  if (Math.abs(count) == 1)
    return this;
  else
    return this + 's';
};

function symbolab_log(action, info1, info2, initialQuery, origin) {
	if (!initialQuery) {
		initialQuery = null;
	}

	if(!origin) {
		origin = null;
	}

	if (info2 && typeof info2 === "string" && info2.startsWith('MobileWeb')){
		if (typeof(OS) == "undefined" || OS === "") OS = "Unknown";
		info2 = OS + "_" + info2;
	}

	if (typeof(sy_var) != "undefined" && action === "Registration" && info2){
		info2 = "Var" + sy_var + "\t" + info2;
	}

	if (info1 === 'OpenStore') {
		amplitude.track('OpenStore', {
			url: window.location.pathname
		});
	}

	window.navigator.sendBeacon('/detailedLogBeacon', JSON.stringify({
		type: action,
		info1,
		info2,
		query: initialQuery,
		origin
	}));
}

// data should be in the format of: key=value<TAB>key=value...
function amp_log(event, data, force) {
	return $.ajax({
		type: "POST",
		url: "/ampLog",
		data: {
			event: event,
			data: data,
			force: force
		}
	});
}

var NoLocalStorage = function(){};
NoLocalStorage.prototype = {
	getItem: function () {
		return null;
	},
	setItem: function () {
	},
	removeItem: function () {
	}
};
var lsObj = new NoLocalStorage();

// to support browsers that dont allow third parties cookies and access to localStorage
function getLocalStorage(){
	try{

		if(localStorage == null) {
			return lsObj;
		}

		return localStorage;
	} catch (err){

	}

	return lsObj;

}

function syMenu(type, destination){
	destination = destination.replace("/solver/", "");
	symbolab_log("Solutions", "Menu"+type, SOLUTIONS.page + "=>" + destination);
}

function prepareQueryForMathQuill(query) {
	if (query == undefined) return query;

	query = query.replace(/operatorname/g, "text");

	// fixes unneeded space between escape and what comes after it
	query = query.replace(/\\(\w+?)\s+(?={|_|\^|\(|\\)/g, "\\$1");

	query = query.replace(/\\,/g, " ");
	query = query.replace(/(, |,\\:|,)/g, ",\\:");

	// do check the following examples if making changes:
	// laplace\:e^{\frac{t}{2}}
	// geometric\:mean\:\left\{0.42,\:0.52,\:0.58,\:0.62\right\}
	// long\:division\:\frac{121}{19}
	if (query.indexOf('\\{') >= 0) {
		query = query.replace(/\{\\space\}/g, "\\space");
		query = query.replace(/\\left\s*\\\{/g, "\\{");
		query = query.replace(/\\\{/g, "\\left\\{");
		query = query.replace(/\\right\s*\\\}/g, "\\}");
		query = query.replace(/\\\}/g, "\\right\\}");
		query = query.replace(/\\space}/g, "{\\space}");
	}

	query = query.replace(/\\vec\{(.+?)\}/g, "\\vec\{$1 \}");
	query = query.replace(/\\hat\{(.+?)\}/g, "\\hat\{$1 \}");

	query = query.replace(/ /g, "#");

	query = query.replace(/</g, "\\lt ").replace(/>/g, "\\gt ");

	return query;
}
function prepareQueryForMathQuillAndCollectWords(query) {
	query = prepareQueryForMathQuill(query);

	// replace \\mathrm blocks with several \\mathrm blocks separated by spaces
	// (treat blocks with parentheses as single monolithic blocks)
	query = query.replace(/\\mathrm{([^(}]+)}/ig, function (match, words, offset) {
		// capture all words in between
		let allWords = words.split(/\s|\\:/);

		// remove empty words
		let allWordsNoBlanks = allWords.filter(function (word) {
			return word !== "";
		});

		// join all words in \\mathrm pieces with a space in between each one
		let newWords = allWordsNoBlanks.join("}\\:\\mathrm{");
		if (words.endsWith("\\:")) {
			newWords += "\\:";
		}

		let addSpace = "";
		if (offset > 0) {
			addSpace = " ";
		}

		// add to output
		return addSpace + "\\mathrm{" + newWords + "} ";
	});

	return query;
}

function getWidth(element, isRomanToo){
	var width = 0;
		
	if (element.hasClass("block") || element.hasClass("numerator") || element.hasClass("denominator")){
		element.children().each(function() {
			width += getWidth($(this), isRomanToo);
		});
	}
	else if (element.hasClass("fraction")){
		var numWidth = getWidth($(element.children()[0]), isRomanToo);
		var denWidth = getWidth($(element.children()[1]), isRomanToo);
		return Math.max(numWidth+10, denWidth+10);
	}
	else if (element.hasClass("roman")){
		if (isRomanToo){
			element.children().each(function() {
				width += $(this).outerWidth();
			});
		}
	}
	else{
		width = element.outerWidth();
	}

	return width;
}

function getActualWidth(element, isRomanToo){
	var totalWidth = 0;
	$(element).find(".mathquill-embedded-latex").children().each(function() {
		if ($(this).is(":visible:not(.selectable)")){
			totalWidth += getWidth($(this), isRomanToo);
		}
	});
	totalWidth = totalWidth * 1.1;
	return totalWidth;
}

function getGraphInputWidth(element){
	var totalWidth = 0;
	$(element).children().each(function() {
		if ($(this).is(":visible:not(.selectable)")){
			totalWidth += getWidth($(this), true);
		}
	});
	totalWidth = totalWidth * 1.1;
	return totalWidth;
}


function createScrollForce(element, newWidth, newHeight){
	if (!newWidth && !newHeight) return;
	
	var scrollContent = $('<div class="scrollContent" style="background: transparent"></div>');
	if (newWidth)  {
		// the input line can be a couple of lines
		if ($(element).hasClass("solution_scrollable")) {
			scrollContent.css("max-width", newWidth + "px");
		}
		else { // the steps line is one line
			scrollContent.width(newWidth);
		}
	}
	if (newHeight) scrollContent.height(newHeight);
	$(element).children().wrap(scrollContent);
	$(element).addClass("syscrollable");
	$(element).find(".mathquill-embedded-latex").mathquill("redraw");


// 	$(element).addClass("syscrollable");
// 	var scrollableContent = $(element).html();
// 	$(element).html("");
// 	$(element).append('<div class="scrollContent" style="background: transparent"></div>');
// 	var arr = $(element).children(".scrollContent");
// 	var scrollContent = arr[0];
// 	$(scrollContent).append(scrollableContent);
// 	if (newWidth){
// 		$(scrollContent).width(newWidth);
// 	}
// 	if (newHeight){
// 		$(scrollContent).height(newHeight);
// 	}
// 	$(element).find(".mathquill-embedded-latex").mathquill("redraw");
}

function createTableArray(line){
	line = line.replace("\\quad \\quad", "");
	line = line.replace("\\begin{array}", "");
	var summaryline = false;
	if (line.indexOf('\\summaryline') > 0){
		line = line.replace("\\summaryline", "");
		summaryline = true;
	}
	line = line.replace("\\end{array}", "");

	// remove {|c|c|c|c|} column definitions
	line = line.replace(/{\|(c\|)+}/ig, "");
	line = line.replace(/\\hline\s*/gi, " ");

	var div = $("<div style='overflow-x: auto;'></div>");
	var table = $("<table class='tableMatrix'></table>");

	var rows = line.split("\\\\");
	rows.pop();
	var tr;
	for (var i = 0; i < rows.length; i++) {
		var row = rows[i];
		var tr = $("<tr></tr>");

		var columns = row.split("&");
		for (var j = 0; j < columns.length; j++) {
			var column = columns[j];
			var sp = $("<span class='mathquill-embedded-latex'></span>");
			sp.text(column);
			var td = $("<td class='syME'></td>");
			td.append(sp);
			tr.append(td);
		}
		if (summaryline && i === rows.length - 1){
			tr.css('background-color', '#f5f5f5');
			tr.css('color', 'black');
		}
		table.append(tr);
	}

	div.append(table);
	return div;
}

function createTable(line){
	line = line.replace("\\quad \\quad", "");
	line = line.replace("\\begin{table}", "");
	var summaryline = false;
	if (line.indexOf('\\summaryline') > 0){
		line = line.replace("\\summaryline", "");
		summaryline = true;
	}
	line = line.replace("\\end{table}", "");
	
	var div = $("<div style='overflow-x: auto;'></div>");
	var table = $("<table class='tableMatrix'></table>");
	
	var rows = line.split("\\\\");
	rows.pop();
	var tr;
	for (var i = 0; i < rows.length; i++) {
		var row = rows[i];
		var tr = $("<tr></tr>");
		
		var columns = row.split("&");
		columns.pop();
		for (var j = 0; j < columns.length; j++) {
			var column = columns[j];
			var sp = $("<span class='mathquill-embedded-latex'></span>");
			sp.text(column);
			var td = $("<td class='syME'></td>");
			td.append(sp);
			tr.append(td);			
		}
		if (summaryline && i == rows.length - 1){
			tr.css('background-color', '#f5f5f5');
			tr.css('color', 'black');
		}
		table.append(tr);
	}

	div.append(table);
	return div;
}

function createMathquillSpan(classType, content, id){
	if (content === undefined) return $('<span></span>');

	// for mobile practice
	if (typeof content !== 'string') {
		content = content.text.createdText;
	}
	var lines = content.split("<br/>");
	var span;
	if (lines.length === 1) {
		if (content.indexOf("\\begin{table}") >= 0){
			span = createTable(content);
			//span.find('.mathquill-embedded-latex:not(.mathquill-rendered-math)').mathquill();
		}
		else if (content.indexOf("\\begin{array}") >= 0){
			span = createTableArray(content);
			//span.find('.mathquill-embedded-latex:not(.mathquill-rendered-math)').mathquill();
		}
		else {
			content = prepareQueryForMathQuill(content);
			span = $('<span class="' + classType + ' mathquill-embedded-latex"></span>');
			span.text(content);
		}	
		if (id){
			$(span).prop('title', id);
		}
		return span;
	}
	else{
		span = $('<div class="multi-line-span"></div>');
		for (var idx in lines) {
			var line = lines[idx];
			var div = createMathquillDiv(classType, line);
			div.addClass('multiline');
			span.append(div);
		}
		return span;
	}		
}

function createMathquillDiv(classType, content, id, extractTextFromMathquill) {
	const div = $('<div class="' + classType + '"></div>');
	if (extractTextFromMathquill) {
		const mathquillContainer = $("<div>", {class: "mathquill-container"});
		content.split(/(\$\$.*?\$\$)/g)
			.filter(it => it.trim().length !== 0)
			.forEach(it => {
				if (it.startsWith("$$")) {
					mathquillContainer.append(this.createMathquillSpan("", it, id))
				} else {
					mathquillContainer.append(`<span class="text-only">${it}</span>`)
				}
			});
		if (classType === null) {
			return mathquillContainer;
		}
		div.append(mathquillContainer);
	} else {
		div.append(this.createMathquillSpan("", content, id));
	}
	return div;
}

function createMathquillDiv2(classType, content, id){
	var div = $('<div class="' + classType + '"></div>');
	div.append(this.createMathquillSpan("", content, id));
	
	div.find('.mathquill-embedded-latex:not(.mathquill-rendered-math)').each(function(){
		var jq = $(this);
		jq.mathquill();
	});
	
	return div;	
}

function mathquillify(jq) {
	jq.find('.mathquill-embedded-latex:not(.mathquill-rendered-math)').each(function(){
		var jq = $(this);
		jq.mathquill();
	});
}

function mathquillifyRedrawOnly(jq) {
	jq.find('.mathquill-embedded-latex.mathquill-rendered-math').each(function(){
		var jq = $(this);
		jq.mathquill("redraw");
	});
}

function mathquillifyVisible(jq){
	jq.find('.mathquill-embedded-latex:not(.mathquill-rendered-math)').each(function(){
		var jq = $(this);
		if (jq.is(":visible")){
			jq.mathquill();
		}
	});
}

$(function() {
	// month and day are both 1-based
	const latestPrivacyStartDate = new Date(2023, 9, 31);
	const latestPrivacyStartTicks = latestPrivacyStartDate.getTime();

	// month and day are both 1-based
	const latestPrivacyEndDate = new Date(2023, 11, 15)
	const latestPrivacyEndTicks = latestPrivacyEndDate.getTime();

	const privacyAcceptDate = readCookie("sy.privacyAcceptDate");
	const cookieBanner = $(".nl-cookiepolicy");

	let shouldShow = false;

	const now = new Date().getTime();

	if(now >= latestPrivacyEndTicks) {
		shouldShow = false;
	} else {
		if (!privacyAcceptDate) {
			if (window.location.pathname.indexOf("privacy") < 0
				&& window.location.pathname.indexOf("cookie") < 0) {

				shouldShow = true;
			}
		} else {
			const parsedTimestamp = parseInt(privacyAcceptDate);
			if (isNaN(parsedTimestamp) || parsedTimestamp < latestPrivacyStartTicks) {
				shouldShow = true;
			}
		}
	}

	if(shouldShow) {
		cookieBanner.show();
	}

	$(".privacy-policy").click(function() {
		if (allowedCookieGroups("C0003")) {
			createCookie("sy.privacyAcceptDate", now, 30);
		}
		$(".nl-cookiepolicy").remove();
	});

	$("#save-as-bookmark.sign-in-button").click(function() {
		showSignIn("AvatarClicked", "NotebookStickie");
	});

	$("#userName,div#avatar").click(function() {
		showSignIn("AvatarClicked", "Avatar");
	});

	$(":not(#save-as-bookmark):not(#user-name).sign-in-button").click(function() {
		showSignIn("AvatarClicked");
	});

	$("#HomeTopNav span").off("click").on("click", () => {
		getLocalStorage().setItem("linkOrigin", "header");
		window.location.href = "/";
	});

	$("#graphingNav a.gc-examples").off("click").on("click", (e) => {
		if(window.location.href.indexOf("/graphing-calculator") >= 0) {
			e.preventDefault();
			window.location.href = $(e.currentTarget).attr("href");
			window.location.reload();
		}
	});

	$("#geometryNav a.geo-examples").off("click").on("click", (e) => {
		if(window.location.href.indexOf("/geometry-calculator") >= 0) {
			e.preventDefault();
			window.location.href = $(e.currentTarget).attr("href");
			window.location.reload();
		}
	});

	$("#solution_page #nl-subNav a").click(function(event){
		event.preventDefault();
		var link = $(this).attr("href");
		getLocalStorage().setItem("linkOrigin", "solverTop");
		window.location = link;
	});
	
	$(".nl-navAction.notifications").click(function(){
		$(".nl-notificationsBox").toggle();
		$(".nl-notificationsBox").mathquill('redraw');
		if ($(".nl-notificationsBox").is(":visible")){
			$(".newNotifications").removeClass('newNotifications');
			$.ajax({
				type: "POST",
				url: "/api/notification/seen",
			    beforeSend: authorizeAjaxWithSyToken				
			});
		}
		return false;
	});
	
	$("select.classification").change(function(e){
		var parent = $(this).parent();
		var classificationId = $(this).attr("id");
		var state = $(this).val();
		var subclassId = classificationId+"-"+state;
		var subclassObj = $("#" + subclassId);
		parent.children(" select.subclass").addClass("hidden");
		parent.children(" select.subclass").attr("disabled", "disabled");
		if (subclassObj.children().size() > 1) {
			subclassObj.removeClass("hidden");
			subclassObj.removeAttr("disabled");
		}
	});
		  
	$('a.more').click(function(event) {
		event.preventDefault();
	    var link = this;
	    var linkParent = $(link).parent();
	    var next = linkParent.next();
	    next.toggle(function(){
	      var previousText = $(link).data('previous-text');
	      var currentText = $(link).text();
	      $(link).text(previousText);
	      $(link).data('previous-text', currentText);
	      if (window.location.href.indexOf('team') < 0){
	    	  $('#SearchExamples').find('.mathquill-embedded-latex').mathquill('redraw');
	      }
	    });
	  });

	ensureCorrectLightsOut();

	$("body").off("click", "#nl-mainNav li > a").on("click", "#nl-mainNav li > a", function(e) {
		e.preventDefault();

		if($(e.target).closest($("#studyToolsNav > a")).length > 0) {
			return;
		}

		const link = $(this).attr("href");
		getLocalStorage().setItem("linkOrigin", "header");
		window.location = link;
	});

	$("body").off("click", "#nl-mainNav li .whiteDropdown a").on("click", "#nl-mainNav li .whiteDropdown a", function(e) {
		e.preventDefault();

		const link = $(this).attr("href");
		getLocalStorage().setItem("linkOrigin", "header");
		window.location = link;
	});

	$("body").off("click", "[data-link-origin] a").on("click", "[data-link-origin] a", (e) => {
		e.preventDefault();

		const target = $(e.currentTarget);

		const closest = target.closest("[data-link-origin]");
		getLocalStorage().setItem("linkOrigin", closest.data("link-origin"));
		window.location = target.attr("href");
	});

	document.addEventListener("click", function(){ $(".nl-notificationsBox").hide(); });
});

function isMobileRender(){
	return typeof(isMobileRendering) != "undefined" && isMobileRendering;	
}

function isPopularSearch(){
	return window.location.href.indexOf("/popular") >= 0;
}

function showUpgradeMessage(){
	if (typeof(mobileWeb) != "undefined" && mobileWeb){
		if (OS === 'iOS'){
			//Use native confirm
			if (confirm("Download the app to see steps. Redirect to App Store?")){
				window.location = "https://itunes.apple.com/app/id876942533";
			}
		}
		else if (OS === 'Android'){
			//Use native confirm
			if (confirm("Download the app to see steps. Redirect to Google Play?")){
				window.location = "https://play.google.com/store/apps/details?id=com.devsense.symbolab";
			}
		}
	}
	else{
		window.location.href = "/upgradeVersion";
	}	
}


function parseQueryParameters(params) {
	var match,
	pl     = /\+/g,  // Regex for replacing addition symbol with a space
	regexp = /([^&=]+)=?([^&]*)/g,
	decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
	qpstr  = window.location.search.substring(1);
	while (match = regexp.exec(qpstr)) {
		params[decodeURIComponent(match[1])] = decodeURIComponent(match[2]);
	}
}

$.extend($.expr[":"], {
    "starts-with": function(elem, i, data, set) {
        var text = $.trim($(elem).text()),
            term = data[3];

        // first index is 0
        return text.indexOf(term) === 0;
    },

    "ends-with": function(elem, i, data, set) {
        var text = $.trim($(elem).text()),
            term = data[3];

        // last index is last possible
        return text.lastIndexOf(term) === text.length - term.length;
    }
});

function changeLanguage(el, curLang){
	var hostname = location.hostname;
	hostname = hostname.replace(curLang+".", "");
	hostname = hostname.replace("www.", "");
	var port = (location.port == 80 ? "" : ":"+location.port);
	var lang = ($(el).attr('data') == "en" ? "www." : $(el).attr('data')+".");	
	window.location = "http://"+lang+hostname+port+"/solver";
}


function showSignIn(reason, reason2, payload) {
	registrationReason = reason;
	googleIsSignUp = false;

	getLocalStorage().setItem("registrationReason", reason);
	if (reason2 === undefined) {
		symbolab_log("Registration", "ShowSignIn", registrationReason);
	}
	getLocalStorage().setItem("beforeSubs", 1);
	showSignUp(reason2 !== undefined ? reason2 : "TopMenu", payload);
}

function showSignUpSubscribe(reason, payload, params){
	if (sy_pSub){
		resumeSubscription(reason, payload);
	}
	else if (isUserLoggedIn()){
		showSubscription(reason, payload);
	}else{
		showSignUp(reason, payload, params);
	}
}

function bookImageError(image){
	image.onerror = "";
	$(image).hide();
	var link = $("<p><a href = '" + image.src + "'>Click here to view image</a></p>");
	$(image).parent().append(link);
	return true;
}

// update cookie  preference
function pickLanguage(lang){
    symbolab_log("General", "UserSwitchLang", lang);
}
	
function loadScript(path) {
	if($('script[src="'+ path + '"]').length > 0) {
		//Already loaded this script. Do not reload it.
		return $.Deferred().resolve();
	}
	
	var result = $.Deferred();
	var script = document.createElement("script");
	
	script.async = true;
	script.type = "text/javascript";
	script.src = path;
	script.onload = script.onreadystatechange = function (_, isAbort) {
	    if (!script.readyState || /loaded|complete/.test(script.readyState)) {
	       if (isAbort)
	           result.reject();
	       else
	          result.resolve();
	  }
	};
	script.onerror = function () { result.reject(); };
	$("head")[0].appendChild(script);
	return result.promise();
}

async function loadScriptAsync(path) {
	if($('script[src="'+ path + '"]').length > 0) {
		//Already loaded this script. Do not reload it.
		return Promise.resolve();
	}

	await new Promise((resolve, reject) => {
		const script = document.createElement("script");
		script.async = true;
		script.type = "text/javascript";
		script.src = path;
		script.onload = script.onreadystatechange = function (_, isAbort) {
			if (!script.readyState || /loaded|complete/.test(script.readyState)) {
				if (isAbort)
					reject();
				else
					resolve();
			}
		};
		script.onerror = reject;
		$("head")[0].appendChild(script);
	});
}

//use "pipe" to wait until loaded (jQuery 1.7)
function showGeneratePdf(){
	$(".nl-generatePdf").removeClass('nl-hidden');
	$.featherlight(".nl-generatePdf");

	return $.when(loadScript("/public/auto/jspdf.debug.min.js")).pipe(function() { return $.when(loadScript("/public/auto/html2canvas2.min.js")); });
}

function showFeedback(support, name, email){
	$(".nl-signInContainer>div").addClass('nl-hidden');
	$(".nl-feedback-modal").removeClass('nl-hidden');

	$.featherlight(".nl-signInContainer");
	if (support){
		$(".featherlight-content .nl-feedback-modal h2").text(i18n('js.How can we help you?'));
		$(".featherlight-content .nl-feedback-modal #inputName").val(name);
		$(".featherlight-content .nl-feedback-modal #inputEmail").val(email);
	}
}

function getRegistrationUrl(flow, reason, payload, params) {
	let parameter = "";
	let currentUrl = window.location.href;

	// If we're already in a registration flow, extract the original return URL to avoid nesting
	if (currentUrl.includes('/registration#') || currentUrl.includes('/registration?')) {
		const urlParts = currentUrl.split('#')[1] || currentUrl.split('?')[1] || '';
		const urlParams = new URLSearchParams(urlParts);
		const originalUrl = urlParams.get('url');
		
		if (originalUrl) {
			currentUrl = decodeURIComponent(originalUrl);
		}
	}

	if (payload !== undefined) {
		parameter = payload;
		if(currentUrl.indexOf("?") >= 0) {
			parameter = "&" + parameter;
		} else {
			parameter = "?" + parameter;
		}
	}

	let paramStr = Object.entries(params || {})
		.map(entry => entry.join("="))
		.reduce((prev, curr) => prev + "&" + curr, "")

	return "/registration#flow=" + flow + paramStr + "&url=" + encodeURIComponent(currentUrl + parameter) + "&reason=" + encodeURIComponent(reason);
}

function showSignUp(reason, payload, params) {
	var reasonParts = reason.split("\t");

	if(reasonParts.indexOf("LockedStep") >= 0) {
		window.location = getRegistrationUrl("lock", reason, payload, params);
	} else if(reasonParts.indexOf("Graphing") >= 0 || reasonParts.indexOf("Solver") >= 0) {
		window.location = getRegistrationUrl("upgrade", reason, payload, params);
	} else if(reasonParts.indexOf("SolverSaveNote") >= 0) {
		window.location = getRegistrationUrl("notebook", reason, params);
	} else if(reasonParts.indexOf("GraphSave") >= 0) {
		window.location = getRegistrationUrl("signup", reason, payload, params);
	} else if(reasonParts.indexOf("qbbundle") >= 0) {
		window.location = getRegistrationUrl("qbbundle", reason, payload, params);
	} else {
		window.location = getRegistrationUrl("signup", reason, params);
	}
}

function sendCourseHeroLink() {

	return $.ajax({
		type: "POST",
		url: "/requestChEmail",
		data: {
			origin: window.location.origin,
			sourceURL: window.location.href
		},
		beforeSend: authorizeAjaxWithSyToken
	});
}

function showSubscription(reason, payload){

	const url = getRegistrationUrl("upgrade", reason, payload);

	if (OS === 'iOS') {
		setTimeout(() => {
			window.location = url;
		}, 100);
	} else {
		window.location = url;
	}
}

function showSubscriptionWithSkipButton(reason){

	let url = getRegistrationUrl("upgrade", reason, "");
	url += "&skip=true";

	if (OS === 'iOS') {
		setTimeout(() => {
			window.location = url;
		}, 100);
	} else {
		window.location = url;
	}
}

function showGroupLicense(groupId){
	$(".nl-signInContainer>div").addClass('nl-hidden');
	$(".nl-groupLicense").removeClass('nl-hidden');
	$.featherlight(".nl-signInContainer");
	setSelectedSubscriptionOption($("td.subscribeOption:visible").last());
	renderPaypalGroupButton(groupId, "todo: clean the code");
}

function renderPaypalGroupButton(groupId, paypalApiClientId){
	loadScript("https://www.paypal.com/sdk/js?client-id="+paypalApiClientId+"&currency=USD").done(function() {
        var options = {
			style: {
				shape: 'pill',
				color: 'gold'
			},
			createOrder: function(data, actions) {
				var json = getGroupOrder(groupId);
				return actions.order.create(json);
			},
			onApprove: paypalOnApprove,
			onCancel: paypalOnCancel,
			onError: paypalOnError
		};

        // create one time payment button
        paypal.Buttons(options).render('.featherlight-content .nl-groupLicense #group-payment-paypal-button');
    });
}

function getFixedStepsFormatAPI(stepsIn){
	var stepsOut = [];
	for (var i = 0; i < stepsIn.length; i++){
		var step = stepsIn[i];
		if (step.type === "interim"){
			stepsOut.push(step);
		}
		else if (step.steps != null && step.steps.length > 1){
			for (var j = 0; j < step.steps.length; j++){
				var step2 = step.steps[j];
				stepsOut.push(step2);
			}

			if (step.entire_result){
				stepsOut.push({'entire_result' : step.entire_result });
			}
		}
		else{
			stepsOut.push(step);
		}
	}

	return stepsOut;
}

function getFixedStepsFormat(stepsIn){
	var stepsOut = [];
	for (var i = 0; i < stepsIn.length; i++){
		var step = stepsIn[i];
		if (step.isInterimStep){
			stepsOut.push(step);
		}
		else if (step.steps != null && step.steps.length > 1){
			for (var j = 0; j < step.steps.length; j++){
				var step2 = step.steps[j];
				stepsOut.push(step2);
			}
			
			if (step.entire_result){
				stepsOut.push({'entire_result' : step.entire_result });
			}
		}
		else{
			stepsOut.push(step);
		}
	}
	
	return stepsOut;
}

function createAndShowTooltipTimout(selector, text, timout, side){
	$(selector).tooltipster({
	    'content': text,
	    'theme': "tooltipster-light",
	    'side': side,
	    'restoration': 'none',
		'trigger': 'custom'
	});
	$(".sy-tooltip-close-icon:visible").click();
	$(selector).tooltipster('show');
	setTimeout(function () {
		$(selector).tooltipster('destroy');          	
    }, timout);
}

function removeUserSettings(){
	getLocalStorage().removeItem("settings.printGraph");
}

function removeUserInfo(){
	getLocalStorage().removeItem("udid");        // old
	getLocalStorage().removeItem("firstName");   // old
	getLocalStorage().removeItem("sy.udid");     // new
	getLocalStorage().removeItem("sy.firstName");// new
}

function logoutWithConfirm() {
	dialogify()
		.message(i18n("confirm logout"))
		.okButtonText(i18n("Logout"))
		.image("#leave-challenge")
		.okButtonHandler(() => {
			logout();
		})
		.showOkCancelDialog();
}

function logout(event){
	if (event) {
		event.preventDefault();
		event.stopPropagation();
	}

	removeAllUserInfo();

	window.location = "/logout";
}

function removeAllUserInfo() {
	removeUserSettings();
	removeUserInfo();
}

function logUserOutWithoutRedirect() {
	removeAllUserInfo(undefined);

	return $.ajax({
		data: {
			isMobile: true
		},
		url: "/logout",
		type: "GET"
	});
}

function refreshLeftNavbarHeight() {
	var internalContentHeight = $(".nl-content:visible").height();
	var pageHeight = $(".nl-pageContent").height();
	
	var h = Math.max(pageHeight, internalContentHeight);
	
	if(h > 0) {
		$("head #navbarStyle").remove();
		$("head").append($("<style id='navbarStyle'>.nl-leftNav { min-height: " + (h + 110) + "px; }</style>"));
		$("head").append($("<style id='navbarStyle'>.sidebar-content { min-height: " + (h + 100) + "px; }</style>"));
	}
}

//barak: todo - cls
// $(window).load(function() {
// 	refreshLeftNavbarHeight();
// });

// Saves current work in a share if relevant.
// Returns a E6 promise resolving to a string to add to the URL hash when returning from login.
function prepareGeometryForReload() {
	if (typeof(SYGEO) != "undefined"){
		var promise = SYGEO.doShareCreateRequest();
		return promise.then(function(result) {

			// TODO: the userIsLoggingIn mechanism could be improved
			SYGEO.userIsLoggingIn = true;

			var id = result._id;
			return "temporaryShare=" + id;
		});
	}

	return Promise.reject();
}

$(function() {
	var featherLightRefreshRequired = false;
	var upgrade_check = false;
	
	if (getLocalStorage().getItem("beforeSubs") == 1) {
		getLocalStorage().removeItem("beforeSubs");
	}

	function refreshPage(){
		if (featherLightRefreshRequired){
			var url = window.location.href.replace(/\#.*$/, "");
			if (upgrade_check){
				url += url.indexOf('?') >= 0 ? '&' : '?'; 
				url += 'upgrade=true';
			}
			window.location.href = url;
		}
	}
	
	$.featherlight.defaults.afterClose = function(event){
		refreshPage();
		$(".nl-signInContainer>div").addClass('nl-hidden');
	};

	function clearAutocomplete() {
		var autoComplete = $(".nl-autocomplete");
		autoComplete.empty();
		autoComplete.hide();
	}
	
	$(".nl-search").click(function(e) {

		var input = $(".nl-searchContainer input");

		if($(e.originalEvent.target).is(input)) {
			// don't react to clicks on the input box this way
			return;
		}

		input.val("");
		var mainNav = $("#nl-mainNav");
	    mainNav.toggleClass("nl-searchOpen");
		if(mainNav.hasClass("nl-searchOpen")) {
			input.focus();
			if (window.location.pathname === '/'){
				symbolab_log("General", "Subject Search Open Homepage");
			} else {
				symbolab_log("General", "Subject Search Open");
			}

		}

		clearAutocomplete();
	});

	$("body").click(function(e) {

		var isOpen = $("#nl-mainNav").hasClass("nl-searchOpen");
		if(!isOpen) {
			return;
		}

		if($(e.originalEvent.target).parents('.nl-search').length === 0) {
			clearAutocomplete();
		}
	});
	
	$(".nl-searchClose").click(function(e) {
	    e.preventDefault();
	    e.stopPropagation();
	    $(".nl-search").css({width: 40});
	    $(".nl-autocomplete").empty();
	    $(".nl-autocomplete").hide();
	    setTimeout(function () {
	        $("#nl-mainNav").removeClass("nl-searchOpen"); 
	        $(".nl-search").removeAttr("style");
	    }, 200);
	});
	
	var isUpdatingSuggest = false;
	$("#nl-searchField").keyup(function () {
		if (isUpdatingSuggest) return;
		isUpdatingSuggest = true;
		var query = $(".nl-searchContainer input").val();
		$.ajax({
			type: "GET",
			url: "/suggestSubjects",
			data: {
				query: query,
				language: "en",
				type: (window.location.href.indexOf('/practice/') >= 0 ? "Practice" : "Solutions")
			},
			success: function(res){
				if (res == null || res.length == 0) {
					$(".nl-autocomplete").hide();
				}
				else{
					$(".nl-autocomplete").empty();
					
					var lastType = null; 
					for (var i = 0; i < res.length; i++){
						var sol = res[i];
						if (sol.type != lastType){
							$(".nl-autocomplete").append("<div class='type'>" + sol.type + "</div>");
							lastType = sol.type;
						}
						
						sol.display = sol.display.replace(/\'/, "&apos;");
						var onClick = "getLocalStorage().setItem(\"linkOrigin\", \"SubjectSearch\"); window.location=\"" + sol.search+"\";";
						$(".nl-autocomplete").append("<div class='result' onclick='"+onClick+"'>" + sol.display + "</div>");
					}
					
					$(".nl-autocomplete").fadeIn();
				}
				isUpdatingSuggest = false;
			}
		});
	});

	$("#fbCancelBtn").click(function () {
		$.featherlight.current().close();
		$(".nl-signInContainer>div").addClass('nl-hidden');
	});
	
	$("#fbSendBtn").click(function () {
		var info = {};
		info.name = $(".featherlight-content .nl-feedback-modal #inputName").val();
		info.email = $(".featherlight-content .nl-feedback-modal #inputEmail").val();
		info.message = $(".featherlight-content .nl-feedback-modal #inputMessage").val();
		info.url = window.location.href;
		info.referrer = document.referrer;
		
		if (typeof(SYPRACTICE) != "undefined"){
			info.subject = SYPRACTICE.subject;
			info.topic = SYPRACTICE.topic;
			info.subTopic = SYPRACTICE.subTopic;
			info.problem = SYPRACTICE.problemInfo.problem.problemTranslation;
		}

		if (typeof(SYGEO) != "undefined") {
			info.problem = "Geometry problem ID: " + SYGEO.problemId;
		}

		if (typeof(syUnsubscribe) != "undefined") {
			symbolab_log("Registration", "ClickedFeature", `NewUnsubscribe\t${syUnsubscribe.planType}\tHelpSent`);
		}

		if (!info.message){
			$(".featherlight-content .nl-feedback-modal .alert-error").show();
		}
		else{
			$.ajax({
				type: "POST",
				url: "/feedback",
				beforeSend: authorizeAjaxWithSyToken,
				data: info
			});
			
			$(".featherlight-content .nl-feedback-modal .alert-error").hide();
			$(".featherlight-content .nl-feedback-modal .alert-success").show();
			setTimeout(function () {
				$.featherlight.current().close();
				$(".nl-signInContainer>div").addClass('nl-hidden');
			}, 2000);
			$(".featherlight-content .nl-feedback-modal #fbSendBtn").addClass('nl-disabled');
		}

	});

	$(".nl-languagesMenu a").click(function (e) {
		e.preventDefault();
		var href=$(this).attr("href");
		pickLanguage($(this).attr("data"));
		window.location = href;
	});

	function getTopMenuLocation(){
		if (window.location.pathname.indexOf("/solver")){
			return "Solver";
		}
		else if (window.location.pathname.indexOf("/graphing-calculator")){
			return "Graphing";
		}
		else if (window.location.pathname.indexOf("/notebook")){
			return "Notebook";
		}
		else if (window.location.pathname.indexOf("/practice")){
			return "Practice";
		}
		else if (window.location.pathname.indexOf("/calculator")){
			return "Calculators";
		}

		return window.location.pathname;
	}
	
	$("#join").click(function () {
		showSignUp("TopMenu\t"+getTopMenuLocation());
	});
	
	$("#upgrade").click(function () {
		showSubscription("UpgradeButton\t"+getTopMenuLocation());
	});

	$("#resume").click(function () {
		resumeSubscription("ResumeButton\t"+getTopMenuLocation());
	});
	
	$(".subscribeOption").click(function(){
		setSelectedSubscriptionOption($(this));
		symbolab_log("Registration", "BrowsePlan", $(this).attr('id'));
	});

    $("input[type=radio][name=subscriptionTypeRadio]").change(function(){
        setSelectedSubscriptionOption($(this).parent().parent().find(".subscribeOption"));
    });

	$("#noAccount").click(function () {
		$(".nl-signInContainer>div").addClass('nl-hidden');
		$(".nl-signUpWithText").removeClass('nl-hidden');
		symbolab_log("Registration", "ShowSignUp", registrationReason);
	});
	
	$("#haveAccount").click(function () {
		$(".nl-signInContainer>div").addClass('nl-hidden');
		$(".nl-signInWithText").removeClass('nl-hidden');
		symbolab_log("Registration", "ShowSignIn", registrationReason);
	});
	
	
	$(".nl-forgotPasswordLink").click(function () {
		$(".nl-signInContainer>div").addClass('nl-hidden');
		$(".nl-forgotPassword").removeClass('nl-hidden');
	});
	
	$(".nl-joinEmail").click(function () {
	    var el = $(this);
	    el.hide();
	    $(".nl-joinEmailForm").show();

	    symbolab_log('Registration', "ClickJoinEmail");
	    el.parent().parent().parent().parent().parent().parent().parent().parent().parent().animate({scrollTop : 300});
		

	});
	
	$(".nl-signInButton").click(function(){
		var button = $(this);
		signInWithEmail(button);
	});
	
	$(".nl-signIn input").on('keyup', function (e) {
		if (e.keyCode == 13) {
			var button = $(this).closest(".nl-signIn").find(".nl-signInButton");
			if(!button.hasClass("nl-disabled")) {
				signInWithEmail(button);
			}
		}
	});



	function signInWithEmail(button) {
		button.addClass("nl-disabled");

    	var loginPromise = $.Deferred();

		symbolab_log('Registration', 'SignInAttempt-Email' , registrationReason);
		$.ajax({
			type: "POST",
			url: "/login",
			data: {
				email: $(".featherlight-content #signin_email").val(),
				password: $(".featherlight-content #signin_password").val(),
				url: window.location.href,
				registrationReason: registrationReason
			},
			success: function(res){
				if (res.alert){
					$(".nl-signInWithText .nl-error").text(res.alert);
					$(".nl-signInWithText .nl-error").show();
					button.removeClass("nl-disabled");
					loginPromise.reject();
				}
				else {
					prepareGeometryForReload().then(function(hashAddition) {
						location.hash = hashAddition;

						// TODO: replace with 'finally'
						loginPromise.resolve();
					}, function() {
						// TODO: replace with 'finally'
						loginPromise.resolve();
					});
				}
			},
			error: function() {
				button.removeClass("nl-disabled");
				loginPromise.reject();
			}
		});

		$.whenAll(loginPromise).done(function() {
			location.reload();
		});
	}
	
	$(".nl-resetButton").click(function(){
		var button = $(this);
		button.addClass("nl-disabled");
		
		symbolab_log("Registration", "ResetPasswordClicked");
		
		$.ajax({
			type: "POST",
			url: "/resetRequest",
			data: {
				email: $(".featherlight-content #reset_email").val()
			},
			success: function(res){
				if (res.success){
					$(".nl-forgotPassword").hide();
					$(".nl-forgotPasswordSuccess").show();
					$(".nl-forgotPasswordSuccess .nl-bold").text(res.email);
				}
				else {
					$(".nl-forgotPassword .nl-error").text(res.alert);
					$(".nl-forgotPassword .nl-error").show();
					button.removeClass("nl-disabled");
				}
			},
			error: function() {
				button.removeClass("nl-disabled");
			}
		});
	});

	var params = {};
	parseQueryParameters(params);
	if (params.upgrade === "true" && !subscribed){
		showSubscription(getLocalStorage().getItem("registrationReason"));
	}
});

var sy_subscType;
function paypalOnApprove(data, actions) {
	data.type = sy_subscType;
	data.variation = sy_var;
	data.country = sy_cid;
	$(".featherlight-content .nl-signInContainer>div").addClass('nl-hidden');
	$(".featherlight-content .nl-processing").removeClass('nl-hidden');

	symbolab_log("Registration", "SubscribeCompleted-"+sy_subscType, registrationReason);

	var paymentPromise = $.Deferred();
	$.ajax({
		type: "POST",
		url: "/paypal/onApprove",
		beforeSend: authorizeAjaxWithSyToken,
		data: data,
		success: function(res) {
			if (res.alert === "success subscription"){
				$(".featherlight-content .nl-signInContainer>div").addClass('nl-hidden');
				$(".featherlight-content .nl-thankYouSubsc #subsRenewText").text(i18n('Subscription renews '+sy_subscType))
				$(".featherlight-content .nl-thankYouSubsc").removeClass('nl-hidden');
				$.featherlight.defaults.afterClose = function() {
					paymentPromise.resolve();
				};
			}
			else if (res.alert === "success payment"){
				$(".featherlight-content .nl-signInContainer>div").addClass('nl-hidden');
				$(".featherlight-content .nl-thankYou").removeClass('nl-hidden');
				$.featherlight.defaults.afterClose = function() {
					paymentPromise.resolve();
				};
			}
			else {
				$(".featherlight-content .nl-signInContainer>div").addClass('nl-hidden');
				$(".featherlight-content .nl-failed").removeClass('nl-hidden');
				paymentPromise.reject();
			}
		},
		error: function(xhr, ajaxOptions, thrownError){
			console.log();
		}
	});
	
	$.whenAll(paymentPromise).done(function() {
		location.reload();
	});
	
	return true;
}

function getAmount(){
	if (sy_subscType === "special")
		return 12.99
	else if (sy_subscType === "weekly")
		return 1.99;
	else if (sy_subscType === "monthly")
    	return 6.99;
	else if (sy_subscType === "annually")
    	return 29.99;
    else return 0;

}

function paypalOnCancel(data){
	symbolab_log("Registration", "PayPalCancel-"+sy_subscType, registrationReason);
}

function paypalOnError(data){
	symbolab_log("Registration", "PayPalError-"+sy_subscType, registrationReason);
}

function getSubscription(){
	var json = "";
	$.ajax({
		type: "GET",
		url: "/paypal/getSubscription",
		async: false,
		data: {
			type: sy_subscType,
			variation: sy_var,
			country: sy_cid
		},
		beforeSend: authorizeAjaxWithSyToken,
		success: function(data) {
			json = data;
		}
	});

	return json;
}

function getGroupOrder(groupId){
	var json = "";
	$.ajax({
		type: "GET",
		url: "/paypal/getGroupOrder",
		async: false,
		data: {
			groupId: groupId,
			type: sy_subscType,
			promo: $(".featherlight-content #promoText").val()
		},
		beforeSend: authorizeAjaxWithSyToken,
        success: function(data) {
			json = data;
		}
	});

	return json;
}



function setSelectedSubscriptionOption(td) {
	$(".featherlight-content .subscribe-button").addClass('nl-disabled');
	var btn = td.data('button');
	sy_subscType = td.attr('id');
	$(".featherlight-content #"+btn).removeClass('nl-disabled');
	$(td.parent().find("input")).prop("checked", true);
}



function createMatrixLatex(rowIndex, colIndex){
	var matrixStr = "\\begin{pmatrix}";
	for (var i = 0; i < rowIndex; i++){
		for (var j = 0; j < colIndex-1; j++){
			matrixStr += "&";
		}
		if (i < rowIndex - 1){
			matrixStr += "\\\\";
		}				
	}
	matrixStr += "\\end{pmatrix}";
	return matrixStr;
}

function createCustomMatrix(mainDiv){
	mainDiv.empty();
	mainDiv.append("<div class='title'>" + i18n("matrix-select-size") + " <span class='customMatrixDimensions'></span></div>");
	mainDiv.append("<span class='closeCustomMatrix'><div>" + i18n('matrix-close') + "</div></span>");
	var size = 10;

	var tableStr = "<div class='matrixTable' style='padding-right: 0px !important; '><table>";
	for (var i = 0; i < size; i++){
		tableStr += "<tr>";
		for (var j = 0; j < size; j++){
			tableStr += "<td class='customMatrixTd'/>";
		}
		tableStr += "</tr>";	
	}
	tableStr += "</table></div>";
	mainDiv.append(tableStr);
	mainDiv.show();

	var sypad = this;
	
	$(".customMatrixTd").hover(function() {
		$('.customMatrixTd').removeClass('on');
		var colIndex = $(this).parent().children().index($(this))+1;
		var rowIndex = $(this).parent().parent().children().index($(this).parent())+1;

		for (var i = 0; i < rowIndex; i++){
			var rows = $(this).parent().parent().children().eq(i);
			for (var j = 0; j < colIndex; j++){
				rows.children().eq(j).addClass('on');
			}
		}

		$('.customMatrixDimensions').text(rowIndex+"x"+colIndex);
	});

	$(".customMatrixTd").click(function() {
		var colIndex = $(this).parent().children().index($(this))+1;
		var rowIndex = $(this).parent().parent().children().index($(this).parent())+1;
		var matrixStr = createMatrixLatex(rowIndex, colIndex);
		mainDiv.hide();
		if (typeof SYPAD != "undefined"){
			SYPAD.inputBox().mathquill('write', matrixStr, rowIndex*colIndex);
			SYPAD.inputBox().focus();
		}
		else{
			$(".mathquill-editable").mathquill('write', matrixStr, rowIndex*colIndex);
			$(".mathquill-editable").focus();
		}
		
		return false;
	});

	mainDiv.find(".closeCustomMatrix").click(function() {
		mainDiv.hide();
		return false;
	});	
}

jQuery.fn.selectText = function(){
   var doc = document;
   var element = this[0];
   var range;
   if (doc.body.createTextRange) {
       range = document.body.createTextRange();
       range.moveToElementText(element);
       range.select();
   } else if (window.getSelection) {
       var selection = window.getSelection();        
       range = document.createRange();
       range.selectNodeContents(element);
       selection.removeAllRanges();
       selection.addRange(range);
   }
};

function pageExpired(xhr, api) {
	
}

function browser(){
	var N= navigator.appName, ua= navigator.userAgent, tem;
	var M= ua.match(/(opera|chrome|safari|firefox|msie)\/?\s*(\.?\d+(\.\d+)*)/i);
	if(M && (tem= ua.match(/version\/([\.\d]+)/i))!= null) M[2]= tem[1];
	M= M? [M[1], M[2]]: [N, navigator.appVersion,'-?'];
	return M;
}

function getProductByUrl(){
	if (window.location.href.indexOf("/solver") >= 0)
		return "Solutions";
	else if (window.location.href.indexOf("/practice") >= 0)
		return "Practice";
	else if (window.location.href.indexOf("/notebook") >= 0)
		return "Notebook";
	else if (window.location.href.indexOf("/graphing-calculator") >= 0)
		return "GraphingCalculator";
	else
		return "Action";
}

function lightsOut() {
	const invert = getInverseCookieValue();

	if(invert === "true") {
		createInvertCookie("false");
		liveToggleInvert(false);
		symbolab_log(getProductByUrl(), "LightsOn", null);
	} else {
		createInvertCookie("true");
		liveToggleInvert(true);
		symbolab_log(getProductByUrl(), "LightsOut", null);
	}
}

function ensureCorrectLightsOut() {
	const invert = getInverseCookieValue();
	const mobile = typeof isMobile !== 'undefined' && isMobile;

	if(invert === "true" && !mobile) {
		liveToggleInvert(true);
	} else {
		liveToggleInvert(false);
	}
}

function liveToggleInvert(darkMode) {
	$("html").toggleClass("dark-mode", darkMode);

	if (darkMode) { // turn on dark mode
		$(".nl-lightsOutSwitch").attr("title", i18n("js.Lights on"));
	} else { // turn off dark mode
		$(".nl-lightsOutSwitch").attr("title", i18n("js.Lights out"));
	}

	graphingSlider(darkMode);
}

function graphingSlider(darkMode) {
	if (darkMode && $("#sliders-button").length > 0) {
		let open = $("#sliders-button.hide").length === 0;
		if (open) {
			$("#sliders-button-inverse").attr("class", "sliders-button-inverse");
			$("#sliders-button-close-inverse").attr("class", "sliders-button-inverse hide-important");
		}
		else {
			$("#sliders-button-inverse").attr("class", "sliders-button-inverse hide-important");
			$("#sliders-button-close-inverse").attr("class", "sliders-button-inverse");
		}
	}
	else if (!darkMode && $("#sliders-button-inverse").length > 0) {
		let open = $("#sliders-button-inverse.hide-important").length === 0;
		if (open) {
			$("#sliders-button").attr("class", "sliders-button");
			$("#sliders-button-close").attr("class", "sliders-button hide");
		}
		else {
			$("#sliders-button").attr("class", "sliders-button hide");
			$("#sliders-button-close").attr("class", "sliders-button");
		}
	}
}

function resetUserData(){
	var startEndSession = getTerminalSessionStringCookieValue();
	if (!startEndSession || startEndSession.indexOf('Start') >= 0){
		startEndSession = "End Session";
	}
	else{
		startEndSession = "Start Session";
	} 

	createTerminalSessionStringCookie(startEndSession);
	$("#resetTop").text(startEndSession);
	
	$.whenAll(
		$.ajax({
			type: "POST",
			url: '/api/user/clearPractice',
		    beforeSend: authorizeAjaxWithSyToken
		}),
		$.ajax({
			type: "POST",
			url: '/api/notebook/clearNotes',
		    beforeSend: authorizeAjaxWithSyToken
		})
	).then(function() {
		window.location.href = '/';
	});
}

//$.whenAll()
;(function($) {
	  var slice = [].slice;

	  $.whenAll = function(array) {
	    var
	      resolveValues = (arguments.length == 1 && $.isArray(array)) ? array : slice.call(arguments),
	      length = resolveValues.length,
	      remaining = length,
	      deferred = $.Deferred(),
	      i = 0,
	      failed = 0,
	      rejectContexts = Array(length),
	      rejectValues = Array(length),
	      resolveContexts = Array(length),
	      value;

	    function updateFunc (index, contexts, values) {
	      return function() {
	        !(values === resolveValues) && failed++;
	        deferred.notifyWith(contexts[index] = this, values[index] = slice.call(arguments));
	        if (!(--remaining)) {
	          deferred[(!failed ? 'resolve' : 'reject') + 'With'](contexts, values);
	        }
	      };
	    }
	    
	    for (; i < length; i++) {
	      if ((value = resolveValues[i]) && $.isFunction(value.promise)) {
	        value.promise()
	          .done(updateFunc(i, resolveContexts, resolveValues))
	          .fail(updateFunc(i, rejectContexts, rejectValues))
	        ;
	      }
	      else {
	        deferred.notifyWith(this, value);
	        --remaining;
	      }
	    }

	    if (!remaining) {
	      deferred.resolveWith(resolveContexts, resolveValues);
	    }

	    return deferred.promise();
	  };
	})(jQuery);

function createCookie(name, value, days, ignoreDomain) {
    var expires;

    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = "; expires=" + date.toGMTString();
    } else {
        expires = "";
    }
    
    var domain = "";
    if(!ignoreDomain) {
	    if(window.location.href.match(/symbolab\.com/)) {
	    	domain = ";domain=.symbolab.com";
	    } else if(window.location.href.match(/scibug\.com/)) {
	    	domain = ";domain=.scibug.com";
	    }
    }
    
    document.cookie = encodeURIComponent(name) + "=" + encodeURIComponent(value) + expires + "; path=/" + domain;
}

function readCookieLegacyFallback(name, legacyName) {
	var newValue = readCookie(name);
	if(newValue == null || newValue === "") {
		return readCookie(legacyName);
	}
	
	return newValue;
}

function readCookie(name) {
    var nameEQ = encodeURIComponent(name) + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) === 0) return decodeURIComponent(c.substring(nameEQ.length, c.length));
    }
    return null;
}

function eraseCookie(name) {
    createCookie(name, "", -1);
}

function eraseLegacyCookie(name) {
	createCookie(name, "", -1, true);
}

function isUserLoggedIn() {
	if(readCookieLegacyFallback("sy2.token", "sy.token")) {
		return true;
	}
	
	return false;
}

function createPubTokenCookie(pubToken) {
	// "essential" cookie
	createCookie("sy2.pub.token", pubToken, 1);
}

function getInverseCookieValue() {
	return readCookieLegacyFallback("sy2.invert", "invert");
}

function createInvertCookie(value) {
	if(allowedCookieGroups("C0003")) {
		createCookie("sy2.invert", value);
	}
}

function authorizeAjaxWithSyToken(xhr) {
	xhr.setRequestHeader("Authorization", 'Bearer '+ readCookieLegacyFallback("sy2.token", "sy.token"));
}

function authorizeAjaxWithSyPubToken(xhr) {
	xhr.setRequestHeader("Authorization", 'Bearer '+ readCookieLegacyFallback("sy2.pub.token", "sy.pub.token"));
}

function ajaxImage(url, image, hideIfFailedElements) {
	return new Promise(function(resolve, reject) {
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function(){
			if (this.readyState === 4) {
				if(this.status === 200) {
					var url = window.URL || window.webkitURL;
					var objUrl = url.createObjectURL(this.response);
					var response = this.response;

					image.on("load", function() {
						resolve(response);
						image.off("load");
					});
					image.attr("src", objUrl);

				} else {
					if(hideIfFailedElements !== undefined) {
						hideIfFailedElements.hide();
					}

					reject(this.error);
				}
			}
		};

		xhr.open('GET', url);
		authorizeAjaxWithSyPubToken(xhr);
		xhr.responseType = 'blob';
		xhr.setRequestHeader("x-requested-with", "XMLHttpRequest");
		xhr.send();
	});
}

function groupSelectSelected(jq) {
	/* When an item is clicked, update the original select box,
	and the selected item: */

	var element = jq[0];

	var y, i, k, s, h;
	s = element.parentNode.parentNode.getElementsByTagName("select")[0];
	h = element.parentNode.previousSibling;
	for (i = 0; i < s.length; i++) {
	  if (s.options[i].innerHTML == element.innerHTML) {
		s.selectedIndex = i;
		h.innerHTML = element.innerHTML;
		y = element.parentNode.getElementsByClassName("same-as-selected");
		for (k = 0; k < y.length; k++) {
		  y[k].removeAttribute("class");
		}
		element.setAttribute("class", "same-as-selected");
		break;
	  }
	}
}

function clearGroupSelects(parent) {
	parent.find(".select-selected").remove();
	parent.find(".select-items").remove();
}

function openSelect(parentContainer) {
	var select = parentContainer.find("div.select-selected")[0];
	select.nextSibling.classList.toggle("select-hide");
	select.classList.toggle("select-arrow-active");
}


function setupGroupSelect( removeFirstOption, onChange, parentId, onOpen) {
    var _ = this;

    var x, i, j, selElmnt, a, b, c;
    /* Look for any elements with the class "custom-select": */
    x = document.getElementsByClassName("group-select");
    for (i = 0; i < x.length; i++) {
      if(parentId !== undefined) {
      	if($(x[i]).attr("id") !== parentId) {
      		continue;
      	}
      }
      selElmnt = x[i].getElementsByTagName("select")[0];
      /* For each element, create a new DIV that will act as the selected item: */
      a = document.createElement("DIV");
      a.setAttribute("class", "select-selected");
      var selectedOption = selElmnt.options[selElmnt.selectedIndex];
      if(selectedOption !== undefined) {
      	a.innerHTML = selectedOption.innerHTML;
      }
      x[i].appendChild(a);
      /* For each element, create a new DIV that will contain the option list: */
      b = document.createElement("DIV");
      b.setAttribute("class", "select-items select-hide");
      j = 0;
      if (removeFirstOption) j = 1;
      for (; j < selElmnt.length; j++) {
        /* For each option in the original select element,
        create a new DIV that will act as an option item: */
        c = document.createElement("DIV");
        c.innerHTML = selElmnt.options[j].innerHTML;
        c.setAttribute("data-group", selElmnt.options[j].value);

        if(selElmnt.options[j].disabled) {
        	$(c).addClass("disabled");
        	c.addEventListener("click", function(e) {
        		 e.stopPropagation();
        	});
        } else {
			c.addEventListener("click", function(e) {
				groupSelectSelected($(this));
				var h = this.parentNode.previousSibling;
				h.click();
				onChange();
			});
        }

        b.appendChild(c);
      }
      x[i].appendChild(b);
		a.addEventListener("click", function(e) {
			/* When the select box is clicked, close any other select boxes,
			and open/close the current select box: */
			e.stopPropagation();
			closeAllSelect(this);
			this.nextSibling.classList.toggle("select-hide");
			this.classList.toggle("select-arrow-active");

			if(this.classList.contains("select-arrow-active") && onOpen) {
				onOpen();
			}
		});
    }

    function closeAllSelect(elmnt) {
      /* A function that will close all select boxes in the document,
      except the current select box: */
      var x, y, i, arrNo = [];
      x = document.getElementsByClassName("select-items");
      y = document.getElementsByClassName("select-selected");
      for (i = 0; i < y.length; i++) {
        if (elmnt == y[i]) {
          arrNo.push(i)
        } else {
          y[i].classList.remove("select-arrow-active");
        }
      }
      for (i = 0; i < x.length; i++) {
        if (arrNo.indexOf(i)) {
          x[i].classList.add("select-hide");
        }
      }
    }

    /* If the user clicks anywhere outside the select box,
    then close all select boxes: */
    document.addEventListener("click", closeAllSelect);
}

function repeat(str, times) {
  var repeated = '';
  for (var i = 1; i <= times; i++) {
    repeated += str;
  }

  return repeated;
}

window.a2a_config = {
	onclick: 1,
	callbacks: [{
		ready: () => {
			$(".a2a_dd span:first-child").click();
		},
		share: (data) => {
			symbolab_log("Registration", "ClickedFeature", a2a_config.logAction+"\tShare\t"+data.service);
			amplitude.track('Clicked', {
				type: 'Share',
				service: data.service,
				url: data.url
			});
			return {
				url: a2a_config.linkurl,
				title: a2a_config.linkname,
			};
		}
	}],
};

let shareClickEventReady = false;
function shareClick({ url, title, logAction }) {
	a2a_config.linkurl = url;
	a2a_config.linkname = title;
	a2a_config.logAction = logAction;

	if (typeof(a2a) == "undefined"){
		const script = document.createElement('script');
		script.type = 'text/javascript';
		script.src = 'https://static.addtoany.com/menu/page.js';

		const head = document.getElementsByTagName('head')[0];
		head.appendChild(script);
	} else {
		if (shareClickEventReady) {
			symbolab_log("Registration", "SeenFeature", a2a_config.logAction+"\tShare");
			if (!url) url = window.location.href;
			amplitude.track('Seen', {
				type: 'Share',
				url: url
			});
		}
		shareClickEventReady = true;
	}
}

function escapeHtml(unsafe) {
	return unsafe
		.replace(/&/g, "&amp;")
		.replace(/</g, "&lt;")
		.replace(/>/g, "&gt;")
		.replace(/"/g, "&quot;")
		.replace(/'/g, "&#039;");
};

function resumeSubscription(reason, payload) {
	symbolab_log("Registration", "ShowResume", reason);
	alertify
		.okBtn(i18n('js.Resume'))
		.cancelBtn(i18n('js.cancel'))
		.confirm(i18n("js.resume_question", i18n(sy_pSub)),
			function() {
				$(".loading-animation").show();
				$.ajax({
					type: "POST",
					url: '/api/payments/resumeSubscription',
					data: {
						reason: "user request"
					},
					beforeSend: authorizeAjaxWithSyToken,
					success: function (res) {
						symbolab_log("Registration", "Resumed", reason);
						alertify
							.okBtn("OK")
							.alert(
								res.success ? i18n("js.Subscription Resumed") : i18n("js.Operation Failed"),
								function () {
									if(payload !== undefined) {
										location = location + payload;
									}
									location.reload();
								},
								function () {
									if(payload !== undefined) {
										location = location + payload;
									}
									location.reload();
								}
							);
					}
				});
			},
			function() {
				$("#paypalActivate").removeClass('nl-disabled');
				$("#paypalUnsubscribeNew").removeClass('nl-disabled');
			}
		);
}

function setDefaultSubscription() {
	setSelectedSubscriptionOption($(".subscribeOption[id=annually]"));
}

function getParams(href){
	var params = new Object();

	var hashPos = href.indexOf('#');
	if (hashPos>=0){
		var str = href.substring(hashPos+1);
		var match;
		var regexp = /([^&=]+)=?([^&]*)/g;
		while (match = regexp.exec(str)) {
			params[decodeURIComponent(match[1])] = decodeURIComponent(match[2]);
		}
	}

	return params;
}

function clickedSendCHLinkButton(buttonEl) {
	const button = $(buttonEl);

	button.addClass("nl-disabled");
	sendCourseHeroLink().done(function(res) {

		button.removeClass("nl-disabled");

		if(res.success) {
			$("#nl-successfullySignedPopup").hide();
			alertify.alert(res.success);
		}
	}).fail(function(error) {

		button.removeClass("nl-disabled");
		alertify.alert(error);
	});
}

function loadCourseHeroLink(linked, linkAvailable) {

	if(isUserLoggedIn()) {
		const newUrl = window.location.href.replace(/\?.*/, "");
		if(subscribed) {
			if(linked === "1") {
				// offer to visit subscription management
				amplitude.track('CHBundle', { state: 'UserLinked' });

				if(!isSolverFeatureRequestedCancelUpgradeMessage()) {
					symbolab_log("Registration", "CHBundle-UserLinked");
					$("#nl-successfullySignedPopup").show();
					$("#popup-avatar").hide();
					$("#successfullySignedUp").text(i18n("Subscription active"));
					$("#UpgradeToProButton").removeClass("hide-important").text(i18n("Manage subscription")).off("click").on("click", function () {
						window.location = "/user#subscription";
					});
				}

				window.history.replaceState({}, document.title, newUrl);
			} else {
				// offer to visit subscription management
				amplitude.track('CHBundle', { state: 'UserSubscribed' });
				symbolab_log("Registration", "CHBundle-UserSubscribed");

				if(!isSolverFeatureRequestedCancelUpgradeMessage()) {
					$("#nl-successfullySignedPopup").show();
					$("#popup-avatar").hide();
					$("#successfullySignedUp").text(i18n("You are currently subscribed"));
					$("#UpgradeToProButton").removeClass("hide-important").text(i18n("Manage subscription")).off("click").on("click", function () {
						window.location = "/user#subscription";
					});
				}

				window.history.replaceState({}, document.title, newUrl);
			}
		} else {
			if (linkAvailable === "1") {
				// offer verification email
				amplitude.track('CHBundle', { state: 'UserNotVerified' });
				symbolab_log("Registration", "CHBundle-UserNotVerified");
				$("#popup-avatar").hide();
				$("#nl-successfullySignedPopup").show();
				$("#successfullySignedUp").text(i18n("Your subscription is ready to activate"));
				$("#UpgradeToProButton").removeClass("hide-important").text(i18n("Activate CourseHero Bundle")).off("click").on("click", function() {
					clickedSendCHLinkButton(this);
				});
				window.history.replaceState({}, document.title, newUrl);
			} else {
				// offer log out and reconnect with correct one
				amplitude.track('CHBundle', { state: 'UserNotFound' });
				symbolab_log("Registration", "CHBundle-UserNotFound");
				$("#success_image").hide();
				$("#nl-successfullySignedPopup").show();
				$("#successfullySignedUp").text(i18n("Your bundle subscription is registered under a different email"));
				$("#UpgradeToProButton").removeClass("hide-important").text(i18n("Sign in with Bundle Email")).off("click").on("click", function() {
					logUserOutWithoutRedirect().done(function(res) {
						window.location = "/registration#flow=signup&reason=CHLink&page=signup&url=" + encodeURIComponent(window.location.href);
					});
				});
				window.history.replaceState({}, document.title, newUrl);
			}
		}
	} else {
		symbolab_log("Registration", "CHBundle-NotLoggedIn");
		// display login/signup page immediately
		amplitude.track('CHBundle', { state: 'NotLoggedIn' }).promise.then(function() {
			window.location = "/registration#flow=signup&reason=CHLink&page=signup&url=" + encodeURIComponent(window.location.href);
		});
	}

	$("#cancelPopup").click(function () {
		$("#nl-successfullySignedPopup").hide();
	});

	$("#StartExploringButton").click(function () {
		$("#nl-successfullySignedPopup").hide();
	});
}

function loadUpgrade(href) {

	// empty moretext
	$("#moreText").text("");

	var params = getParams(href);
	var text = getPlanText(params['planInfo']);

	if (text.length > 0) {
		$("#moreText").css("font-size", "17px").html(text);
		$("#popup-avatar").css("margin-top", "30px");
		$("#popupButtons").css("margin-top", "50px");
	}

	if (params['page']) {

		if (params['link'] === '1') {
			$("#UpgradeToProButton").text(i18n("Activate CourseHero Bundle"));
		}

		if (params['page'] === "upgraded") {
			if(!isSolverFeatureRequestedCancelUpgradeMessage()) {
				$("#nl-successfullySignedPopup").show();
			}

			// send track event request via Javs SDK (writes 374 times to amplitude)
			symbolab_log("Registration", "SubscribeCompleted-"+params['vendor']+"_"+params['planInfo'], params['reason']);
			// send track event request via Browser SDK (writes 302 times to amplitude)
			amp_log('SubscribeCompleted', 'vendor='+params['vendor']+'\tplanInfo='+params['planInfo'], true);

			if(!isSolverFeatureRequestedCancelUpgradeMessage()) {
				$("#popup-avatar").hide();

				if (params['link'] === '1') {
					// change wording slightly
					$("#moreText").text(i18n("Subscription active"));
					$("#successfullySignedUp").text(i18n("Thank you for signing in"));
					$("#UpgradeToProButton").text(i18n("Activate CourseHero Bundle"));
				} else {

					if (typeof isQbBundle !== 'undefined' && isQbBundle === "true") {
						$("#successfullySignedUp").text(i18n("qb-bundle-thank-you-text"));
						$("#successfullySignedUp").css("font-size", "1.5rem");
					} else {
						$("#successfullySignedUp").text(i18n("Thank you for subscribing"));
					}
				}
			}
		} else if (params['page'] === "signedIn" && params['link'] === '1') {
			if (params['upgradeAttempt'] === '1') {
				$("#successfullySignedUp").text(i18n("Your subscription bundle awaits"));
			} else {
				$("#successfullySignedUp").text(i18n("Thank you for signing in"));
			}

			$("#nl-successfullySignedPopup").show();
			$("#success_image").hide();
		} else if (params['page'] === "signedUp") {
			$("#successfullySignedUp").text(i18n("Thank you for signing up"));
			$("#nl-successfullySignedPopup").show();
			$("#popup-avatar").hide();
		} else if (params['page'] === "ongoingSubscription") {
			if(!isSolverFeatureRequestedCancelUpgradeMessage()) {
				$("#successfullySignedUp").text("Thank you for your ongoing subscription");
				$("#nl-successfullySignedPopup").show();
				$("#popup-avatar").hide();
			}
		}

		$("body")
			.off("click", "#UpgradeToProButton:not(.nl-disabled)")
			.on("click", "#UpgradeToProButton:not(.nl-disabled)", function () {
			if(params['link'] === '1') {
				clickedSendCHLinkButton(this);
			} else {
				showSignUp("Solver");
			}
		});
	}

	$("#cancelPopup").click(function () {
		$("#nl-successfullySignedPopup").hide();
	});

	$("#GoToQuillBotButton").click(function () {
		window.open("https://quillbot.com", "_blank");
		$("#nl-successfullySignedPopup").hide();
	});

	$("#StartExploringButton").click(function () {
		$("#nl-successfullySignedPopup").hide();
	});

	window.history.replaceState({}, document.title, window.location.pathname + window.location.search);
}
function getPlanText(plan) {
	var text = "";
	if (plan === "monthly") {
		text = i18n('Subscription renews monthly');
	} else if (plan === "weekly") {
		text = i18n('Subscription renews weekly');
	} else if (plan === "annually") {
		text = i18n('Subscription renews annually');
	} else if (plan === "semi") {
		text = i18n('Subscription renews semi-annually');
	}
	return text;
}

function isSolverFeatureRequestedCancelUpgradeMessage() {
	const urlParams = new URLSearchParams(window.location.search);
	return ["verify", "challenge"].indexOf(urlParams.get("feature")) >= 0;
}

function checkIPad() {

	const cookieName = "sy.probablyIPad";
	const detectedCookieValue = "1";
	const searchParamKey = "mobileWebRedirect";
	const alreadyRedirectedValue = "1";
	const parser = new URL(window.location);

	const redirect = decodeURIComponent(parser.searchParams.get(searchParamKey));
	if(redirect === alreadyRedirectedValue) {
		return;
	}

	const probablyIPad =
		(navigator.userAgent
			&& navigator.userAgent.toLowerCase().indexOf('macintosh') > -1
			&& navigator.maxTouchPoints
			&& navigator.maxTouchPoints > 2);
	// todo samsung browser tablet don't get press
		// ||
		// (navigator.userAgent
		// 	&& navigator.userAgent.toLowerCase().indexOf('samsungbrowser') > -1
		// 	&& navigator.userAgent.toLowerCase().indexOf('android') < 0
		// 	&& navigator.maxTouchPoints
		// 	&& navigator.maxTouchPoints > 2);

	const cookieContents = readCookie(cookieName);

	const alreadyDetected = cookieContents && cookieContents === detectedCookieValue;

	if(!alreadyDetected && probablyIPad) {
		createCookie(cookieName, detectedCookieValue);

		parser.searchParams.set(searchParamKey, alreadyRedirectedValue);
		window.location = parser.href;
	}
}

function isApplicationRender() {
	return new URL(window.location.href).protocol.indexOf("file") >= 0;
}

$(document).ready(function() {
	catchUnhandledExceptionHandler();

	var _ = this;

	checkIPad();

	const url = new URL(window.location);
	if(url.searchParams.has("coursehero")) {
		loadCourseHeroLink(url.searchParams.get("linked"), url.searchParams.get("linkavailable"));
	} else {
		var href = window.location.hash;
		if (href.includes("page=upgraded") || href.includes("page=signedIn") || href.includes("page=signedUp") || href.includes("page=coursehero") || href.includes("page=ongoingSubscription")) {
			loadUpgrade(href);
		}
	}

	$("#signIn").click(function(e) {
		e.preventDefault();
		showSignUp("TopMenu");
	});

	$("#mobile_logout").click(function(event) {
		event.preventDefault();
		window.location = "/logout";
	});

	const linkOrigin = getLocalStorage().getItem("linkOrigin");
	getLocalStorage().removeItem("linkOrigin");

	if(!isApplicationRender()) {
		symbolab_log('General',
			"Enter",
			window.location.href.replace(window.location.origin, ""), document.referrer,
			linkOrigin);
	}

	if ("undefined" !== typeof amplitude){
		const track = amplitude.track('Enter', {
			data: window.location.href,
			linkOrigin: linkOrigin,
			referrer: document.referrer
		});
		if (track && track.promise) {
			track.promise.then(function (result) {
				if (allowedCookieGroups("C0002")) {
					createCookie("sy.amp.session", amplitude.getSessionId());
					createCookie("sy.amp.device", amplitude.getDeviceId());
				}
			});
		}
	}

	$("a.contact-us").off("click").on("click", e => {
		e.preventDefault();
		showFeedback();
	});
});

function allowedCookieGroups(targetGroup) {

	var cookie = readCookie("OptanonConsent");

	if(cookie) {

		var keyValues = cookie.split("&");
		var listOfPairs = keyValues.map(function (kv) {
			return kv.split("=");
		});

		var optanonObject = Object.fromEntries(listOfPairs);
		var groupsString = optanonObject.groups;
		var groupsPairs = groupsString.split(",").map(function(g) {
			var groupPair = g.split(":");
			return [groupPair[0], groupPair[1] === '1'];
		});

		var groupsObject = Object.fromEntries(groupsPairs);

		return groupsObject[targetGroup] === true;
	}

	// if not Optanon cookie, allow it
	return true;
}

function OptanonWrapper() {

	// runs when One Trust has established consent

	// noinspection SpellCheckingInspection
	window.geofeed = function(options) {

		// string two digit ISO country code
		const country = options.country.toString();

		const domainData = OneTrust.GetDomainData();
		if (domainData && domainData.ConsentModel) {
			if (domainData.ConsentModel.Name === "opt-out") {
				if (country === 'US') {
					// show alternate title on link for USA residents
					$(".cookie-settings-link").text(i18n("Do not sell"));
				} else {
					// Do not show footer link for opt-in countries that aren't USA
					$(".cookie-settings-link").hide();
				}
			}
		}
	};

	// Call geo-location JSON service
	const json = document.createElement('script');
	json.setAttribute('src', 'https://geolocation.onetrust.com/cookieconsentpub/v1/geo/location/geofeed');
	document.head.appendChild(json);

	OneTrust.OnConsentChanged(function (e) {

		var domainData = OneTrust.GetDomainData();
		if (domainData && domainData.ConsentModel) {
			if (domainData.ConsentModel.Name === "opt-in") {

				// reload page if consent model is opt-in
				// this removes cookies on backend
				window.location.reload();
			}
		}

	});
}

function openCookiePreferencesIfRelevant() {

	var domainData = OneTrust.GetDomainData();
	if (domainData && domainData.ConsentModel) {
		if (domainData.ConsentModel.Name === "opt-in") {
			// only show the info when we are in opt-in mode
			OneTrust.ToggleInfoDisplay();
		}
	}
}

function handleGoogleOneTap(response) {
	const page = window.location.pathname === "/" ? "HomePage" : "Solver"
	symbolab_log('Registration', "ClickedFeature", "OneTap\t" + page + "\tLogin");
	registrationReason = "OneTap\t" + page;
	handleGoogleToken(response);
}

function handleGoogleToken(response) {

	var redirect = requestUrl;

	// TODO: replace with 'finally'
	var finalAction = function(additionalUrlQuery) {

		if (window.location.href === redirect){

			if(additionalUrlQuery !== undefined) {

				if(redirect.indexOf("#") < 0) {
					redirect += "#";
				} else {
					redirect += "&";
				}

				window.location = redirect + additionalUrlQuery;
			}

			// reload even if location changed. when hash is the only change it won't autoreload
			window.location.reload();

		} else {

			if(additionalUrlQuery !== undefined) {
				if(redirect.indexOf("#") < 0) {
					redirect += "#";
				} else {
					redirect += "&";
				}

				redirect += additionalUrlQuery;
			}

			window.location = redirect;

			// reload even though location changed. when hash is the only change it won't autoreload
			window.location.reload();
		}
	}

	$.ajax({
		type: "POST",
		url: "/googleMobileAuth",
		beforeSend: authorizeAjaxWithSyToken,
		data: {
			idRequestToken: response.credential,
			registrationReason: registrationReason,
			redirect: requestUrl
		}
	}).done(function(res) {

		if(res.success || res.jwt) {

			let additionalUrlQuery = undefined;
			if(res.newlyLinkedToCourseHero) {
				additionalUrlQuery = "firstTimeLink=1";
			}

			prepareGeometryForReload().then(function(hashAddition) {
				redirect = redirect + encodeURIComponent("#" + hashAddition);
				finalAction(additionalUrlQuery);
			}, function() {
				finalAction(additionalUrlQuery);
			});
		} else {
			var err = $("<p />", {text: res.alert, "class": "alert alert-error"});
			$("#loginOptionsPanel .alert.alert-error").remove();
			$("#loginOptionsPanel").append(err);
		}
	});
}

async function securedAjax(options) {
	return ajax(options, true);
}

async function ajax(options, secured) {
	return new Promise((resolve, reject) => {
		options.type = options.type ?? "GET";
		if (secured) {
			options.beforeSend = authorizeAjaxWithSyToken;
		}
		options.success = function(res) {
			resolve(res);
		}
		options.error = function(err) {
			reject(err);
		}
		$.ajax(options);
	});
}

function searchInitiatedLog(query, origin) {
	if (!origin) {
		const urlParams = new URLSearchParams(window.location.search);
		origin = urlParams.get('or') ?? "";
	}
	symbolab_log("General", "SearchInitiated", origin, query)
}

function catchUnhandledExceptionHandler() {
	const originalOnErrorHandler = window.onerror;
	window.onerror = async function (message, file, line, col, error) {
		if (file.includes("symbolab.com")) {
			await ajax({
				type: "POST",
				url: "/jsError",
				data: {
					url: window.location.href,
					message: error.message ?? message,
					stacktrace: error.stack
				},
			});
		}

		return originalOnErrorHandler?.(message, file, line, col, error) ?? false;
	};
}

// Show Chrome extension
let browserTypeSafe = (typeof browserType !== 'undefined') ? browserType : '';

function sendCTAPadEvent() {
	const mobile = typeof isMobile !== 'undefined' && isMobile;
	if (!mobile || browserTypeSafe === 'chrome') {
		const visible = $("#all-pads").hasClass("on");

		if (visible){
			symbolab_log('Registration', "SeenFeature", "ExtensionCTA\tPad");
		}
	}
}

$(document).ready(() => {

	const extUrlBase = "https://chromewebstore.google.com/detail/mgfcnnpakbfcefgphceolkjldjfpieff";

	const $extButtonInfo = $('.ext-button-info');
	const $extDownloadBtnInfo = $('#ext-download-btn-button-info');
	const $extInfoIcon = $('.ext-info-icon');
	const $extTooltip = $('.ext-tooltip');
	const $extModal = $('#ext-modal');
	const $extModalCloseBtn = $extModal.find('.ext-close-btn');
	const $extDownloadBtnModal = $('#ext-download-btn-modal');
	const $extHomepageVideoBanner = $('.ext-homepage-video-banner');
	const $extDownloadBtnHomepageVideoBanner = $('#ext-download-btn-homepage-video-banner');

	const mobile = typeof isMobile !== 'undefined' && isMobile;

	$extButtonInfo.hide();
	$extHomepageVideoBanner.hide();

	let shouldShowModal = false;
	let shouldShowSideBanner = false;

	if (mobile || browserTypeSafe !== 'chrome') {
		$extHomepageVideoBanner.hide();
		shouldShowModal = false;
		shouldShowSideBanner = false;
		return;
	}

	const urlParams = new URLSearchParams(window.location.search);
	if (urlParams.has('or')) {
		if (urlParams.get('or') === 'input') {
			shouldShowModal = true;
		}
	} else if (!window.location.pathname.includes('step-by-step')) {
		shouldShowSideBanner = true;
	}

	setTimeout(() => {

		if (mobile || browserType !== 'chrome') {
			$extButtonInfo.hide();
			$extHomepageVideoBanner.hide();
			shouldShowModal = false;
			shouldShowSideBanner = false;
			return;
		}

		let sceHost = document.querySelector("#symbolab-extension-host");

		if (!sceHost) {

			if ($extButtonInfo.length > 0) {

				$extButtonInfo.addClass("variation" + sy_var);

				$extButtonInfo.show();

				sendCTAPadEvent();

				$extInfoIcon.on('mouseover', function() {
					$extTooltip.show();
				});

				$extInfoIcon.on('mouseout', function() {
					$extTooltip.hide();
				});

				$extDownloadBtnInfo.off('click').on('click', function () {
					symbolab_log('Registration', "ClickedFeature", "ExtensionCTA\tPad");
					window.open(extUrlBase, "_blank");
				});

			}

			if ($extHomepageVideoBanner.length > 0) {
				$extHomepageVideoBanner.show();
				symbolab_log('Registration', "SeenFeature", "ExtensionCTA\tHomePage");
				$extDownloadBtnHomepageVideoBanner.off('click').on('click', function () {
					symbolab_log('Registration', "ClickedFeature", "ExtensionCTA\tHomePage");
					window.open(extUrlBase, "_blank");
				});
			}

			const EXT_SHOW_MODAL_STORAGE_KEY = "extShowModal";
			const THREE_MONTHS_MILLIS = 7890048000;
			const storage = window.localStorage;
			const lastShown = storage.getItem(EXT_SHOW_MODAL_STORAGE_KEY);

			function showModal(position = 'center') {

				if (lastShown) {
					try {
						const timestamp = Number(lastShown);
						if (timestamp + THREE_MONTHS_MILLIS > Date.now()) {
							return; // too soon to show again
						}
					} catch (err) {
						console.log(err);
					}
				}

				symbolab_log('Registration', "SeenFeature", "ExtensionCTA\tModal");

				$extModal.removeClass('hidden bottom-right bottom-left')
					.css({ top: '', left: '', right: '', bottom: '', transform: '' });

				if (position === 'bottom-right') {
					$extModal.addClass('bottom-right');
				} else if (position === 'bottom-left') {
					$extModal.addClass('bottom-left');
				} else {
					$extModal.css({
						top: '50%',
						left: '50%',
						transform: 'translate(-50%, -50%)'
					});
				}
			}

			if (shouldShowModal) {

				$extModalCloseBtn.on('click', function () {

					if (!lastShown) {
						storage.setItem(EXT_SHOW_MODAL_STORAGE_KEY, Date.now().toString());
					}

					$extModal.addClass('hidden');
				});

				$extDownloadBtnModal.off('click').on('click', function () {
					symbolab_log('Registration', "ClickedFeature", "ExtensionCTA\tModal");
					window.open(extUrlBase, "_blank");
					$extModal.addClass('hidden');
				});

				showModal('bottom-left');

			}
		}
	}, 1000);
});
