
/**
 * String.prototype.replaceAll() polyfill
 */
if (!String.prototype.replaceAll) {
	String.prototype.replaceAll = function(str, newStr){

		// If a regex pattern
		if (Object.prototype.toString.call(str).toLowerCase() === '[object regexp]') {
			return this.replace(str, newStr);
		}

		// If a string
		return this.replace(new RegExp(str, 'g'), newStr);

	};
}

var SymbolabSteps = function(lang, subscribed, origin, userFirstName, useHtmlChat) {
	this.requestLang = lang;
	this.stepsRes = null;
	this.stepsArray = [];
	this.stepsHighestBox = [];
	this.stepsArrayIndex = 0;
	this.relatedProblems = null;
	this.subscribed = subscribed === "true";
	this.NotebookSourceSolutions = origin ? origin : "Solutions";

	this.showHideMap = {};
	this.showHideMap.hideSteps = i18n('hide steps');
	this.showHideMap.showSteps = i18n('show steps');
	this.showHideMap.stepByStep = i18n('Step by Step');
	this.showHideMap.unlockSteps = i18n('unlock steps');
	this.userFirstName = userFirstName;
	this.useHtmlChat = useHtmlChat;

	this.init();
};

SymbolabSteps.prototype = {
	init: function(){
		var _ = this;

		var body = $("body");

		body.off("click", ".newSelect").on("click", ".newSelect", function(event) {

			event.preventDefault();

			var had = $(this).hasClass("closed");

			if ($(this).hasClass('stepsSelect') &&
				($(event.target).hasClass("arrows") || $(event.target).hasClass("value"))
			) {

				logFunnel("ClickedFeature", "Dropdown");
			}

			$(".newSelect").addClass("closed");
			$(".slItems").hide();

			$(this).toggleClass("closed", !had);
			$(this).children('.slItems').toggle(had);
		});

		body.off("click", "#multipleOptions .slItem").on("click", "#multipleOptions .slItem", function (event) {
			event.preventDefault();
			event.stopPropagation();
		});

		body.off("click", "#multipleOptions .slItem").on("click", "#multipleOptions .slItem", function() {
			lastVal = $(this).attr("value");
			symbolab_log('Solutions', 'ClickSolvingOptions', _.stepsRes.topic);

			var newVal = $(this).attr('value');
			var select = $(this).parent().parent();
			if (select.children('.value').attr('value') === newVal) return;

			_.setNewQuery(newVal);
		});

		body.off("click", ".solution_step_definition").on("click", ".solution_step_definition", function() {
			var el = $(this);
			el.toggleClass("expanded");
			mathquillifyVisible(el.find(".solution_step_definition_body"));
		});
	},

	showGraph: function(show) {
		var _ = this;
		$("#Plot_dynaimc").toggle(show);
	},

	showPracticeLink: function(show) {
		var _ = this;

		var linkContainer = $("#practice-link-container");

		if(!show || !_.stepsRes || !_.stepsRes.steps || !_.stepsRes.steps.meta) {
			linkContainer.hide();
			return;
		}

		var meta = _.stepsRes.steps.meta;
		var link = meta.practiceLink;
		var topic = meta.practiceTopic;

		if(!link || !topic) {
			linkContainer.hide();
			return;
		}

		var text = i18n("Practice") + " " + topic;
		linkContainer.find("span.text").text(text);
		linkContainer.data("practice-link", link);

		linkContainer.show();
	},

	showChallengePracticeLink: function(show) {
		var _ = this;

		var challengeLinkContainer = $("#challenge-practice-link-container");

		if(!show || !_.stepsRes || !_.stepsRes.steps || !_.stepsRes.steps.meta) {
			challengeLinkContainer.hide();
			return;
		}

		var meta = _.stepsRes.steps.meta;
		var link = meta.practiceLink;

		if(!link) {
			challengeLinkContainer.hide();
			return;
		}

		challengeLinkContainer.data("practice-link", link);
		challengeLinkContainer.show();
	},

	setNewQuery: function(newQuestion, newDisplay) {
		setNewMobileQuery(newQuestion, newDisplay);
	},

	setSolutionFromMobileResponse : function(res) {
		var _ = this;
		_.receiveNewSolution(res);
	},

	setStepsFromMobileResponse : function(res, stepsSettings) {
		var _ = this;
		_.receiveNewSteps(res, false, stepsSettings);
	},

	receiveNewSolution: function(res) {
		var _ = this;
		_.receiveNewSteps(res, false, "hideSteps");

		if (res.query !== undefined) {
			notifyHostNewExpression(res.query.display);
		}
	},

	receiveNewSteps: function(res, dontUpdatePlot, stepsSettings) {
		var _ = this;
		_.stepsRes = res;
		_.stepSettings = stepsSettings;
		_.stepsArrayIndex = 0;

		// console.log(res);

		createSteps(res);

		if(res.error && res.error.message) {
			_.showError(res.error.message);
			return;
		}

		if(res.solution === undefined || Object.keys(res.solution).length === 0 || res.solution.default === undefined || res.solution.default === null) {
			_.showError(i18n("js.Solution not currently supported on this platform"));
			return;
		}

		if (stepsSettings !== "showSteps") {
			_.doDynamicPlot(false);
		}

		_.applyStepsSettings(stepsSettings);
	},

	showError : function(message) {
		var _ = this;
		$("#solution-only").hide();
		$("#other-solutions-container").hide();
		$("#plot-iframe").hide();
		$("#show-steps-button").hide();

		var err = $("#error");
		err.append(createMathquillDiv("", message)).removeClass("hide-important");
		mathquillifyVisible(err);
	},

	setPlotFromMobileResponse : function(res) {
		var _ = this;

		var plot = $('#Plot_dynaimc');
		var plotLink = $('#PlotLink');
		var plotLoading = $("#plot-loading");
		plotLoading.hide();

		if(res) {
			_.stepsRes.plot_output.meta.plotInfo = res;

			var errs = _.stepsRes && _.stepsRes.plot_output && _.stepsRes.plot_output.meta && _.stepsRes.plot_output.meta.plotInfo ? _.stepsRes.plot_output.meta.plotInfo.graphCalcInputErrors : ["error"];
			if (!Array.isArray(errs) || errs.length === 0 || errs.length === 1 && !errs[0]) {
				_.stepsRes.plot_output.meta.plotInfo.plotRequest = undefined;
				_.doDynamicPlot(_.showZoom, true);
			} else {
				plotLink.hide();
				plot.hide();
			}
		}
	},

	applyStepsSettings : function(stepsSettings) {
        var _ = this;

		_.stepSettings = stepsSettings;

		if (_.inStepByStep){
			_.makeStepByStepSolution();
			_.showPracticeLink(false);
		} else if (stepsSettings === undefined || stepsSettings === "showSteps") {

			_.isPracticeIconAdded = false;
			_.stepsArrayIndex = 0;

			$("#show-steps-button").hide();
			$("#steps-container").show();
			_.writeSteps();

			_.openHideStepsNew(0, true);

			_.showPracticeLink(true);
			_.showVerify();
			// _.showGraph(true);
		} else if (stepsSettings === "hideSteps") {

			_.stepsArrayIndex = 0;

			_.showPracticeLink(false);
			_.showVerify();

			$("#show-steps-button").show();
			$("#steps-container").hide();
			// _.showGraph(true);
		} else if (stepsSettings === "stepByStep"){

			$("#solution-only").hide();
			$("#other-solutions-container").hide();
			$("#show-steps-button").hide();
			$("#steps-container").hide();
			$('#related').hide();

			_.makeStepByStepSolution();
			_.showPracticeLink(false);
			_.showGraph(false);

		} else if (stepsSettings === "challenge") {

			$("#solution-only").hide();
			$("#other-solutions-container").hide();
			$("#show-steps-button").hide();
			$("#steps-container").hide();
			$('#related').hide();
			$('.edit-question').hide();
			$("#next-step-button").addClass("challenge")

			_.makeStepByStepSolution();
			_.showPracticeLink(false);
			_.showGraph(false);

		}
	},

	writeChAnswer : function(res){
		var _ = this;
		if (res.externalSolution != null) {
			var delim = new RegExp("</?formula.*?>","g");
			var nonFormula = new RegExp("(^|</?formula.*?>)(.*?)(</?formula.*?>|$)", "g");
			var pTags = new RegExp("</?p>","g");
			var parsedSolution = _.parseExternalSolution(res);
			var steps = parsedSolution.steps;
			if (steps.length === 0 || (steps.length === 1 && steps[0] === '')) {
				this.showCannotSolve();
				return;
			}
			var multipleSolutions = $('#multipleSolutions');
			var temp = $('<div></div>');
			var solutionDiv = $('<div class="solution_div"></div>');
			var solutionOutside = $('<div class="solution_box solution_outside_box"></div>');
			var solutionTitleContainer = $('<div onClick class="solution_title_container_highest"></div>');
			var solutionMainTitle = $('<div class="solution_step_title"></div>');
			var solution = parsedSolution.solution;
			if (parsedSolution.query.startsWith("\\lim") && (solution.indexOf("does not exist") >= 0)) {
				solution = "Diverges.";
			}
			// If the solution is just concatenation of steps, remove it.
			if (res.standardQuery.startsWith("prove") ||
				solution.replaceAll("<p> </p>", "").indexOf(steps[0]) >= 0) { // contains 1st step
				solution = "True "; // trailing space for overflow x right padding issue.
			}
			if (solution.match("^<img[^<>]*>$")) {
				steps.push(solution);
				solution = "See image in steps.";
			}
			solution = _.getLastSolutionLine(solution);
			solution = solution.replaceAll(nonFormula, _.processSolutionTitleText);
			var separator = parsedSolution.query.indexOf("=") >= 0 ? " \\quad:\\quad " : " = ";
			var solutionTitle = "###" + parsedSolution.query + separator + solution + "###";
			solutionTitle = solutionTitle.replaceAll(pTags, "").replaceAll(delim, "\\space ");
			solutionMainTitle.append(solutionTitle);
			renderMathInElement(solutionMainTitle[0], {
				delimiters:	[{left: "###", right: "###", display: true}]
			});

			// katex couldn't render for some reason
			if (solutionMainTitle[0].innerText.indexOf("###") >= 0) {
				this.showCannotSolve();
				return;
			}

			var step;
			var stepItem;
			var stepDiv = $('<div style="display: block;"></div>');
			var stepList = $('<div id="steps-container" class="solution_step_list"></div>');
			stepList.append('<li class="solution_step_list_itemc solution_steps_text">Steps</li>');
			if (parsedSolution.steps.length > 0) {
				step = parsedSolution.steps[0];
				stepItem = $('<li class="solution_step_list_item"></li>');
				stepItem.append(_.createSolutionStepBook(step, delim));
				stepList.append(stepItem);
			}
			if (parsedSolution.steps.length > 1) {
				if (this.subscribed) {
					var arr = parsedSolution.steps.slice(1);
					for (var stepId in arr) {
						step = arr[stepId];
						stepItem = $('<li class="solution_step_list_item"></li>');
						stepItem.append(_.createSolutionStepBook(step, delim));
						stepList.append('<hr class="stepsHr">');
						stepList.append(stepItem);
					}
				} else {
					stepItem = $('<li class="solution_step_list_item"></li>');
					var solutionInside = $('<div class="solution_box solution_inside_box""></div>');
					var innerSolutionTitleContainer = $('<div onclick="SYSTEPS.showHideRule(this)" class="solution_title_container"></div>');
					var a = $("<a></a>");
					a.append($("<span class='locked-step'/>"));
					a.append($("<span class='showButtonText'>Show Steps</span>"));
					var solutionStepTitle = $('<div class="solution_step_title">More steps</div>');
					innerSolutionTitleContainer.append(a);
					innerSolutionTitleContainer.append(solutionStepTitle);
					solutionInside.append(innerSolutionTitleContainer);
					stepItem.append(solutionInside);
					stepList.append('<hr class="stepsHr">');
					stepList.append(stepItem);
				}
			}

			solutionTitleContainer.append(solutionMainTitle);
			solutionOutside.append(solutionTitleContainer);
			stepDiv.append(stepList);
			solutionOutside.append(stepDiv);
			solutionDiv.append(solutionOutside);
			temp.append(solutionDiv);

			temp.find("img").each(function() {
				var img = $(this);
				var url = img.attr("src");
				var id = url.replace(/[\/:.]/g, "");
				img.wrap($("<div />", {id: id}));
				img.remove();
				requestChImage(url, id);
			});

			multipleSolutions.append(temp.html());
		}
	},

	getLastSolutionLine : function(solution) {
		solution = solution.replaceAll("<p> </p>", "");
		if (solution.indexOf("<p>") >= 0) {
			solution = solution.substr(solution.lastIndexOf("<p>"));
		}
		if (solution.indexOf("\\begin{aligned}") >= 0 && solution.match("&\\s*=")) {	// multi line formula
			solution = solution.replace(/\\begin\{aligned\}(.*)\\end\{aligned\}/, function (_, multiline) {
				return multiline.split("\\\\").pop().replaceAll("&", "");
			});
		}
		return solution;
	},

	processSolutionTitleText : function(textPart) {
		var imageTag = new RegExp("<img.*?>", "g");
		return textPart.replaceAll(" ", " \\space ")
			.replaceAll(imageTag, "");
	},

	createSolutionStepBook : function(step, delim) {
		var stepText = $('<div class="solution_step_book"></div>');
		stepText.append(step.replaceAll(delim, "###"));
		renderMathInElement(stepText[0], {
			delimiters:
				[
					{left: "###", right: "###", display: false}
				]
		});
		return stepText;
	},

	parseExternalSolution : function(res) {
		var rareTrigo =
			new RegExp("\\\\(sech|csch|arcsech?|arccsch?|arcsinh|arccosh|arctanh|arccoth)", "g");
		var parsedSolution = {};
		parsedSolution.query = res.externalSolution.renamedQuery.replaceAll(rareTrigo,"\\mathrm{$1}");
		parsedSolution.solution = "";
		parsedSolution.steps = [];

		var widgetId, widget;
		var answerObj = JSON.parse(res.externalSolution.solution);
		if (answerObj.answers !== undefined) {
			for (var answerId in answerObj.answers) {
				var answer = answerObj.answers[answerId];
				if (answer.widgets !== undefined) {
					for (widgetId in answer.widgets) {
						widget = answer.widgets[widgetId];
						if (widget.text !== undefined) {
							parsedSolution.solution += widget.text;
						}
					}
				}
				if (answer.explanations !== undefined) {
					for (var stepId in answer.explanations) {
						var step = answer.explanations[stepId];
						var stepText = "";
						if (step.explanations !== undefined) {
							for (var stepPartId in step.explanations) {
								var stepPart = step.explanations[stepPartId];
								if (stepPart.widgets !== undefined) {
									for (widgetId in stepPart.widgets) {
										widget = stepPart.widgets[widgetId];
										stepText += widget.text;
									}
								}
							}
						}
						parsedSolution.steps.push(stepText);
					}
				}
			}
		}
		return parsedSolution;
	},

	getScrollHeight : function(selector){
		var jq = $(selector);
		if (jq.size() === 0) return 0;
		return jq[0].scrollHeight;
	},

	showVerify : function(step_by_step_div) {

		var _ = this;

		if (_.stepsRes.showVerify) {
		    var template;

			if(step_by_step_div) {

				template = $("#verify-section-template").clone();
				template.removeAttr("id");
				template.find("#verify-input").addClass("stepByStepInput");
				step_by_step_div.append(template.html());

				step_by_step_div.find('.mathquill-editable').mathquill('editable');
				step_by_step_div.find('.hintText.bold').text(i18n("Know the answer?"));
				step_by_step_div.find("#EnterText").text(i18n('Enter your answer'));
				step_by_step_div.find("#clear-textfield").toggleClass("lockedVerify", !_.subscribed);
				$("#clear-textfield").addClass("verify-hidden");
                $("#verify-camera-button").removeClass("verify-hidden");

			} else {
				template = $("#verify-section-template").clone();
				template.removeAttr("id");
				template.toggleClass("lockedVerify", !_.subscribed);
				$("#verify-section").empty().append(template.html());

				$('#verify-section .mathquill-editable').mathquill('editable');

				$('#verify-section .hintText.bold').text(i18n("Got a different answer?"));
				$('#verify-section #EnterText').text(i18n('Enter your answer'));

				$("#verify-section #clear-textfield").toggleClass("lockedVerify", !_.subscribed);

	            $("#clear-textfield").addClass("verify-hidden");
                $("#verify-camera-button").removeClass("verify-hidden");
				$('#verify-section').show();
			}

			$('.verify-button').unbind('click').click(function(event) {
				_.verify($(this));
			});

			$('#verify-input').unbind('keyup').keyup(function(event) {
				var charCode = (event.charCode) ? event.charCode : event.keyCode;
				if (event.keyCode === 13) {
					_.verify($(this).parent().find("button"));
				}
			});
		}
	},

	verify: function(button) {
		var latex = button.parent().find(".verify-input").mathquill("latex");
		appVerify(latex);
	},

	makeStepByStepSolution : function(){
		var _ = this;

		_.inStepByStep = true;
		$(".ul-div").remove();
		var index = $(".show-hide-steps-div").first().data("index");
		// _.openHideStepsNew(index, true);
		_.populateStepByStep();
	},

	populateStepByStep: function(){
		var _ = this;

		_.steps = getFixedStepsFormatAPI(_.stepsRes.steps.steps);

		_.stepIndex = 0;

		var stepByStepContainer = $("#step-by-step-container");
		stepByStepContainer.show();

		var next_step_button = $("#next-step-button");

		next_step_button.off("click").on("click", function() {
			_.nextStep();
		});

		$("#next-step-button .text").html(i18n("Get a hint") + "&nbsp;" + "<b>" + (_.stepIndex + 1) + "</b>" + " / " + _.steps.length)
		next_step_button.show();
	},

	nextStep : function() {
		var _ = this;

		var steps_target = $("#step-by-step-steps");
		var button_text = $("#next-step-button .text");
		var next_step_button = $("#next-step-button");

		var steps = _.steps; //_.stepsRes.steps.steps;

		if (_.stepIndex < steps.length){
			steps_target.append(_.createStepListItem(steps[_.stepIndex]));
			$("#step-by-step-steps .mathquill-embedded-latex:not(.mathquill-rendered-math)").mathquill();
		}
		if (_.stepIndex > 0){
			symbolab_log('Solutions', "StepByStep-Next");
		}

		_.stepIndex++;
		if (_.stepIndex < steps.length){
			button_text.html(i18n("Next Hint") + "&nbsp;" + "<b>" + (_.stepIndex + 1) + "</b>" + " / " + steps.length)
			next_step_button.show();
		} else {
			notifyDoneWithSteps();
			next_step_button.hide();
		}
		getAHint();
	},

	getSolvingOptions : function(){
		var _ = this;
		if (!_.stepsRes.solvingOptions) return;
		var select = $("<div id='multipleOptions' class='newSelect closed'></select>");
		select.append("<span class='arrows'><i class='nl-practice-sprite'></i></span>");
		select.append("<div class='value' value='"+_.stepsRes.solvingOptions.returnedOption+"'></div>");

		var values = $("<div class='slItems'></div>");
		for (var i = 0; i < _.stepsRes.solvingOptions.count; i++){
			_.stepsRes.solvingOptions.displays[i] = _.stepsRes.solvingOptions.displays[i].replace(/\\mathrm\{/, "");
			_.stepsRes.solvingOptions.displays[i] = _.stepsRes.solvingOptions.displays[i].replace(/\}/, "");
			var isSelectedValue = _.stepsRes.solvingOptions.returnedOption === _.stepsRes.solvingOptions.queries[i];
			if (isSelectedValue){
				select.find('.value').append(_.stepsRes.solvingOptions.displays[i]);
			}

			values.append("<div class='slItem' value='" + _.stepsRes.solvingOptions.queries[i] + "'>"+_.stepsRes.solvingOptions.displays[i]+"</div>");
		}
		select.append(values);
		symbolab_log('Solutions', 'ShowSolvingOptions', _.stepsRes.topic);

		return select;
	},

	getSettingsContent: function(val, noStepByStep){
		var _ = this;
		var select = $("<div class='stepsSelect newSelect closed'></select>");
		select.append("<span class='arrows'><i class='nl-practice-sprite'></i></span>");
		select.append("<div class='value' value='"+val+"'>"+_.showHideMap[val]+"</div>");

		var values = $("<div class='slItems'></div>");
		values.append("<div class='slItem' value='hideSteps'>" + _.showHideMap.hideSteps + "</div>");
		values.append("<div class='slItem' value='showSteps'>" + _.showHideMap.showSteps + "</div>");
		if (!noStepByStep) {
			values.append("<div class='slItem' value='stepByStep'>" + _.showHideMap.stepByStep + "</div>");
		}
		select.append(values);

		var div = $("<div class='show-hide-steps-div'></div>");
		div.append(select);

		return div;
	},

	removeSolvingOptions : function(){
		$("#multipleOptions").remove();
	},

	updatePracticeLinks : function(where2add) {
		var _ = this;
		if (_.stepsRes){
			var url = '/practice';
			var text = 'click here to start symbolab practice »';
			if (_.stepsRes.topic !== "Other"){
				url = _.stepsRes.practiceLink;
				text = 'click here to practice ' + _.stepsRes.topic.toLowerCase() + ' »';

				if (_.stepsRes.topic.toLowerCase() === 'integrals' && !isUserLoggedIn()){
					url = "/practice/integrals-practice#area=quiztrial";
					text = 'click here to test your integrals skills »';
				}
				else if (_.stepsRes.topic === 'Equations'  && (_.stepsRes.subTopic === 'Quadratic' || _.stepsRes.subTopic === 'Linear')){
					text = 'click here to practice ' + _.stepsRes.subTopic.toLowerCase() + ' equations »';
				}
				$("#PracticeLink").attr('href', url);
			}

			_.addPracticeLink(where2add, 'SolutionBottom', url, text);
		}
	},

	addPracticeLink : function(where2add, type, url, text) {
		var _ = this;
		where2add.append($('<a class="stepsPracticeLink" href="'+url+'">' + text + '</a>'));
	},

	hasTitle : function(solution, title){
		if (solution.title && solution.title.text && solution.title.text.createdText){
			if (solution.title.text.createdText.indexOf(title) >= 0) {
				return true;
			}
		}

		if (solution.steps){
			for (var i = 0; i < solution.steps.length; i++){
				if (this.hasTitle(solution.steps[i], title)){
					return true;
				}
			}
		}

		return false;
	},

	method_select : function(e) {
		var _ = this;
		var selectedObjectVal = $("#methods-target").val();
		var selectedObject = JSON.parse(selectedObjectVal);

		if(selectedObject.symbolab_question === _.selectedMethod) {
			// nothing changed, this is the selected method
			return;
		}

		_.selectedMethod = selectedObject.symbolab_question;

		setNewMobileQuery(selectedObject.symbolab_question, selectedObject.display, true);
	},

	writeSteps : function() {
		var _ = this;

		var steps = _.stepsRes.steps;

		var temp = $("<div />");

		if(steps) {
			var solutionDiv = $('<div class="solution_div"></div>');
			solutionDiv.append(_.createSolutionBox(steps, true));
			temp.append(solutionDiv);
		}

		var target = $("#methods-target");

		if(_.stepsRes.methods && _.stepsRes.methods.length > 1) {

			target.empty();
			$("#methods .select-selected, #methods .select-items").remove();

			var container = $("#methods-container");
			container.removeClass("hide");

			_.stepsRes.methods.forEach(function(item, i) {
				var methodMathquill = createMathquillSpan("", item.method, "");
				var html = $("<option />", {
					"value": JSON.stringify({symbolab_question: item.query.symbolab_question, display: item.query.display,}),
					"html": methodMathquill,
					"aria-label": "method-option"
				});
				target.append(html);
			});

			mathquillify(container);

			target.val(_.stepsRes.methods[0].query);
			_.selectedMethod = _.stepsRes.methods[0].query.symbolab_question;

			setupGroupSelect(false, function(e) {
				logFunnel("ClickedFeature", "SolvingOptions\tChange"); _.method_select(e);
			}, undefined, function() {
				logFunnel("ClickedFeature", "SolvingOptions");
			});
		}

		var multipleSolutions = $("#multipleSolutions");
		multipleSolutions.empty().append(temp.html());

		mathquillifyVisible(multipleSolutions);
		setTimeout(function () {
			_.makeScrollable(multipleSolutions);

			_.twoLineTitle(multipleSolutions);

		}, 100);
	},

	writeSolution : function(res) {
		var _ = this;
		if (res){
			if (res.error){
				//not append-intensive
				$('#multipleSolutions').empty().append(this.createMessageBox(res.error.message));
				$('#multipleSolutions .mathquill-embedded-latex').mathquill();
				if (res.error.message.indexOf('Upgrade') >= 0){
					$('#multipleSolutions .mathquill-embedded-latex')
						.after(" <a class='upgrde-button' onclick='if (isUserLoggedIn()) {showSubscription(\"SolutionsSolvingMethod\")}else{showSignUp(\"SolutionsSolvingMethod\")}'>Upgrade</a>");
				}
			}
			else if (res.solution !== undefined) {
				$('#multipleSolutions').empty();

				if(!_.eitherStepByStepOrChallenge()) {
					_.showDYM(res.alternatives);
				}

				_.showChallenge(res.similar);

				_.parseSolutions(res.solution);
				if (_.requestLang !== "" && _.requestLang !== res.stepLang){
					$(".onlyEnglish").show();
				}

				if (res.related && res.related.length > 0){
					_.related = res.related;
					_.addRelatedProblems(3);
					$('#RelatedLink').show();
					// symbolab_log('Solutions', 'ShowRelated', null, $("#main-input").mathquill('latex'));
				}
			} else {
				this.showCannotSolve();
			}
		} else {
			this.showCannotSolve();
		}

		$(".solution_div").each(function(i, item) {
			var div = $(item);
			var inside = div.find(".show-hide-steps-div");
			inside.insertBefore(div);
		});

		$('#ExamplesLink').show();

		setTimeout(function() {
			_.makeScrollable($("#mathquill_query_container .solution_box"));
		}, 100);

		mathquillifyVisible($("#other-solutions"));
	},

	showDYM : function(dymData) {
		if(!dymData || dymData.length === 0) {
			return;
		}

		var dymObj = $("#dym");
		var dymTarget = $("#dym-target");

		dymData.forEach(function (alt) {
			var dymItem = createMathquillSpan('dymQuery', alt.display);
			var altEncoded = encodeURIComponent(alt.symbolab_question);
			var altDisplayEncoded = encodeURIComponent(alt.display);
			var dymItemA = $("<a />", {'class': 'dymQueryLink', href: "mobileRender?symbolabQuestion=" + altEncoded + "&display=" + altDisplayEncoded });
			dymItemA.append(dymItem);
			dymTarget.append(dymItemA);
		});

		dymObj.show();
		mathquillifyVisible(dymObj);
	},

	eitherStepByStepOrChallenge : function() {
		var _ = this;
		return ["challenge", "stepByStep"].indexOf(_.stepSettings) >= 0;
	},

	showChallenge : function(challenge) {
		var _ = this;

		var challengeElement = $("#challenge");

		if(!challenge || _.eitherStepByStepOrChallenge()) {
			challengeElement.hide();
			return;
		}

		challengeElement.show();

		$("#challenge-button").off("click").on("click", function() {
			challengeClicked(challenge);
		});

		logFunnel("SeenFeature", "Challenge");
	},

	addRelatedProblems : function(limit) {
		var _ = this;

		var relatedList = $('#relatedList');
		relatedList.empty();

		var related;
		var solvingUrl;
		var problem;
		var li;

		for (var i = 0; i < this.related.length && i < limit; i++){
			related = this.related[i];
			var relatedEncoded = encodeURIComponent(related.symbolab_question);
			var displayEncoded = encodeURIComponent(related.display);
			var origin = encodeURIComponent(related.origin);
			solvingUrl = "solveRelated/" + relatedEncoded + "?or=" + origin + "&display=" + displayEncoded;
			problem = related.display.replace(/ /g, "\\:").replace(/</g, "&lt;").replace(/>/g, "&gt;");
			problem = prepareQueryForMathQuill(problem);
			li = $('<li><a href="' + solvingUrl + '"><span class="mathquill-embedded-latex">' + problem + '</span> <svg><use href="#related_go" data-exclude-when-prepare xlink:href="#related_go"></use></svg></a></li>');
			relatedList.append(li);
		}

		if(this.related.length > limit) {
			li = $('<li><span class="more">' + i18n("Show More") + '</span></li>');
			li.on("click", function() {
				_.addRelatedProblems(100);
			});
			relatedList.append(li);
		}

		$('#related').show();
		$('#relatedList .mathquill-embedded-latex').mathquill();
	},

	showCannotSolve : function(){
        $('#multipleSolutions').append(this.createMessageBox(i18n("cannot solve")));
        $('#multipleSolutions .mathquill-embedded-latex').mathquill();
	},

	getPlotSettings : function(showZoom, allowTouch) {
		return this.plotSettings ? this.plotSettings : {showZoom: showZoom, pixelRatio: window.devicePixelRatio, lineWidth: 2, allowTouch: allowTouch};
	},

	doDynamicPlot : function(showZoom, recur) {
		var _ = this;
		_.showZoom = showZoom;

		// For now, don't show the number line outside of steps
		// if(_.stepsRes && _.stepsRes.plot_output && _.stepsRes.plot_output.meta && _.stepsRes.plot_output.meta.numberLineInfo) {
		// 	setTimeout(function() {
		// 		var numberLine = SyNumberLine.fromNumberLineInfo($('#numberLine .solution_box'), $("#numberLine, #NumberLineLink"), _.stepsRes.plot_output.meta.numberLineInfo);
		// 		if (numberLine.valid) {
		// 			$('#numberLine').show();
		// 			$('#NumberLineLink').show();
		// 		}
		// 	}, 0);
		// }

		var plot = $('#Plot_dynaimc');

		if (_.stepsRes && _.stepsRes.plot_output && _.stepsRes.plot_output.meta && _.stepsRes.plot_output.meta.plotInfo){
			var plotText;
			var plotRequest = _.stepsRes.plot_output.meta.plotInfo.plotRequest;
            if (plotRequest === '') {
                plot.hide();
            }
			else if (_.eitherStepByStepOrChallenge()) {
				plot.hide();
			}
			else if (plotRequest && !recur){
				plot.show();
				_.syPlot = new SyPlot("#sy_graph", {}, this.getPlotSettings(showZoom, false));
				plotText = plot.find('.plotText');
				plotText.hide();
				var sygraph = $("#sy_graph");
				var plotLoading = $("#plot-loading");
				plotLoading.css("position", "absolute");
				plotLoading.css("margin-top", (sygraph.height()/2+1) + "px");
				plotLoading.css("margin-left", (sygraph.width()/2-16) + "px");
				plotLoading.show();

				if (plotRequest === "yes") {
					plotRequest = SYMBOLAB.params.query;
				}

				// plot is not returned with the steps request, make another request to plot, with _.stepsRes.plot_output.meta.plotInfo.plotInfo.plotRequest
				requestPlot(plotRequest);
			}
			else{
				try{
					if (!recur) plot.show();
					_.syPlot = new SyPlot("#sy_graph", _.stepsRes.plot_output.meta.plotInfo, this.getPlotSettings(showZoom, false));
					plotText = plot.find('.plotText');
					plotText.show();
					var plotTitleTarget = plotText.find("#plot-title-target").empty();
					var plotTitle = this.getPlotTitle();
					plotTitleTarget.append(createMathquillSpan(null, plotTitle));
					$('#ExamplesLink').show();
					mathquillifyVisible(plot);
				}
				catch(err){
				    console.log(err);
					plot.hide();
				}
			}

			_.addViewMore();
		} else {
			plot.hide();
		}
	},

	addViewMore: function() {
		var _ = this;

		var query;

		if (_.stepsRes.plot_output.meta.showViewLarger) {
			query = _.stepsRes.query.display;
			if ("System of Inequalities" === _.stepsRes.solution.topic){
				query = query.replace(/,/g, ";");
			}
		}

		var viewLargerPlot = $(".viewLargerPlot");

		if (query) {
			query = query.replace(/ /g, "\\:");
			query = encodeURI(query);
			query = query.replace(/\+/g, "%2B");
			query = query.replace(/&/g, "%26");
			viewLargerPlot.attr('href', 'graphing-calculator?functions=' + query);
			$(".viewLargerPlotContainer").toggle(true);

			viewLargerPlot.off("click").on("click", function() {
				logFunnel('ClickedFeature', 'ViewLargerPlot');
			});
		} else {
			$(".viewLargerPlotContainer").toggle(false);
		}
	},

	getPlotTitle : function() {
		var _ = this;
		var title = "";
		if (_.stepsRes.plot_output.meta.plotInfo && _.stepsRes.plot_output.meta.plotInfo.functionChanges && _.stepsRes.plot_output.meta.plotInfo.functionChanges[0]){
			var functionChanges = _.stepsRes.plot_output.meta.plotInfo.functionChanges[0];
			title = functionChanges.plotTitle;
			if (functionChanges.paramsLatex && functionChanges.paramsLatex.length){

				title += "\\quad\\mathrm{" + i18n('plot assuming') + "}";
				for(var i = 0; i < functionChanges.paramsLatex.length; i++) {
					title += "\\quad ";
					title += functionChanges.paramsLatex[i];
					title += "=";
					title += functionChanges.paramsReplacementsLatex[i];
				}
			}
		}

		return title;
	},

	parseSolutions : function(solution) {
		var first = solution.default;
		if(first !== null) {
			var firstSolutionDiv = createMathquillDiv("solution_math", first, first);
			var solutionOnly = $("#solution-only-target").empty();
			solutionOnly.append(firstSolutionDiv);
			mathquillifyVisible(solutionOnly);
		}

		var okKeys = ["interval", "radians", "degrees", "decimal"];
		var goodKeys = Object.keys(solution).filter(function(k) {
			return okKeys.indexOf(k) >= 0;
		});

		var otherSolutionsContainer = $("#other-solutions-container");
		var otherSolutions = $("#other-solutions").empty();

		if(goodKeys.length > 0) {
			var spacer = $("<div />", {'class': 'other-solutions-spacer', 'html': "&nbsp;"});

			otherSolutions.append(spacer.clone());
			goodKeys.forEach(function(key) {
				var oneSolution = $("<div />", {'class': "one-solution"});
				var oneSolutionTitle = $("<div />", {'class': 'one-solution-title', text: i18n(key)});
				var oneSolutionContents = createMathquillDiv("", solution[key], "solution-" + key);

				oneSolution.append(oneSolutionTitle);
				oneSolution.append(oneSolutionContents);

				otherSolutions.append(oneSolution);
			});
			otherSolutions.append(spacer.clone());

			$("#number-extra-formats").text("+" + goodKeys.length);

			$("#solution-format-indicator").show()
				.off("click")
				.on("click", function() {
					otherSolutionsContainer.toggleClass("hide-important");
					$("#solution-format-indicator").toggleClass("collapse");
					mathquillifyVisible(otherSolutions);
					logFunnel("ClickedFeature", "MultipleSolutions");
				});
		}
	},

	createSolutionBoxDiv : function(oneSolution, highestBox){
		var solutionBox;
		if (highestBox){
			solutionBox = $('<div class="solution_box solution_outside_box"></div>');
		}
		else{
			solutionBox = $('<div class="solution_box solution_inside_box"></div>');
		}

		// if (oneSolution.step_id !== undefined){
		// 	solutionBox.attr("id", oneSolution.step_id);
		// }

		return solutionBox;
	},


	getTitleContainer : function(oneSolution, highestBox) {
		var openCommand = "SYSTEPS.showHideRule(this);";
		if(highestBox) {
			openCommand = "";
		}

		var index = -1;

		if (!this.isToLock(oneSolution)){
			index = this.stepsArrayIndex;
			this.stepsArray[this.stepsArrayIndex] = oneSolution;
			this.stepsHighestBox[this.stepsArrayIndex] = highestBox;
			this.stepsArrayIndex++;
		}

		var titleContainer = $("<div></div>", {onclick: openCommand});

		if (highestBox) {
			titleContainer.addClass("solution_title_container_highest");
		} else {
			titleContainer.addClass("solution_title_container");
		}

		titleContainer.attr("data-index", index);

		var stepIsLocked = oneSolution.isLocked && !this.subscribed;

		var a = $("<a></a>");
		if (stepIsLocked) {
			a.append($("<span class='locked-step'/>", {html: "&nbsp;"}));
			if (!this.seenLockedStep) {
				logFunnel('SeenFeature', "LockedStep");
			}
			this.seenLockedStep = true;
		} else {
			a.append($("<span class='showStepsButton'/>"));
		}

		a.append($("<span class='showButtonText'>" + i18n('show steps') + "</span>"));
		if(!highestBox || stepIsLocked) {
			titleContainer.append(a);
		}

		// if(oneSolution.title === undefined){
		// 	titleContainer.append(createMathquillDiv("title", "title"));
		// }
		// else{
		// 	titleContainer.append(this.getInfoLine("title", oneSolution.title));
		// }

		return titleContainer;
	},

	isToLock : function(oneSolution) {
		return oneSolution.isLocked && !this.subscribed;
	},

	createSolutionBox : function(oneSolution, highestBox){
		var solutionBox = this.createSolutionBoxDiv(oneSolution, highestBox);
		var titleContainer = this.getTitleContainer(oneSolution, highestBox);
		solutionBox.append(titleContainer);
		return solutionBox;
	},

	createSolutionBoxContentUl2 : function(oneSolution, highestBox) {
		var _ = this;
		var stepListElement = $('<div class="solution_step_list"></div>');

		_.renderSteps(oneSolution, highestBox, stepListElement);

		return stepListElement;
	},

	toggleInterimStep: function(element, oneSolution) {
		var _ = this;
		var isOpen = element.hasClass("open");

		if(isOpen) {
			element.removeClass("open");
			_.toggleParentResult(element);
			element.find(".solution_step_list").first().remove();
			element.find(".unlock-steps-message").hide();
			return;
		}

		var stepListElement = $('<div class="solution_step_list"></div>');

		if(oneSolution.input) {
			let input = createMathquillDiv("solution_step_title", oneSolution.input);

			if (oneSolution.meta?.gptData && _.stepsSettings !== "challenge") {
				if(_.useHtmlChat) {
					const aiIcon = $("<svg class='locked-step-icon ai-icon'><use href='#ai-help-with-body'></use></svg>");
					const aiHelpButton = $("<button />", {'class': 'ai-help-element inner'}).append(aiIcon);
					const aiHelpButtonContainer = $("<div>", {'class': 'ai-help-container'}).append(aiHelpButton);

					aiHelpButton.on("click", function (e) {
						e.preventDefault();
						_.openAiHelpDialog(aiHelpButton, oneSolution.meta?.gptData, oneSolution.meta?.gptTitle ?? oneSolution.input, _.stepsRes.query.display);
					});

					input = $("<div>", {class: 'input-with-ai-help'}).append(input).append(aiHelpButtonContainer);
				}
			}

			stepListElement.append(input);
		}

		oneSolution.steps.forEach(function (step) {
			_.renderSteps(step, false, stepListElement);
		});

		element.append(stepListElement);
		element.addClass("open");

		mathquillifyVisible(element);

		if (oneSolution.locked) {
			stepListElement.addClass("locked");

			const containsAi = _.stepsSettings !== "challenge";
			const template = _.getUnlockMessageTemplate(containsAi);
			const unlockStepsElement = $(template);
			element.append(unlockStepsElement);
			const eventType = "Blurred" + (containsAi ? "AI" : "");
			unlockStepsElement.find(".unlock-steps").click(() => { // make all unlockStepsElement clickable, not only the unlock-go-pro button
				showUpgradeReason(eventType);
			});
			unlockStepsElement.find(".reward-ads").click(() => {
				showRewardAds(eventType);
			});

			logFunnel("SeenFeature", eventType);
		} else {
			mathquillifyVisible(element);
			logFunnel('ClickedFeature', "UnlockedInterim");
		}

		_.toggleParentResult(element);

		setTimeout(function() { _.makeScrollable(element); }, 100);
	},

	toggleParentResult: function(interim) {
		const resultLatex = interim.find(
			"> .solution_step_list > .solution_step_title:last-child > .mathquill-embedded-latex, " +
			"> .solution_step_list > .solution_step_title:last-child > .scrollContent > .mathquill-embedded-latex"
		)?.mathquill("latex")
		const nextElementInList = interim.next();
		if (nextElementInList.length === 0 || !nextElementInList.hasClass("solution_step_title")) {
			return;
		}
		if (nextElementInList.find("> .scrollContent > .mathquill-embedded-latex").mathquill("latex") !== resultLatex) {
			return;
		}

		const lastElementInList = interim.parent().children().last();
		const isOpen = interim.hasClass("open");
		nextElementInList.toggleClass("last_result_hidden", isOpen);
		if (lastElementInList[0] === nextElementInList[0]) {
			interim.parent().toggleClass("last_result_hidden", isOpen);
			interim.toggleClass("last_result_hidden", isOpen);
		}
	},

	openAiHelpDialog: function(aiHelpButton, gptData, title, query) {
		const _ = this;

		if(_.useHtmlChat) {
			const chatDialog = new AiChatDialog(
				aiChatDialogNetwork,
				aiHelpButton.parent().parent(),
				(action, reason) => logFunnel(action, reason),
				function () {
					showUpgradeReason(reason)
				},
				_.userFirstName,
				gptData,
				query,
				_.subscribed,
				false);
			chatDialog.show();
		} else {
			notifyOpenAiChatHost(gptData, title, query);
		}
	},

    sendAiChatSeenEvent: function() {
        const _ = this;
        if(!_.useHtmlChat) {
            if (!_.sentNonHtmlChatEvent) {
                logFunnel("SeenFeature", "Chat\tStepIcon");
                _.sentNonHtmlChatEvent = true;
            }
        }
    },

	renderSteps: function (oneSolution, highestBox, stepListElement) {
		var _ = this;

		switch (oneSolution.type) {
			case "interim":

				if (highestBox) {

					if(oneSolution.input) {
						stepListElement.append(createMathquillDiv("solution_step_title", oneSolution.input));
					}

					oneSolution.steps.forEach(function (step) {
						_.renderSteps(step, false, stepListElement);
					});
				} else {
					var interimContainer = $("<div />", {'class': 'interim_container'});
					var titleContainer = $("<div />", {'class': "interim_step_title_container"});
					var title = createMathquillDiv("interim_step_title", oneSolution.title);
					var spacer = $("<div />", {'class': "interim_step_title_spacer", html: "&nbsp;"});

					// you have to refresh the html after doing this, see below
					var svg = $("<svg />", {html: $("<use />", {href: "#chevron-reveal-up-black"}), 'class': "arrow"});

					titleContainer.append(title).append(spacer);

					if (oneSolution.meta?.gptData && _.stepsSettings !== "challenge") {
						const aiIcon = $("<svg class='ai-icon'><use href='#ai-help-inside'></use></svg>");
						const aiHelpButton = $("<span />", {'class': 'ai-help-element print-hide'}).append(aiIcon);
						const aiHelpButtonContainer = $("<div>", {'class': 'ai-help-container'}).append(aiHelpButton);
						titleContainer.append(aiHelpButtonContainer);

                        _.sendAiChatSeenEvent();
					}


					// if(oneSolution.locked) {
					//
					// 	if (!_.seenLockedStep) {
					// 		logFunnel("SeenFeature", "LockedStep");
					// 	}
					// 	_.seenLockedStep = true;
					//
					// 	var lock = $("<svg />", {html: $("<use />", {href: "#locked-step-key-icon"}), 'class': "locked-step-icon"});
					// 	titleContainer.append(lock);
					// }

					titleContainer.append(svg);
					interimContainer.append(titleContainer);
					stepListElement.append(interimContainer);

					// refresh html for SVGs
					titleContainer.html(titleContainer.html());

					titleContainer.on("click",  function() {
						_.toggleInterimStep(interimContainer, oneSolution);
					});

					if(!_.useHtmlChat) {
						const aiHelpButtonContainer = $(".ai-help-container", titleContainer);
						const aiHelpButton = $(".ai-help-element", aiHelpButtonContainer);
						aiHelpButtonContainer.on("click", function (e) {
							e.preventDefault();
							logFunnel("ClickedFeature", "Chat\tStepIcon");
							_.openAiHelpDialog(aiHelpButton, oneSolution.meta?.gptData, oneSolution.meta?.gptTitle ?? oneSolution.input, _.stepsRes.query.display);
						});
					}
				}

				break;
			case "step":

                if (oneSolution.meta?.gptData && _.stepsSettings !== "challenge") {
                    const aiIcon = $("<svg class='ai-icon'><use href='#ai-help-inside'></use></svg>");
                    const aiHelpButton = $("<span />", {'class': 'ai-help-element print-hide'}).append(aiIcon);
                    const aiHelpButtonContainer = $("<div>", {'class': 'ai-help-container'}).append(aiHelpButton);
                    stepListElement.append(aiHelpButtonContainer);

                    _.sendAiChatSeenEvent();
                }

				if(oneSolution.primary) {
					stepListElement.append(createMathquillDiv("solution_step_primary", oneSolution.primary));
				}

				if(oneSolution.secondary) {
					oneSolution.secondary.forEach(function(sec) {
						stepListElement.append(createMathquillDiv("solution_step_secondary", sec));
					});
				}

				if(oneSolution.image !== undefined) {
					setTimeout(function() {
						var inStepImage = SyNumberLine.fromInStepImageUrl(stepListElement, $("blank"), oneSolution.image);
					}, 0);
				}

                if(!_.useHtmlChat) {
                    const aiHelpButtonContainer = $(".ai-help-container", stepListElement);
                    const aiHelpButton = $(".ai-help-element", aiHelpButtonContainer);
                    aiHelpButtonContainer.on("click", function (e) {
                        e.preventDefault();
                        logFunnel("ClickedFeature", "Chat\tStepIcon");
                        _.openAiHelpDialog(aiHelpButton, oneSolution.meta?.gptData, oneSolution.meta?.gptTitle ?? oneSolution.input, _.stepsRes.query.display);
                    });
                }

				break;

			case "definition":

				_.writeDefinition(stepListElement, oneSolution);

				if(oneSolution.secondary) {
					oneSolution.secondary.forEach(function(sec) {
						stepListElement.append(createMathquillDiv("solution_step_secondary", sec));
					});
				}

				break;
				
			case "html":
				var delim = new RegExp("</?formula.*?>","g");
				let stepText = $('<div class="external_step"></div>');
				stepText.append(oneSolution.content.replaceAll(delim, "###"));

				renderMathInElement(stepText[0], {
					delimiters:	[{left: "###", right: "###", display: false}]
				});
				// katex couldn't render for some reason
				if (stepText[0].innerText.indexOf("###") >= 0) {
					stepListElement.append(stepText);
					return;
				}
				stepListElement.append(stepText);
				// state.callbacks.handleElementAdded?.("html-step-content", stepText, oneSolution)
				break;
		}

		if(oneSolution.result) {
			var result = createMathquillDiv("solution_step_title", oneSolution.result);
			stepListElement.append(result);
		}
	},

	writeDefinition : function(target, oneSolution) {
		var defTitle = $("<div />", {'class': "solution_step_definition_title_container"});
		var left = $("<svg class='info'><use href='#definition-i-icon'></use></svg>");
		var text = createMathquillDiv("text", oneSolution.title);
		var right1 = $("<svg class='expand'><use href='#definition-expand'></use></svg>");
		var right2 = $("<svg class='collapse'><use href='#definition-collapse'></use></svg>");
		defTitle.append(left).append(text).append(right1).append(right2);

		// replace \\mathrm blocks with several \\mathrm blocks separated by spaces
		// (treat blocks with parentheses as single monolithic blocks)
		let oneSolutionText = oneSolution.text.replace(/\\mathrm{([^(}]+)}/ig, function(match, words, offset) {
			// capture all words in between
			let allWords = words.split(/\s|\\:/);

			// remove empty words
			let allWordsNoBlanks = allWords.filter(function(word) {
				return word !== "";
			});

			// join all words in \\mathrm pieces with a space in between each one
			let newWords = allWordsNoBlanks.join("}\\:\\mathrm{");

			var addSpace = "";
			if(offset > 0) {
				addSpace = " ";
			}

			// add to output
			return addSpace + "\\mathrm{" + newWords + "} ";
		});

		var defBody = createMathquillDiv("solution_step_definition_body", oneSolutionText);

		var defAll = $("<div />", {'class': "solution_step_definition"}).append(defTitle).append(defBody);

		target.append(defAll);
	},

	createSolutionBoxContentUl : function(oneSolution, highestBox){
		var _  = this;
		var appendQueryInput = true;
		var stepList;
		if (typeof(isCompare) != "undefined" && isCompare){
			stepList = $('<div style="margin-left:-15px !important;list-style:inherit;list-style-type: decimal;" type="1" id="steps-container" class="solution_step_list"></div>');
		}
		else{
			stepList = $('<div id="steps-container" class="solution_step_list"></div>');
		}
		if (highestBox){
			stepList.append($("<li class='solution_step_list_itemc solution_steps_text'>" + (oneSolution.isInfoStep ? "" : i18n('steps')) + "</li>"));
		}

		if (oneSolution.definition !== undefined){
			stepList.append(this.getDefintionLine(oneSolution.definition, highestBox));
			appendQueryInput = false;
		}

		var div;

		if (oneSolution.general_rule !== undefined){
			div = $("<div></div>");
			div.append(this.getInfoLine("rule", oneSolution.general_rule));
			stepList.append(div);
			appendQueryInput = false;
		}

		if (oneSolution.explanation !== undefined){
			for (var idx2 in oneSolution.explanation) {
				div = $("<div></div>");
				div.append(createMathquillDiv('solution_step_explanation', oneSolution.explanation[idx2].createdText, oneSolution.explanation[idx2].id));
				stepList.append(div);
				appendQueryInput = false;
			}
		}

		if (appendQueryInput === true && oneSolution.step_input !== undefined){
			stepList.append(createMathquillDiv("solution_step_result", oneSolution.step_input));
			stepList.append($("<hr class='stepsHr'/>"));
		}

		var stepListItem;
		var wasEntireResultEnetered = false;
		for (var idx in oneSolution.steps) {
			var step = oneSolution.steps[idx];
			stepListItem = this.createStepListItem(step);
			if (this.isAddHR(stepListItem, stepList)) {
				stepList.append($("<hr class='stepsHr'/>"));
			}
			stepList.append(stepListItem);
			wasEntireResultEnetered = stepListItem.find(">.solution_step_result").size() > 0;
		}

		if (wasEntireResultEnetered === false){
			stepListItem = $('<li class="solution_step_list_item"></li>');
			stepListItem.append(createMathquillDiv("solution_step_result", oneSolution.entire_result));
			stepList.append(stepListItem);
		}

		return stepList;
	},

	createStepListItem : function(oneStep){
		var _ = this;

		var stepListItem = $('<li class=" "></li>');

		switch (oneStep.type) {
			case "interim":

				var content = this.createSolutionBoxContent(oneStep, false);
				stepListItem.append(content);
				mathquillifyVisible(content);
				setTimeout(function() {_.makeScrollable(content);}, 100);

				break;
			case "step":

				this.populateStepListItem(stepListItem, oneStep);
				break;

			case "definition":

				_.writeDefinition(stepListItem, oneStep);

				break;

			case "html":
				var delim = new RegExp("</?formula.*?>","g");
				let stepText = $('<div class="external_step"></div>');
				stepText.append(oneStep.content.replaceAll(delim, "###"));

				renderMathInElement(stepText[0], {
					delimiters:	[{left: "###", right: "###", display: false}]
				});
				// katex couldn't render for some reason
				if (stepText[0].innerText.indexOf("###") >= 0) {
					stepListItem.append(stepText);
					return;
				}
				stepListItem.append(stepText);
				// state.callbacks.handleElementAdded?.("html-step-content", stepText, oneSolution)
				break;
			default: // for Practice hint
				stepListItem = $('<li class="solution_step_list_item"></li>');
				this.populateStepListItem(stepListItem, oneStep);
		}

		return stepListItem;
	},

	createSolutionBoxContent : function(oneSolution, highestBox){
		var _ = this;
		var ul = this.createSolutionBoxContentUl2(oneSolution, highestBox);
		var ulDiv = $("<div></div>", {"class": "ul-div"});
		if (!highestBox){
			ulDiv.addClass('solution_list_div');
		}

		ulDiv.append(ul);
		return ulDiv;
	},

	addNotesDiv : function(){
		var _ = this;
		var h = $("#main-input").innerHeight();
		$(".nl-notesFav").css('margin-top', h/2-15);
		$(".nl-notesFav").show();
	},

	openCloseNotes :  function(){
		var next = $(".notesTitle").next();
		var parent = $(".notesTitle").parent();

		if(next.is(":visible")){
			next.hide();
			$('.notesTitle').text(i18n('Save'));
		}else{
			next.show();
			$('.notesTitle').text(i18n('Notes'));
		}
		var height = parent.outerHeight() + 3;
		if (typeof(SYPRAC) != "undefined"){
			height += 3;
		}
		parent.css("margin-top", "-"+height + "px");
	},

	injectChImage : function(id, base64) {
		var div = $("div." + id);
		var img = $("<img />", {"src": 'data:image/png;base64,' + base64});
		div.append(img);
	},

	injectImage : function(id, width, base64, type, isEmptyImage) {
		var _ = this;
		var image = $("img." + id);
		if(image.length === 0) {
			// backwards compatibility for outside-of-steps
			var stepListItem = $("." + id);
			image = $("<img />");
			image.css({"width": width});

			if(!isEmptyImage) {
				// blank image does not get extra padding
				image.css({"padding": "10px"});
			}

			stepListItem.append(image);
		}

		if(isEmptyImage === "false" || isEmptyImage === false) {
			image.on("load", function () {
				image.off("load");

				if (type === "gif" || type === "png") {
					image.parent().parent().find(".loader").remove();
					var playStopGif = image.parent().parent().parent().find(".playStopGifBtn");
					if (type === "gif") {
						playStopGif.addClass("nl-show");
						playStopGif.addClass("play_icon");
					} else {
						playStopGif.hide();
					}
				} else {
					image.parent().hide();
				}

				// go up two levels, to catch both styles
				image.parent().parent().find(".empty_number_line_img").remove();
				image.show();
			});
		}

		image.attr("src", 'data:image/png;base64,' + base64);
	},

	populateStepListItem : function(stepListItem, oneStep) {
		if (oneStep.step_id !== undefined){
			stepListItem.attr("id", oneStep.step_id);
		}

	 	if (oneStep.title !== undefined){
	 		if (oneStep.general_rule !== undefined){
				if (this.requestLang === "he"){
					oneStep.title.text.createdText = oneStep.general_rule.text.createdText + "\\quad:" + oneStep.title.text.createdText;
				}else{
					oneStep.title.text.createdText += ":\\quad " + oneStep.general_rule.text.createdText;
				}

				oneStep.general_rule = null;
	 		}
	 		stepListItem.append(this.getInfoLine("title", oneStep.title));
	 	}

		if (oneStep.definition !== undefined){
			var div = $("<div></div>");
			div.append(this.getDefintionLine(oneStep.definition, false));
			stepListItem.append(div);
		}
		if (oneStep.general_rule !== undefined){
			stepListItem.append(this.getInfoLine("rule", oneStep.general_rule));
		}

		var idx2;

		if (oneStep.explanation !== undefined){
			for (idx2 in oneStep.explanation) {
				stepListItem.append(createMathquillDiv('solution_step_explanation', oneStep.explanation[idx2].createdText, oneStep.explanation[idx2].id));
			}
		}

		if(oneStep.image !== undefined) {
			setTimeout(function() {
				var inStepImage = SyNumberLine.fromInStepImageUrl(stepListItem, $("blank"), oneStep.image);
			}, 0);
		}

		if (oneStep.steps !== undefined){
			for (idx2 in oneStep.steps) {
				var interim = oneStep.steps[idx2];
				if (interim.isInterimStep){
					var interimDiv = this.createSolutionBox(interim);
					stepListItem.append(interimDiv);
				}
				else{
					//interim.result = null;
					this.populateStepListItem(stepListItem, interim);
					if (interim.result == null && idx2 < (oneStep.steps.length - 1)){
						stepListItem.append("<br/>");
					}
				}
			}
		}

		if(oneStep.primary) {
			stepListItem.append(createMathquillDiv("solution_step_primary", oneStep.primary));
		}

		if(oneStep.secondary) {
			oneStep.secondary.forEach(function(sec) {
				stepListItem.append(createMathquillDiv("solution_step_secondary", sec));
			});
		}

		if (oneStep.result !== undefined){
			stepListItem.append(createMathquillDiv("solution_step_result", oneStep.result));
		}
	},

	isAddHR : function(stepListItem, stepList) {
		var lastItem = stepList.children().last();

		if (stepListItem.find(">.solution_box").size()>0 && lastItem.find(">.solution_step_result").size() === 1) return true;
		if (lastItem.size() === 0 || lastItem.is("hr") || lastItem.text() === "Steps") return false;
		if ( $(stepListItem).children().length <= 1) return false;
		if (lastItem.find(">.solution_box").size()>0 && lastItem.find(">.solution_step_result").size() === 0) return false;

		return true;
	},

	getDefintionLine : function(infoLine, highestBox){
		var definitionBox = $('<div class="solution_box solution_step_definition_main"></div>');
		var titleContainer = $('<div class="solution_step_definition" onclick="SYSTEPS.showHideRule(this)" ></div>');

		var a = $("<a></a>");
		a.append($("<span class='print-hide hideStepsButton'/>"));
		a.append($("<span class='print-hide hideButtonText'>" + i18n('hide definition') + "</span>"));

		titleContainer.append(a);
		titleContainer.append(createMathquillDiv("solution_step_title_text", infoLine.text.createdText, infoLine.text.id));

		definitionBox.append(titleContainer);
		var defBox = createMathquillDiv("solution_step_definition_text", infoLine.extension.createdText, infoLine.extension.id);
		definitionBox.append(defBox);

		return definitionBox;
	},

	getInfoLine : function(type, infoLine) {
	    var _ = this;
	    var topDiv = $("<div></div>");

	    if (infoLine){
	        if(infoLine.text_part1 !== undefined && infoLine.text_part2 !== undefined) {
	            var line1 = _.getSingleInfoLine(type, infoLine.text_part1.createdText, infoLine.text_part1.id, "splitAnswerFirst");
	            var colon = _.getSingleInfoLine(type, "\\quad:\\quad", infoLine.text_part1.id, "splitAnswerLineColon");
	            var line2 = _.getSingleInfoLine(type, infoLine.text_part2.createdText, infoLine.text_part2.id, "splitAnswerLine");

				topDiv.append(line1);
	            topDiv.append(colon);
	            topDiv.append(line2);
	        } else {
	            var line = _.getSingleInfoLine(type, infoLine, infoLine.text);
	            topDiv.append(line);
	        }
	    }

        return topDiv;
	},

	getSingleInfoLine : function(type, text, id, extraClass){
		var span = $('<div class="solution_step_' + type + '"></div>');

		if(extraClass !== undefined) {
		    span.addClass(extraClass);
		}

		text = createMathquillSpan("solution_step_" + type + "_text", text, id);
        text.css('position', 'relative');
        span.append(text);
		return span;
	},

    openHideStepsNew :function(index, open){
		var _ = this;

		var select = $('.show-hide-steps-div').filter(function() { return $(this).data("index") === index; });
		var target = $('.solution_title_container_highest').filter(function() { return $(this).data("index") === index; });

		$('.notesMainDiv').remove();
		$('.stepsPracticeLink').remove();

		if (open) {
			target.parent().find(".ul-div").remove();

			_.addContentIfNeeded(target);
			_.updateNotesPractice(target);

            target.prepend($("<div></div>", {css: {"clear": "both"}}));
            target.prepend(_.getSolvingOptions());

			target.parent().find(".ul-div").show();
		} else {
			target.parent().find(".ul-div").hide();
			_.removeSolvingOptions();
		}

		var value = select.find(".value");
		value.attr('value', open ? "showSteps" : "hideSteps");
		value.text(_.showHideMap[open ? "showSteps" : "hideSteps"]);
	},

	openHiddenSteps :function(obj, shouldLog) {
		var _ = this;
		var jq = $(obj);
		var button = jq.find('.show-hide-steps');
		if (button.size() === 0) return;

		var next = jq.next();
		$('.notesMainDiv').remove();
		$('.stepsPracticeLink').remove();
		if (button.text().indexOf(i18n('show steps')) >= 0) {
			this.addContentIfNeeded(jq);
			button.text("\u00AB " + i18n('hide steps'));
			_.updateNotesPractice(jq);
		}
		else {
			next.hide();
			button.text(i18n('show steps') + " \u00BB");

			if(shouldLog) {
				symbolab_log("Solutions", "	Steps", null, $("#main-input").mathquill('latex'));
			}
		}
	},

	setSavedNote : function(noteJq, savedClass) {
		var _ = this;
		if (isUserLoggedIn()) {
			if(_.stepsRes.isInNotebook) {
				noteJq.addClass(savedClass);
			}
		}
	},

	updateNotesPractice : function(jq){
		var _ = this;
	},

	addContentIfNeeded : function(jq){
		let _ = this;
		var index = jq.data("index");
		if (typeof(index) != "undefined") {
			var content = this.createSolutionBoxContent(this.stepsArray[index], this.stepsHighestBox[index]);
			jq.parent().append(content);
			mathquillifyVisible(content);
			setTimeout(function() {_.makeScrollable(content);}, 100);

			//For the rules/definitions, we remove this placeholder
			//so it is only generated once, and hidden/shown after that
			if(!jq.hasClass('solution_title_container_highest')) {
				jq.removeData("index");
				jq.removeAttr("data-index");
			}
		}
		else{
			jq.parent().find(".ul-div").show();
			jq.parent().find(".solution_step_definition_text").show();
		}
	},

	openHiddenPlot : function(){
		if ($('.show-hide-plot').text().indexOf(i18n('show plot')) >= 0){
			$('.show-hide-plot').text('« ' + i18n('hide plot'));
			$('#plot-image').show();
			$('#sy_graph').show();
			$("#Plot_dynaimc").removeClass('plot-closed');
			if (typeof(SYMBOLAB) != "undefined" && typeof(SYPAD) != "undefined"){
				symbolab_log('Solutions', 'hideSteps', SYPAD.inputValue('latex'));
			}
		}
		else{
			$('.show-hide-plot').text(i18n('show plot') + ' »');
			$('#plot-image').hide();
			$('#sy_graph').hide();
			$("#Plot_dynaimc").addClass('plot-closed');
		}
	},

	combineTextEquation : function(text, equation){
		var out = "";
		if (text){
			out += text;
			out += " ";
		}
		out+=equation;
		return out;
	},

	createMessageBox : function(text){
		var solutionDiv = $('<div class="solution_div"></div>');
		var solutionBox = $('<div class="solution_box solution_outside_box"></div>');
		var titleContainer = $("<div class='solution_title_container_highest'> </div>");
		titleContainer.append(createMathquillDiv("solution_step_title", text));
		solutionBox.append(titleContainer);
		solutionDiv.append(solutionBox);
		return solutionDiv;
	},

	isShowMoreImage : function (obj){
		return $(obj).find(".showStepsButton").size() > 0;
	},

	changeToShowMore : function (obj){
		var button = $(obj).find(".hideStepsButton");
		button.removeClass("hideStepsButton");
		button.addClass("showStepsButton");

		var text = $(obj).find(".hideButtonText");
		text.removeClass("hideButtonText");
		text.addClass("showButtonText");

		var textContent = text.html();
		if (textContent != null){
			textContent = textContent.replace(i18n('hide'), i18n('show'));
			text.html(textContent);
		}
	},

	changeToShowLess : function (obj){
		var button = $(obj).find(".showStepsButton");
		button.removeClass("showStepsButton");
		button.addClass("hideStepsButton");

		var text = $(obj).find(".showButtonText");
		text.removeClass("showButtonText");
		text.addClass("hideButtonText");

		var textContent = text.html();
		if (textContent != null){
			textContent = textContent.replace( i18n('show'),  i18n('hide'));
			text.html(textContent);
		}
	},

	showHideRule : function(obj){
		var jq = $(obj);
		if (jq.find('.show-hide-steps').size() > 0){
			return;
		}
		var next = $(obj).next();
		if ($(obj).find(".locked-step").size() > 0){
			showUpgradeReason("LockedStep");
		}
		else if (this.isShowMoreImage(obj)){
			this.addContentIfNeeded(jq);
			this.changeToShowLess(obj);
		}
		else{
			next.hide();
			this.changeToShowMore(obj);
		}
	},

	twoLineTitle : function(jq) {

        jq.find(".splitAnswerLine").each(function() {
            var element = $(this);

            var parent = element.parent();


            var height = parent.find(".splitAnswerFirst").height();
            var colon = parent.find(".splitAnswerLineColon");
            colon
                .height(height + 1)
                .css({"line-height": "" + (height + 1) + "px"});
            if(colon.offset().left < 50) {
                colon.hide();
            }

            if(element.offset().left < 50) {
                element.prev().css('opacity', '0.0'); //hide extra colon element

                var solutionText = i18n("solution");
                if(element.find("span.selectable").text().indexOf(solutionText) > -1) {
                    //redundant to add "Answer" when "Solution" appears
                    return;
                }

                var answerWordSpan = $("<span></span>").text("\\mathrm{" + i18n("js.Answer") + "}:\\quad");

                var scrollContent = element.find(".scrollContent");
                if(scrollContent.length > 0) {
                    scrollContent.prepend(answerWordSpan);
                } else {
                    element.prepend(answerWordSpan);
                    element.find(".solution_step_title_text").css({"display": "inline"});
                }
                answerWordSpan.mathquill();
            }

            //after all has been settled, set height of last element

            var answerHeight = element.height();
            if(answerHeight > height) {
                parent.find(".splitAnswerFirst, .splitAnswerLineColon")
                    .height(answerHeight + 1)
                    .css({"line-height": "" + (answerHeight + 1) + "px"});
            } else {
                element
                    .height(height + 1)
                    .css({"line-height": "" + (height + 1) + "px"});
            }
        });
	},

	makeScrollable : function(jq){
		var steps = this;

		jq.find(".interim_step_title, .solution_step_primary, .solution_step_title, .solution_step_result, .solution_step_explanation, .solution_step_definition_text, .solution_scrollable, .solution_math").not(".splitAnswerLineColon").each(function(){
		    var parent = $(this);
			if(parent.is(":visible") && !parent.hasClass("syscrollable")){
				var embedded = parent.find(".mathquill-embedded-latex");
				if(embedded.length === 1){

			        if(parent.hasClass("splitAnswerFirst")) {
			            steps.createScrollIgnoreMathrm(this);
			        } else {
						// mathquill doesn't put the break where it belongs, even when using mathrm ><
						steps.createScrollIgnoreMathrm(this);
					}
				}
				else{
					$(this).find(".multiline").each(function() {
						if(parent.hasClass("splitAnswerFirst")) {
                            steps.createScrollIgnoreMathrm(this);
                        } else {
                            steps.createScroll(this);
                        }
					});
				}
	    	}
		});
	},

	createScrollIgnoreMathrm : function(element) {
        var _ = this;
        if ($(element).width() === 0){
            return;
        }

        var totalWidth = getActualWidth(element, true);

		var parent = $(element).parent();
		var allOtherElementsWidths = parent.children().map(function(i, elem) {
			if($(elem) === $(element)) {
				return 0;
			}

			return $(elem).outerWidth(true);
		}).toArray().reduce(function(prev, curr) {
			return prev + curr;
		}, 0);

		var totalRoom = parent.width() - allOtherElementsWidths;

        if (totalWidth < totalRoom){
            return;
        }

        createScrollForce(element, totalWidth);

        $(element).css({"float": "none"});
	},

	scrollPageToTheTop: function() {
		window.scrollTo({
			top: 0,
			left: 0,
			behavior: 'smooth'
		});
	},

	createScroll : function(element){
		var _ = this;
		if ($(element).width() === 0){
			return;
		}

		//Mathquill can wrap lines nicely but only if they are \mathrm.

		var answerWidth = 70;

        	var totalWidth = getActualWidth(element, true) + answerWidth;
        	var nonMathrmWidth = getActualWidth(element, false);
        	if( $(element).hasClass("solution_scrollable")){
        	    if (nonMathrmWidth < $(element).parent().width()){
                    return;
                }
        	}else{
            	if (nonMathrmWidth < $(element).parent().width() + answerWidth){
        	    	return;
        	    }
        	}

        	createScrollForce(element, totalWidth);

		$(element).css({"float": "none"});
	},

	getUnlockMessageTemplate: function(containsAi) {
		const unlockAction = containsAi ? i18n("Upgrade") : i18n("show steps");
		const rewardAds = i18n("Watch Ad");
		const imageId = Math.floor(Math.random() * 3) + (containsAi ? 3 : 1);
		const unlockTitle = i18n("Unlock Solution Steps");
		const unlockMsg = i18n("Get full access to all solution steps for any math problem");
		console.log(imageId);

		return`<div class="unlock-steps-message print-hide">
					<svg><use href="#unlock-steps-${imageId}"></use></svg>
					<div class="unlock-title">${unlockTitle}</div>
					<div class="unlock-message">${unlockMsg}</div>
					<div class="buttons-container ${abTestValue === 0 ? 'oneButton' : ''}">
						<button class="unlock-go-pro unlock-steps ${imageId === 3 && containsAi ? 'with-image' : ''}">
							<span>${unlockAction}</span>
						</button>
						<button class="unlock-go-pro reward-ads ${abTestValue === 0 ? 'hide-important' : ''}">
							<span>${rewardAds}</span>
						</button>
					</div>
				</div>`;
	}
};
