#extension GL_OES_EGL_image_external : require
precision mediump float;
varying vec2 textureCoordinate;
uniform samplerExternalOES inImageTexture;

uniform int mEnhanceQuality;
uniform float mContrastAdjust;
uniform float mBrightnessAdjust;
uniform float mSaturationAdjust;

uniform vec2  blurCenter;
uniform float blurRadius;
uniform float aspectRatio;
uniform float textureWidthOffset;
uniform float textureHeightOffset;

const int GAUSSIAN_SAMPLES = 9;
vec2 blurCoordinates[GAUSSIAN_SAMPLES];

const float epsilon = 1e-10;
const vec3 halfVal = vec3(0.5, 0.5, 0.5);


vec3 hslToRgbColor(vec3 hsl) {
    float r = abs(hsl.x * 6.0 - 3.0) - 1.0;
    float g = 2.0 - abs(hsl.x * 6.0 - 2.0);
    float b = 2.0 - abs(hsl.x * 6.0 - 4.0);
    vec3 rgb = clamp(vec3(r, g, b), 0.0, 1.0);
    float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
    return (rgb - 0.5) * c + hsl.z;
}


vec3 rgbToHslColor(vec3 rgb) {
    vec4 p = (rgb.g < rgb.b) ? vec4(rgb.bg, -1.0, 2.0 / 3.0) : vec4(rgb.gb, 0.0, -1.0 / 3.0);
    vec4 q = (rgb.r < p.x) ? vec4(p.xyw, rgb.r) : vec4(rgb.r, p.yzx);
    float c = q.x - min(q.w, q.y);
    float h = abs((q.w - q.y) / (6.0 * c + epsilon) + q.z);
    float l = q.x - c * 0.5;
    float s = c / (1.0 - abs(l * 2.0 - 1.0) + epsilon);
    return vec3(h, s, l);
}


void main() {
    vec4 glRgbColor = texture2D(inImageTexture, textureCoordinate);

    if (mEnhanceQuality == 1) {
        vec3 hslColor = rgbToHslColor(glRgbColor.rgb);

        float saturation = 1.0 + smoothstep(0.05, 0.8, hslColor.y) / 2.0;
        saturation = clamp(saturation, 1.0, mSaturationAdjust);
        float average = (glRgbColor.r + glRgbColor.g + glRgbColor.b) / 3.0;

        saturation = step(0.05, average) == 1.0 ? saturation : 1.0;
        hslColor.y = clamp(hslColor.y * saturation, 0.0, 1.0);

        float diffc = 1.0 - smoothstep(0.0, 0.7, hslColor.z);
        diffc = mBrightnessAdjust + diffc * 0.05;
        float brightnessAdjust = hslColor.z <= 0.7 ? diffc : 0.0;
        hslColor.z = clamp(hslColor.z + brightnessAdjust, 0.0, 1.0);
        glRgbColor = vec4(hslToRgbColor(hslColor), glRgbColor.a);

        vec3 contrastColor = mContrastAdjust * (glRgbColor.rgb - halfVal) + halfVal;
        glRgbColor.r = clamp(contrastColor.r, 0.0, 1.0);
        glRgbColor.g = clamp(contrastColor.g, 0.0, 1.0);
        glRgbColor.b = clamp(contrastColor.b, 0.0, 1.0);
    }

    gl_FragColor = glRgbColor;
}