webpackJsonp([14],{

/***/ "K0nL":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "Qyrf":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAICAYAAACccC2SAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyFpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQyIDc5LjE2MDkyNCwgMjAxNy8wNy8xMy0wMTowNjozOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo1NUVFREIxMjdGNEYxMUU4ODNGOENEMjFDM0RCOEQ4RSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo1NUVFREIxMzdGNEYxMUU4ODNGOENEMjFDM0RCOEQ4RSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjU1RUVEQjEwN0Y0RjExRTg4M0Y4Q0QyMUMzREI4RDhFIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjU1RUVEQjExN0Y0RjExRTg4M0Y4Q0QyMUMzREI4RDhFIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+4F3rsAAAAJBJREFUeNpidDr4hwEIVIG4A4hdGCBgDxBXAPFtBtyAqnoYgQ5RBzJOALEAmqYPQGwBxDexGEh1PUxAog2LJANUrA2Hz6iuBxQiH4EMPhyavwAxLxZxquthYhgkgAmaYHCBXTjEqa4HFDUaQMZxHInIEohvYNFIdT1MUE2glL4OiD9D8Tqo2A0cPqC6HoAAAwAFEz9X+Pji7AAAAABJRU5ErkJggg=="

/***/ }),

/***/ "ekzJ":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "l/YE":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/timePicker/timePicker.vue + 2 modules
var timePicker = __webpack_require__("+7rW");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./src/components/studentList/module/index.js


var defaultImg = __webpack_require__("7G5z");
/* harmony default export */ var studentList_module = ({
    props: {
        studentList: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        AttendanceMark: {
            type: Boolean
        },
        detailFlag: {
            type: Boolean,
            default: false
        },
        activeIndex: {
            type: Boolean,
            default: 0
        },
        AllStudentList: {
            type: Array,
            default: function _default() {
                return [];
            }
        }
    },
    data: function data() {
        return {
            longTapAnimateFlag: null,
            chooseAllFlag: false,
            operationFlag: true,
            localIndex: '', // 本地存储开启动画列表元素的index值
            changeList: {
                status: '',
                studentId: [],
                ids: []
            }
        };
    },
    created: function created() {
        this.longTapAnimateFlag = null;
    },

    methods: {
        call: function call(name, tel, item) {
            if (item.substituteApply) {
                Object(bridgeAPI["f" /* callSomeOne */])({
                    title: name + '\u5BB6\u957F',
                    content: item.substituteApply.phoneNumber ? item.substituteApply.phoneNumber : tel,
                    operate: '拨打'
                });
            } else {
                Object(bridgeAPI["f" /* callSomeOne */])({
                    title: name + '\u5BB6\u957F',
                    content: tel,
                    operate: '拨打'
                });
            }
        },
        returnTimeType: function returnTimeType(time) {
            var str = '',
                dayStr,
                toDayStr,
                localDayStr;
            localDayStr = new Date().getDate();
            if (localDayStr < 10) {
                localDayStr = '0' + localDayStr;
            }
            toDayStr = time.split(' ')[0].split('-')[2];
            if (parseInt(localDayStr) == parseInt(toDayStr)) {
                dayStr = '今天';
            } else if (parseInt(toDayStr) - parseInt(localDayStr) == 1) {
                dayStr = '明天';
            } else if (parseInt(toDayStr) - parseInt(localDayStr) == 2) {
                dayStr = '后天';
            } else {
                dayStr = parseInt(toDayStr) + '号';
            }
            if (time.indexOf('10:00:00') != -1) {
                str = '(时段:' + dayStr + '上午)';
            } else if (time.indexOf('12:00:00') != -1) {
                str = '(时段:' + dayStr + '中午)';
            } else if (time.indexOf('13:00:00') != -1) {
                str = '(时段:' + dayStr + '下午)';
            } else {
                str = '(时段:' + dayStr + '放学)';
            }
            return str;
        },
        toPickDetail: function toPickDetail(id, flag, animateFlag, substituteFlag) {
            // 跳转接送详情 title: 接送处理
            var op = {};
            if (flag) {
                op.url = 'normalPickDetail?id=' + id + '&substitude=' + substituteFlag;
                op.title = '接送处理';
            } else {
                op.url = 'studentDetail?id=' + id;
                op.title = '接送详情';
            }
            if (animateFlag) {
                setTimeout(function () {
                    Object(bridgeAPI["o" /* newWindow */])(op);
                }, 200);
            } else {
                Object(bridgeAPI["o" /* newWindow */])(op);
            }
        },

        switchLeaveType: function switchLeaveType(type) {
            var leaveText;
            switch (type) {
                case 0:
                    leaveText = '事假';
                    break;
                case 1:
                    leaveText = '病假';
                    break;
                case 2:
                    leaveText = '其他';
                    break;
                default:
                    leaveText = '其他';
            }
            return leaveText;
        },
        changeStudentStatus: function changeStudentStatus() {
            var _this = this;

            // 判断是更改考勤还是更改代接
            if (this.changeList.substitute) {
                this.$http.post(api["G" /* changeSubstituteStatus */], {
                    id: this.changeList.ids,
                    status: this.changeList.status
                }).then(function (res) {
                    _this.chooseAllFlag = false;
                    bridgeAPI["n" /* loading */].hide();
                    // 关闭动画
                    if (_this.longTapAnimateFlag) {
                        _this.longTapAnimateFlag = false;
                    }
                    setTimeout(function () {
                        _this.longTapAnimateFlag = null;
                    }, 200);
                    _this.$emit('updateList');
                });
            } else {
                this.$http.post(api["F" /* changeSignStatus */], {
                    studentId: this.changeList.studentId,
                    status: this.changeList.status
                }).then(function (res) {
                    _this.chooseAllFlag = false;
                    bridgeAPI["n" /* loading */].hide();
                    if (_this.longTapAnimateFlag) {
                        _this.longTapAnimateFlag = false;
                    }
                    setTimeout(function () {
                        _this.longTapAnimateFlag = null;
                    }, 200);
                    _this.$emit('updateList');
                });
            }
        },
        allStateChange: function allStateChange(toLabel) {
            var tempArr = [];
            bridgeAPI["n" /* loading */].show();
            // 判断是否全选， 是的话取所有数据， 不是的话取选中数据
            if (this.chooseAllFlag) {
                tempArr = this.AllStudentList;
            } else {
                this.studentList.forEach(function (item) {
                    if (item.checkFlag) {
                        tempArr.push(item);
                    }
                });
            }
            this.addChangeList(tempArr, toLabel);
            this.changeStudentStatus();
        },
        singleChangeStatus: function singleChangeStatus(item, toLabel) {
            this.addChangeList(item, toLabel);
            this.changeStudentStatus();
        },
        addChangeList: function addChangeList(itemArr, toLabel) {
            var _this2 = this;

            // 每次调用添加变更数据的时候，先清空数组
            var tempArr = [];
            this.changeList.status = '';
            this.changeList.studentId = [];

            switch (toLabel) {
                case 'atSchoolList':
                    this.changeList.status = 2;
                    this.changeList.substitute = false;
                    break;
                case 'leaveApplyList':
                    this.changeList.status = 1;
                    this.changeList.substitute = false;
                    break;
                case 'leaveSchoolList':
                    this.changeList.status = 3;
                    this.changeList.substitute = false;
                    break;
                case 'substituteApplyList':
                    this.changeList.status = 0;
                    this.changeList.substitute = true;
                    break;
            }
            if (Array.isArray(itemArr)) {
                tempArr = itemArr;
            } else {
                tempArr.push(itemArr);
            }
            // 判断变更的是否是代接， 如果是，则传入代接id,不是的话，传入studentId
            if (toLabel == 'substituteApplyList') {
                tempArr.forEach(function (item, index) {
                    _this2.changeList.ids.push(item.id);
                });
            } else {
                tempArr.forEach(function (item, index) {
                    _this2.changeList.studentId.push(item.studentId);
                });
            }
        },
        initAnimate: function initAnimate() {
            var _this3 = this;

            this.longTapAnimateFlag = null;
            this.chooseAllFlag = false;
            this.studentList.forEach(function (item, index) {
                _this3.$set(_this3.studentList[index], 'animateFlag', null);
                _this3.$set(_this3.studentList[index], 'checkFlag', null);
            });
        },
        checkAHideAnimate: function checkAHideAnimate(index) {
            window.event.stopPropagation();
            if (this.longTapAnimateFlag) {
                // 处于可选状态，才能进行选中和取消选中
                if (this.studentList[index].checkFlag) {
                    this.$set(this.studentList[index], 'checkFlag', false);
                } else {
                    this.$set(this.studentList[index], 'checkFlag', true);
                }
                // 判断是否全部选中
                this.chooseAllFlag = this.studentList.every(function (item) {
                    return item.checkFlag == true;
                });
            }
            if (this.studentList[index].animateFlag !== null) {
                this.$set(this.studentList[index], 'animateFlag', false);
            }
        },
        swipeLeft: function swipeLeft(index, e) {
            var _this4 = this;

            //e.srcEvent.cancelBubble = true
            // 判断是否是今天之前的数据，是的话无动画
            if (this.operationFlag) {
                // 处于长按动画激活状态， 左滑激活回退动画
                if (this.longTapAnimateFlag) {
                    this.longTapAnimateFlag = false;
                } else {
                    // 激活左滑动画
                    this.studentList.forEach(function (item, _index) {
                        if (_this4.studentList[_index].animateFlag === true) {
                            _this4.$set(_this4.studentList[_index], 'animateFlag', false);
                        }
                    });
                    this.$set(this.studentList[index], 'animateFlag', true);
                }
            } else {
                return;
            }
            console.log('1111');
        },
        swipeRight: function swipeRight(index, e) {
            e.srcEvent.cancelBubble = true;
            // 判断是否是今天之前的数据，是的话无动画
            if (this.operationFlag) {
                if (!this.longTapAnimateFlag) {
                    if (this.studentList[index].animateFlag !== null) this.$set(this.studentList[index], 'animateFlag', false);
                }
            } else {
                return;
            }
        },
        longTap: function longTap(e) {
            var _this5 = this;

            e.srcEvent.cancelBubble = true;
            // 判断是否是今天之前的数据，是的话无动画
            if (this.operationFlag) {
                this.studentList.forEach(function (item, _index) {
                    if (_this5.studentList[_index].animateFlag === true) {
                        _this5.$set(_this5.studentList[_index], 'animateFlag', false);
                    }
                });
                this.longTapAnimateFlag = true;
            } else {
                return;
            }
        },
        checkAll: function checkAll() {
            var _this6 = this;

            // 全选和取消全选
            this.chooseAllFlag = !this.chooseAllFlag;
            if (this.chooseAllFlag) {
                this.studentList.forEach(function (item) {
                    _this6.$set(item, 'checkFlag', true);
                });
                // 通知父组件全选，设置滚动加载出来的数据为全选状态
                this.$emit('allCheck', true);
            } else {
                this.studentList.forEach(function (item) {
                    _this6.$set(item, 'checkFlag', false);
                });
                // 通知父组件取消全选，设置滚动加载出来的数据为取消全选状态
                this.$emit('allCheck', false);
            }
        },
        showImgHead: function showImgHead(img) {
            var headImg;
            headImg = img ? img : defaultImg;
            return headImg;
        },
        cutString: function cutString(str, len) {
            // 截取字符串
            if (!str) {
                return str;
            }
            var s = '';
            if (str.length <= len) {
                return str;
            } else {
                s = str.substring(0, 10);
                s += '...';
            }
            return s;
        }
    }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/components/studentList/studentList.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ var studentList = ({
  mixins: [studentList_module]
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-c38c43a6","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/components/studentList/studentList.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-student-list"},[_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.studentList.length),expression:"studentList.length"}],staticClass:"mv-attendance-inschool"},[_c('v-touch',{staticClass:"mv-attendance-identify-list",class:{'mv-enlarge-padding': _vm.longTapAnimateFlag === true}},_vm._l((_vm.studentList),function(item,index){return _c('v-touch',{key:item.studentId,staticClass:"mv-attendance-identify-item",class:{'swipeLeft': item.animateFlag === true, 'swipeLeftBack': item.animateFlag === false, 'longClickActive': _vm.longTapAnimateFlag === true, 'longClickInActive': _vm.longTapAnimateFlag === false, 'checked': item.checkFlag},attrs:{"tag":"li"},on:{"swipeleft":function($event){_vm.swipeLeft(index, $event)},"swiperight":function($event){_vm.swipeRight(index, $event)},"tap":function($event){_vm.checkAHideAnimate(index, $event)},"press":function($event){_vm.longTap($event)}}},[_c('ul',{staticClass:"mv-attendance-identify-item-inner"},[_c('li',{staticClass:"mv-attendance-msg-check"},[_c('div',{staticClass:"mv-attendance-checkbox"},[_c('i')]),_vm._v(" "),_c('div',{staticClass:"mv-attendance-identify-student"},[_c('div',{directives:[{name:"lazy",rawName:"v-lazy:background-image",value:(_vm.showImgHead(item.photoUrl)),expression:"showImgHead(item.photoUrl)",arg:"background-image"}],staticClass:"mv-attendance-student-img",staticStyle:{"backgroundRepeat":"'no-repeat'","backgroundPosition":"'center center'","backgroundSize":"'cover'"}}),_vm._v(" "),(item.leaveApply)?_c('div',{staticClass:"mv-attendance-student-msg"},[_c('span',{staticClass:"mv-attendance-student-name"},[_vm._v("\n                  请假人：\n                  "),_c('span',{staticClass:"mv-apply-name",domProps:{"textContent":_vm._s(item.studentName)}}),_vm._v("(\n                  "),_c('span',{},[_vm._v(_vm._s(_vm.switchLeaveType(item.leaveApply.leaveType)))]),_vm._v(" )\n                ")]),_vm._v(" "),_c('span',{staticClass:"mv-apply-starttime"},[_c('span',{staticClass:"mv-apply-starttime-title"},[_vm._v("开始时间：")]),_vm._v(" "),_c('span',{domProps:{"textContent":_vm._s(item.leaveApply.applyBeginTime.slice(0, item.leaveApply.applyBeginTime.length - 3))}})]),_vm._v(" "),_c('span',{staticClass:"mv-apply-starttime"},[_c('span',{staticClass:"mv-apply-starttime-title"},[_vm._v("结束时间：")]),_vm._v(" "),_c('span',{domProps:{"textContent":_vm._s(item.leaveApply.applyEndTime.slice(0, item.leaveApply.applyEndTime.length - 3))}})])]):_vm._e(),_vm._v(" "),(!item.leaveApply)?_c('div',{staticClass:"mv-attendance-student-msg"},[(item.substituteApply)?_c('div',[_c('span',{staticClass:"mv-attendance-student-name mv-detail-studentName",domProps:{"textContent":_vm._s(item.studentName)}}),_vm._v(" "),_c('span',{domProps:{"textContent":_vm._s(_vm.returnTimeType(item.substituteApply.applyTime))}})]):_c('span',{staticClass:"mv-attendance-student-name",domProps:{"textContent":_vm._s(item.studentName)}}),_vm._v(" "),(item.sex != 2)?_c('span',{staticClass:"mv-attendance-student-status mv-noarrival",domProps:{"textContent":_vm._s(item.sex == 0 ? '男' : '女')}}):_vm._e()]):_vm._e()])]),_vm._v(" "),_c('li',{directives:[{name:"show",rawName:"v-show",value:(_vm.operationFlag),expression:"operationFlag"}],staticClass:"mv-attendance-identify-operate"},[_c('div',{staticClass:"mv-attendance-call",on:{"click":function($event){_vm.call(item.studentName,item.phoneNumber,item)}}},[_c('img',{attrs:{"src":__webpack_require__("wlgP")}})]),_vm._v(" "),_c('div',{staticClass:"mv-attendance-more",on:{"click":function($event){_vm.swipeLeft(index, $event)}}},[_c('img',{attrs:{"src":__webpack_require__("Qyrf")}})])]),_vm._v(" "),(_vm.activeIndex == 0)?_c('li',{staticClass:"mv-attendance-stateChange",class:{'mv-show': _vm.activeIndex == 0}},[_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-detail",on:{"tap":function($event){_vm.toPickDetail(item.studentId, true, true, false)}}},[_vm._v("详情")]),_vm._v(" "),_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-attendance-sec-btn mv-atSchool",on:{"tap":function($event){_vm.singleChangeStatus(item, 'atSchoolList')}}},[_vm._v("在园")])],1):_vm._e(),_vm._v(" "),(_vm.activeIndex == 2)?_c('li',{staticClass:"mv-attendance-stateChange",class:{'mv-show': _vm.activeIndex == 2}},[_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-detail",on:{"tap":function($event){_vm.toPickDetail(item.studentId, true, true, true)}}},[_vm._v("详情")]),_vm._v(" "),_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-attendance-sec-btn mv-substu",on:{"tap":function($event){_vm.singleChangeStatus(item, 'substituteApplyList')}}},[_vm._v("不代接")])],1):_vm._e(),_vm._v(" "),(_vm.activeIndex == 1)?_c('li',{staticClass:"mv-attendance-stateChange",class:{'mv-show': _vm.activeIndex == 1}},[_c('v-touch',{staticClass:"mv-detail mv-detail-three",on:{"tap":function($event){_vm.toPickDetail(item.studentId, true, true, false)}}},[_vm._v("详情")]),_vm._v(" "),_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-apply",on:{"tap":function($event){_vm.singleChangeStatus(item, 'leaveApplyList')}}},[_vm._v("请假")]),_vm._v(" "),_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-attendance-sec-btn mv-three mv-leave",on:{"tap":function($event){_vm.singleChangeStatus(item, 'leaveSchoolList')}}},[_vm._v("离园")])],1):_vm._e(),_vm._v(" "),(_vm.activeIndex == 3)?_c('li',{staticClass:"mv-attendance-stateChange",class:{'mv-show': _vm.activeIndex == 3}},[_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-detail",on:{"tap":function($event){_vm.toPickDetail(item.studentId, false, true, false)}}},[_vm._v("详情")]),_vm._v(" "),_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-attendance-sec-btn mv-atSchool",on:{"tap":function($event){_vm.singleChangeStatus(item, 'atSchoolList')}}},[_vm._v("在园")])],1):_vm._e()])])})),_vm._v(" "),_c('div',{staticClass:"mv-attendance-stateAllChange",class:{'checkAllShow': _vm.longTapAnimateFlag === true, 'checkAllHide': _vm.longTapAnimateFlag === false}},[_c('div',{staticClass:"mv-attendance-checkbox",on:{"click":_vm.checkAll}},[_c('i',{class:{'mv-attendance-checkbox-active': _vm.chooseAllFlag}}),_vm._v(" "),_c('span',{staticClass:"checkAllText"},[_vm._v("全选")])]),_vm._v(" "),_c('div',{staticClass:"mv-attendance-allOperate"},[(_vm.activeIndex == 0 || _vm.activeIndex == 3)?_c('span',{staticClass:"mv-attendance-allInSchool activeBtn",on:{"click":function($event){_vm.allStateChange('atSchoolList')}}},[_vm._v("变更在园")]):_vm._e(),_vm._v(" "),(_vm.activeIndex == 1)?_c('span',{staticClass:"mv-attendance-allInSchool",on:{"click":function($event){_vm.allStateChange('leaveApplyList')}}},[_vm._v("变更请假")]):_vm._e(),_vm._v(" "),(_vm.activeIndex == 1)?_c('span',{staticClass:"mv-attendance-allInSchool activeBtn",on:{"click":function($event){_vm.allStateChange('leaveSchoolList')}}},[_vm._v("变更离园")]):_vm._e(),_vm._v(" "),(_vm.activeIndex == 2)?_c('span',{staticClass:"mv-attendance-allInSchool activeBtn",on:{"click":function($event){_vm.allStateChange('substituteApplyList')}}},[_vm._v("不代接")]):_vm._e()])])],1)])}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var studentList_studentList = (esExports);
// CONCATENATED MODULE: ./src/components/studentList/studentList.vue
function injectStyle (ssrContext) {
  __webpack_require__("K0nL")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-c38c43a6"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  studentList,
  studentList_studentList,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var components_studentList_studentList = (Component.exports);

// EXTERNAL MODULE: ./src/components/noData/noData.vue + 2 modules
var noData = __webpack_require__("ycV+");

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__("Gu7T");
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// CONCATENATED MODULE: ./src/pages/attendenceDetail/module/index.js




/* harmony default export */ var attendenceDetail_module = ({
    data: function data() {
        return {
            unConfirmed: {},
            unconfirmList: [],
            toDayNum: 0,
            localDayNum: 0,
            activeIndex: 0,
            tabs: [{
                text: '请假'
            }, {
                text: '在园'
            }, {
                text: '代接'
            }, {
                text: '离园'
            }],
            noDataFlag: false,
            tempList: [],
            pageNum: 1,
            allCheckFlag: null
        };
    },

    computed: {
        switchIndex2Param: function switchIndex2Param() {
            switch (this.activeIndex) {
                case 0:
                    return 'leaveApplyList';
                case 1:
                    return 'atSchoolList';
                case 2:
                    return 'substituteApplyList';
                case 3:
                    return 'leaveSchoolList';
            }
        },
        calUnconfirmList: function calUnconfirmList() {
            var _this = this;

            this.tempList.forEach(function (element) {
                if (element.animateFlag === undefined) {
                    _this.$set(element, 'animateFlag', null);
                }
                if (element.checkFlag === undefined) {
                    if (_this.allCheckFlag) {
                        _this.$set(element, 'checkFlag', true);
                    } else {
                        _this.$set(element, 'checkFlag', null);
                    }
                }
            });
            return this.tempList;
        }
    },
    created: function created() {
        var _this2 = this;

        if (this.$route.query.index || this.$route.query.index === 0) {
            this.activeIndex = Number(this.$route.query.index);
        } else {
            this.activeIndex = 0;
        }
        if (this.$route.query.toDayNum) {
            this.toDayNum = Number(this.$route.query.toDayNum);
        } else {
            this.toDayNum = Number(new Date());
        }
        if (this.$route.query.localDayNum) {
            this.localDayNum = Number(this.$route.query.localDayNum);
        } else {
            this.localDayNum = Number(new Date());
        }
        var toDayNum = +new Date(),
            toDayStr = moment(toDayNum).format('YYYY-MM-DD'),
            paramStr = moment(this.toDayNum).format('YYYY-MM-DD');
        if (+new Date(paramStr) < +new Date(toDayStr)) {
            this.$nextTick(function () {
                _this2.$refs.studentList.operationFlag = false;
            });
        }
    },
    mounted: function mounted() {
        var _this3 = this;

        this.getStudentList();
        Object(bridgeAPI["j" /* commonRegister */])('reloadStudentStatus', function () {
            _this3.getStudentList();
        });
        var yScroll = void 0,
            screenHeight = void 0,
            scrollHeight = void 0;

        document.addEventListener('scroll', function () {
            screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
            scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
            if (self.pageYOffset) {
                yScroll = self.pageYOffset;
            } else if (document.documentElement && document.documentElement.scrollTop) {
                // Explorer 6 Strict
                yScroll = document.documentElement.scrollTop;
            } else if (document.body) {
                // all other Explorers
                yScroll = document.body.scrollTop;
            }
            if (scrollHeight - (yScroll + screenHeight) < 150) {
                _this3.concatList();
            }
        });
    },

    methods: {
        concatList: function concatList() {
            if (this.tempList.length == this.unconfirmList.length) {
                return;
            } else {
                this.pageNum = this.pageNum + 1;
                this.tempList = [].concat(toConsumableArray_default()(this.tempList), toConsumableArray_default()(this.unconfirmList.slice(10 * (this.pageNum - 1), 10 * this.pageNum)));
            }
        },
        listAllCheck: function listAllCheck(val) {
            this.allCheckFlag = val;
        },
        getLastData: function getLastData(timeNum) {
            bridgeAPI["n" /* loading */].show();
            this.toDayNum = timeNum;
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.getStudentList();
            this.$refs.studentList.operationFlag = false;
        },
        getPreData: function getPreData(timeObj) {
            bridgeAPI["n" /* loading */].show();
            timeObj = JSON.parse(timeObj);
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.toDayNum = timeObj.toDayNum;
            this.$refs.studentList.operationFlag = timeObj.operateFlag;
            this.getStudentList();
        },
        pickDate: function pickDate(timeObj) {
            bridgeAPI["n" /* loading */].show();
            timeObj = JSON.parse(timeObj);
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.toDayNum = timeObj.toDayNum;
            this.$refs.studentList.operationFlag = timeObj.operateFlag;
            this.getStudentList();
        },
        update: function update() {
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.getStudentList();
        },
        goTab: function goTab(index) {
            this.activeIndex = index;
            this.$refs.studentList.longTapAnimateFlag = null;
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.$refs.studentList.initAnimate();
            bridgeAPI["n" /* loading */].show();
            this.getStudentList();
        },
        getStudentList: function getStudentList() {
            var _this4 = this;

            // date 时间
            var params = {};
            params.date = moment(this.toDayNum).format('YYYY-MM-DD');
            params.classId = JSON.parse(Object(auth["h" /* getData */])('teacherMSG')).classId;
            this.$http.post(api["z" /* attendenceaIn */], params).then(function (res) {
                Object(bridgeAPI["l" /* endPullDown */])();
                _this4.unConfirmed = res.resData;
                // this.unConfirmed[this.switchIndex2Param].forEach(element => {
                //     this.$set(element, 'animateFlag', null)
                //     this.$set(element, 'checkFlag', null)
                // });
                _this4.unconfirmList = _this4.unConfirmed[_this4.switchIndex2Param];
                if (_this4.unconfirmList.length) {
                    _this4.noDataFlag = false;
                    if (_this4.unconfirmList.length > 10) {
                        _this4.tempList = _this4.unconfirmList.slice(10 * (_this4.pageNum - 1), 10 * _this4.pageNum);
                    } else {
                        _this4.tempList = _this4.unconfirmList;
                    }
                } else {
                    _this4.noDataFlag = true;
                    _this4.tempList = [];
                }
                bridgeAPI["n" /* loading */].hide();
            });
        }
    }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/attendenceDetail/attendenceDetail.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//






/* harmony default export */ var attendenceDetail = ({
  mixins: [attendenceDetail_module],
  components: { timePicker: timePicker["a" /* default */], studentList: components_studentList_studentList, noData: noData["a" /* default */] }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-59f0cfa1","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/attendenceDetail/attendenceDetail.vue
var attendenceDetail_render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"attendenceDetail"},[_c('div',{staticClass:"mv-detail-operate"},[_c('time-picker',{attrs:{"toDayNum":_vm.toDayNum,"localDayNum":_vm.localDayNum},on:{"getLastData":_vm.getLastData,"getPreData":_vm.getPreData,"pickDate":_vm.pickDate}}),_vm._v(" "),_c('ul',{staticClass:"mv-detail-tab"},_vm._l((_vm.tabs),function(item,index){return _c('li',{key:index,staticClass:"mv-tab-item",on:{"click":function($event){_vm.goTab(index)}}},[_c('span',{domProps:{"textContent":_vm._s(item.text)}}),_vm._v(" "),_c('i',{staticClass:"activeFlag",class:{'activeItem': index == _vm.activeIndex}})])}))],1),_vm._v(" "),(_vm.noDataFlag)?_c('no-data',{attrs:{"noDataText":"暂无数据~"}}):_vm._e(),_vm._v(" "),_c('student-list',{ref:"studentList",attrs:{"studentList":_vm.calUnconfirmList,"detailFlag":true,"activeIndex":_vm.activeIndex,"AllStudentList":_vm.unconfirmList},on:{"updateList":_vm.update,"allCheck":_vm.listAllCheck}})],1)}
var attendenceDetail_staticRenderFns = []
var attendenceDetail_esExports = { render: attendenceDetail_render, staticRenderFns: attendenceDetail_staticRenderFns }
/* harmony default export */ var attendenceDetail_attendenceDetail = (attendenceDetail_esExports);
// CONCATENATED MODULE: ./src/pages/attendenceDetail/attendenceDetail.vue
function attendenceDetail_injectStyle (ssrContext) {
  __webpack_require__("ekzJ")
}
var attendenceDetail_normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var attendenceDetail___vue_template_functional__ = false
/* styles */
var attendenceDetail___vue_styles__ = attendenceDetail_injectStyle
/* scopeId */
var attendenceDetail___vue_scopeId__ = "data-v-59f0cfa1"
/* moduleIdentifier (server only) */
var attendenceDetail___vue_module_identifier__ = null
var attendenceDetail_Component = attendenceDetail_normalizeComponent(
  attendenceDetail,
  attendenceDetail_attendenceDetail,
  attendenceDetail___vue_template_functional__,
  attendenceDetail___vue_styles__,
  attendenceDetail___vue_scopeId__,
  attendenceDetail___vue_module_identifier__
)

/* harmony default export */ var pages_attendenceDetail_attendenceDetail = __webpack_exports__["default"] = (attendenceDetail_Component.exports);


/***/ }),

/***/ "wlgP":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ })

});