webpackJsonp([20],{

/***/ "Gs9B":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/tabs/tabs.vue + 2 modules
var tabs = __webpack_require__("u+1G");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/components/billList/billList.vue + 2 modules
var billList = __webpack_require__("FiUT");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/schoolPayList/schoolPayList.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//






/* harmony default export */ var schoolPayList = ({
  components: {
    tabs: tabs["a" /* default */],
    billList: billList["a" /* default */]
  },
  computed: {
    // 金额
    sum: function sum() {
      return this.payState ? Object(auth["r" /* thousands */])(this.receivedAmount) : Object(auth["r" /* thousands */])(this.unpaidAmount);
    },

    // 人数
    people: function people() {
      return this.payState ? this.receivedCount : this.unpaidCount;
    }
  },
  data: function data() {
    return {
      noDataFlag: false,
      noMoreFlag: false,
      queryDataLoading: false,
      list: [{
        tabsName: '已缴'
      }, {
        tabsName: '未缴'
      }],
      currentList: [
        // {
        //     "id":"1",//清单标识
        //     "billName":"上学期学杂费",//账单名称
        //     "studentName":"李四",//学生名称
        //     "receivableAmount":36300,//应收金额
        //     "receivedAmount":18150,//实收金额
        //     "payState":0,//0未收 1已收 2超额
        //     "paymentTime":"2019-12-01 14:00:00",//缴费时间
        //     "itemList":[
        //         {
        //             "costCategory":1,//0其他 1保教费 2伙食费 3托管费 4校车费 5住宿费
        //             "originalAmount":6300,//原价
        //             "deductionAmount":300,//减免
        //             "receivableAmount":6000,//应收金额
        //             "remark":""//备注
        //         }
        //     ]
        // },
        // {
        //     "id":"1",//清单标识
        //     "billName":"上学期学杂费",//账单名称
        //     "studentName":"李四",//学生名称
        //     "receivableAmount":36300,//应收金额
        //     "receivedAmount":18150,//实收金额
        //     "payState":0,//0未收 1已收 2超额
        //     "paymentTime":"2019-12-01 14:00:00",//缴费时间
        //     "itemList":[
        //         {
        //             "costCategory":1,//0其他 1保教费 2伙食费 3托管费 4校车费 5住宿费
        //             "originalAmount":6300,//原价
        //             "deductionAmount":300,//减免
        //             "receivableAmount":6000,//应收金额
        //             "remark":""//备注
        //         }
        //     ]
        // }
      ],
      receivedCount: 0, // 实收人数
      receivedAmount: 0, // 实收金额
      unpaidAmount: 0, // 未收金额
      unpaidCount: 0, // 未收人数
      id: '', // 账单id
      teacherMSG: null, // 老师信息
      payState: 1, // 缴费状态,默认查已收
      pageNum: 1 // 当前页码
    };
  },
  created: function created() {
    var _this = this;

    this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    // receivedCount 实收人数 receivedAmount 实收金额 unpaidAmount 未收金额 unpaidCount 未收人数
    this.receivedCount = this.$route.query.receivedCount;
    this.receivedAmount = this.$route.query.receivedAmount;
    this.unpaidAmount = this.$route.query.unpaidAmount;
    this.unpaidCount = this.$route.query.unpaidCount;
    this.id = this.$route.query.id;
    Object(bridgeAPI["j" /* commonRegister */])('toSearchBill', function () {
      Object(bridgeAPI["o" /* newWindow */])({
        title: '',
        url: "searchBill?billId=" + _this.id,
        pullDown: false
      });
    });
    this.queryBillList();
  },
  mounted: function mounted() {},

  methods: {
    /**
     * 查询当前账单
     */
    queryBillList: function queryBillList() {
      var _this2 = this;

      this.$http.post(api["_51" /* queryPaymentByPage */], {
        "classId": this.teacherMSG.classId, // 班级标识
        "billId": this.id, //账单标识
        "payState": this.payState, //0未收 1已收
        "pageNum": this.pageNum, //页码，必须
        "pageSize": 10 //每页数据量，必须
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        if (res.resData.pageTotal <= _this2.pageNum) {
          // 显示noMore字样
          _this2.queryDataLoading = true;
          _this2.noMoreFlag = true;
        } else {
          //noMore字样跟加载圈都不现实
          _this2.queryDataLoading = false;
          _this2.noMoreFlag = false;
        }
        if (_this2.pageNum == 1) {
          if (res.resData.resultList.length == 0) {
            _this2.noDataFlag = true;
            _this2.currentList = [];
          } else {
            _this2.currentList = res.resData.resultList;
          }
        } else {
          _this2.currentList = _this2.currentList.concat(res.resData.resultList);
        }
      });
    },

    /**
     * 加载更多
     */
    loadMore: function loadMore() {
      this.pageNum = this.pageNum + 1;
      this.queryDataLoading = true;
      this.queryBillList();
    },

    /**
     * 展开收缩
     */
    toggle: function toggle(data) {
      var _this3 = this;

      if (!this.currentList[data.i].showFlag) {
        this.currentList.forEach(function (item, index) {
          _this3.$set(_this3.currentList[index], 'showFlag', false);
        });
      }
      this.$set(this.currentList[data.i], 'showFlag', !this.currentList[data.i].showFlag);
    },

    /**
     * tab 切换
     */
    refTabs: function refTabs(index) {
      this.payState = index == 1 ? 0 : 1;
      this.pageNum = 1;
      this.queryBillList();
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-15e30a73","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/schoolPayList/schoolPayList.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"schoolPayList"},[_c('tabs',{ref:"updatePoint",attrs:{"list":_vm.list,"beamRatio":"0.25","hasBorderBottom":false},on:{"tabs":_vm.refTabs}},[_c('div',[_c('div',{staticClass:"bill-title"},[_vm._v(_vm._s(("实收金额：" + _vm.sum + "元; 人次：" + _vm.people + "人")))]),_vm._v(" "),_c('bill-list',{attrs:{"listData":_vm.currentList,"noData":"未查询到学生信息~","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"queryDataLoading":_vm.queryDataLoading},on:{"toggle":_vm.toggle,"loadMore":_vm.loadMore}})],1)])],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var schoolPayList_schoolPayList = (esExports);
// CONCATENATED MODULE: ./src/pages/schoolPayList/schoolPayList.vue
function injectStyle (ssrContext) {
  __webpack_require__("cy1h")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-15e30a73"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  schoolPayList,
  schoolPayList_schoolPayList,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_schoolPayList_schoolPayList = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "cy1h":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "u+1G":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/components/tabs/tabs.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ var tabs = ({
	props: {
		list: {
			type: Array,
			default: []
		},
		// 宽度比
		beamRatio: {
			type: Number,
			default: 0.6,
			moveX: 0
		},
		hasBorderBottom: {
			type: Boolean,
			default: true
		}
	},
	data: function data() {
		return {
			defaultIndex: 0,
			left: 0
		};
	},

	computed: {
		calcWidth: function calcWidth() {
			return 100 / this.list.length * this.beamRatio;
		},
		initLeft: function initLeft() {
			if (!this.calcWidth) return 0;
			return (100 / this.list.length - this.calcWidth) / 2;
		}
	},
	mounted: function mounted() {
		// this.handleData();
	},

	methods: {
		touchTabs: function touchTabs(item, index) {
			// 如果选的就是当前的tab不切换
			if (index == this.defaultIndex) return;
			// 设置左边距离
			this.left = this.initLeft + 100 / this.list.length * index;
			this.defaultIndex = index;
			this.$emit("tabs", index);
		}
	}
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-96cfe936","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/components/tabs/tabs.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',[_c('div',{staticClass:"tabs",class:{'border-bottom-1px':_vm.hasBorderBottom}},[_c('ul',_vm._l((_vm.list),function(item,index){return _c('li',{key:item,class:{isShow: index === _vm.defaultIndex},style:({'width':((100/_vm.list.length) + "%")}),on:{"click":function($event){_vm.touchTabs(item, index)}}},[_vm._v("\n\t\t\t\t"+_vm._s(item.tabsName)+"\n\t\t\t\t"),(item.messageCount)?_c('em',{staticClass:"iconPoint"},[_vm._v(_vm._s(item.messageCount))]):_vm._e()])})),_vm._v(" "),_c('div',{staticClass:"border_btm",style:({'left':((_vm.left || _vm.initLeft) + "%"),'width':(_vm.calcWidth + "%")})})]),_vm._v(" "),_vm._t("default")],2)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var tabs_tabs = (esExports);
// CONCATENATED MODULE: ./src/components/tabs/tabs.vue
function injectStyle (ssrContext) {
  __webpack_require__("uDRY")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-96cfe936"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  tabs,
  tabs_tabs,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var components_tabs_tabs = __webpack_exports__["a"] = (Component.exports);


/***/ }),

/***/ "uDRY":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});