webpackJsonp([29],{

/***/ "BfBk":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./node_modules/swiper/dist/css/swiper.css
var swiper = __webpack_require__("v2ns");
var swiper_default = /*#__PURE__*/__webpack_require__.n(swiper);

// EXTERNAL MODULE: ./node_modules/vue-awesome-swiper/dist/vue-awesome-swiper.js
var vue_awesome_swiper = __webpack_require__("7QTg");
var vue_awesome_swiper_default = /*#__PURE__*/__webpack_require__.n(vue_awesome_swiper);

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/components/listComponents/listComponents.vue + 5 modules
var listComponents = __webpack_require__("JKqx");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/schoolPay/schoolPay.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//







/* harmony default export */ var schoolPay = ({
  components: {
    swiper: vue_awesome_swiper["swiper"],
    swiperSlide: vue_awesome_swiper["swiperSlide"],
    listComponents: listComponents["a" /* default */]
  },
  data: function data() {
    return {
      historyBillList: [],
      noDataFlag: false,
      noBill: false,
      noMoreFlag: false,
      queryDataLoading: false,
      swiperOption: {
        effect: 'coverflow',
        slidesPerView: 1,
        centeredSlides: true,
        coverflowEffect: {
          rotate: 0,
          stretch: 10,
          depth: 160,
          modifier: 2,
          slideShadows: false
        },
        scrollbar: {
          el: '.swiper-scrollbar',
          dragClass: 'mv-swiper-scrollbar-drag'
        }
      },
      currentBillList: [],
      goCurrentDetail: function goCurrentDetail() {},
      goHistoryDetail: function goHistoryDetail() {},
      teacherMSG: null, // 老师信息
      pageNum: 1 // 页码
    };
  },
  created: function created() {
    this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    this.goCurrentDetail = Object(auth["s" /* throttle */])(this.goDetail, 500);
    this.goHistoryDetail = Object(auth["s" /* throttle */])(this.goBillDetail, 500);
    this.queryBillList();
    this.queryCurrentBillList();
  },
  mounted: function mounted() {},

  methods: {
    /**
     * 处理数字
     */
    calcNum: function calcNum(n) {
      return Object(auth["r" /* thousands */])(n);
    },

    /**
     * 查询当前列表
     */
    queryCurrentBillList: function queryCurrentBillList() {
      var _this = this;

      this.$http.post(api["_40" /* queryCurrentBills */], {
        "classId": this.teacherMSG.classId, // 班级标识
        "pageNum": 1, //页码，必须
        "pageSize": 999 //每页数据量，必须
      }).then(function (res) {
        if (res.resData.resultList.length == 0) {
          _this.noBill = true;
          _this.currentBillList = [];
        } else {
          _this.noBill = false;
          _this.currentBillList = res.resData.resultList;
        }
      }).catch(function (err) {
        _this.noBill = true;
        _this.currentBillList = [];
      });
    },

    /**
     * 加载更多
     */
    loadMore: function loadMore() {
      this.pageNum = this.pageNum + 1;
      this.queryDataLoading = true;
      this.queryBillList();
    },

    /**
     * 查询历史列表
     */
    queryBillList: function queryBillList() {
      var _this2 = this;

      this.$http.post(api["_26" /* queryBillsHistory */], {
        'classId': this.teacherMSG.classId, // 班级标识
        "pageNum": this.pageNum, //页码，必须
        "pageSize": 10 //每页数据量，必须
      }).then(function (res) {
        // 结束上下拉刷新
        Object(bridgeAPI["l" /* endPullDown */])();
        if (res.resData.pageTotal <= _this2.pageNum) {
          // 显示noMore字样
          _this2.queryDataLoading = true;
          _this2.noMoreFlag = true;
        } else {
          //noMore字样跟加载圈都不现实
          _this2.queryDataLoading = false;
          _this2.noMoreFlag = false;
        }
        if (_this2.pageNum == 1) {
          if (res.resData.resultList.length == 0) {
            _this2.noDataFlag = true;
            _this2.historyBillList = [];
          } else {
            _this2.historyBillList = res.resData.resultList;
          }
        } else {
          _this2.historyBillList = _this2.historyBillList.concat(res.resData.resultList);
        }
      }).catch(function (err) {
        _this2.noDataFlag = true;
        _this2.historyBillList = [];
      });
    },

    /**
     * 查看详情
     */
    goDetail: function goDetail(item) {
      Object(bridgeAPI["o" /* newWindow */])({
        // receivedCount 实收人数 receivedAmount 实收金额 unpaidAmount 未收金额 unpaidCount 未收人数
        title: item.billName,
        url: 'schoolPayList?receivedCount=' + item.receivedCount + '&receivedAmount=' + item.receivedAmount + '&id=' + item.billId + '&unpaidAmount=' + item.unpaidAmount + '&unpaidCount=' + item.unpaidCount,
        pullDown: false,
        toolsWay: [{
          text: 'icon-search', // 图片标识
          type: 1,
          func: 'toSearchBill'
        }]
      });
    },

    /**
     * 查看历史账单详情
     */
    goBillDetail: function goBillDetail(item) {
      Object(bridgeAPI["o" /* newWindow */])({
        title: item.billName,
        url: 'historyBillList?receivedCount=' + item.receivedCount + '&receivedAmount=' + item.receivedAmount + '&id=' + item.billId + '&payState=' + item.payState,
        pullDown: false,
        toolsWay: [{
          text: 'icon-search', // 图片标识
          type: 1,
          func: 'toSearchBill'
        }]
      });
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-ea448702","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/schoolPay/schoolPay.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"schoolPay"},[_c('swiper',{staticClass:"mv-swipe",attrs:{"options":_vm.swiperOption}},[_vm._l((_vm.currentBillList),function(item,index){return _c('swiper-slide',{key:item.id,staticClass:"swiper-slide"},[_c('div',{staticClass:"mv-schoolPay-bg"},[_c('div',{staticClass:"title",domProps:{"textContent":_vm._s(_vm.billName)}}),_vm._v(" "),_c('div',{staticClass:"sum"},[_c('b',{},[_vm._v(_vm._s(_vm.calcNum(item.receivableAmount)))]),_vm._v(_vm._s(("元 (" + (item.personCount) + "人)"))+"\n          ")]),_vm._v(" "),_c('div',{staticClass:"sum-title"},[_vm._v("应收金额")]),_vm._v(" "),_c('div',{staticClass:"sum-detail"},[_c('div',{staticClass:"block"},[_c('span',{staticClass:"money"},[_c('b',{},[_vm._v(_vm._s(_vm.calcNum(item.receivedAmount)))]),_vm._v("元")]),_vm._v(" "),_c('span',{staticClass:"text"},[_vm._v(_vm._s(("实收(" + (item.receivedCount) + "人)")))])]),_vm._v(" "),_c('div',{staticClass:"block"},[_c('span',{staticClass:"money"},[_c('b',{},[_vm._v(_vm._s(_vm.calcNum(item.onlineReceivedAmount)))]),_vm._v("元")]),_vm._v(" "),_c('span',{staticClass:"text"},[_vm._v(_vm._s(("线上(" + (item.onlineReceivedCount) + "人)")))])]),_vm._v(" "),_c('div',{staticClass:"block"},[_c('span',{staticClass:"money"},[_c('b',{},[_vm._v(_vm._s(_vm.calcNum(item.offlineReceivedAmount)))]),_vm._v("元")]),_vm._v(" "),_c('span',{staticClass:"text"},[_vm._v(_vm._s(("线下(" + (item.offlineReceivedCount) + "人)")))])])]),_vm._v(" "),_c('div',{staticClass:"detail-btn",on:{"click":function($event){_vm.goCurrentDetail(item)}}},[_vm._v("缴费详情")])])])}),_vm._v(" "),(_vm.currentBillList.length == 0 && _vm.noBill)?_c('swiper-slide',{staticClass:"swiper-slide"},[_c('div',{staticClass:"mv-schoolPay-bg nodata"},[_c('div',{staticClass:"nodata-block"},[_c('i',{staticClass:"nodata-icon"}),_vm._v(" "),_c('span',{staticClass:"nodata-text"},[_vm._v("无收费账单")])])])]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"swiper-scrollbar",attrs:{"slot":"scrollbar"},slot:"scrollbar"})],2),_vm._v(" "),_c('div',{staticClass:"history-bill-block"},[_vm._m(0),_vm._v(" "),_c('list-components',{attrs:{"listPadDomClass":"ul-bill-block","listData":_vm.historyBillList,"noData":"暂无历史账单","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"queryDataLoading":_vm.queryDataLoading},on:{"loadMore":_vm.loadMore},scopedSlots:_vm._u([{key:"default",fn:function(slotProps){return _c('div',{staticClass:"lis-bill-block ",class:{'border-bottom-1px':slotProps.index != (_vm.historyBillList.length - 1)},on:{"click":function($event){_vm.goHistoryDetail(slotProps.item)}}},[_c('div',{staticClass:"bill-info"},[_c('span',{staticClass:"text",domProps:{"textContent":_vm._s(slotProps.item.billName)}}),_vm._v(" "),_c('span',{staticClass:"money"},[_vm._v(_vm._s(("实收" + (_vm.calcNum(slotProps.item.receivedAmount)) + "元(" + (slotProps.item.receivedCount) + "人)")))])]),_vm._v(" "),_c('div',{staticClass:"bill-state"},[(slotProps.item.payState == 1)?_c('span',{staticClass:"state"},[_vm._v("已收齐")]):_vm._e(),_vm._v(" "),_c('i',{staticClass:"icon-arrow-right"})])])}}])})],1)],1)}
var staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"title"},[_c('i'),_vm._v(" "),_c('span',[_vm._v("历史账单")])])}]
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var schoolPay_schoolPay = (esExports);
// CONCATENATED MODULE: ./src/pages/schoolPay/schoolPay.vue
function injectStyle (ssrContext) {
  __webpack_require__("oRU4")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-ea448702"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  schoolPay,
  schoolPay_schoolPay,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_schoolPay_schoolPay = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "oRU4":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "v2ns":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});