webpackJsonp([32],{

/***/ "XTTt":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/components/listComponents/listComponents.vue + 5 modules
var listComponents = __webpack_require__("JKqx");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./node_modules/vue-touch/dist/vue-touch.js
var vue_touch = __webpack_require__("I0MY");
var vue_touch_default = /*#__PURE__*/__webpack_require__.n(vue_touch);

// EXTERNAL MODULE: ./src/utils/jsBridge.js
var jsBridge = __webpack_require__("f0WW");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/admin/schoolList/schoolList.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//








/* harmony default export */ var schoolList = ({
    components: {
        listComponents: listComponents["a" /* default */]
    },
    data: function data() {
        return {
            pageNum: 1,
            pageSize: 10,
            schoolList: [],
            noDataFlag: false,
            noMoreFlag: false,
            queryDataLoading: false,
            dataReceive: true
        };
    },
    beforeCreate: function beforeCreate() {
        this.teacherMSG = JSON.parse(localStorage.adminInfo);
    },
    created: function created() {
        var _this = this;

        //点击发布
        Object(bridgeAPI["j" /* commonRegister */])("addSchool", function () {
            _this.isMask = false;
            Object(bridgeAPI["o" /* newWindow */])({
                title: "新增校园公告",
                url: "addSchool",
                registerBack: 1,
                toolsWay: [{
                    text: "发表", // 文字按钮
                    type: 2, // 文字按钮类型
                    func: "goAddNotice" // 点击时call方法名
                }]
            });
        });

        // 发布成功通知列表刷新
        Object(bridgeAPI["j" /* commonRegister */])("loadSchoolList", function () {
            _this.pageNum = 1;
            _this.schoolNotice();
        });
    },

    computed: {
        cutString: function cutString() {
            /**参数说明：
             * 根据长度截取先使用字符串，超长部分追加…
             * str 对象字符串
             * len 目标字节长度
             * 返回值： 处理结果字符串
             */
            return function (str, len) {
                //length属性读出来的汉字长度为1
                if (str.length * 2 <= len) {
                    return str;
                }
                var strlen = 0;
                var s = "";
                for (var i = 0; i < str.length; i++) {
                    s = s + str.charAt(i);
                    if (str.charCodeAt(i) > 128) {
                        strlen = strlen + 2;
                        if (strlen >= len) {
                            return s.substring(0, s.length - 1) + "...";
                        }
                    } else {
                        strlen = strlen + 1;
                        if (strlen >= len) {
                            return s.substring(0, s.length - 2) + "...";
                        }
                    }
                }
                return s;
            };
        }
    },
    mounted: function mounted() {
        var _this2 = this;

        this.schoolNotice();
        // 开始下拉刷新
        Object(bridgeAPI["c" /* beginPullDown */])(function () {
            _this2.pageNum = 1;
            _this2.schoolNotice();
            _this2.isMask = false;
        });
    },
    updated: function updated() {},

    watch: {},
    methods: {
        loadMore: function loadMore() {
            if (!this.dataReceive) {
                return;
            }
            this.pageNum += 1;
            this.queryDataLoading = true;
            this.schoolNotice();
        },
        schoolNotice: function schoolNotice() {
            var _this3 = this;

            this.dataReceive = false;
            var data = {
                schoolId: this.teacherMSG.id,
                pageNum: this.pageNum,
                pageSize: this.pageSize
            };
            this._http.post(api["o" /* adminQueryNotice */], data).then(function (res) {
                _this3.dataReceive = true;
                if (res.resData.pageTotal <= _this3.pageNum) {
                    // 显示noMore字样
                    _this3.queryDataLoading = true;
                    _this3.noMoreFlag = true;
                } else {
                    //noMore字样跟加载圈都不现实
                    _this3.queryDataLoading = false;
                    _this3.noMoreFlag = false;
                }
                // 判断是否是第一页
                if (_this3.pageNum == 1) {
                    if (res.resData.resultList.length == 0) {
                        _this3.noDataFlag = true;
                    } else {
                        _this3.schoolList = res.resData.resultList;
                    }
                } else if (_this3.pageNum > res.resData.pageTotal) {
                    return;
                } else {
                    _this3.schoolList = _this3.schoolList.concat(res.resData.resultList);
                }
                //页面加载完成
                Object(bridgeAPI["l" /* endPullDown */])();
            });
        },

        //链接跳转
        schoolActive: function schoolActive(item) {
            Object(bridgeAPI["o" /* newWindow */])({
                title: "公告详情",
                url: "adminDetail?id=" + item.id + "&listType=0"
            });
        }
    }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-e27f828c","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/admin/schoolList/schoolList.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',[_c('listComponents',{staticClass:"schoolContent",attrs:{"listData":_vm.schoolList,"noData":"暂无数据","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"queryDataLoading":_vm.queryDataLoading,"listPadDomClass":"schoolContent"},on:{"loadMore":_vm.loadMore},scopedSlots:_vm._u([{key:"default",fn:function(slotItem){return _c('div',{staticClass:"slotItem",on:{"click":function($event){_vm.schoolActive(slotItem.item)}}},[_c('div',{staticClass:"schoolContentTitle"},[_c('span',[_vm._v("校园公告")]),_vm._v(" "),_c('em',{},[_vm._v(_vm._s(slotItem.item.createTimeDesc))])]),_vm._v(" "),_c('div',{staticClass:"schoolText"},[_c('span',{staticClass:"notice-content"},[_vm._v(_vm._s(slotItem.item.title))]),_vm._v(" "),_c('em',[_c('i',{staticClass:"eyes"}),_vm._v(" "),_c('span',[_vm._v(_vm._s(slotItem.item.readCount))])])])])}}])})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var schoolList_schoolList = (esExports);
// CONCATENATED MODULE: ./src/pages/admin/schoolList/schoolList.vue
function injectStyle (ssrContext) {
  __webpack_require__("jE1R")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-e27f828c"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  schoolList,
  schoolList_schoolList,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var admin_schoolList_schoolList = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "jE1R":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});