webpackJsonp([38],{

/***/ "+cBq":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "g1tV":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./src/pages/leaveDetail/modules/leaveDetail.js



/* harmony default export */ var leaveDetail = ({
  methods: {
    /*方法说明
      *@method 图片预览
      *@param{
        index 当前图片索引
      }
    */
    showDetail: function showDetail(index) {
      var images = [];
      this.leaveInfo.leaveAttachmentList.forEach(function (item) {
        images.push(item.attachmentUrl);
      });
      Object(bridgeAPI["m" /* getMedia */])('showImages', {
        index: index,
        content: "",
        images: images,
        deleteFlag: false
      });
    },

    /*方法说明
      *@method 压缩图片
      *@param{url}
      url 图片地址
    */
    compress: function compress(url) {
      return Object(auth["b" /* commonCutImg */])(url, {
        width: 150,
        height: 150
      });
    },

    /*方法说明
      *@method 请求详情数据
      *@param{}
    */
    getLeaveInfo: function getLeaveInfo() {
      var _this = this;

      this.$http.post(api["_2" /* getAttendanceLeaveApplyById */], {
        id: this.$route.query.id // 请假标识
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        if (!res.resData) {
          _this.noDataFlag = true;
          return;
        }
        _this.leaveInfo = res.resData;
      });
    },

    /*方法说明
      *@method 请假类型
      *@param{type}
      type 请假类型，0：晚到，1：事假，2：病假, 3:公出
    */
    calcLeaveType: function calcLeaveType(type) {
      type = Number(type);
      var result;
      switch (type) {
        case 0:
          result = '晚到';
          break;
        case 1:
          result = '事假';
          break;
        case 2:
          result = '病假';
          break;
        case 3:
          result = '公出';
          break;
        case 4:
          result = '调休';
          break;
      }
      return result;
    },

    /*方法说明
      *@method 计算请假周期
      *@param{
        startTime // 开始时间
        endTime // 结束时间
        startTimeDesc // 开始时间段 1 上午 2 下午
        endTimeDesc // 结束时间段 1 上午 2 下午
      }
    */
    calcLeaveCycle: function calcLeaveCycle(startTime, endTime, startTimeDesc, endTimeDesc) {
      var leaveCycle;
      startTimeDesc = Number(startTimeDesc) == 1 ? ' 上午' : ' 下午'; // 转成时间段
      endTimeDesc = Number(endTimeDesc) == 1 ? ' 上午' : ' 下午'; // 转成时间段
      startTime = moment(startTime).format('MM-DD'); // 转成月日格式
      endTime = moment(endTime).format('MM-DD'); // 转成月日格式
      if (startTime == endTime && startTimeDesc == ' 上午' && endTimeDesc == ' 下午') {
        leaveCycle = startTime + ' 全天';
      } else if (startTime == endTime && startTimeDesc == endTimeDesc) {
        leaveCycle = startTime + startTimeDesc;
      } else {
        leaveCycle = startTime + startTimeDesc + ' - ' + endTime + endTimeDesc;
      }
      return leaveCycle;
    },

    /*方法说明
      *@method 审核结果
      *@param{type}
      type 审核结果类型，0待审核，1已通过，2已驳回
    */
    auditResult: function auditResult(type) {
      type = Number(type);
      var result;
      switch (type) {
        case 0:
          result = '待批准';
          break;
        case 1:
          result = '已通过';
          break;
        case 2:
          result = '已驳回';
          break;
      }
      return result;
    }
  },
  computed: {
    momentTime: function momentTime() {
      return function (time) {
        return moment(time).format('YYYY年MM月DD号');
      };
    }
  },
  created: function created() {
    var _this2 = this;

    this.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    this.teacherHead = Object(auth["l" /* judgeHeadImg */])(this.teacherMsg.headImage);
    this.getLeaveInfo();
    if (this.$route.query.msgId) {
      this.$http.post(api["_75" /* setMessageRead */], {
        messageIdList: [this.$route.query.msgId],
        subjectTypeList: [this.$route.query.subjectType]
      }).then(function (res) {
        Object(bridgeAPI["h" /* commonMsg */])({
          call: 'updateMsgCenter',
          data: {
            subjectType: _this2.$route.query.subjectType
          }
        });
      });
    }
  }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/leaveDetail/leaveDetail.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ var leaveDetail_leaveDetail = ({
  data: function data() {
    return {
      leaveInfo: {}, // 请假详情
      teacherMsg: {}, // 老师信息
      teacherHead: null, // 头像地址
      params: {}, // url参数集
      noDataFlag: false // 无图显示
    };
  },

  mixins: [leaveDetail]
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-83ebff32","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/leaveDetail/leaveDetail.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"leaveDetail"},[_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.leaveInfo.teacherName),expression:"leaveInfo.teacherName"}],staticClass:"mv-leaveContent"},[_c('div',{staticClass:"mv-headBox"},[_c('div',{staticClass:"mv-head"},[_c('div',{staticClass:"mv-headPhoto",style:({backgroundImage:'url('+ _vm.teacherHead +')'})}),_vm._v(" "),_c('div',{staticClass:"mv-headInfo"},[_c('p',{domProps:{"innerHTML":_vm._s(_vm.leaveInfo.teacherName)}}),_vm._v(" "),_c('p',{domProps:{"innerHTML":_vm._s(_vm.leaveInfo.createTimeDesc)}})])]),_vm._v(" "),_c('div',{staticClass:"mv-leaveState",class:{'icon-Unaudited':_vm.leaveInfo.applyStatus==0,'icon-Solve':_vm.leaveInfo.applyStatus==1,'icon-pass':_vm.leaveInfo.applyStatus==2}})]),_vm._v(" "),_c('div',{staticClass:"mv-bodyBox"},[_c('ul',{staticClass:"leaveTypeAndTime"},[_c('li',[_c('p',[_vm._v("请假类型：")]),_vm._v(" "),_c('p',{staticClass:"text"},[_vm._v(_vm._s(_vm.calcLeaveType(_vm.leaveInfo.leaveType)))])]),_vm._v(" "),_c('li',[_c('p',[_vm._v("请假周期：")]),_vm._v(" "),_c('p',{staticClass:"text"},[_vm._v(_vm._s(_vm.calcLeaveCycle(_vm.leaveInfo.queryStartTime,_vm.leaveInfo.queryEndTime,_vm.leaveInfo.queryStartTimeDesc,_vm.leaveInfo.queryEndTimeDesc) + ' ' + _vm.leaveInfo.leaveDays + '天'))])]),_vm._v(" "),_c('li',[_c('p',{staticClass:"contentText",domProps:{"innerHTML":_vm._s(_vm.leaveInfo.leaveReason)}})])]),_vm._v(" "),(_vm.leaveInfo.leaveAttachmentList && _vm.leaveInfo.leaveAttachmentList.length)?_c('ul',{staticClass:"mv-accessory"},_vm._l((_vm.leaveInfo.leaveAttachmentList),function(item,index){return _c('li',{key:index,style:({background:'url('+ _vm.compress(item.attachmentUrl) +') no-repeat center',backgroundSize:'cover'}),on:{"click":function($event){_vm.showDetail(index)}}})})):_vm._e()])]),_vm._v(" "),_c('div',{directives:[{name:"show",rawName:"v-show",value:(Number(_vm.leaveInfo.applyStatus)),expression:"Number(leaveInfo.applyStatus)"}],staticClass:"approveInfo"},[_c('ul',{staticClass:"approveList"},[_c('li',[_c('p',[_vm._v("审批结果：")]),_vm._v(" "),_c('p',{staticClass:"text"},[_vm._v(_vm._s(_vm.auditResult(_vm.leaveInfo.applyStatus)))])]),_vm._v(" "),_c('li',[_c('p',[_vm._v("审批时间：")]),_vm._v(" "),_c('p',{staticClass:"text"},[_vm._v(_vm._s(_vm.leaveInfo.approveTime))])]),_vm._v(" "),(_vm.leaveInfo.approverName)?_c('li',[_c('p',[_vm._v("审批领导：")]),_vm._v(" "),_c('p',{staticClass:"text"},[_vm._v(_vm._s(_vm.leaveInfo.approverName))])]):_vm._e(),_vm._v(" "),(_vm.leaveInfo.applyStatus != 1)?_c('li',[_c('p',{staticClass:"contentText"},[_vm._v(_vm._s(_vm.leaveInfo.remark ? _vm.leaveInfo.remark : '领导很忙,没有留下任何文字..'))])]):_vm._e()])])])}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_leaveDetail_leaveDetail = (esExports);
// CONCATENATED MODULE: ./src/pages/leaveDetail/leaveDetail.vue
function injectStyle (ssrContext) {
  __webpack_require__("+cBq")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-83ebff32"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  leaveDetail_leaveDetail,
  pages_leaveDetail_leaveDetail,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_leaveDetail_leaveDetail = __webpack_exports__["default"] = (Component.exports);


/***/ })

});