webpackJsonp([40],{

/***/ "8jbK":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/imgPicker/imgPicker.vue + 2 modules
var imgPicker = __webpack_require__("8cMp");

// EXTERNAL MODULE: ./src/components/textarea/textarea.vue + 2 modules
var textarea_textarea = __webpack_require__("+hyH");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// CONCATENATED MODULE: ./src/pages/toLeave/modules/toLeave.js



/* harmony default export */ var toLeave = ({
    methods: {
        /**
         * 选择结束时间
         */
        chooseEndtTime: function chooseEndtTime() {
            var _this = this;

            Object(bridgeAPI["i" /* commonPost */])("showDatePickerView", {
                dateStr: moment(this.endTime.defaultTime).format("YYYY-MM-DD")
            }).then(function (res) {
                if (res.type == 1) {
                    if (new Date(res.dateStr).getTime() < new Date(_this.startTime.defaultTime).getTime()) {
                        Object(bridgeAPI["t" /* toast */])('结束时间不能小于开始时间');
                    } else {
                        _this.$set(_this.endTime, 'defaultTime', moment(res.dateStr).format('YYYY-MM-DD'));
                        _this.calcLeaveDays();
                    }
                }
            });
        },

        /**
         * 选择开始时间
         */
        chooseStartTime: function chooseStartTime() {
            var _this2 = this;

            Object(bridgeAPI["i" /* commonPost */])("showDatePickerView", {
                dateStr: moment(this.startTime.defaultTime).format("YYYY-MM-DD")
            }).then(function (res) {
                if (res.type == 1) {
                    if (new Date(res.dateStr).getTime() > new Date(_this2.endTime.defaultTime).getTime()) {
                        Object(bridgeAPI["t" /* toast */])('开始时间不能大于结束时间');
                    } else {
                        _this2.$set(_this2.startTime, 'defaultTime', moment(res.dateStr).format('YYYY-MM-DD'));
                        _this2.calcLeaveDays();
                    }
                }
            });
        },

        // 点击区域外
        hideDeleteFlag: function hideDeleteFlag(event) {
            var a = document.getElementById("myPicker");
            if (a) {
                // 如果不包含当前dom,说面点击的是外面
                if (!a.contains(event.target)) {
                    this.$refs.userImgs.hideDelete();
                }
            }
        },

        /*方法说明
          *@method 上传图片至oss服务器
          *@param{
            params 后续请求所需要的参数
          }
        */
        uploadToOss: function uploadToOss(params) {
            var _this3 = this;

            var dateStr = moment(new Date()).format('YYYY-MM-DD'),
                schoolId = this.teacherMsg.schoolId,
                ossPath = dateStr + "/" + schoolId + "/offWork/";
            Object(bridgeAPI["i" /* commonPost */])('startUploadImage', {
                imgArr: this.$refs.userImgs.submitImages,
                token: this.token
            }).then(function (res) {
                var startLoacl = void 0,
                    leaveAttachmentList = [];
                res.images.forEach(function (item) {
                    startLoacl = item.indexOf('eduo');
                    item = item.substring(startLoacl, item.length);
                    leaveAttachmentList.push({
                        attachmentType: '1',
                        attachmentUrl: 'https://' + item
                    });
                });
                // 将上传至OSS的视频数组带进参数里
                params.leaveAttachmentList = leaveAttachmentList;
                // 请求服务器,将请假数据发送给服务器
                _this3.sendToDataBase(params);
            }).catch(function (res) {
                bridgeAPI["n" /* loading */].hide();
                Object(bridgeAPI["t" /* toast */])('新增失败~');
            });
        },

        /**
         * 结束时间监听
         */
        endTimeListener: function endTimeListener() {
            var endTimeDom = document.querySelector('#endTime');
            if (endTimeDom.value == '') {
                endTimeDom.value = this.oldEndTime;
                return;
            }
            if (new Date(endTimeDom.value).getTime() < new Date(this.startTime.defaultTime).getTime()) {
                Object(bridgeAPI["t" /* toast */])('结束时间不能小于开始时间');
                endTimeDom.value = this.oldEndTime;
            } else {
                this.$set(this.endTime, 'defaultTime', moment(endTimeDom.value).format('YYYY-MM-DD'));
                // this.endTime.defaultTime = moment(endTimeDom.value).format('YYYY-MM-DD')
                this.calcLeaveDays();
                this.oldEndTime = moment(endTimeDom.value).format('YYYY-MM-DD');
            }
        },

        /**
         * 起始时间监听
         */
        startTimeListener: function startTimeListener() {
            var startTimeDom = document.querySelector('#satrtTime');
            if (startTimeDom.value == '') {
                startTimeDom.value = this.oldStartTime;
                return;
            }
            if (new Date(startTimeDom.value).getTime() > new Date(this.endTime.defaultTime).getTime()) {
                Object(bridgeAPI["t" /* toast */])('开始时间不能大于结束时间');
                startTimeDom.value = this.oldStartTime;
            } else {
                this.$set(this.startTime, 'defaultTime', moment(startTimeDom.value).format('YYYY-MM-DD'));
                // this.startTime.defaultTime = moment(startTimeDom.value).format('YYYY-MM-DD')
                this.calcLeaveDays();
                this.oldStartTime = moment(startTimeDom.value).format('YYYY-MM-DD');
            }
        },

        /*方法说明
          *@method 时间监听判断
          *@param{
          }
        */
        datePick: function datePick() {
            if (auth["n" /* platForms */].isIOS()) {
                document.querySelector('#satrtTime').addEventListener('blur', this.startTimeListener);
                document.querySelector('#endTime').addEventListener('blur', this.endTimeListener);
            } else {
                document.querySelector('#satrtTime').addEventListener('change', this.startTimeListener);
                document.querySelector('#endTime').addEventListener('change', this.endTimeListener);
            }
        },

        /**
         * 改变当前type值
         * @param {number} type 选择项的type 
         */
        changeLeaveType: function changeLeaveType(type) {
            this.leaveType = type;
        },

        /*方法说明
          *@method 切换上下午
          *@param{
            type 当前选中状态 1 上午 2 下午
            timeType 开始时间 0 结束时间 1
            time 当前时间
          }
        */
        switchTimeSlot: function switchTimeSlot(type, timeType, time) {
            // 判断选择的是结束时间还是开始时间
            if (timeType) {
                // 结束时间逻辑
                // 如果结束时间小于开始时间
                if (new Date(time).getTime() < new Date(this.startTime.defaultTime).getTime()) {
                    Object(bridgeAPI["t" /* toast */])('结束时间不能小于开始时间~');
                    return;
                } else if (new Date(time).getTime() == new Date(this.startTime.defaultTime).getTime()) {
                    // 如果结束时间等于开始时间
                    if (this.startTimeSlot == 2 && type == 1) {
                        // 如果开始时间为下午 结束时间为下午
                        Object(bridgeAPI["t" /* toast */])('结束时间不能小于开始时间~');
                        return;
                    }
                    this.endTimeSlot = type;
                } else {
                    this.endTimeSlot = type;
                }
                this.calcLeaveDays();
            } else {
                // 开始时间逻辑
                // 如果开始时间大于结束时间
                if (new Date(time).getTime() > new Date(this.endTime.defaultTime).getTime()) {
                    Object(bridgeAPI["t" /* toast */])('开始时间不能大于结束时间~');
                    return;
                } else if (new Date(time).getTime() == new Date(this.endTime.defaultTime).getTime()) {
                    // 如果开始时间等于结束时间
                    if (this.endTimeSlot == 1 && type == 2) {
                        // 如果结束时间为上午 开始时间为下午
                        Object(bridgeAPI["t" /* toast */])('开始时间不能大于结束时间~');
                        return;
                    }
                    this.startTimeSlot = type;
                } else {
                    this.startTimeSlot = type;
                }
                this.calcLeaveDays();
            }
        },

        /*方法说明
          *@method 计算天数
          *@param{
          }
        */
        calcLeaveDays: function calcLeaveDays() {
            var days = 0;
            // 计算是不是当天
            if (moment(this.endTime.defaultTime).diff(moment(this.startTime.defaultTime), 'days') == 0) {
                // 是当天
                if (this.startTimeSlot == 1) {
                    // 开始时间段为上午
                    days = days + 0.5;
                }
                if (this.endTimeSlot == 2) {
                    // 结束时间段为下午
                    days = days + 0.5;
                }
            } else {
                // 不是当天
                days = moment(this.endTime.defaultTime).diff(moment(this.startTime.defaultTime), 'days');
                if (this.startTimeSlot == 2) {
                    // 开始时间段为下午
                    days = days - 0.5;
                }
                if (this.endTimeSlot == 1) {
                    // 结束时间段为上午
                    days = days + 0.5;
                } else {
                    // 结束时间段为下午
                    days = days + 1;
                }
            }
            this.days = days;
        },

        /*方法说明
         *@method 拼接回复人名称
         *@param{}
         */
        limit: function limit() {
            /* 输入字数限制 */
            if (this.$refs.userInput.content.length > 300) {
                Object(bridgeAPI["t" /* toast */])('您已输入超过300个字~');
                return true;
            } else {
                return false;
            }
        },

        /*方法说明
          *@method 时间判断
          *@param{
          }
        */
        timeJudgment: function timeJudgment() {
            if (new Date(this.startTime.defaultTime).getTime() > new Date(this.endTime.defaultTime).getTime()) {
                Object(bridgeAPI["t" /* toast */])('开始时间不能大于结束时间~');
                return true;
            } else if (new Date(this.endTime.defaultTime).getTime() < new Date(this.startTime.defaultTime).getTime()) {
                Object(bridgeAPI["t" /* toast */])('结束时间不能小于开始时间~');
                return true;
            } else {
                return false;
            }
        },

        /*方法说明
          *@method 请求服务器,将请假数据发送给服务器
          *@param{
            params 请求所需要的参数
          }
        */
        sendToDataBase: function sendToDataBase(params) {
            this.$http.post(api["a" /* addAttendanceLeaveApply */], params).then(function (res) {
                bridgeAPI["n" /* loading */].hide();
                Object(bridgeAPI["t" /* toast */])('请假成功!');
                // leaveSuccess
                Object(bridgeAPI["h" /* commonMsg */])({
                    call: 'leaveSuccess'
                });
                Object(bridgeAPI["g" /* closeWindow */])();
            });
            // var _this = this
            // module.$http(API.leave.addAttendanceLeaveApply, params, function () {
            //   toast('请假成功!')
            //   module.postToNativeMessage({
            //     call:'leaveSuccess',
            //     data:{}
            //   })
            //   module.closeToWindow()
            //   module.loading.hide();
            //   _this.sendNow = false
            // },function(err){
            //   toast('请假失败,请稍后重试!')
            //   module.loading.hide();
            //   _this.sendNow = false
            // },function(){
            //   toast('请假失败,请稍后重试!')
            //   module.loading.hide();
            //   _this.sendNow = false
            // },function(){
            //   module.loading.hide();
            //   _this.sendNow = false
            // })
        },

        /*方法说明
          *@method 提交请假
          *@param{
          }
        */
        leaveSubmit: function leaveSubmit() {
            // 请假原因不能为空
            if (this.$refs.userInput.content == '') {
                Object(bridgeAPI["t" /* toast */])('请假原因不能为空~');
                return;
            }
            // 检测字数限制
            if (this.limit()) {
                return;
            }
            if (this.timeJudgment()) {
                return;
            }
            bridgeAPI["n" /* loading */].show();
            var startTemporaryPeriod = this.startTimeSlot == 1 ? ' 00:00:00' : ' 12:00:00';
            var endTimeporaryPeriod = this.endTimeSlot == 1 ? ' 11:59:59' : ' 23:59:59';
            var startTime = moment(this.startTime.defaultTime).format('YYYY-MM-DD') + startTemporaryPeriod;
            var endTime = moment(this.endTime.defaultTime).format('YYYY-MM-DD') + endTimeporaryPeriod;
            var params = {
                teacherName: this.teacherMsg.name, // 教师名字
                teacherId: this.teacherMsg.id, // 教师标识
                schoolId: this.teacherMsg.schoolId, // 学校标识
                leaveReason: this.$refs.userInput.content, // 请假原因
                leaveType: this.leaveType, // 请假类型，0：晚到，1：事假，2：病假, 3:公出
                startTime: startTime, // 请假开始时间
                endTime: endTime // 请假结束时间
            };
            if (this.$refs.userImgs.submitImages.length) {
                this.uploadToOss(params);
            } else {
                this.sendToDataBase(params);
            }
        }
    },
    computed: {
        momentTime: function momentTime() {
            return function (time) {
                return moment(time).format('YYYY年MM月DD号');
            };
        }
    },
    created: function created() {
        this.startTime.defaultTime = moment().add(1, 'days').format('YYYY-MM-DD');
        this.endTime.defaultTime = moment().add(1, 'days').format('YYYY-MM-DD');
        this.oldStartTime = this.startTime.defaultTime;
        this.oldEndTime = this.endTime.defaultTime;
        this.token = Object(auth["h" /* getData */])('token');
        this.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
        Object(bridgeAPI["l" /* endPullDown */])();
    },
    mounted: function mounted() {
        // 开始监听时间选择
        // this.datePick()
        // 计算请假时间
        this.calcLeaveDays();
    }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/toLeave/toLeave.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//



var deleteIcon = __webpack_require__("1aYl");

/* harmony default export */ var toLeave_toLeave = ({
  mixins: [toLeave],
  data: function data() {
    return {
      placeholder: '请填写请假原因(300字以内)', // textarea默认文本
      maxLength: 300, // textarea默认文本
      styleCss: 'mv-toLeave-textarea-style', // 图标地址
      imgLeng: '3', // 初始化imgpicker选择数量
      deleteIcon: deleteIcon, // 删除按钮图标
      leaveTypeList: [{
        typeName: '事假',
        type: 1
      }, {
        typeName: '病假',
        type: 2
      }, {
        typeName: '公出',
        type: 3
      }, {
        typeName: '调休',
        type: 4
      }], // 请假类型列表
      startTime: {
        title: '开始时间',
        timeType: 0, // 0 开始时间 1 结束时间
        defaultTime: '',
        timeArr: [{
          timeSlot: '上午',
          type: 1
        }, {
          timeSlot: '下午',
          type: 2
        }]
      }, // 请假开始时间
      endTime: {
        title: '结束时间',
        timeType: 1, // 0 开始时间 1 结束时间
        defaultTime: '',
        timeArr: [{
          timeSlot: '上午',
          type: 1
        }, {
          timeSlot: '下午',
          type: 2
        }]
      }, // 请假结束时间
      startTimeSlot: 1, // 开始时间段 1 上午 2 下午
      endTimeSlot: 1, // 结束时间段 1 上午 2 下午
      imgArr: [], // 选择的图片列表
      deleteFlag: false, // 可删除状态
      addShow: true, // 可添加状态
      leaveType: 1, // 请假类型，0：晚到，1：事假，2：病假, 3:公出, 4：调休
      days: 1, // 计算的请假天数
      teacherMsg: {}, // 老师信息
      oldStartTime: '', // 历史开始时间
      oldEndTime: '', // 历史结束时间  兼容inputdate监听问题
      token: '' // token
    };
  },

  components: {
    imgPicker: imgPicker["a" /* default */],
    textArea: textarea_textarea["a" /* default */]
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-6d9040ef","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/toLeave/toLeave.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"toLeave",on:{"click":_vm.hideDeleteFlag}},[_c('div',{staticClass:"paddingBox"},[_c('text-Area',{ref:"userInput",attrs:{"placeholder":_vm.placeholder,"maxLength":_vm.maxLength,"styleCss":_vm.styleCss}}),_vm._v(" "),_c('div',{staticClass:"leaveType"},[_c('b',[_vm._v("请假类型")]),_vm._v(" "),_c('ul',{staticClass:"leaveTypeList"},_vm._l((_vm.leaveTypeList),function(item,index){return _c('li',{key:index,on:{"click":function($event){_vm.changeLeaveType(item.type)}}},[_c('i',{class:{active:item.type == _vm.leaveType}}),_vm._v(" "),_c('span',{},[_vm._v(_vm._s(item.typeName))])])}))]),_vm._v(" "),_c('dl',{staticClass:"chooseTime"},[_vm._m(0),_vm._v(" "),_c('dd',[_c('span',{staticClass:"timeTitle"},[_vm._v("\n          "+_vm._s(_vm.startTime.title)+"\n        ")]),_vm._v(" "),_c('div',{staticClass:"timeInput"},[_c('label',{attrs:{"for":"satrtTime"},on:{"click":_vm.chooseStartTime}},[_vm._v(_vm._s(_vm.momentTime(_vm.startTime.defaultTime)))])]),_vm._v(" "),_c('i',{staticClass:"icon-arrow"}),_vm._v(" "),_c('div',{staticClass:"pmOrAm"},_vm._l((_vm.startTime.timeArr),function(item,index){return _c('span',{key:index,class:{active:item.type == _vm.startTimeSlot},on:{"click":function($event){_vm.switchTimeSlot(item.type,_vm.startTime.timeType,_vm.startTime.defaultTime)}}},[_vm._v(_vm._s(item.timeSlot))])}))]),_vm._v(" "),_c('dd',[_c('span',{staticClass:"timeTitle"},[_vm._v("\n          "+_vm._s(_vm.endTime.title)+"\n        ")]),_vm._v(" "),_c('div',{staticClass:"timeInput"},[_c('label',{attrs:{"for":"endTime"},on:{"click":_vm.chooseEndtTime}},[_vm._v(_vm._s(_vm.momentTime(_vm.endTime.defaultTime)))])]),_vm._v(" "),_c('i',{staticClass:"icon-arrow"}),_vm._v(" "),_c('div',{staticClass:"pmOrAm"},_vm._l((_vm.endTime.timeArr),function(item,index){return _c('span',{key:index,class:{active:item.type == _vm.endTimeSlot},on:{"click":function($event){_vm.switchTimeSlot(item.type,_vm.endTime.timeType,_vm.endTime.defaultTime)}}},[_vm._v(_vm._s(item.timeSlot))])}))])]),_vm._v(" "),_c('div',{staticClass:"leaveDays"},[_c('b',[_vm._v("请假天数")]),_vm._v(" "),_c('span',{},[_vm._v(_vm._s(_vm.days)+"天")])])],1),_vm._v(" "),_c('img-picker',{ref:"userImgs",staticClass:"myPicker",attrs:{"deleteIconUrl":_vm.deleteIcon,"imgLeng":_vm.imgLeng,"id":"myPicker"}}),_vm._v(" "),_c('div',{staticClass:"paddingBox"},[_c('div',{staticClass:"accessory"},[_vm._v("附件")]),_vm._v(" "),_c('div',{staticClass:"leaveSubmitBox"},[_c('span',{staticClass:"leaveSubmit",on:{"click":_vm.leaveSubmit}},[_vm._v("提交")])])])],1)}
var staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('dt',[_c('b',[_vm._v("时间选择")])])}]
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_toLeave_toLeave = (esExports);
// CONCATENATED MODULE: ./src/pages/toLeave/toLeave.vue
function injectStyle (ssrContext) {
  __webpack_require__("N/nq")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-6d9040ef"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  toLeave_toLeave,
  pages_toLeave_toLeave,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_toLeave_toLeave = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "N/nq":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});