webpackJsonp([42],{

/***/ "9xiw":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/imgPicker/imgPicker.vue + 2 modules
var imgPicker = __webpack_require__("8cMp");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// CONCATENATED MODULE: ./src/pages/report/module/index.js



/* harmony default export */ var report_module = ({
    created: function created() {
        var _this2 = this;

        this.mediaId = this.$route.query.mediaId;
        // sendReport
        Object(bridgeAPI["j" /* commonRegister */])('sendReport', function () {
            _this2.sendReport();
        });
        Object(bridgeAPI["l" /* endPullDown */])();
    },

    methods: {
        sendReport: function sendReport() {
            // 投诉类型不能不选
            if (!this.contentShow) {
                Object(bridgeAPI["t" /* toast */])('请选择投诉类型');
                return;
            }
            // 内容不能为空
            if (!this.reportText.length) {
                Object(bridgeAPI["t" /* toast */])('投诉内容不能为空~');
                return;
            }
            // 内容不能大于500字
            if (this.reportText.length > 500) {
                Object(bridgeAPI["t" /* toast */])('投诉内容不能超过500字~');
                return;
            }
            bridgeAPI["n" /* loading */].show();
            var data = {
                "source": 3, //来源栏目，0音频，1视频，2笔记，3课件
                "clientType": 1, //终端类型，0家长端，1老师端
                "mediaId": this.mediaId,
                "complainTypeId": 0, //0广告内容， 1违法违规内容， 2抄袭他人作品， 3隐私肖像， 4色情， 5其他
                "complainContent": this.reportText
            };
            if (this.$refs.userImgs.submitImages.length) {
                // 上传图片至oss
                data.imageUrlList = [];
                this.uploadToOss(data);
            } else {
                // 发给后台
                this.submit(data);
            }
        },
        choosedType: function choosedType(index) {
            if (index == this.currentChooseIndex) {
                this.currentChooseIndex = null;
                this.contentShow = false;
                return;
            }
            this.currentChooseIndex = index;
            this.contentShow = true;
        },
        limit: function limit() {
            /* 输入字数限制 */
            if (this.reportText.length > 500) {
                Object(bridgeAPI["t" /* toast */])('您已输入超过500个字~');
                return true;
            } else {
                return false;
            }
        },
        hideDeleteFlag: function hideDeleteFlag(event) {
            var a = document.getElementById("myPicker");
            if (a) {
                // 如果不包含当前dom,说面点击的是外面
                if (!a.contains(event.target)) {
                    this.$refs.userImgs.hideDelete();
                }
            }
        },
        submit: function submit(params) {
            this.$http.post(api["N" /* complaintMedia */], params).then(function () {
                // 修改成功,重新拉取页面数据
                bridgeAPI["n" /* loading */].hide();
                Object(bridgeAPI["t" /* toast */])('投诉成功~');
                setTimeout(function () {
                    Object(bridgeAPI["g" /* closeWindow */])();
                }, 600);
            });
        },
        uploadToOss: function uploadToOss(params) {
            var _this = this,
                token = Object(auth["h" /* getData */])('token');
            var dateStr = moment(new Date()).format('YYYY-MM-DD'),
                ossPath = dateStr + '/complain/';
            Object(bridgeAPI["i" /* commonPost */])("startUploadImage", {
                imgArr: this.$refs.userImgs.submitImages,
                token: token,
                ossPath: ossPath
            }).then(function (res) {
                bridgeAPI["n" /* loading */].hide();
                var sub = void 0,
                    fdStart = void 0,
                    order = void 0,
                    imageUrl = void 0;
                res.images.forEach(function (val) {
                    fdStart = val.indexOf("edus");
                    if (fdStart != 0) {
                        sub = val.indexOf('_');
                        order = val.substring(0, sub);
                        imageUrl = val.substring(sub + 1, val.length);
                    }
                    params.imageUrlList.push('https://' + imageUrl);
                });
                _this.submit(params);
            }).catch(function (res) {
                bridgeAPI["n" /* loading */].hide();
                Object(bridgeAPI["t" /* toast */])('图片上传失败');
            });
        }
    }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/report/report.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//



var deleteIcon = __webpack_require__("1aYl");
/* harmony default export */ var report = ({
  mixins: [report_module],
  components: { imgPicker: imgPicker["a" /* default */] },
  data: function data() {
    return {
      deleteIcon: deleteIcon,
      reportText: "", // 输入文本
      reportList: [{
        type: 0,
        reportText: "广告内容"
      }, {
        type: 1,
        reportText: "违法违规内容"
      }, {
        type: 2,
        reportText: "抄袭他人作品"
      }, {
        type: 3,
        reportText: "隐私肖像"
      }, {
        type: 4,
        reportText: "色情"
      }, {
        type: 5,
        reportText: "其它"
      }], // 投诉类型列表
      imgArr: [], // 选择的图片列表
      currentChooseIndex: null, // 当前选中的索引
      contentShow: false, // 控制下面内容是否显示
      mediaId: "" // 多媒体id
    };
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-64794687","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/report/report.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"report",attrs:{"id":"report"},on:{"click":_vm.hideDeleteFlag}},[_c('div',{staticClass:"mv-report-type-head"},[_vm._v("请选择投诉类型")]),_vm._v(" "),_c('ul',{staticClass:"mv-report-type-list"},_vm._l((_vm.reportList),function(item,index){return _c('li',{key:item.reportText,on:{"click":function($event){_vm.choosedType(index)}}},[_c('span',{staticClass:"mv-report-text",domProps:{"textContent":_vm._s(item.reportText)}}),_vm._v(" "),_c('i',{staticClass:"icon-choose",class:{'active':_vm.currentChooseIndex == index}})])})),_vm._v(" "),_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.contentShow),expression:"contentShow"}],staticClass:"mv-report-content-box"},[_c('div',{staticClass:"mv-reportTextareaBox"},[_c('p',{staticClass:"mv-reportTextareaTitle"},[_vm._v("请填写理由(必填)")]),_vm._v(" "),_c('div',{staticClass:"mv-editAct-textarea"},[_c('textarea',{directives:[{name:"model",rawName:"v-model.trim",value:(_vm.reportText),expression:"reportText",modifiers:{"trim":true}}],attrs:{"maxlength":"500","placeholder":"请描述您举报的理由"},domProps:{"value":(_vm.reportText)},on:{"input":[function($event){if($event.target.composing){ return; }_vm.reportText=$event.target.value.trim()},_vm.limit],"blur":function($event){_vm.$forceUpdate()}}}),_vm._v(" "),_c('div',{staticClass:"mv-regNum"},[_c('span',{domProps:{"textContent":_vm._s(_vm.reportText.length+'/500')}})])])]),_vm._v(" "),_c('div',{staticClass:"mv-reportAccessory"},[_c('p',{staticClass:"mv-accessoryTitle"},[_vm._v("请上传图片证据(选填)")]),_vm._v(" "),_c('img-picker',{ref:"userImgs",attrs:{"imgLeng":3,"deleteIconUrl":_vm.deleteIcon,"id":"myPicker"}})],1)])])}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var report_report = (esExports);
// CONCATENATED MODULE: ./src/pages/report/report.vue
function injectStyle (ssrContext) {
  __webpack_require__("ZcTT")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-64794687"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  report,
  report_report,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_report_report = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "ZcTT":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});