webpackJsonp([45],{

/***/ "HfsA":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/components/mvEditor/mvEditor.vue + 1 modules
var mvEditor = __webpack_require__("VHNc");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/admin/addClassNotice/addClassNotice.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//





/* harmony default export */ var addClassNotice = ({
	components: {
		mvEditor: mvEditor["a" /* default */]
	},
	data: function data() {
		return {
			nowTouch: 0,
			noticeList: [{
				label: '公告',
				value: 0
			}, {
				label: '活动',
				value: 1
			}],
			isSwitch: 0,
			title: '',
			content: '', // 输入内容
			ossPath: '', // 图片地址
			currentMsg: "全校可见", // 当前选中的范围
			isIos: false
		};
	},
	created: function created() {
		var _this = this;

		this.isIos = auth["n" /* platForms */].isIOS();
		this.teacherMSG = JSON.parse(localStorage.adminInfo);
		this.token = Object(auth["h" /* getData */])('token');
		this.queryScopeFn();
		this.dateStr = moment(new Date()).format('YYYY-MM-DD');
		this.ossPath = this.dateStr + '/' + this.teacherMSG.id + '/notice/';
		Object(bridgeAPI["j" /* commonRegister */])('goAdd', function () {
			_this.sendToOss();
		});
		Object(bridgeAPI["j" /* commonRegister */])('scopeData', function (data) {
			_this.currentMsg = data.data.className;
			_this.queryScopeFn();
		});
		Object(bridgeAPI["j" /* commonRegister */])("moduleChoosed", function (data) {
			_this.title = data.data.title;
			_this.content = '<p style="white-space: pre-line;">' + data.data.content + '</p>';
		});
	},
	mounted: function mounted() {
		var _this2 = this;

		// 注册监听返回键
		Object(bridgeAPI["j" /* commonRegister */])('registerBack', function (res) {
			if (!_this2.title.length && !_this2.content.length && !_this2.currentMsg.length) {
				Object(bridgeAPI["g" /* closeWindow */])();
			} else {
				Object(bridgeAPI["k" /* dialog */])({
					title: "放弃本次编辑？",
					message: "已编辑的内容将会被清空哦~",
					comfirmBtn: "确定退出",
					cancelBtn: '再想想'
				}).then(function () {
					Object(auth["p" /* removeData */])("scopeData");
					Object(bridgeAPI["g" /* closeWindow */])();
				}).catch(function () {});
			}
		});
		Object(bridgeAPI["l" /* endPullDown */])();
	},

	methods: {
		editorBlur: function editorBlur() {
			this.$refs.editor.editorBlur();
		},
		queryScopeFn: function queryScopeFn() {
			if (localStorage.scopeData) {
				this.scopeData = JSON.parse(localStorage.scopeData);
			} else {
				this.scopeData = null;
			}
		},

		// 点击添加后的图片，删除图标消失
		hideDeleteFlag: function hideDeleteFlag(event) {
			var a = document.getElementById("myPanel");
			if (a) {
				if (!a.contains(event.target)) {
					this.$refs.userImgs.hideDelete();
				}
			}
		},

		// 跳转到模板
		goUseTemp: function goUseTemp() {
			Object(bridgeAPI["o" /* newWindow */])({
				title: '模板',
				url: 'adminTemp?level=1&type=' + this.nowTouch
			});
		},

		// 到发布范围
		scopeFn: function scopeFn() {
			Object(bridgeAPI["o" /* newWindow */])({
				title: '发布范围',
				url: 'adminScope',
				toolsWay: [{
					text: '确认', // 文字按钮
					type: 2, // 文字按钮类型
					func: 'sendScope' // 点击时call方法名
				}]
			});
		},

		// 切换公告活动
		touchLabel: function touchLabel(item, index) {
			this.nowTouch = item.value;
		},

		// 上传到阿里oss
		sendToOss: function sendToOss() {
			if (!this.title.length) {
				Object(bridgeAPI["t" /* toast */])("请输入标题~");
				return;
			}
			if (this.title.length > 20) {
				Object(bridgeAPI["t" /* toast */])("标题不能超过20字~");
				return;
			}
			if (!this.content.length) {
				Object(bridgeAPI["t" /* toast */])("请输入内容~");
				return;
			}
			bridgeAPI["n" /* loading */].show();
			if (navigator.onLine) {
				var imageArr = this.$refs.editor.imgArr.map(function (item, index) {
					return {
						imageUrl: item,
						order: index
					};
				});
				this.addNotice(imageArr);
			} else {
				bridgeAPI["n" /* loading */].hide();
			}
		},

		// 发布
		addNotice: function addNotice(result) {
			var parmas = {
				noticeType: this.nowTouch ? 1 : 2,
				schoolId: this.teacherMSG.id,
				setTop: this.isSwitch ? 1 : 0,
				title: this.title,
				imageType: 1, // 公告图片类型，0 公告附加图片， 1 富文本图片
				content: Object(auth["g" /* getContent */])(this.content),
				noticeClassification: this.scopeData ? 1 : 2, // 是否全校可见
				classLimits: this.scopeData ? this.scopeData : [], // 发布范围
				posterImages: result
			};
			this._http.post(api["j" /* adminAddClassNotice */], parmas).then(function (res) {
				bridgeAPI["n" /* loading */].hide();
				Object(bridgeAPI["t" /* toast */])('发布成功~');
				Object(bridgeAPI["p" /* notifyPage */])('commonMsg', {
					call: 'loadingListMsg'
				});
				Object(auth["p" /* removeData */])("scopeData");
				setTimeout(function () {
					Object(bridgeAPI["g" /* closeWindow */])();
				}, 1000);
			});
		}
	},
	filters: {}
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-5f00f832","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/admin/addClassNotice/addClassNotice.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"releaseNotice",class:{isIos:_vm.isIos},on:{"click":_vm.hideDeleteFlag}},[_c('div',{staticClass:"addType border-bottom-1px"},[_c('div',{staticClass:"left"},[_vm._v("发布类型")]),_vm._v(" "),_c('div',{staticClass:"right"},[_c('ul',_vm._l((_vm.noticeList),function(item,index){return _c('li',{key:item.id,on:{"click":function($event){_vm.touchLabel(item, index)}}},[_c('i',{staticClass:"icon",class:{active: item.value === _vm.nowTouch}}),_vm._v(" "),_c('span',[_vm._v(_vm._s(item.label))])])}))])]),_vm._v(" "),_c('div',{staticClass:"isTop border-bottom-1px"},[_c('div',{staticClass:"left"},[_vm._v("是否置顶")]),_vm._v(" "),_c('div',{staticClass:"right"},[_c('i',{staticClass:"icon",class:{active: _vm.isSwitch},on:{"click":function($event){_vm.isSwitch = !_vm.isSwitch}}})])]),_vm._v(" "),_c('div',{staticClass:"useTemp border-bottom-1px",on:{"click":function($event){_vm.goUseTemp()}}},[_c('div',{staticClass:"left"},[_vm._v("使用模板")]),_vm._v(" "),_vm._m(0)]),_vm._v(" "),_c('div',{staticClass:"useTemp border-bottom-1px",on:{"click":function($event){_vm.scopeFn()}}},[_c('div',{staticClass:"left"},[_vm._v("发布范围")]),_vm._v(" "),_c('div',{staticClass:"right"},[_c('span',{domProps:{"textContent":_vm._s(_vm.currentMsg)}}),_vm._v(" "),_c('i',{staticClass:"icon"})])]),_vm._v(" "),_c('div',{staticClass:"inputTitle border-bottom-1px"},[_c('input',{directives:[{name:"model",rawName:"v-model.trim",value:(_vm.title),expression:"title",modifiers:{"trim":true}}],attrs:{"type":"text","maxlength":"20","placeholder":"标题"},domProps:{"value":(_vm.title)},on:{"focus":_vm.editorBlur,"input":function($event){if($event.target.composing){ return; }_vm.title=$event.target.value.trim()},"blur":function($event){_vm.$forceUpdate()}}})]),_vm._v(" "),_c('div',{staticClass:"mv-editor"},[_c('mv-editor',{ref:"editor",attrs:{"admin":true,"placeholder":"正文...","ossPath":_vm.ossPath},model:{value:(_vm.content),callback:function ($$v) {_vm.content=$$v},expression:"content"}})],1)])}
var staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"right"},[_c('i',{staticClass:"icon"})])}]
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var addClassNotice_addClassNotice = (esExports);
// CONCATENATED MODULE: ./src/pages/admin/addClassNotice/addClassNotice.vue
function injectStyle (ssrContext) {
  __webpack_require__("dZg8")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-5f00f832"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  addClassNotice,
  addClassNotice_addClassNotice,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var admin_addClassNotice_addClassNotice = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "dZg8":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});