webpackJsonp([48],{

/***/ "HHns":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/classOverview/classOverview.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//




/* harmony default export */ var classOverview = ({
  data: function data() {
    return {
      studentData: {},
      studentList: [],
      locateFlag: true
    };
  },
  created: function created() {
    var _this = this;

    var id = JSON.parse(Object(auth["h" /* getData */])('teacherMSG')).classId;
    this.getData(id);
    // 监听考勤详情页离园成功
    Object(bridgeAPI["j" /* commonRegister */])('reloadStudentStatus', function () {
      _this.getData(id);
    });
  },

  methods: {
    transformList: function transformList(studentData) {
      var atSchool = studentData.atSchoolList.map(function (item) {
        /* 增加类型标识，0代表在校 */
        item["type"] = 0;
        return item;
      });
      var leaveApply = studentData.leaveApplyList.map(function (item) {
        /* 增加类型标识，1代表请假 */
        item["type"] = 1;
        return item;
      });
      var leaveSchool = studentData.leaveSchoolList.map(function (item) {
        /* 增加类型标识，2代表离校 */
        item["type"] = 2;
        return item;
      });
      var substituteApply = studentData.substituteApplyList.map(function (item) {
        /* 增加类型标识，3代表代接 */
        item["type"] = 3;
        return item;
      });
      var unConfirmed = studentData.unconfirmedList.map(function (item) {
        /* 增加类型标识，4代表未确认 */
        item["type"] = 4;
        return item;
      });
      /* 去重 */
      this.unique(atSchool, substituteApply);
      this.studentList = [].concat(unConfirmed, substituteApply, atSchool, leaveSchool, leaveApply);
    },
    cutString: function cutString(str, len) {
      if (!str) {
        return str;
      }
      var s = "";
      if (str.length <= len) {
        return str;
      } else {
        s = str.substring(0, len);
        s += "...";
      }
      return s;
    },
    getData: function getData(id) {
      var _this2 = this;

      /* 判断是否可以跳转 */
      var toDayNum = this.$route.query.toDayNum,
          localDayNum = this.$route.query.toDayNum;
      if (localDayNum > toDayNum) {
        this.locateFlag = false;
      } else {
        this.locateFlag = true;
      }
      /* 获取数据 */
      this.$http.post(api["z" /* attendenceaIn */], {
        classId: id,
        date: moment(Number(toDayNum)).format("YYYY-MM-DD")
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        _this2.studentData = res.resData;
        _this2.transformList(res.resData);
      });
    },
    toPickDetail: function toPickDetail(index) {
      if (this.locateFlag) {
        var id = this.studentList[index].studentId;
        if (this.studentList[index].type == 2) {
          Object(bridgeAPI["o" /* newWindow */])({
            title: "接送详情",
            url: "studentDetail?id=" + id
          });
        } else {
          Object(bridgeAPI["o" /* newWindow */])({
            title: "接送处理",
            url: "normalPickDetail?id=" + id + "&substitude=" + (this.studentList[index].type == 3 ? true : false)
          });
        }
      }
    },
    chooseBgColor: function chooseBgColor(item) {
      switch (item) {
        case 0:
          return "mv-atSchool";
          break;
        case 1:
          return "mv-leaveApply";
          break;
        case 2:
          return "mv-leaveSchool";
          break;
        case 3:
          return "mv-substituteApply";
          break;
        case 4:
          return "mv-unConirm";
          break;
      }
    },
    unique: function unique(arr, subArr) {
      for (var i = 0; i < arr.length; i++) {
        for (var j = 0; j < subArr.length; j++) {
          if (arr[i].studentId == subArr[j].studentId) {
            arr.splice(i, 1);
          }
        }
      }
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-4e0c8f86","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/classOverview/classOverview.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{attrs:{"id":"overview"}},[_vm._m(0),_vm._v(" "),(_vm.studentList.length)?_c('ul',{staticClass:"mv-student-list"},_vm._l((_vm.studentList),function(item,index){return _c('li',{key:item.studentId,staticClass:"mv-student-list-item",class:_vm.chooseBgColor(item.type),on:{"click":function($event){_vm.toPickDetail(index)}}},[_vm._v("\n    "+_vm._s(_vm.cutString(item.studentName,4))+"\n    ")])})):_vm._e()])}
var staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-overview-notice"},[_c('i',{staticClass:"mv-overview-notice-icon"}),_vm._v(" "),_c('ul',{staticClass:"mv-color-info"},[_c('li',{staticClass:"mv-color-item"},[_c('span',{staticClass:"mv-color"},[_vm._v("未入园")])]),_vm._v(" "),_c('li',{staticClass:"mv-color-item mv-color-sub"},[_c('span',{staticClass:"mv-color"},[_vm._v("代接")])]),_vm._v(" "),_c('li',{staticClass:"mv-color-item mv-color-atSchool"},[_c('span',{staticClass:"mv-color"},[_vm._v("在园")])]),_vm._v(" "),_c('li',{staticClass:"mv-color-item mv-color-leaveSchool"},[_c('span',{staticClass:"mv-color"},[_vm._v("离园")])]),_vm._v(" "),_c('li',{staticClass:"mv-color-item mv-color-leaveApply"},[_c('span',{staticClass:"mv-color"},[_vm._v("请假")])])])])}]
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var classOverview_classOverview = (esExports);
// CONCATENATED MODULE: ./src/pages/classOverview/classOverview.vue
function injectStyle (ssrContext) {
  __webpack_require__("TQrm")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-4e0c8f86"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  classOverview,
  classOverview_classOverview,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_classOverview_classOverview = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "TQrm":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});