webpackJsonp([5],{

/***/ "CSJ3":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "Hzkc":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "Qyrf":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAICAYAAACccC2SAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyFpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQyIDc5LjE2MDkyNCwgMjAxNy8wNy8xMy0wMTowNjozOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo1NUVFREIxMjdGNEYxMUU4ODNGOENEMjFDM0RCOEQ4RSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo1NUVFREIxMzdGNEYxMUU4ODNGOENEMjFDM0RCOEQ4RSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjU1RUVEQjEwN0Y0RjExRTg4M0Y4Q0QyMUMzREI4RDhFIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjU1RUVEQjExN0Y0RjExRTg4M0Y4Q0QyMUMzREI4RDhFIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+4F3rsAAAAJBJREFUeNpidDr4hwEIVIG4A4hdGCBgDxBXAPFtBtyAqnoYgQ5RBzJOALEAmqYPQGwBxDexGEh1PUxAog2LJANUrA2Hz6iuBxQiH4EMPhyavwAxLxZxquthYhgkgAmaYHCBXTjEqa4HFDUaQMZxHInIEohvYNFIdT1MUE2glL4OiD9D8Tqo2A0cPqC6HoAAAwAFEz9X+Pji7AAAAABJRU5ErkJggg=="

/***/ }),

/***/ "YOo7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./src/components/studentList4index/module/index4Index.js


var defaultImg = __webpack_require__("mX+a");
/* harmony default export */ var index4Index = ({
    props: {
        studentList: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        AttendanceMark: {
            type: Boolean
        },
        AllStudentList: {
            type: Array,
            default: function _default() {
                return [];
            }
        }
    },
    data: function data() {
        return {
            longTapAnimateFlag: null,
            chooseAllFlag: false,
            operationFlag: true,
            localIndex: '', // 本地存储开启动画列表元素的index值
            changeList: {
                status: '',
                studentId: []
            }
        };
    },
    created: function created() {
        this.longTapAnimateFlag = null;
    },

    methods: {
        call: function call(name, tel) {
            Object(bridgeAPI["f" /* callSomeOne */])({
                title: name + '\u5BB6\u957F',
                content: tel,
                operate: '拨打'
            });
        },
        toPickDetail: function toPickDetail(id, flag, animateFlag, substitudeFlag) {
            // 跳转接送详情 title: 接送处理
            var op = {};
            if (flag) {
                op.url = 'normalPickDetail?id=' + id + '&substitude=' + substitudeFlag;
                op.title = '接送处理';
            } else {
                op.url = 'studentDetail?id=' + id;
                op.title = '接送详情';
            }
            if (animateFlag) {
                setTimeout(function () {
                    Object(bridgeAPI["o" /* newWindow */])(op);
                }, 200);
            } else {
                Object(bridgeAPI["o" /* newWindow */])(op);
            }
        },
        changeStudentStatus: function changeStudentStatus() {
            var _this = this;

            // 判断是更改考勤还是更改代接
            if (this.changeList.substitute) {
                this.$http.post(api["G" /* changeSubstituteStatus */], {
                    studentId: this.changeList.studentId,
                    status: this.changeList.status
                }).then(function (res) {
                    _this.chooseAllFlag = false;
                    bridgeAPI["n" /* loading */].hide();
                    // 关闭动画
                    if (_this.longTapAnimateFlag) {
                        _this.longTapAnimateFlag = false;
                    }
                    setTimeout(function () {
                        _this.longTapAnimateFlag = null;
                    }, 200);
                    _this.$emit('updateList');
                });
            } else {
                this.$http.post(api["F" /* changeSignStatus */], {
                    studentId: this.changeList.studentId,
                    status: this.changeList.status
                }).then(function (res) {
                    _this.chooseAllFlag = false;
                    bridgeAPI["n" /* loading */].hide();
                    if (_this.longTapAnimateFlag) {
                        _this.longTapAnimateFlag = false;
                    }
                    setTimeout(function () {
                        _this.longTapAnimateFlag = null;
                    }, 200);
                    _this.$emit('updateList');
                });
            }
        },
        allStateChange: function allStateChange(toLabel) {
            var tempArr = [];
            bridgeAPI["n" /* loading */].show();
            // 判断是否全选， 是的话取所有数据， 不是的话取选中数据
            if (this.chooseAllFlag) {
                tempArr = this.AllStudentList;
            } else {
                this.studentList.forEach(function (item) {
                    if (item.checkFlag) {
                        tempArr.push(item);
                    }
                });
            }
            this.addChangeList(tempArr, toLabel);
            this.changeStudentStatus();
        },
        singleChangeStatus: function singleChangeStatus(item, toLabel) {
            this.addChangeList(item, toLabel);
            this.changeStudentStatus();
        },
        addChangeList: function addChangeList(itemArr, toLabel) {
            var _this2 = this;

            // 每次调用添加变更数据的时候，先清空数组
            var tempArr = [];
            this.changeList.status = '';
            this.changeList.studentId = [];
            switch (toLabel) {
                case 'atSchoolList':
                    this.changeList.status = 2;
                    break;
                case 'leaveApplyList':
                    this.changeList.status = 1;
                    break;
                case 'leaveSchoolList':
                    this.changeList.status = 3;
                    break;
                case 'substituteApplyList':
                    this.changeList.status = 0;
                    this.changeList.substitute = true;
                    break;
            }
            if (Array.isArray(itemArr)) {
                tempArr = itemArr;
            } else {
                tempArr.push(itemArr);
            }
            // 判断变更的是否是代接， 如果是，则传入代接id,不是的话，传入studentId
            tempArr.forEach(function (item, index) {
                _this2.changeList.studentId.push(item.studentId);
            });
        },
        initAnimate: function initAnimate() {
            var _this3 = this;

            this.longTapAnimateFlag = null;
            this.chooseAllFlag = false;
            this.studentList.forEach(function (item, index) {
                _this3.$set(_this3.studentList[index], 'animateFlag', null);
                _this3.$set(_this3.studentList[index], 'checkFlag', null);
            });
        },
        checkAHideAnimate: function checkAHideAnimate(index) {
            window.event.stopPropagation();
            if (this.longTapAnimateFlag) {
                // 处于可选状态，才能进行选中和取消选中
                if (this.studentList[index].checkFlag) {
                    this.$set(this.studentList[index], 'checkFlag', false);
                } else {
                    this.$set(this.studentList[index], 'checkFlag', true);
                }
                // 判断是否全部选中
                this.chooseAllFlag = this.studentList.every(function (item) {
                    return item.checkFlag == true;
                });
            }
            if (this.studentList[index].animateFlag !== null) {
                this.$set(this.studentList[index], 'animateFlag', false);
            }
        },
        swipeLeft: function swipeLeft(index, e) {
            var _this4 = this;

            //e.srcEvent.cancelBubble = true
            // 判断是否是今天之前的数据，是的话无动画
            if (this.operationFlag) {
                // 处于长按动画激活状态， 左滑激活回退动画
                if (this.longTapAnimateFlag) {
                    this.longTapAnimateFlag = false;
                } else {
                    // 激活左滑动画
                    this.studentList.forEach(function (item, _index) {
                        if (_this4.studentList[_index].animateFlag === true) {
                            _this4.$set(_this4.studentList[_index], 'animateFlag', false);
                        }
                    });
                    this.$set(this.studentList[index], 'animateFlag', true);
                }
            } else {
                return;
            }
            console.log('1111');
        },
        swipeRight: function swipeRight(index, e) {
            e.srcEvent.cancelBubble = true;
            // 判断是否是今天之前的数据，是的话无动画
            if (this.operationFlag) {
                if (!this.longTapAnimateFlag) {
                    if (this.studentList[index].animateFlag !== null) this.$set(this.studentList[index], 'animateFlag', false);
                }
            } else {
                return;
            }
        },
        longTap: function longTap(e) {
            var _this5 = this;

            e.srcEvent.cancelBubble = true;
            // 判断是否是今天之前的数据，是的话无动画
            if (this.operationFlag) {
                this.studentList.forEach(function (item, _index) {
                    if (_this5.studentList[_index].animateFlag === true) {
                        _this5.$set(_this5.studentList[_index], 'animateFlag', false);
                    }
                });
                this.longTapAnimateFlag = true;
            } else {
                return;
            }
        },
        checkAll: function checkAll() {
            var _this6 = this;

            // 全选和取消全选
            this.chooseAllFlag = !this.chooseAllFlag;
            if (this.chooseAllFlag) {
                this.studentList.forEach(function (item) {
                    _this6.$set(item, 'checkFlag', true);
                });
                // 通知父组件全选，设置滚动加载出来的数据为全选状态
                this.$emit('allCheck', true);
            } else {
                this.studentList.forEach(function (item) {
                    _this6.$set(item, 'checkFlag', false);
                });
                // 通知父组件取消全选，设置滚动加载出来的数据为取消全选状态
                this.$emit('allCheck', false);
            }
        },
        showImgHead: function showImgHead(img) {
            var headImg;
            headImg = img ? img : defaultImg;
            return headImg;
        },
        cutString: function cutString(str, len) {
            // 截取字符串
            if (!str) {
                return str;
            }
            var s = '';
            if (str.length <= len) {
                return str;
            } else {
                s = str.substring(0, 10);
                s += '...';
            }
            return s;
        }
    }
});
// EXTERNAL MODULE: ./src/components/noData/noData.vue + 2 modules
var noData = __webpack_require__("ycV+");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/components/studentList4index/studentList4index.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//



/* harmony default export */ var studentList4index = ({
  mixins: [index4Index],
  components: { noData: noData["a" /* default */] }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-9ba1cc26","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/components/studentList4index/studentList4index.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-student-list"},[(!_vm.studentList.length)?_c('no-data',{attrs:{"noDataText":"暂无数据~"}}):_vm._e(),_vm._v(" "),(_vm.studentList.length)?_c('div',{staticClass:"mv-attendance-inschool"},[_c('v-touch',{staticClass:"mv-attendance-identify-list",class:{'mv-enlarge-padding': _vm.longTapAnimateFlag === true}},_vm._l((_vm.studentList),function(item,index){return _c('v-touch',{key:item.studentId,staticClass:"mv-attendance-identify-item",class:{'swipeLeft': item.animateFlag === true, 'swipeLeftBack': item.animateFlag === false, 'longClickActive': _vm.longTapAnimateFlag === true, 'longClickInActive': _vm.longTapAnimateFlag === false, 'checked': item.checkFlag},attrs:{"tag":"li"},on:{"swipeleft":function($event){_vm.swipeLeft(index, $event)},"swiperight":function($event){_vm.swipeRight(index, $event)},"tap":function($event){_vm.checkAHideAnimate(index, $event)},"press":function($event){_vm.longTap($event)}}},[_c('ul',{staticClass:"mv-attendance-identify-item-inner"},[_c('li',{staticClass:"mv-attendance-msg-check"},[_c('div',{staticClass:"mv-attendance-checkbox"},[_c('i')]),_vm._v(" "),_c('div',{staticClass:"mv-attendance-identify-student"},[_c('div',{directives:[{name:"lazy",rawName:"v-lazy:background-image",value:(_vm.showImgHead(item.photoUrl)),expression:"showImgHead(item.photoUrl)",arg:"background-image"}],staticClass:"mv-attendance-student-img",staticStyle:{"backgroundRepeat":"'no-repeat'","backgroundPosition":"'center center'","backgroundSize":"'cover'"}}),_vm._v(" "),(!_vm.detailFlag)?_c('div',{staticClass:"mv-attendance-student-msg"},[_c('div',[_c('span',{staticClass:"mv-attendance-student-name"},[_vm._v(_vm._s(_vm.cutString(item.studentName,10)))]),_vm._v(" "),(!!item.substitude)?_c('span',[_vm._v("（代接）")]):_vm._e()]),_vm._v(" "),(_vm.AttendanceMark)?_c('span',{staticClass:"mv-attendance-student-status mv-noarrival"},[_vm._v("未到")]):_vm._e(),_vm._v(" "),(!_vm.AttendanceMark)?_c('span',{staticClass:"mv-attendance-student-status mv-noarrival"},[_vm._v("在园")]):_vm._e()]):_vm._e()])]),_vm._v(" "),(!_vm.detailFlag)?_c('li',{directives:[{name:"show",rawName:"v-show",value:(_vm.operationFlag),expression:"operationFlag"}],staticClass:"mv-attendance-identify-operate"},[_c('div',{staticClass:"mv-attendance-call",on:{"click":function($event){_vm.call(item.studentName,item.phoneNumber)}}},[_c('img',{attrs:{"src":__webpack_require__("wlgP")}})]),_vm._v(" "),(_vm.AttendanceMark)?_c('div',{staticClass:"mv-attendance-more",on:{"click":function($event){_vm.swipeLeft(index, $event)}}},[_c('img',{attrs:{"src":__webpack_require__("Qyrf")}})]):_c('div',{staticClass:"mv-toDetail",class:{'mv-attendance-leave-more': !_vm.AttendanceMark},on:{"click":function($event){_vm.toPickDetail(item.studentId, true, false, !!item.substitude)}}},[_c('img',{attrs:{"src":__webpack_require__("Hzkc")}})])]):_vm._e(),_vm._v(" "),(!_vm.detailFlag)?_c('li',{staticClass:"mv-attendance-stateChange"},[(_vm.AttendanceMark)?_c('v-touch',{staticClass:"mv-attendance-leave-btn mv-apply",on:{"tap":function($event){_vm.singleChangeStatus(item, 'leaveApplyList')}}},[_vm._v("请假")]):_vm._e(),_vm._v(" "),(_vm.AttendanceMark)?_c('v-touch',{staticClass:"mv-attendance-atschool-btn mv-attendance-sec-btn mv-atSchool",on:{"tap":function($event){_vm.singleChangeStatus(item, 'atSchoolList')}}},[_vm._v("在园")]):_vm._e(),_vm._v(" "),(!_vm.AttendanceMark)?_c('v-touch',{staticClass:"mv-first-btn mv-leave",on:{"tap":function($event){_vm.singleChangeStatus(item, 'leaveSchoolList')}}},[_vm._v("离园")]):_vm._e()],1):_vm._e()])])})),_vm._v(" "),_c('div',{staticClass:"mv-attendance-stateAllChange",class:{'checkAllShow': _vm.longTapAnimateFlag === true, 'checkAllHide': _vm.longTapAnimateFlag === false}},[_c('div',{staticClass:"mv-attendance-checkbox",on:{"click":_vm.checkAll}},[_c('i',{class:{'mv-attendance-checkbox-active': _vm.chooseAllFlag}}),_vm._v(" "),_c('span',{staticClass:"checkAllText"},[_vm._v("全选")])]),_vm._v(" "),_c('div',{staticClass:"mv-attendance-allOperate"},[(_vm.AttendanceMark)?_c('span',{staticClass:"mv-attendance-allApply",on:{"click":function($event){_vm.allStateChange('leaveApplyList')}}},[_vm._v("变更请假")]):_vm._e(),_vm._v(" "),(_vm.AttendanceMark)?_c('span',{staticClass:"mv-attendance-allInSchool activeBtn",on:{"click":function($event){_vm.allStateChange('atSchoolList')}}},[_vm._v("变更在园")]):_vm._e(),_vm._v(" "),(!_vm.AttendanceMark)?_c('span',{staticClass:"mv-attendance-allInSchool activeBtn",on:{"click":function($event){_vm.allStateChange('leaveSchoolList')}}},[_vm._v("变更离园")]):_vm._e()])])],1):_vm._e()],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var studentList4index_studentList4index = (esExports);
// CONCATENATED MODULE: ./src/components/studentList4index/studentList4index.vue
function injectStyle (ssrContext) {
  __webpack_require__("CSJ3")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-9ba1cc26"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  studentList4index,
  studentList4index_studentList4index,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var components_studentList4index_studentList4index = (Component.exports);

// EXTERNAL MODULE: ./src/components/timePicker/timePicker.vue + 2 modules
var timePicker = __webpack_require__("+7rW");

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__("Gu7T");
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// CONCATENATED MODULE: ./src/pages/attendence/module/attendence.js




var defaultPersonImg = __webpack_require__("mX+a");
/* harmony default export */ var attendence = ({
    data: function data() {
        return {
            localIndex: '', // 本地存储开启动画列表元素的index值
            tempList: [],
            pageNum: 1,
            allCheckFlag: null
        };
    },
    created: function created() {
        var _this = this;

        // 下拉刷新
        Object(bridgeAPI["c" /* beginPullDown */])(function () {
            _this.calLeaveFlag();
            // 初始化页数
            _this.pageNum = 1;
            _this.allCheckFlag = false;
            _this.getStudentList();
        });
        // 存储当前时间戳
        this.toDayNum = Number(new Date());
        this.localDayNum = Number(new Date());
        // 监听进入页面
        Object(bridgeAPI["p" /* notifyPage */])('checkingin', function () {
            // 初始化页数
            _this.pageNum = 1;
            _this.allCheckFlag = false;
            _this.calLeaveFlag();
            _this.getStudentList();
        });
        Object(bridgeAPI["j" /* commonRegister */])('reloadStudentStatus', function () {
            _this.getStudentList();
        });
        this.calLeaveFlag();
        this.getStudentList();
        // 监听跳转页面
        Object(bridgeAPI["j" /* commonRegister */])('toBabyLeaveRecord', function () {
            Object(bridgeAPI["o" /* newWindow */])({
                title: '请假记录',
                url: 'babyLeaveRecord',
                pullDown: true
            });
        });
        // 监听登陆成功
        Object(bridgeAPI["j" /* commonRegister */])('loginSuccess', function () {
            _this.calLeaveFlag();
            // 初始化页数
            _this.pageNum = 1;
            _this.allCheckFlag = false;
            _this.getStudentList();
        });
    },
    mounted: function mounted() {
        var _this2 = this;

        var yScroll = void 0,
            screenHeight = void 0,
            scrollHeight = void 0;

        document.addEventListener('scroll', function () {
            screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
            scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
            if (self.pageYOffset) {
                yScroll = self.pageYOffset;
            } else if (document.documentElement && document.documentElement.scrollTop) {
                // Explorer 6 Strict
                yScroll = document.documentElement.scrollTop;
            } else if (document.body) {
                // all other Explorers
                yScroll = document.body.scrollTop;
            }
            if (scrollHeight - (yScroll + screenHeight) < 150) {
                _this2.concatList();
            }
        });
        // // 解决x5初始化失败问题
        // commonRegister('x5InitAgin',()=>{
        //   this.calLeaveFlag()
        //   this.getStudentList()
        // })
    },

    computed: {
        calUnconfirmList: function calUnconfirmList() {
            var _this3 = this;

            this.tempList.forEach(function (element) {
                if (element.animateFlag === undefined) {
                    _this3.$set(element, 'animateFlag', null);
                }
                if (element.checkFlag === undefined) {
                    if (_this3.allCheckFlag) {
                        _this3.$set(element, 'checkFlag', true);
                    } else {
                        _this3.$set(element, 'checkFlag', null);
                    }
                }
            });
            return this.tempList;
        }
    },
    methods: {
        concatList: function concatList() {
            if (this.tempList.length == this.unconfirmList.length) {
                return;
            } else {
                this.pageNum = this.pageNum + 1;
                this.tempList = [].concat(toConsumableArray_default()(this.tempList), toConsumableArray_default()(this.unconfirmList.slice(10 * (this.pageNum - 1), 10 * this.pageNum)));
            }
        },
        listAllCheck: function listAllCheck(val) {
            this.allCheckFlag = val;
        },
        update: function update() {
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.getStudentList();
        },
        getLastData: function getLastData(timeNum) {
            bridgeAPI["n" /* loading */].show();
            this.toDayNum = timeNum;
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.getStudentList();
            this.$refs.studentList.operationFlag = false;
        },
        getPreData: function getPreData(timeObj) {
            bridgeAPI["n" /* loading */].show();
            timeObj = JSON.parse(timeObj);
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.toDayNum = timeObj.toDayNum;
            this.$refs.studentList.operationFlag = timeObj.operateFlag;
            this.getStudentList();
        },
        pickDate: function pickDate(timeObj) {
            bridgeAPI["n" /* loading */].show();
            timeObj = JSON.parse(timeObj);
            // 初始化页数
            this.pageNum = 1;
            this.allCheckFlag = false;
            this.toDayNum = timeObj.toDayNum;
            this.$refs.studentList.operationFlag = timeObj.operateFlag;
            this.getStudentList();
        },
        getStudentList: function getStudentList() {
            var _this4 = this;

            // date 时间
            var params = {};
            params.date = moment(this.toDayNum).format('YYYY-MM-DD');
            params.classId = JSON.parse(Object(auth["h" /* getData */])('teacherMSG')).classId;
            this.$http.post(api["z" /* attendenceaIn */], params).then(function (res) {
                _this4.showFlag = true;
                bridgeAPI["n" /* loading */].hide();
                Object(bridgeAPI["l" /* endPullDown */])();
                _this4.unConfirmed = res.resData;
                if (_this4.AttendanceMark) {
                    _this4.unconfirmList = _this4.unConfirmed.unconfirmedList;
                    if (_this4.unconfirmList.length > 10) {
                        _this4.tempList = _this4.unconfirmList.slice(10 * (_this4.pageNum - 1), 10 * _this4.pageNum);
                    } else {
                        _this4.tempList = _this4.unconfirmList;
                    }
                } else {
                    if (_this4.leaveFlag) {
                        _this4.unconfirmList = _this4.unConfirmed.atSchoolList;
                        if (_this4.unconfirmList.length > 10) {
                            _this4.tempList = _this4.unconfirmList.slice(10 * (_this4.pageNum - 1), 10 * _this4.pageNum);
                        } else {
                            _this4.tempList = _this4.unconfirmList;
                        }
                    } else {
                        _this4.unconfirmList = [];
                        _this4.tempList = [];
                    }
                }
                _this4.sortUnconfirmList();
            });
        },
        sortUnconfirmList: function sortUnconfirmList() {
            /* 将代接元素排在数组前面 */
            var applyList = this.unConfirmed.substituteApplyList,
                substitude = this.unConfirmed.atSchoolList;
            /* 循环比对，存在重复，则删除，添加到首位 */
            for (var i = 0; i < applyList.length; i++) {
                for (var j = 0; j < substitude.length; j++) {
                    if (applyList[i].studentId == substitude[j].studentId) {
                        var item = substitude[j];
                        item.substitude = true;
                        substitude.splice(j, 1);
                        substitude.unshift(item);
                    }
                }
            }
        },
        goToTab: function goToTab(index) {
            var params = {};
            if (index == 4) {
                params.title = "班级总览";
                params.url = 'classOverview?toDayNum=' + this.toDayNum + '&localDayNum=' + this.localDayNum;
            } else {
                params.title = "考勤列表";
                params.url = 'attendenceDetail?index=' + index + '&toDayNum=' + this.toDayNum + '&localDayNum=' + this.localDayNum;
            }
            Object(bridgeAPI["o" /* newWindow */])(params);
        },
        activeIn: function activeIn() {

            if (this.AttendanceMark) {
                // 清除动画, 清除选中状态
                this.$refs.studentList.initAnimate();
            } else {
                // 激活样式
                this.AttendanceMark = true;
                // 赋值
                this.unconfirmList = this.unConfirmed.unconfirmedList;
                // 初始化页数
                this.pageNum = 1;
                if (this.unconfirmList.length > 10) {
                    this.tempList = this.unconfirmList.slice(10 * (this.pageNum - 1), 10 * this.pageNum);
                } else {
                    this.tempList = this.unconfirmList;
                }
                // 清除动画 清除选中状态
                this.$refs.studentList.initAnimate();
            }
        },
        activeOut: function activeOut() {

            if (!this.AttendanceMark) {
                // 清除动画, 清除选中状态
                this.$refs.studentList.initAnimate();
            } else {
                // 激活样式
                this.AttendanceMark = false;
                this.$refs.studentList.initAnimate();
                // 初始化页数
                this.pageNum = 1;
                if (this.leaveFlag) {
                    this.unconfirmList = this.unConfirmed.atSchoolList;
                    if (this.unconfirmList.length > 10) {
                        this.tempList = this.unconfirmList.slice(10 * (this.pageNum - 1), 10 * this.pageNum);
                    } else {
                        this.tempList = this.unconfirmList;
                    }
                } else {
                    this.unconfirmList = [];
                    this.tempList = [];
                }
            }
        },
        showImgHead: function showImgHead(img) {
            var headImg;
            headImg = img ? img : defaultPersonImg;
            return headImg;
        },
        cutString: function cutString(str, len) {
            // 截取字符串
            if (!str) {
                return str;
            }
            var s = '';
            if (str.length <= len) {
                return str;
            } else {
                s = str.substring(0, 10);
                s += '...';
            }
            return s;
        },
        calLeaveFlag: function calLeaveFlag() {
            // 判断当前时间是入园还是离园
            var now = void 0,
                leaveTimeNum = void 0;
            now = new Date().getHours() * 3600 + new Date().getMinutes() * 60;
            leaveTimeNum = Number(this.leaveTime.split(':')[0]) * 3600 + Number(this.leaveTime.split(':')[1]) * 60;
            if (now >= leaveTimeNum) {
                this.leaveFlag = true;
                this.AttendanceMark = false;
            } else {
                this.leaveFlag = false;
                this.AttendanceMark = true;
            }
        },
        returnAtSchoolList: function returnAtSchoolList() {
            if (this.leaveFlag) {
                if (this.AttendanceMark) {
                    return this.unConfirmed.atSchoolList.length;
                } else {
                    return this.unconfirmList.length;
                }
            } else {
                return 0;
            }
        },
        returnUnConfirmList: function returnUnConfirmList() {
            return this.unConfirmed.unconfirmedList.length;
        }
    }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/attendence/attendence.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//





/* harmony default export */ var attendence_attendence = ({
  mixins: [attendence],
  components: { studentList: components_studentList4index_studentList4index, timePicker: timePicker["a" /* default */] },
  data: function data() {
    return {
      unConfirmed: {},
      unconfirmList: [],
      atSchoolList: [],
      AttendanceMark: true,
      toDayNum: 0,
      localDayNum: 0,
      classId: "",
      operationFlag: true,
      noDataFlag: false,
      leaveFlag: true,
      leaveTime: "12:00",
      longTapAnimateFlag: null,
      chooseAllFlag: false
    };
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-600fa344","hasScoped":false,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/attendence/attendence.vue
var attendence_render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return (_vm.unConfirmed.className)?_c('div',{staticClass:"mv-attendance"},[_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.unConfirmed.healthyCount || _vm.unConfirmed.sickCount || _vm.unConfirmed.leaveApplyCount),expression:"unConfirmed.healthyCount || unConfirmed.sickCount || unConfirmed.leaveApplyCount"}],staticClass:"mv-morning-check"},[_c('i',{staticClass:"icon-morning-check"}),_vm._v(" "),_c('ul',{staticClass:"mv-morningCheck-list"},[_c('li',[_vm._v("\n        健康:\n        "),_c('span',{},[_vm._v(_vm._s(_vm.unConfirmed.healthyCount+'人'))])]),_vm._v(" "),_c('li',[_vm._v("\n        生病在校:\n        "),_c('span',{},[_vm._v(_vm._s(_vm.unConfirmed.sickCount+'人'))])]),_vm._v(" "),_c('li',[_vm._v("\n        晨检请假:\n        "),_c('span',{},[_vm._v(_vm._s(_vm.unConfirmed.leaveApplyCount+'人'))])])])]),_vm._v(" "),_c('div',{staticClass:"mv-attendance-banner"},[_vm._m(0),_vm._v(" "),_c('time-picker',{attrs:{"toDayNum":_vm.toDayNum,"localDayNum":_vm.localDayNum},on:{"getLastData":_vm.getLastData,"getPreData":_vm.getPreData,"pickDate":_vm.pickDate}}),_vm._v(" "),_c('ul',{staticClass:"mv-attendance-category"},[_c('li',{staticClass:"mv-attendance-category-item"},[_c('div',{staticClass:"mv-attendance-category-item-num mv-attendance-total",domProps:{"innerHTML":_vm._s(_vm.unConfirmed.total ? _vm.unConfirmed.total : 0)},on:{"click":function($event){_vm.goToTab(4)}}}),_vm._v(" "),_c('div',{staticClass:"mv-attendance-category-item-title",staticStyle:{"transform":"translateY(-5px)","-webkit-transform":"translateY(-5px)"}},[_vm._v("总人数")])]),_vm._v(" "),_c('li',{staticClass:"mv-attendance-category-item"},[_c('div',{staticClass:"mv-attendance-category-item-num mv-attendance-leave",domProps:{"innerHTML":_vm._s(_vm.unConfirmed.leaveApplyList.length)},on:{"click":function($event){_vm.goToTab(0)}}}),_vm._v(" "),_c('div',{staticClass:"mv-attendance-category-item-title"},[_vm._v("请假")])]),_vm._v(" "),_c('li',{staticClass:"mv-attendance-category-item"},[_c('div',{staticClass:"mv-attendance-category-item-num mv-attendance-atschool",domProps:{"innerHTML":_vm._s(_vm.unConfirmed.atSchoolList.length)},on:{"click":function($event){_vm.goToTab(1)}}}),_vm._v(" "),_c('div',{staticClass:"mv-attendance-category-item-title"},[_vm._v("在园")])]),_vm._v(" "),_c('li',{staticClass:"mv-attendance-category-item"},[_c('div',{staticClass:"mv-attendance-category-item-num mv-attendance-substitute",domProps:{"innerHTML":_vm._s(_vm.unConfirmed.substituteApplyList.length)},on:{"click":function($event){_vm.goToTab(2)}}}),_vm._v(" "),_c('div',{staticClass:"mv-attendance-category-item-title"},[_vm._v("代接")])]),_vm._v(" "),_c('li',{staticClass:"mv-attendance-category-item"},[_c('div',{staticClass:"mv-attendance-category-item-num mv-attendance-outschool",domProps:{"innerHTML":_vm._s(_vm.unConfirmed.leaveSchoolList.length)},on:{"click":function($event){_vm.goToTab(3)}}}),_vm._v(" "),_c('div',{staticClass:"mv-attendance-category-item-title"},[_vm._v("离园")])])])],1),_vm._v(" "),_c('div',{staticClass:"mv-attendance-inschool-title"},[_c('div',{staticClass:"mv-in",class:{'mv-active': _vm.AttendanceMark},on:{"click":_vm.activeIn}},[_c('span',[_vm._v("入园待确认")]),_vm._v(" "),_c('span',[_vm._v("\n        （\n        "),_c('span',{staticClass:"mv-attendance-identify-num",domProps:{"innerHTML":_vm._s(_vm.returnUnConfirmList())}}),_vm._v(" ）\n      ")])]),_vm._v(" "),_c('div',{staticClass:"mv-out",class:{'mv-active': !_vm.AttendanceMark},on:{"click":_vm.activeOut}},[_c('span',[_vm._v("离园待确认")]),_vm._v(" "),_c('span',[_vm._v("\n        （\n        "),_c('span',{staticClass:"mv-attendance-identify-num",domProps:{"textContent":_vm._s(_vm.returnAtSchoolList())}}),_vm._v(" ）\n      ")])])]),_vm._v(" "),_c('student-list',{ref:"studentList",attrs:{"studentList":_vm.calUnconfirmList,"AttendanceMark":_vm.AttendanceMark,"AllStudentList":_vm.unconfirmList},on:{"updateList":_vm.update,"allCheck":_vm.listAllCheck}})],1):_vm._e()}
var attendence_staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-attendance-banner-img"},[_c('img',{staticClass:"mv-attendance-banner-bg",attrs:{"src":__webpack_require__("uOPa"),"alt":"背景图"}}),_vm._v(" "),_c('img',{staticClass:"mv-attendance-banner-bg-eye",attrs:{"src":__webpack_require__("d1+i"),"alt":"背景图"}})])}]
var attendence_esExports = { render: attendence_render, staticRenderFns: attendence_staticRenderFns }
/* harmony default export */ var pages_attendence_attendence = (attendence_esExports);
// CONCATENATED MODULE: ./src/pages/attendence/attendence.vue
function attendence_injectStyle (ssrContext) {
  __webpack_require__("fb0Z")
}
var attendence_normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var attendence___vue_template_functional__ = false
/* styles */
var attendence___vue_styles__ = attendence_injectStyle
/* scopeId */
var attendence___vue_scopeId__ = null
/* moduleIdentifier (server only) */
var attendence___vue_module_identifier__ = null
var attendence_Component = attendence_normalizeComponent(
  attendence_attendence,
  pages_attendence_attendence,
  attendence___vue_template_functional__,
  attendence___vue_styles__,
  attendence___vue_scopeId__,
  attendence___vue_module_identifier__
)

/* harmony default export */ var src_pages_attendence_attendence = __webpack_exports__["default"] = (attendence_Component.exports);


/***/ }),

/***/ "fb0Z":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "uOPa":
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "static/img/banner.b598283.jpg";

/***/ }),

/***/ "wlgP":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ })

});