webpackJsonp([50],{

/***/ "f2FJ":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "upXH":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./node_modules/babel-runtime/core-js/json/stringify.js
var stringify = __webpack_require__("mvHQ");
var stringify_default = /*#__PURE__*/__webpack_require__.n(stringify);

// EXTERNAL MODULE: ./src/components/noData/noData.vue + 2 modules
var noData = __webpack_require__("ycV+");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/assets/imgs/babyHead.png
var babyHead = __webpack_require__("mX+a");
var babyHead_default = /*#__PURE__*/__webpack_require__.n(babyHead);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/schoolInvitation/schoolInvitation.vue

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//






/* harmony default export */ var schoolInvitation = ({
  components: {
    noData: noData["a" /* default */]
  },
  data: function data() {
    return {
      teacherMsg: null, //老师信息
      stduentList: [], // 学生列表
      defaultImg: babyHead_default.a, //小孩默认头像
      notApprovedCount: 0, // 未读消息数量
      nodataFlag: false // 是否没数据
    };
  },
  created: function created() {
    var _this = this;

    // 获取老师信息
    this.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    // 查询通过学生列表
    this.queryStudentList();
    // 注册下拉刷新
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      _this.queryStudentList();
    });
    // 注册录入成功刷新页面
    Object(bridgeAPI["j" /* commonRegister */])('updateStudentList', function () {
      _this.queryStudentList();
    });
  },
  mounted: function mounted() {},

  methods: {
    /**
     * 查询通过学生列表
     */
    queryStudentList: function queryStudentList() {
      var _this2 = this;

      this.$http.post(api["_29" /* queryClassApprovedStudents */], {
        teacherId: this.teacherMsg.id
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        if (res.resData.approvedStudents && res.resData.approvedStudents.length) {
          _this2.stduentList = res.resData.approvedStudents;
          _this2.nodataFlag = false;
        } else {
          _this2.stduentList = [];
          _this2.nodataFlag = true;
        }
        _this2.notApprovedCount = res.resData.notApprovedCount;
      }).catch(function (err) {
        _this2.stduentList = [];
        _this2.nodataFlag = true;
      });
    },

    /**
     * 跳转至入园申请
     */
    toSchoolApply: function toSchoolApply() {
      Object(bridgeAPI["o" /* newWindow */])({
        title: '入园邀请',
        url: 'schoolApply',
        pullDown: true
      });
    },

    /**
     * 跳转至学生编辑页面
     */
    toStudentEditInfo: function toStudentEditInfo(item) {
      Object(auth["q" /* setData */])('studentEditInfo', stringify_default()(item));
      Object(bridgeAPI["o" /* newWindow */])({
        title: '信息编辑',
        url: 'editInfo'
      });
    },

    /**
     * 跳转至二维码页面
     */
    toSchoolQrcode: function toSchoolQrcode() {
      Object(bridgeAPI["o" /* newWindow */])({
        title: '二维码邀请入园',
        url: 'schoolQrcode'
      });
    },

    /**
     * 跳转至单条录入页面
     */
    toSingleEntry: function toSingleEntry() {
      Object(bridgeAPI["o" /* newWindow */])({
        title: '添加新生',
        url: 'joinNewStudent'
      });
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-4965fc90","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/schoolInvitation/schoolInvitation.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-invitation"},[_c('div',{staticClass:"mv-invitation-module"},[_c('div',{staticClass:"mv-invite-qrcode",on:{"click":_vm.toSchoolQrcode}},[_c('i'),_vm._v(" "),_c('span',[_vm._v("扫码邀请")])]),_vm._v(" "),_c('div',{staticClass:"mv-single-entry",on:{"click":_vm.toSingleEntry}},[_c('i'),_vm._v(" "),_c('span',[_vm._v("单条录入")])])]),_vm._v(" "),_c('div',{staticClass:"mv-invitation-info",on:{"click":_vm.toSchoolApply}},[_c('span',[_vm._v("入园申请信息")]),_vm._v(" "),_c('div',{staticClass:"flex-right-block"},[(_vm.notApprovedCount)?_c('span',{staticClass:"point",domProps:{"textContent":_vm._s(_vm.notApprovedCount)}}):_vm._e(),_vm._v(" "),_c('i',{staticClass:"icon-arrow-right"})])]),_vm._v(" "),_c('div',{staticClass:"mv-invitation-record"},[_c('div',{staticClass:"head"},[_c('i',{staticClass:"icon"}),_vm._v(" "),_c('span',{domProps:{"textContent":_vm._s(_vm.teacherMsg.className)}})]),_vm._v(" "),_c('ul',{directives:[{name:"show",rawName:"v-show",value:(!_vm.nodataFlag),expression:"!nodataFlag"}],staticClass:"body"},_vm._l((_vm.stduentList),function(item,index){return _c('li',{key:index,class:{'border-bottom-1px':index!=_vm.stduentList.length-1},on:{"click":function($event){_vm.toStudentEditInfo(item)}}},[_c('div',{staticClass:"info"},[_c('i',{style:({'background-image':("url(" + (item.photoUrl?item.photoUrl:_vm.defaultImg) + ")")})}),_vm._v(" "),_c('span',{domProps:{"textContent":_vm._s(item.name)}})]),_vm._v(" "),_c('i',{staticClass:"icon-arrow-right"})])})),_vm._v(" "),_c('no-data',{directives:[{name:"show",rawName:"v-show",value:(_vm.nodataFlag),expression:"nodataFlag"}],attrs:{"noDataText":"暂无学生信息"}})],1)])}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var schoolInvitation_schoolInvitation = (esExports);
// CONCATENATED MODULE: ./src/pages/schoolInvitation/schoolInvitation.vue
function injectStyle (ssrContext) {
  __webpack_require__("f2FJ")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-4965fc90"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  schoolInvitation,
  schoolInvitation_schoolInvitation,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_schoolInvitation_schoolInvitation = __webpack_exports__["default"] = (Component.exports);


/***/ })

});