webpackJsonp([52],{

/***/ "2jL+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/vueWaterfallEasy/vue-waterfall-easy.vue + 5 modules
var vue_waterfall_easy = __webpack_require__("Gub5");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/assets/imgs/personHead2.png
var personHead2 = __webpack_require__("7G5z");
var personHead2_default = /*#__PURE__*/__webpack_require__.n(personHead2);

// EXTERNAL MODULE: ./src/assets/imgs/bg-user-delete.png
var bg_user_delete = __webpack_require__("Y8jG");
var bg_user_delete_default = /*#__PURE__*/__webpack_require__.n(bg_user_delete);

// CONCATENATED MODULE: ./src/pages/courseware/modules/courseware.js






/* harmony default export */ var courseware = ({
  methods: {
    calcNum: function calcNum(num) {
      if (num > 9999) {
        return (num / 10000).toFixed(1) + 'w';
      }
      return num;
    },

    // 瀑布流渲染完成
    preloaded: function preloaded() {
      // 停止下拉刷新
      Object(bridgeAPI["l" /* endPullDown */])();
      // loading 隐藏
      bridgeAPI["n" /* loading */].hide();
    },

    /*方法说明
      *@method 点赞
      *@param{
        i 索引
        liked 点赞状态
        likeNum 点赞数量
        id 课件内容id
      }
    */
    liked: function liked(i, _liked, likeNum, id) {
      _liked = _liked ? 0 : 1;
      _liked ? likeNum += 1 : likeNum -= 1;
      this.$set(this.imgsArr[i], 'liked', _liked);
      this.$set(this.imgsArr[i], 'likedNumber', likeNum);
      this.$http.post(api["_11" /* likeTeacherCommunityBlog */], {
        communityId: id, //用户标识，
        userId: this.teacherMsg.id, //用户标识，
        liked: _liked //0：取消点赞 1：点赞
      }).then(function (res) {
        // 无点赞成功逻辑
      });
    },

    /*方法说明
      *@method 编辑头像,看是否头像不存在
      *@param{
        headUrl 头像地址
      }
    */
    editHead: function editHead(headUrl) {
      if (headUrl) {
        return encodeURI(headUrl);
      } else {
        return personHead2_default.a;
      }
    },

    /**参数说明： 
    * 根据长度截取先使用字符串，超长部分追加… 
    * str 对象字符串 
    * len 目标字节长度 
    * label1 标签1
    * label2 标签2
    * 返回值： 处理结果字符串 
    */
    cutString: function cutString(str, len, label1, label2) {
      var label1Length = void 0,
          label2Length = void 0;
      label1Length = label1 ? label1.length * 2 + 1 : 0; //+1是#号
      label2Length = label2 ? label2.length * 2 + 1 : 0;
      len = len - label1Length - label2Length;
      //length属性读出来的汉字长度为1 
      if (str.length * 2 <= len) {
        return str;
      }
      var strlen = 0;
      var s = "";
      for (var i = 0; i < str.length; i++) {
        s = s + str.charAt(i);
        if (str.charCodeAt(i) > 128) {
          strlen = strlen + 2;
          if (strlen >= len) {
            return s.substring(0, s.length - 1) + "...";
          }
        } else {
          strlen = strlen + 1;
          if (strlen >= len) {
            return s.substring(0, s.length - 2) + "...";
          }
        }
      }
      return s;
    },

    /*方法说明
      *@method 查询当前瀑布流列表
      *@param{
        
      }
    */
    queryWaterfullList: function queryWaterfullList() {
      var _this = this;

      if (!this.currentTabId) {
        return;
      }
      this.$http.post(api["_23" /* queryAllTeacherCommunityBlog */], {
        userId: this.teacherId, //用户id
        categoryId: this.currentTabId, // 师说话题分类标识
        pageNum: this.pageNum, //页码，必须
        pageSize: this.pageSize //每页数据量，必须
      }).then(function (res) {
        _this.pageTotal = res.resData.pageTotal;
        if (res.resData.pageTotal <= _this.pageNum) {
          /*通知上拉刷新 没有数据*/
          _this.$refs.waterfall.waterfallOver();
        }
        if (!res.resData.resultList.length) {
          _this.noDataFlag = true;
          _this.imgsArr = [];
          bridgeAPI["n" /* loading */].hide();
          Object(bridgeAPI["l" /* endPullDown */])();
        } else {
          _this.noDataFlag = false;
          res.resData.resultList.forEach(function (item, i) {
            item.src = item.teacherBlogImageList ? item.teacherBlogImageList[0].imageUrl ? item.teacherBlogImageList[0].imageUrl.indexOf('?') == -1 ? item.teacherBlogImageList[0].imageUrl : item.teacherBlogImageList[0].imageUrl : bg_user_delete_default.a : bg_user_delete_default.a;
          });
          if (_this.pageNum == 1) {
            _this.imgsArr = res.resData.resultList;
          } else {
            _this.imgsArr = [].concat(_this.imgsArr, res.resData.resultList);
          }
        }
      }).catch(function (err) {
        if (!_this.imgsArr.length) {
          _this.noDataFlag = true;
        }
      });
    },

    /*方法说明
      *@method 查询tab列表
      *@param{
        
      }
    */
    queryTabList: function queryTabList() {
      var _this2 = this;

      bridgeAPI["n" /* loading */].show();
      this.$http.post(api["_61" /* queryTeacherCommunityCategory */], {}).then(function (res) {
        _this2.tabList = res.resData;
        // 将当前第一个tab标识赋值给当前taba标识存储
        if (_this2.tabList && _this2.tabList.length) {
          // 将当前的tab索引存储一下
          _this2.currentTabIndex = _this2.$route.query.index;
          _this2.currentTabId = _this2.tabList[_this2.currentTabIndex].id;
          _this2.currentTabName = _this2.tabList[_this2.currentTabIndex].categoryName;
          // 当前选中的tab标识存储并拉对应数据 
          _this2.queryWaterfullList();
        }
      }).catch(function (res) {
        bridgeAPI["n" /* loading */].hide();
        if (!_this2.imgsArr.length) {
          _this2.noDataFlag = true;
        }
      });
    },

    /*方法说明
      *@method tab切换
      *@param{
        index 当前已选择的索引
      }
    */
    tabChange: function tabChange(index) {
      // 如果当前选中的索引与当前存储的索引相等说明用户重复点击不拉取数据
      if (index == this.currentTabIndex) {
        return;
      }
      // 将当前的tab索引存储一下
      this.currentTabIndex = index;
      // 当前选中的tab标识存储并拉对应数据 
      this.currentTabId = this.tabList[index].id;
      this.currentTabName = this.tabList[index].categoryName;
      this.pageNum = 1;
      this.queryWaterfullList();
      /*通知下拉刷新结束重置*/
    },
    loadMore: function loadMore() {
      if (this.pageNum < this.pageTotal) {
        this.pageNum += 1;
        this.queryWaterfullList();
      }
    },
    clickFn: function clickFn(val) {
      var _this3 = this;

      // 详情id
      var id = val.value.id,
          imageUrl,
          videoUrl,
          approveStatus,
          approveResult,
          data,
          creatorId = val.value.creatorId;
      // 详情用户名称
      var nikeName = val.value.nickName,
          title = val.value.title,
          content = val.value.content;
      // 详情用户头像
      var userHeadImageUrl = val.value.userHeadImageUrl ? val.value.userHeadImageUrl : 'default';
      if (val.value.imageOrVideo == 2) {
        imageUrl = val.value.teacherBlogImageList[0].imageUrl;
        videoUrl = val.value.teacherBlogImageList[0].videoUrl;
        approveStatus = val.value.approveStatus;
        approveResult = val.value.approveResult;
        data = {
          title: nikeName,
          url: 'contentDetail?id=' + id,
          headPic: userHeadImageUrl,
          lessonDetail: 1,
          hasVideo: {
            imageUrl: imageUrl,
            videoUrl: videoUrl,
            approveStatus: approveStatus, // 内容审核状态，目前主要针对视频内容，0未审，1已审
            approveResult: approveResult, // 0公开，1私有，2：删除视频，3：删除视频且用户加入黑名单
            content: content ? content : '', // 内容
            contentTitle: title ? title : '', // 内容文本
            subjectId: id, // 动态id
            userHeadImg: this.teacherMsg.headImage ? this.teacherMsg.headImage : '', // 用户头像
            userId: this.teacherMsg.id, // 用户id
            actk: Object(auth["h" /* getData */])('token'), // token
            nickName: this.teacherMsg.nickName, // 用户昵称
            position: this.currentTabIndex + '-' + val.index // 当前索引 0-? 0:环境创设 1:创意手工 2:精选教案 3:我的发布 4:收藏详情
          }
        };
      } else {
        data = {
          title: nikeName,
          url: 'contentDetail?id=' + id + '&position=' + this.currentTabIndex + '-' + val.index,
          headPic: userHeadImageUrl,
          lessonDetail: 1
        };
      }
      if (creatorId != this.teacherId) {
        data.toolsWay = [{
          text: 'icon-msgList',
          type: 1,
          func: 'toReport'
        }];
      }
      if (this.clickNow) return;
      this.clickNow = true;
      setTimeout(function () {
        _this3.clickNow = false;
      }, 2000);
      Object(bridgeAPI["o" /* newWindow */])(data);
    },

    /**
     * 弹出发布窗口
     */
    showAddPopup: function showAddPopup() {
      var _this4 = this;

      Object(bridgeAPI["i" /* commonPost */])('showAddPopup').then(function (res) {
        var id = _this4.tabList[res.releaseIndex].id;
        if (res.releaseIndex == 2) {
          // 文字 教案
          Object(bridgeAPI["o" /* newWindow */])({
            title: '发布',
            url: 'teachingPlanAdd?type=' + res.releaseIndex + '&id=' + id,
            registerBack: 1,
            toolsWay: [{
              text: '完成',
              type: 2,
              func: 'teachingPlanAddFinish'
            }]
          });
        } else {
          // 图文
          Object(bridgeAPI["o" /* newWindow */])({
            title: '发布',
            url: 'coursewareAdd?type=' + res.releaseIndex + '&id=' + id,
            registerBack: 1,
            toolsWay: [{
              text: '完成',
              type: 2,
              func: 'coursewareAddFinish'
            }]
          });
        }
      }).catch(function (err) {});
    }
  },
  created: function created() {
    var _this5 = this;

    // 获取老师信息
    this.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    // 获取老师标识id
    this.teacherId = this.teacherMsg.id;
    // 获取课件分类
    this.queryTabList();
    // 下拉刷新事件
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      _this5.pageNum = 1;
      _this5.queryWaterfullList();
    });
    Object(bridgeAPI["j" /* commonRegister */])('getCoursewareRefreshIndex', function (data) {
      var iArr = data.index.split('-');
      var id = iArr[0],
          index = iArr[1];
      if (id == _this5.currentTabIndex) {
        // 说明是通知次页面刷新
        if (_this5.imgsArr[index]) {
          _this5.$set(_this5.imgsArr[index], 'liked', data.liked);
          _this5.$set(_this5.imgsArr[index], 'likedNumber', data.liked ? ++_this5.imgsArr[index].likedNumber : --_this5.imgsArr[index].likedNumber);
        }
      }
    });
    Object(bridgeAPI["j" /* commonRegister */])('changeTeacherInfo', function () {
      console.log('changeTeacherInfo');
      // 获取老师信息
      _this5.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
      // 获取老师标识id
      _this5.teacherId = _this5.teacherMsg.id;
      _this5.pageNum = 1;
      _this5.queryWaterfullList();
    });
    Object(bridgeAPI["j" /* commonRegister */])('loginSuccess', function () {
      // 获取老师信息
      _this5.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
      // 获取老师标识id
      _this5.teacherId = _this5.teacherMsg.id;
      _this5.pageNum = 1;
      _this5.queryWaterfullList();
    });
  }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/courseware/courseware.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//



/* harmony default export */ var courseware_courseware = ({
  components: {
    vueWaterfallEasy: vue_waterfall_easy["a" /* default */]
  },
  mixins: [courseware],
  data: function data() {
    return {
      tabList: [],
      imgsArr: [], // 瀑布流数组
      currentTabIndex: 0, // 当前tab栏索引
      top: 0,
      pageNum: 1, //当前请求页数
      pageSize: 10, // 当前请求每页数量
      teacherMsg: null, // 老师信息
      noDataFlag: false, // 无数据控制
      teacherId: null, // 老师id
      currentTabId: null, // 当前tab标识id
      currentTabName: '', // 当前tab名字
      pageTotal: 0,
      clickNow: false
    };
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-405cf7c0","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/courseware/courseware.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"courseware"},[_c('vue-waterfall-easy',{ref:"waterfall",attrs:{"imgs-arr":_vm.imgsArr,"noDataFlag":_vm.noDataFlag},on:{"scrollReachBottom":_vm.loadMore,"click":_vm.clickFn,"preloaded":_vm.preloaded},scopedSlots:_vm._u([{key:"waterfall-head",fn:function(props){return _c('div',{},[(props.value.imageOrVideo == 2)?_c('i',{class:{'isVideo':props.value.imageOrVideo == 2}}):_vm._e()])}},{key:"default",fn:function(props){return _c('div',{staticClass:"mv-waterfall-content"},[_c('p',{},[_vm._v("\n          "+_vm._s(_vm.cutString(props.value.title,34,props.value.topicName,props.value.classTypeName))+"\n          "),_c('span',{directives:[{name:"show",rawName:"v-show",value:(props.value.topicName),expression:"props.value.topicName"}]},[_vm._v(_vm._s('#' + props.value.topicName))]),_vm._v(" "),_c('span',{directives:[{name:"show",rawName:"v-show",value:(props.value.classTypeName),expression:"props.value.classTypeName"}]},[_vm._v(_vm._s('#' + props.value.classTypeName))])]),_vm._v(" "),_c('div',{staticClass:"mv-flex-content"},[_c('div',{staticClass:"mv-userInfo"},[_c('div',{staticClass:"mv-userHead",style:({backgroundImage:'url(' + _vm.editHead(props.value.userHeadImageUrl) + ')', backgroundRepeat:'no-repeat', backgroundPosition:'center center', backgroundSize: 'cover'})}),_vm._v(" "),_c('p',{},[_vm._v(_vm._s(_vm.cutString(props.value.nickName,12)))])]),_vm._v(" "),_c('div',{staticClass:"mv-likedInfo"},[_c('div',{staticClass:"liked",class:{'active':props.value.liked},on:{"click":function($event){$event.preventDefault();$event.stopPropagation();_vm.liked(props.index,props.value.liked,props.value.likedNumber,props.value.id
            )}}}),_vm._v(" "),_c('span',{},[_vm._v("\n              "+_vm._s(_vm.calcNum(props.value.likedNumber))+"\n            ")])])])])}}])}),_vm._v(" "),_c('div',{staticClass:"icon-courseware-add",on:{"click":_vm.showAddPopup}})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_courseware_courseware = (esExports);
// CONCATENATED MODULE: ./src/pages/courseware/courseware.vue
function injectStyle (ssrContext) {
  __webpack_require__("KjxF")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-405cf7c0"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  courseware_courseware,
  pages_courseware_courseware,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_courseware_courseware = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "KjxF":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});