webpackJsonp([53],{

/***/ "prG5":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/changeTelNum/changeTelNum.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//





/* harmony default export */ var changeTelNum = ({
	data: function data() {
		return {
			telNum: null,
			code: null,
			codeText: '获取验证码',
			codeFlag: true,
			teacherMSG: null,
			phoneNumber: null
		};
	},
	created: function created() {
		this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
		this.phoneNumber = this.teacherMSG.phoneNumber;
	},
	mounted: function mounted() {
		Object(bridgeAPI["l" /* endPullDown */])();
	},

	methods: {
		// 获取验证码
		getCode: function getCode() {
			var _this = this;

			if (this.telNum) {
				if (this.telNum == this.teacherMSG.phoneNumber) {
					Object(bridgeAPI["t" /* toast */])('不能与当前号码相同');
				} else {
					var reg = /^[1][0-9]{10}$/;
					if (reg.test(this.telNum)) {
						if (this.codeFlag) {
							this.$http.post(api["_83" /* validateTeacherPhone */], {
								id: this.teacherMSG.id,
								phoneNumber: this.telNum
							}).then(function (res) {
								var parmas = {
									projectCode: 'edus-teacher',
									phone: _this.telNum,
									smsType: 4
								};
								_this.$http.post(api["_4" /* getCodeUrl */], parmas).then(function (res) {
									Object(bridgeAPI["t" /* toast */])('验证码发送成功！');
									var count = 90;
									_this.codeText = count + '秒后重试';
									_this.codeFlag = false;
									clearInterval(timer);
									var timer = setInterval(function () {
										count--;
										if (count > 0) {
											_this.codeText = count + '秒后重试';
											_this.codeFlag = false;
										} else {
											clearInterval(timer);
											_this.codeText = '获取验证码';
											_this.codeFlag = true;
										}
									}, 1000);
								});
							}).catch(function (err) {});
						}
					} else {
						Object(bridgeAPI["t" /* toast */])('手机号格式错误');
					}
				}
			} else {
				Object(bridgeAPI["t" /* toast */])('手机号不能为空');
			}
		},

		// 确认修改
		confirm: function confirm() {
			if (!this.telNum) {
				Object(bridgeAPI["t" /* toast */])('手机号不能为空');
				return;
			}
			if (!this.code) {
				Object(bridgeAPI["t" /* toast */])("验证码不能为空");
			} else {
				var reg = /^[0-9]{6}$/;
				if (reg.test(this.code)) {
					bridgeAPI["n" /* loading */].show();
					var parmas = {
						id: this.teacherMSG.id,
						phoneNumber: this.telNum,
						verificationCode: this.code
					};
					this.$http.post(api["I" /* changeTelNum */], parmas).then(function (res) {
						bridgeAPI["n" /* loading */].hide();
						Object(auth["p" /* removeData */])('birthdayStudentList');
						Object(auth["p" /* removeData */])('deviceId');
						Object(auth["p" /* removeData */])('teacherMSG');
						Object(auth["p" /* removeData */])('token');
						Object(auth["p" /* removeData */])('userInfo');
						Object(bridgeAPI["t" /* toast */])('修改成功');
						setTimeout(function () {
							Object(bridgeAPI["g" /* closeWindow */])();
						});
						Object(bridgeAPI["i" /* commonPost */])('toLogin', {
							type: 0
						});
					}).catch(function () {});
				} else {
					Object(bridgeAPI["t" /* toast */])('验证码格式错误');
				}
			}
		}
	}
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-3c8a1884","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/changeTelNum/changeTelNum.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"changeTelNum"},[_c('div',{staticClass:"numWrap"},[_c('div',{staticClass:"numItem border-bottom-1px"},[_c('label',[_vm._v("当前手机")]),_vm._v(" "),_c('input',{directives:[{name:"model",rawName:"v-model",value:(_vm.phoneNumber),expression:"phoneNumber"}],attrs:{"readonly":""},domProps:{"value":(_vm.phoneNumber)},on:{"input":function($event){if($event.target.composing){ return; }_vm.phoneNumber=$event.target.value}}})]),_vm._v(" "),_c('div',{staticClass:"numItem border-bottom-1px"},[_c('label',[_vm._v("新手机号")]),_vm._v(" "),_c('input',{directives:[{name:"model",rawName:"v-model.trim",value:(_vm.telNum),expression:"telNum",modifiers:{"trim":true}}],attrs:{"type":"tel","maxlength":"11","placeholder":"请输入手机号"},domProps:{"value":(_vm.telNum)},on:{"input":function($event){if($event.target.composing){ return; }_vm.telNum=$event.target.value.trim()},"blur":function($event){_vm.$forceUpdate()}}})]),_vm._v(" "),_c('div',{staticClass:"numItem"},[_c('label',[_vm._v("验证码")]),_vm._v(" "),_c('input',{directives:[{name:"model",rawName:"v-model.trim",value:(_vm.code),expression:"code",modifiers:{"trim":true}}],attrs:{"type":"tel","maxlength":"6","placeholder":"请输入验证码"},domProps:{"value":(_vm.code)},on:{"input":function($event){if($event.target.composing){ return; }_vm.code=$event.target.value.trim()},"blur":function($event){_vm.$forceUpdate()}}}),_vm._v(" "),_c('span',{staticClass:"mv-msg-item-content"},[_c('div',{domProps:{"textContent":_vm._s(_vm.codeText)},on:{"click":function($event){_vm.getCode()}}})])])]),_vm._v(" "),_c('div',{staticClass:"mv-confirm-change",on:{"click":function($event){_vm.confirm()}}},[_vm._v("确认修改")])])}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var changeTelNum_changeTelNum = (esExports);
// CONCATENATED MODULE: ./src/pages/changeTelNum/changeTelNum.vue
function injectStyle (ssrContext) {
  __webpack_require__("zrdZ")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-3c8a1884"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  changeTelNum,
  changeTelNum_changeTelNum,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_changeTelNum_changeTelNum = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "zrdZ":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});