webpackJsonp([55],{

/***/ "9gjz":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "UziZ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/assets/imgs/bg-user-delete.png
var bg_user_delete = __webpack_require__("Y8jG");
var bg_user_delete_default = /*#__PURE__*/__webpack_require__.n(bg_user_delete);

// CONCATENATED MODULE: ./src/pages/myCollect/modules/myCollect.js




/* harmony default export */ var myCollect = ({
  methods: {
    toCollectDetail: function toCollectDetail(id, name) {
      Object(bridgeAPI["o" /* newWindow */])({
        title: name,
        url: 'collectDetail?folderName=' + encodeURI(name) + '&id=' + id,
        toolsWay: [{
          text: '选择',
          type: 2,
          func: 'collectChoose'
        }],
        pullDown: true
      });
    },

    /**
     * 删除收藏夹
     * @param {*} id 收藏夹id
     */
    deleteCollect: function deleteCollect(id) {
      var _this = this;

      bridgeAPI["n" /* loading */].show();
      this.$http.post(api["R" /* deleteCollectFolder */], {
        id: id, // 收藏夹id
        userId: this.teacherId, // 用户id
        userType: "teacher" //用户类型，teacher,parent
      }).then(function (res) {
        bridgeAPI["n" /* loading */].hide();
        _this.queryCollectList();
      });
    },

    /**
     * 更新收藏夹
     * @param {*} id 收藏夹标识
     * @param {*} name 收藏夹名称
     */
    updateCollect: function updateCollect(id, name) {
      var _this2 = this;

      bridgeAPI["n" /* loading */].show();
      this.$http.post(api["_79" /* updateCollectFolder */], {
        id: id, // 收藏夹id
        userId: this.teacherId, // 用户id
        userType: "teacher", //用户类型，teacher,parent
        folderName: name //收藏夹名称
      }).then(function (res) {
        // 修改成功,重新拉取页面数据
        bridgeAPI["n" /* loading */].hide();
        _this2.queryCollectList();
      });
    },

    /**
     * 弹出actionsheet
     * @param {*} id 收藏夹标识
     * @param {*} defaultFolder 是否是默认收藏夹
     * @param {*} folderName 收藏夹名称
     */
    showActionSheet: function showActionSheet(id, defaultFolder, folderName) {
      var _this3 = this;

      // 如果是默认收藏夹
      if (!+defaultFolder) {
        return;
      }
      Object(bridgeAPI["a" /* actionSheet */])({
        btns: ['重命名', '删除']
      }).then(function (index) {
        if (index == 0) {
          // 重命名
          Object(bridgeAPI["i" /* commonPost */])('showCollect', {
            style: 2,
            name: folderName
          }).then(function (res) {
            _this3.updateCollect(id, res.name);
          }).catch(function (err) {});
        } else if (index == 1) {
          // 删除
          _this3.deleteCollect(id);
        }
      });
    },

    /*方法说明
      *@method 创建收藏夹
      *@param{
        
      }
    */
    addCollect: function addCollect() {
      var _this4 = this;

      Object(bridgeAPI["i" /* commonPost */])('showCollect', {
        style: 2,
        name: ''
      }).then(function (res) {
        bridgeAPI["n" /* loading */].show();
        _this4.$http.post(api["c" /* addCollectFolder */], {
          userId: _this4.teacherId, // 用户id
          userType: "teacher", //用户类型，teacher,parent
          folderName: res.name //收藏夹名称
        }).then(function (res) {
          bridgeAPI["n" /* loading */].hide();
          _this4.queryCollectList();
        });
      }).catch(function (err) {});
    },

    /*方法说明
      *@method 查询收藏列表
      *@param{
        
      }
    */
    queryCollectList: function queryCollectList() {
      var _this5 = this;

      var data = {
        userId: this.teacherId, // 用户id
        userType: "teacher" //用户类型，teacher,parent
      };
      this.$http.post(api["_36" /* queryCollectList */], data).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        _this5.collectList = res.resData;
        _this5.collectList.forEach(function (item, index) {
          if (item.imageUrlList && item.imageUrlList.length) {
            item.imageUrlList.forEach(function (img, i) {
              var imgObj = new Image();
              imgObj.src = img;
              imgObj.onload = function () {
                _this5.$set(item.imageUrlList, i, img);
              };
              imgObj.onerror = function () {
                _this5.$set(item.imageUrlList, i, bg_user_delete_default.a);
              };
            });
          }
        });
      }).catch(function (err) {});
    }
  },
  created: function created() {
    var _this6 = this;

    this.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    this.teacherId = this.teacherMsg.id;
    // 请求收藏夹数据
    this.queryCollectList();
    // 注册开始下拉刷新
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      _this6.queryCollectList();
    });
  }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/myCollect/myCollect.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

// import listComponents from "@/components/listComponents/listComponents";

// const deleteIcon = require("../../assets/imgs/deleteBlue.png")
/* harmony default export */ var myCollect_myCollect = ({
  mixins: [myCollect],
  data: function data() {
    return {
      collectList: [],
      teacherMsg: null, // 老师信息
      noDataFlag: false, // 无数据控制
      teacherId: null, // 老师id
      noMoreFlag: false,
      queryDataLoading: false
    };
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-36bfca63","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/myCollect/myCollect.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"myCollect"},[_c('div',{staticClass:"mv-add-collect",on:{"click":_vm.addCollect}},[_vm._m(0),_vm._v(" "),_c('i',{staticClass:"icon-arrow-right"})]),_vm._v(" "),_vm._l((_vm.collectList),function(item){return _c('v-touch',{key:item.id,staticClass:"mv-item-collect",on:{"press":function($event){_vm.showActionSheet(item.id,item.defaultFolder,item.folderName)},"tap":function($event){_vm.toCollectDetail(item.id,item.folderName)}}},[_c('div',{staticClass:"mv-collect-title"},[_vm._v(_vm._s(item.folderName))]),_vm._v(" "),_c('ul',{staticClass:"mv-collect-imgList"},[(!item.imageUrlList)?_c('li',{staticClass:"no-more-pic"}):_vm._e(),_vm._v(" "),_vm._l((item.imageUrlList),function(img){return _c('li',{key:img,style:({backgroundImage:'url(' + img + ')'})})})],2)])})],2)}
var staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-add-title"},[_c('i',{staticClass:"icon-collect-add"}),_vm._v(" "),_c('span',[_vm._v("创建新的收藏夹")])])}]
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_myCollect_myCollect = (esExports);
// CONCATENATED MODULE: ./src/pages/myCollect/myCollect.vue
function injectStyle (ssrContext) {
  __webpack_require__("9gjz")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-36bfca63"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  myCollect_myCollect,
  pages_myCollect_myCollect,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_myCollect_myCollect = __webpack_exports__["default"] = (Component.exports);


/***/ })

});