webpackJsonp([56],{

/***/ "PRD7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/noData/noData.vue + 2 modules
var noData = __webpack_require__("ycV+");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/assets/imgs/babyHead.png
var babyHead = __webpack_require__("mX+a");
var babyHead_default = /*#__PURE__*/__webpack_require__.n(babyHead);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/schoolApply/schoolApply.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//






/* harmony default export */ var schoolApply = ({
  components: {
    noData: noData["a" /* default */]
  },
  data: function data() {
    return {
      teacherMSG: null, // 老师信息
      applyList: [], // 申请列表
      defaultImg: babyHead_default.a, //小孩默认头像
      nodataFlag: false // 无数据显示状态
    };
  },
  created: function created() {
    var _this = this;

    // 获取老师信息
    this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    // 注册下拉刷新
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      // 获取申请列表
      _this.queryApplyList();
    });
    // 获取申请列表
    this.queryApplyList();
  },
  mounted: function mounted() {},

  filters: {
    filterIdCard: function filterIdCard(idcard) {
      return idcard.replace(/(\d{1})\d{16}(\d{1})/, "$1****************$2");
    }
  },
  methods: {
    /**
     * 查看宝贝人脸
     */
    showBabyFace: function showBabyFace(face) {
      Object(bridgeAPI["m" /* getMedia */])("showImages", {
        index: 0,
        content: "",
        images: face,
        deleteFlag: false
      });
    },

    /**
     * 循环匹配关系
     */
    switchRelation: function switchRelation(type) {
      //主监护人关系类型，0：爸爸，1：妈妈，2：爷爷，3：奶奶，4：外公，5：外婆
      var res = '';
      switch (type) {
        case 0:
          res = '爸爸';
          break;
        case 1:
          res = '妈妈';
          break;
        case 2:
          res = '爷爷';
          break;
        case 3:
          res = '奶奶';
          break;
        case 4:
          res = '外公';
          break;
        case 5:
          res = '外婆';
          break;
        case 8:
          res = '其他';
          break;
        default:
          res = '其他';
      }
      return res;
    },

    /**
     * 通过
     */
    confirm: function confirm(item) {
      var _this2 = this;

      Object(bridgeAPI["k" /* dialog */])({
        title: '提示',
        message: '确认将该幼儿加入班级？'
      }).then(function (result) {
        bridgeAPI["n" /* loading */].show();
        _this2.$http.post(api["y" /* approveStudentApplication */], {
          "id": item.id, //学生标识
          "teacherId": _this2.teacherMSG.id, //老师id
          "approveStatus": 2, //2 通过 9 拒绝
          "schoolId": _this2.teacherMSG.schoolId, //校园id
          "classId": _this2.teacherMSG.classId, //班级标识
          "phoneNumber": item.phoneNumber //手机号
        }).then(function (res) {
          bridgeAPI["n" /* loading */].hide();
          // 重新获取申请列表
          _this2.queryApplyList();
          // 通知上个页面刷新
          Object(bridgeAPI["h" /* commonMsg */])({
            call: 'updateStudentList'
          });
        }).catch(function (err) {
          bridgeAPI["n" /* loading */].hide();
        });
      }).catch(function () {});
    },

    /**
     * 拒绝
     */
    cancel: function cancel(item) {
      var _this3 = this;

      Object(bridgeAPI["i" /* commonPost */])('popupCancel', {}).then(function (res) {
        bridgeAPI["n" /* loading */].show();
        _this3.$http.post(api["y" /* approveStudentApplication */], {
          "id": item.id, //学生标识
          "teacherId": _this3.teacherMSG.id, //老师id
          "approveStatus": 9, //2 通过 9 拒绝
          "schoolId": _this3.teacherMSG.schoolId, // 校园id
          "classId": _this3.teacherMSG.classId, // 班级标识
          "approveChoose": res.index, // 审核项 0 学生已入园，1 不属于该班级， 2 其他
          "remark": res.reason, // 拒绝理由
          "phoneNumber": item.phoneNumber //手机号
        }).then(function (result) {
          bridgeAPI["n" /* loading */].hide();
          // 重新获取申请列表
          _this3.queryApplyList();
          // 通知上个页面刷新
          Object(bridgeAPI["h" /* commonMsg */])({
            call: 'updateStudentList'
          });
        }).catch(function (err) {});
      });
    },

    /**
     * 查询申请列表
     */
    queryApplyList: function queryApplyList() {
      var _this4 = this;

      this.$http.post(api["_28" /* queryClassApplications */], {
        classId: this.teacherMSG.classId
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        if (res.resData && res.resData.length) {
          _this4.applyList = res.resData;
          _this4.nodataFlag = false;
        } else {
          _this4.nodataFlag = true;
        }
      }).catch(function (err) {
        Object(bridgeAPI["l" /* endPullDown */])();
      });
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-30983b58","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/schoolApply/schoolApply.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"schoolApply"},[_c('ul',{directives:[{name:"show",rawName:"v-show",value:(!_vm.nodataFlag),expression:"!nodataFlag"}],staticClass:"mv-list"},_vm._l((_vm.applyList),function(item,index){return _c('li',{key:item.id},[_c('div',{staticClass:"state",class:{'confirm':item.approveStatus == 2,'cancel':item.approveStatus==9}}),_vm._v(" "),_c('div',{staticClass:"babyHead"},[_c('div',{staticClass:"headBorder"},[_c('i',{staticClass:"head",style:({'background-image':("url(" + (item.photoUrl?item.photoUrl:_vm.defaultImg) + ")")})}),_vm._v(" "),_c('i',{staticClass:"sex",class:{'female':item.sex,'male':!item.sex}})]),_vm._v(" "),_c('span',{staticClass:"name",domProps:{"textContent":_vm._s(item.name)}})]),_vm._v(" "),_c('ul',{staticClass:"babyInfo"},[(item.birthday || item.identityCard)?_c('li',[(item.birthday)?_c('div',[_c('span',{staticClass:"key"},[_vm._v("出生日期：")]),_vm._v(" "),_c('span',{staticClass:"value",domProps:{"textContent":_vm._s(item.birthday)}})]):_vm._e(),_vm._v(" "),(item.identityCard)?_c('div',[_c('span',{staticClass:"key"},[_vm._v("身份证号码：")]),_vm._v(" "),_c('span',{staticClass:"value"},[_vm._v(_vm._s(_vm._f("filterIdCard")(item.identityCard)))])]):_vm._e()]):_vm._e(),_vm._v(" "),_c('li',[_c('div',[_c('span',{staticClass:"key"},[_vm._v("申请人：")]),_vm._v(" "),_c('span',{staticClass:"value"},[_vm._v(_vm._s(_vm.switchRelation(item.relationType)))])]),_vm._v(" "),_c('div',[_c('span',{staticClass:"key"},[_vm._v("手机号：")]),_vm._v(" "),_c('span',{staticClass:"value",domProps:{"textContent":_vm._s(item.phoneNumber)}})])])]),_vm._v(" "),_c('div',{directives:[{name:"show",rawName:"v-show",value:(item.approveStatus != 1),expression:"item.approveStatus != 1"}],staticClass:"reviewInfo"},[_c('div',{},[_vm._v("\n          审核人："+_vm._s(item.approverName)+"\n        ")]),_vm._v(" "),_c('div',{},[_vm._v("\n          审核时间："+_vm._s(item.approveTime)+"\n        ")]),_vm._v(" "),(item.approveStatus == 9 && item.remark)?_c('div',{},[_vm._v("\n          拒绝理由："+_vm._s(item.remark)+"\n        ")]):_vm._e()]),_vm._v(" "),_c('div',{directives:[{name:"show",rawName:"v-show",value:(item.approveStatus == 1),expression:"item.approveStatus == 1"}],staticClass:"reviewBtn"},[_c('span',{staticClass:"cancel",on:{"click":function($event){_vm.cancel(item)}}},[_vm._v("拒绝")]),_vm._v(" "),_c('span',{staticClass:"confirm",on:{"click":function($event){_vm.confirm(item)}}},[_vm._v("通过")])])])})),_vm._v(" "),_c('no-data',{directives:[{name:"show",rawName:"v-show",value:(_vm.nodataFlag),expression:"nodataFlag"}],attrs:{"noDataText":"暂无入园申请"}})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var schoolApply_schoolApply = (esExports);
// CONCATENATED MODULE: ./src/pages/schoolApply/schoolApply.vue
function injectStyle (ssrContext) {
  __webpack_require__("hOzZ")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-30983b58"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  schoolApply,
  schoolApply_schoolApply,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_schoolApply_schoolApply = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "hOzZ":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});