webpackJsonp([57],{

/***/ "659Z":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/listComponents/listComponents.vue + 5 modules
var listComponents = __webpack_require__("JKqx");

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__("bOdI");
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: ./node_modules/vue-lazyload/vue-lazyload.js
var vue_lazyload = __webpack_require__("cTzj");
var vue_lazyload_default = /*#__PURE__*/__webpack_require__.n(vue_lazyload);

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// CONCATENATED MODULE: ./src/pages/childTask/modules/childTask.js




Vue.use(vue_lazyload_default.a, defineProperty_default()({
	preLoad: 2,
	attempt: 3
}, "preLoad", 10));


var defaultImg = __webpack_require__("ScjG");
/* harmony default export */ var childTask = ({
	mounted: function mounted() {
		this.getTaskList();
	},
	beforeCreate: function beforeCreate() {
		this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
	},
	created: function created() {
		var _this = this;

		// 监听点击新增按钮
		Object(bridgeAPI["d" /* buryingPoint */])('BJ_10000_003_01');
		Object(bridgeAPI["j" /* commonRegister */])('addChildTask', function () {
			Object(bridgeAPI["o" /* newWindow */])({
				title: '新增亲子互动',
				url: 'releaseTask',
				toolsWay: [{
					text: '发表', // 文字按钮
					type: 2, // 文字按钮类型
					func: 'send' // 点击时call方法名
				}]
			});
		});
		// 监听任务发布成功
		Object(bridgeAPI["j" /* commonRegister */])('reloadPage', function () {
			_this.pageNum = 1;
			_this.getTaskList();
		});
		// 下拉刷新
		Object(bridgeAPI["c" /* beginPullDown */])(function () {
			_this.pageNum = 1;
			_this.getTaskList();
		});
	},

	methods: {
		// 点击跳转任务详情
		tapLi: function tapLi(id) {
			Object(bridgeAPI["o" /* newWindow */])({
				title: '任务详情',
				url: 'taskDetail?id=' + id
			});
		},

		// 长按操作
		gTouch: function gTouch(item, i) {
			var _this2 = this;

			Object(bridgeAPI["a" /* actionSheet */])({ btns: ['删除'] }).then(function (index) {
				if (index == 0) {
					var params = {
						id: item.id
					};
					_this2.$http.post(api["Q" /* deleteClassTask */], params).then(function (res) {
						Object(bridgeAPI["t" /* toast */])("删除成功");
						_this2.childTaskList.splice(i, 1);
					});
				}
			});
		},
		comfirmImgUrl: function comfirmImgUrl(taskImages) {
			if (taskImages && taskImages.length) {
				return Object(auth["b" /* commonCutImg */])(taskImages[0].imageUrl, {
					width: 150,
					height: 150
				});
			} else {
				return defaultImg;
			}
		},
		loadMore: function loadMore() {
			this.pageNum = this.pageNum + 1;
			this.queryDataLoading = true;
			this.getTaskList();
		},
		changeTime: function changeTime(time, reg) {
			if (time && time.indexOf('.') == -1) {
				var date = new Date(time.replace(/-/g, "/"));
				return Object(auth["e" /* formatDate */])(date, reg);
			}
		},
		getTaskList: function getTaskList() {
			var _this3 = this;

			this.$http.post(api["_33" /* queryClassTask */], {
				classId: this.teacherMSG.classId,
				pageNum: this.pageNum,
				pageSize: this.pageSize
			}).then(function (res) {
				// 结束上下拉刷新
				Object(bridgeAPI["l" /* endPullDown */])();
				if (res.resData.pageTotal <= _this3.pageNum) {
					// 显示noMore字样
					_this3.queryDataLoading = true;
					_this3.noMoreFlag = true;
				} else {
					//noMore字样跟加载圈都不现实,可以出发上拉刷新
					_this3.queryDataLoading = false;
					_this3.noMoreFlag = false;
				}
				if (_this3.pageNum == 1) {
					if (res.resData.resultList.length == 0) {
						_this3.noDataFlag = true;
					} else {
						_this3.childTaskList = res.resData.resultList;
					}
				} else {
					_this3.childTaskList = _this3.childTaskList.concat(res.resData.resultList);
				}
				_this3.messageRead();
			});
		},

		//初始进来置消息已读
		messageRead: function messageRead() {
			var data = {
				subjectTypeList: [4]
			};
			this.$http.post(api["_75" /* setMessageRead */], data).then(function (res) {
				// 通知原生消除红点
				Object(bridgeAPI["h" /* commonMsg */])({
					call: 'clearTaskRedPoint'
				});
			});
		}
	}
});
// EXTERNAL MODULE: ./node_modules/vue-touch/dist/vue-touch.js
var vue_touch = __webpack_require__("I0MY");
var vue_touch_default = /*#__PURE__*/__webpack_require__.n(vue_touch);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/childTask/childTask.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//





/* harmony default export */ var childTask_childTask = ({
  mixins: [childTask],
  data: function data() {
    return {
      pageNum: 1,
      pageSize: 10,
      pageTotal: 0,
      noDataFlag: false,
      noMoreFlag: false,
      childTaskList: [],
      queryDataLoading: false
    };
  },

  components: { listComponents: listComponents["a" /* default */] }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-2f8819a0","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/childTask/childTask.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-task-body"},[_c('list-components',{attrs:{"listPadDomClass":"mv-tasks","listData":_vm.childTaskList,"noData":"暂无亲子任务","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"queryDataLoading":_vm.queryDataLoading},on:{"loadMore":_vm.loadMore},scopedSlots:_vm._u([{key:"default",fn:function(slotProps){return _c('v-touch',{attrs:{"tag":"div"},on:{"tap":function($event){_vm.tapLi(slotProps.item.id)},"press":function($event){_vm.gTouch(slotProps.item, slotProps.index)}}},[_c('div',{staticClass:"mv-task-item"},[_c('div',{staticClass:"mv-item-pic"},[_c('span',{directives:[{name:"lazy",rawName:"v-lazy:background-image",value:(_vm.comfirmImgUrl(slotProps.item.taskImages)),expression:"comfirmImgUrl(slotProps.item.taskImages)",arg:"background-image"}],staticClass:"taskImages"})]),_vm._v(" "),_c('div',{staticClass:"mv-task-content"},[_c('div',{staticClass:"taskListTitle"},[_c('pre',{},[_vm._v(_vm._s(slotProps.item.title))])]),_vm._v(" "),_c('div',{staticClass:"taskListTime"},[_vm._v("时间要求："+_vm._s(_vm.changeTime(slotProps.item.beginTime, 'MM.dd') + '-' + _vm.changeTime(slotProps.item.endTime, 'MM.dd')))]),_vm._v(" "),_c('div',{staticClass:"taskListFooter"},[_c('span',{},[_vm._v(_vm._s(slotProps.item.completeNum ? "已经完成" + slotProps.item.completeNum + "人": "还没有人完成互动哦"))])])])])])}}])})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_childTask_childTask = (esExports);
// CONCATENATED MODULE: ./src/pages/childTask/childTask.vue
function injectStyle (ssrContext) {
  __webpack_require__("OhLD")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-2f8819a0"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  childTask_childTask,
  pages_childTask_childTask,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_childTask_childTask = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "OhLD":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});