webpackJsonp([58],{

/***/ "0hlm":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/billList/billList.vue + 2 modules
var billList = __webpack_require__("FiUT");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/searchBill/searchBill.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//





/* harmony default export */ var searchBill = ({
  components: {
    billList: billList["a" /* default */]
  },
  data: function data() {
    return {
      noDataFlag: false,
      noMoreFlag: false,
      queryDataLoading: false,
      billList: [], // 账单列表
      defaultShow: false, // 默认不展示
      teacherMSG: null, // 老师信息
      billId: '' // 账单id
    };
  },
  created: function created() {
    var _this = this;

    this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    this.billId = this.$route.query.billId;
    Object(bridgeAPI["j" /* commonRegister */])('billSearch', function (data) {
      // toast(data.searchText);
      _this.queryHistoryBillList(data.searchText);
    });
  },
  mounted: function mounted() {
    Object(bridgeAPI["l" /* endPullDown */])();
  },

  methods: {
    /**
     * 查询历史列表
     */
    queryHistoryBillList: function queryHistoryBillList(studentName) {
      var _this2 = this;

      this.$http.post(api["_51" /* queryPaymentByPage */], {
        "classId": this.teacherMSG.classId, // 班级标识
        "pageNum": 1, // 页码，必须
        "pageSize": 999, // 每页数据量，必须
        "studentName": studentName, // 学生姓名
        "billId": this.billId
      }).then(function (res) {
        _this2.defaultShow = true;
        if (res.resData.resultList.length == 0) {
          _this2.noDataFlag = true;
          _this2.billList = [];
        } else {
          _this2.billList = res.resData.resultList;
        }
      });
    },

    /**
     * 展开收起动画
     */
    toggle: function toggle(data) {
      var _this3 = this;

      if (!this.billList[data.i].showFlag) {
        this.billList.forEach(function (item, index) {
          _this3.$set(_this3.billList[index], 'showFlag', false);
        });
      }
      this.$set(this.billList[data.i], 'showFlag', !this.billList[data.i].showFlag);
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-2edc4be7","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/searchBill/searchBill.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"searchBill"},[_c('bill-list',{directives:[{name:"show",rawName:"v-show",value:(_vm.defaultShow),expression:"defaultShow"}],attrs:{"listData":_vm.billList,"noData":"无查询到学生信息","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"queryDataLoading":_vm.queryDataLoading},on:{"toggle":_vm.toggle}})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var searchBill_searchBill = (esExports);
// CONCATENATED MODULE: ./src/pages/searchBill/searchBill.vue
function injectStyle (ssrContext) {
  __webpack_require__("Djro")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-2edc4be7"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  searchBill,
  searchBill_searchBill,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_searchBill_searchBill = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "Djro":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});