webpackJsonp([62],{

/***/ "kIMK":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__("d7EF");
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// EXTERNAL MODULE: ./src/components/listComponents/listComponents.vue + 5 modules
var listComponents = __webpack_require__("JKqx");

// EXTERNAL MODULE: ./src/components/imgList/imgList.vue + 2 modules
var imgList = __webpack_require__("DVP0");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/feedbackList/feedbackList.vue

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//






/* harmony default export */ var feedbackList = ({
  name: "feedbackList",
  data: function data() {
    return {
      feedbackList: [],
      pageNum: 1,
      pageSize: 10,
      pageTotal: 0,
      noDataFlag: false,
      noMoreFlag: false,
      queryDataLoading: false
    };
  },

  components: {
    listComponents: listComponents["a" /* default */],
    imgList: imgList["a" /* default */]
  },
  created: function created() {
    var _this = this;

    /*注册下拉刷新回调*/
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      _this.pageNum = 1;
      _this.queryFeedbackList();
    });
    Object(bridgeAPI["j" /* commonRegister */])("advicePoint", function () {
      _this.queryFeedbackList();
    });
  },
  mounted: function mounted() {
    // 查询意见回复列表
    this.queryFeedbackList();
  },

  methods: {
    // 格式化时间
    formatTime: function formatTime(time) {
      var timeArr = time.split(" "),
          year,
          hour,
          min,
          formated;
      timeArr[1] = timeArr[1].split(":");

      var _timeArr = slicedToArray_default()(timeArr, 2);

      year = _timeArr[0];

      var _timeArr$ = slicedToArray_default()(_timeArr[1], 2);

      hour = _timeArr$[0];
      min = _timeArr$[1];

      formated = year + " " + hour + ":" + min;
      return formated;
    },

    // 清除已读
    setRead: function setRead() {
      var _this2 = this;

      this.$http.post(api["_75" /* setMessageRead */], {
        subjectTypeList: [8]
      }).then(function () {
        Object(bridgeAPI["h" /* commonMsg */])({
          call: "clearAdvicePointH5"
        });
        Object(bridgeAPI["h" /* commonMsg */])({
          call: 'updateMsgCenter',
          data: {
            subjectType: _this2.$route.query.subjectType
          }
        });
        Object(bridgeAPI["h" /* commonMsg */])({
          call: 'refreshMsgPoint',
          data: {
            subjectType: _this2.$route.query.subjectType
          }
        });
      });
    },
    loadMore: function loadMore() {
      this.pageNum = this.pageNum + 1;
      this.queryDataLoading = true;
      this.queryFeedbackList();
    },
    queryFeedbackList: function queryFeedbackList() {
      var _this3 = this;

      this.$http.post(api["_52" /* queryReplySuggestion */], {
        pageNum: this.pageNum,
        pageSize: this.pageSize
      }).then(function (res) {
        // 结束上下拉刷新
        Object(bridgeAPI["l" /* endPullDown */])();
        if (res.resData.pageTotal == _this3.pageNum) {
          // 显示noMore字样
          _this3.queryDataLoading = true;
          _this3.noMoreFlag = true;
        } else {
          //noMore字样跟加载圈都不现实
          _this3.queryDataLoading = false;
          _this3.noMoreFlag = false;
        }
        if (_this3.pageNum == 1) {
          if (res.resData.resultList.length == 0) {
            _this3.noDataFlag = true;
          } else {
            _this3.feedbackList = res.resData.resultList;
          }
        } else {
          _this3.feedbackList = _this3.feedbackList.concat(res.resData.resultList);
        }
        _this3.setRead();
      });
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-2bd6cc72","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/feedbackList/feedbackList.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-feedbackList"},[_c('list-components',{attrs:{"queryDataLoading":_vm.queryDataLoading,"listData":_vm.feedbackList,"noData":"暂无回复~","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag},on:{"loadMore":_vm.loadMore},scopedSlots:_vm._u([{key:"default",fn:function(slotProps){return _c('div',{staticClass:"mv-feedback-item border-bottom-1px"},[_c('div',{staticClass:"mv-feedback-time",domProps:{"textContent":_vm._s(_vm.formatTime(slotProps.item.createTime))}}),_vm._v(" "),_c('div',{staticClass:"mv-feedback-content"},[_c('span',{staticClass:"mv-feedback-name"},[_vm._v("小主:")]),_vm._v(" "),_c('span',{staticClass:"mv-feedback-text",domProps:{"textContent":_vm._s(slotProps.item.suggestionContent)}})]),_vm._v(" "),(slotProps.item.images)?_c('img-list',{class:{'mv-img-list' : slotProps.item.images.length},attrs:{"imgArr":slotProps.item.images}}):_vm._e(),_vm._v(" "),_c('div',{staticClass:"mv-reply-time",domProps:{"textContent":_vm._s(_vm.formatTime(slotProps.item.updateTime))}}),_vm._v(" "),_c('div',{staticClass:"mv-reply-content"},[_c('span',{staticClass:"mv-reply-name"},[_vm._v("客服:")]),_vm._v(" "),_c('span',{staticClass:"mv-reply-text mv-text",domProps:{"textContent":_vm._s(slotProps.item.remark)}})])],1)}}])})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var feedbackList_feedbackList = (esExports);
// CONCATENATED MODULE: ./src/pages/feedbackList/feedbackList.vue
function injectStyle (ssrContext) {
  __webpack_require__("vdQL")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-2bd6cc72"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  feedbackList,
  feedbackList_feedbackList,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_feedbackList_feedbackList = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "vdQL":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});