webpackJsonp([67],{

/***/ "81T/":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/babyOnline/babyOnline.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//




/* harmony default export */ var babyOnline = ({
  data: function data() {
    return {
      ApplyList: [],
      classId: "", // 班级id
      className: "", // 班级名字
      existCamera: 0, // 是否存在摄像头，0表示不存在摄像头，1表示存在摄像头
      watchOnLineCount: 0, // 视频观看在线人数
      isOpen: null, // 是否开通
      teacherMSG: {},
      babyOnlineApplyLimit: "班级申请人数大于10人时候,宝贝所在班级将会开通宝贝视频在线"
    };
  },
  created: function created() {
    var _this = this;

    var teacherMSG = JSON.parse(Object(auth["h" /* getData */])("teacherMSG"));
    this.classId = teacherMSG.classId;
    this.className = teacherMSG.className;
    this.teacherMSG = teacherMSG;
    this.querySchoolConfigValueByKey();
    this.queryOnlineCount(); // 获取该班是否有开通视频服务以及正在该班正在观看的人数
    // 宝贝在线
    Object(bridgeAPI["d" /* buryingPoint */])('BJ_10000_004');
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      _this.queryOnlineCount();
    });
  },

  methods: {
    // 查询在线人数
    queryOnlineCount: function queryOnlineCount() {
      var _this2 = this;

      this.$http.post(api["_24" /* queryBabyOnlineCount */], {
        classId: this.classId
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        _this2.existCamera = Number(res.resData.existCamera);
        _this2.watchOnLineCount = Number(res.resData.watchOnLineCount);
        if (!_this2.existCamera) {
          // 当前未开通的时候
          _this2.isOpen = false;
          _this2.getApplyListFn();
        } else {
          // 当前开通的时候
          _this2.isOpen = true;
        }
      });
    },
    querySchoolConfigValueByKey: function querySchoolConfigValueByKey() {
      var _this3 = this;

      this.$http.post(api["_44" /* queryKey */], {
        orgId: this.teacherMSG.schoolId, //家长标识
        configNameList: ["babyOnlineApplyLimit"]
      }).then(function (res) {
        _this3.babyOnlineApplyLimit = res.resData.babyOnlineApplyLimit ? res.resData.babyOnlineApplyLimit : "班级申请人数大于10人时候,宝贝所在班级将会开通宝贝视频在线";
      });
    },
    getApplyListFn: function getApplyListFn() {
      var _this4 = this;

      this.$http.post(api["_25" /* queryBabyonlineApply */], {
        classId: this.classId
      }).then(function (res) {
        _this4.ApplyList = res.resData;
        Object(bridgeAPI["t" /* toast */])("欢迎您的加入，敬请期待~~~");
      });
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-1c843c56","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/babyOnline/babyOnline.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"classOnline",attrs:{"id":"classOnline"}},[_c('section',{staticClass:"mv-edit-banner"},[(!_vm.isOpen && _vm.isOpen !== null)?_c('div',{staticClass:"mv-bannerFoot"},[_vm._v(_vm._s(_vm.babyOnlineApplyLimit))]):_vm._e(),_vm._v(" "),(_vm.isOpen)?_c('div',{staticClass:"hasClass"},[_c('i',{staticClass:"icon-classFlag"}),_vm._v(" "),_c('span',{},[_vm._v(_vm._s(_vm.className))])]):_vm._e()]),_vm._v(" "),(!_vm.isOpen &&  _vm.isOpen !== null)?_c('div',{staticClass:"mv-uncomputed"},[(_vm.ApplyList.length)?_c('div',{staticClass:"applyLength"},[_vm._v(_vm._s(_vm.ApplyList.length ? _vm.ApplyList.length +'人申请开通宝贝在线' : '暂时还没有宝宝申请哦~'))]):_vm._e()]):_vm._e(),_vm._v(" "),(_vm.isOpen)?_c('div',{staticClass:"mv-watchNumber"},[_c('div',{staticClass:"mv-watchNumberBg"}),_vm._v(" "),_c('span',{class:{'onlineColor':_vm.watchOnLineCount}},[_vm._v("\n      "+_vm._s(_vm.watchOnLineCount ? '本摄像头目前在线人数' + _vm.watchOnLineCount +
      '人' : '本摄像头目前空闲中...')+"\n    ")])]):_vm._e()])}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var babyOnline_babyOnline = (esExports);
// CONCATENATED MODULE: ./src/pages/babyOnline/babyOnline.vue
function injectStyle (ssrContext) {
  __webpack_require__("tVJL")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-1c843c56"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  babyOnline,
  babyOnline_babyOnline,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var pages_babyOnline_babyOnline = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "tVJL":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});