webpackJsonp([71],{

/***/ "9baS":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/listComponents/listComponents.vue + 5 modules
var listComponents = __webpack_require__("JKqx");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./src/pages/babyLeaveRecord/modules/babyLeaveRecord.js



var personHead = __webpack_require__("mX+a");
/* harmony default export */ var babyLeaveRecord = ({
  methods: {
    reported: function reported(item) {
      if (item.seenEnable == 1) return;
      this.$http.post(api["O" /* confirmLeaveApply */], {
        id: item.id
      }).then(function (res) {
        item.seenEnable = 1;
      });
    },

    /*方法说明
      *@method 判断头像
      *@param{
        url  头像地址
      }
    */
    judgeUrl: function judgeUrl(url) {
      return url ? url : personHead;
    },

    // 加载更多
    loadMore: function loadMore() {
      this.pageNum = this.pageNum + 1;
      this.queryDataLoading = true;
      this.queryLeaveRecord();
    },

    /*方法说明
      *@method 匹配类型
      *@param{
        type  0：事假，1：病假，2：其它
      }
    */
    matchType: function matchType(type) {
      var typeText;
      switch (type) {
        case 0:
          typeText = '事假';
          break;
        case 1:
          typeText = '病假';
          break;
        case 2:
          typeText = '其它';
          break;
      }
      return typeText;
    },

    /**
     * 查询请假记录
     * 
     */
    queryLeaveRecord: function queryLeaveRecord() {
      var _this = this;

      this.$http.post(api["_58" /* queryStudentLeaveApplyList */], {
        classId: this.teacherMsg.classId, // 教师标识
        pageNum: this.pageNum, //页码，必须
        pageSize: 10 //每页数据量，必须。按照创建时间降序排序
      }).then(function (res) {
        Object(bridgeAPI["l" /* endPullDown */])();
        if (res.resData.pageTotal <= _this.pageNum) {
          // 显示noMore字样
          _this.queryDataLoading = true;
          _this.noMoreFlag = true;
        } else {
          //noMore字样跟加载圈都不现实,可以出发上拉刷新
          _this.queryDataLoading = false;
          _this.noMoreFlag = false;
        }
        if (_this.pageNum == 1) {
          if (res.resData.resultList.length == 0) {
            _this.noDataFlag = true;
          } else {
            _this.leaveRecordList = res.resData.resultList;
          }
        } else {
          _this.leaveRecordList = _this.leaveRecordList.concat(res.resData.resultList);
        }
      });
    }
  },
  created: function created() {
    var _this2 = this;

    this.teacherMsg = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    this.queryLeaveRecord();
    // 开始下拉刷新
    Object(bridgeAPI["c" /* beginPullDown */])(function () {
      _this2.pageNum = 1;
      _this2.queryLeaveRecord();
    });
  }
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/babyLeaveRecord/babyLeaveRecord.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//



/* harmony default export */ var babyLeaveRecord_babyLeaveRecord = ({
  data: function data() {
    return {
      pageNum: 1, // 请求页数
      pageSize: 10, // 请求字数
      pageTotal: 0,
      noDataFlag: false,
      noMoreFlag: false,
      leaveRecordList: [], // 请假记录列表
      queryDataLoading: false,
      teacherMsg: null
    };
  },

  mixins: [babyLeaveRecord],
  components: { listComponents: listComponents["a" /* default */] }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-1141335e","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/babyLeaveRecord/babyLeaveRecord.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',[_c('list-components',{attrs:{"listPadDomClass":"mv-leaveRecordList","listData":_vm.leaveRecordList,"noData":"暂无请假记录","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"queryDataLoading":_vm.queryDataLoading},on:{"loadMore":_vm.loadMore},scopedSlots:_vm._u([{key:"default",fn:function(slotProps){return _c('v-touch',{directives:[{name:"show",rawName:"v-show",value:(slotProps.item.leaveTimeType!=0),expression:"slotProps.item.leaveTimeType!=0"}],staticClass:"leaveRecordLi"},[_c('div',{staticClass:"mv-leaveHead",style:({backgroundImage:'url('+ _vm.judgeUrl(slotProps.item.photoUrl) +')'})}),_vm._v(" "),_c('div',{staticClass:"mv-leaveInfo"},[_c('div',{staticClass:"mv-leaveText"},[_c('p',{staticClass:"mv-leaveName"},[_vm._v(_vm._s(slotProps.item.studentName))]),_vm._v(" "),_c('div',{staticClass:"mv-leaveTime"},[_c('span',{},[_vm._v(_vm._s(slotProps.item.createTime))])]),_vm._v(" "),_c('div',{staticClass:"mv-leaveReason"},[_c('b',[_vm._v("请假理由：")]),_c('span',{},[_vm._v(_vm._s(slotProps.item.leaveInstructions))])]),_vm._v(" "),_c('div',{staticClass:"mv-leaveReason"},[_c('b',[_vm._v("请假类型：")]),_c('span',{},[_vm._v(_vm._s(_vm.matchType(slotProps.item.leaveType)))])]),_vm._v(" "),_c('div',{staticClass:"mv-leaveCycle"},[_c('b',[_vm._v("请假周期：")]),_c('span',{},[_vm._v(_vm._s(slotProps.item.applyPeriodDesc))])])]),_vm._v(" "),_c('div',{staticClass:"mv-confirm-btn",class:{disabled:slotProps.item.seenEnable == 1},on:{"click":function($event){_vm.reported(slotProps.item)}}},[_vm._v(_vm._s(slotProps.item.seenEnable == 1 ? '已确认' : '待确认'))])])])}}])})],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_babyLeaveRecord_babyLeaveRecord = (esExports);
// CONCATENATED MODULE: ./src/pages/babyLeaveRecord/babyLeaveRecord.vue
function injectStyle (ssrContext) {
  __webpack_require__("GofE")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-1141335e"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  babyLeaveRecord_babyLeaveRecord,
  pages_babyLeaveRecord_babyLeaveRecord,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_babyLeaveRecord_babyLeaveRecord = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "GofE":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});