webpackJsonp([73],{

/***/ "ldzT":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/components/listComponents/listComponents.vue + 5 modules
var listComponents = __webpack_require__("JKqx");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// CONCATENATED MODULE: ./src/pages/messageList/module/messageList.js




var defaultImg = __webpack_require__("7G5z");
/* harmony default export */ var messageList = ({
	beforeCreate: function beforeCreate() {
		var _this2 = this;

		Object(bridgeAPI["j" /* commonRegister */])('clearAll', function () {
			_this2.clearAll();
		});
	},
	created: function created() {
		if (auth["n" /* platForms */].isIOS()) {
			Object(auth["q" /* setData */])('amount', 0);
		}
		this.messageStatus = this.$route.query.messageStatus == 'null' ? null : 0;
		this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
		this.disScrollFlag = false;
		// 判断是否时从查看旧消息进入的
		if (this.messageStatus == null) {
			this.readFlag = null;
			this.totalPageNum = 1;
			this.checkMoreFlag = false;
		} else {
			this.readFlag = true;
			this.pageNum = 1;
			this.checkMoreFlag = true;
		}
		this.getMessageData();
	},

	methods: {
		// 置已读
		setMessageRead: function setMessageRead() {
			this.$http.post(api["_75" /* setMessageRead */], {
				messageType: ['reply'],
				subjectType: 1,
				endTime: this.endTime
			}).then(function () {
				Object(bridgeAPI["p" /* notifyPage */])('clearMessageNum');
			});
		},

		// 判断评论是否被删除
		returnComment: function returnComment(flag, content) {
			if (flag) {
				return '该评论已删除';
			} else {
				return content;
			}
		},
		toMessageDetail: function toMessageDetail(id, type, deleteFlag) {
			if (deleteFlag) return;
			// type: 主题类型
			Object(bridgeAPI["o" /* newWindow */])({
				title: '详情',
				url: 'dynamicDetail?id=' + id
			});
		},
		clearAll: function clearAll() {
			var _this3 = this;

			if (this.messageList.length == 0) {
				return;
			} else {
				Object(bridgeAPI["k" /* dialog */])({
					title: '提示',
					message: '清空消息列表所有消息'
				}).then(function () {
					_this3.$http.post(api["L" /* clearMessage */], {
						subjectType: 1
					}).then(function () {
						_this3.messageList = [];
						_this3.noDataFlag = true;
						Object(bridgeAPI["h" /* commonMsg */])({
							call: 'clearMsg'
						});
					});
				});
			}
		},

		// 查看历史消息记录
		checkMoreMessage: function checkMoreMessage() {
			// 消息标志位置为false
			this.readFlag = false;
			// 放开无限滚动
			this.disScrollFlag = false;
			// 关闭查看更多按钮
			this.checkMoreFlag = false;
			// 加载已读消息
			this.readPageNum = this.readPageNum + 1;
			this.getMessageData();
		},
		checkHeadImg: function checkHeadImg(img) {
			// 检查是否有头像
			if (img) {
				return Object(auth["b" /* commonCutImg */])(img, {
					width: 100,
					height: 100
				});
			} else {
				return defaultImg;
			}
		},
		loadMore: function loadMore() {
			if (this.readFlag === null) {
				// 同时加载已读未读
				this.queryDataLoading = true;
				this.totalPageNum = this.totalPageNum + 1;
				this.getMessageData();
			} else if (this.readFlag === false) {
				if (!this.checkMoreFlag) {
					// 判断是否点击了加载更多
					this.queryDataLoading = true;
					this.readPageNum = this.readPageNum + 1;
					this.getMessageData();
				}
			}
		},
		getMessageData: function getMessageData() {
			var _this4 = this;

			var _this = this,
			    params = {};
			params.subjectType = 1;
			params.messageType = ['reply'];
			params.lastPageLastId = this.lastPageLastId;
			if (this.readFlag === null) {
				params.pageNum = this.totalPageNum;
				params.messageStatus = null;
				params.pageSize = this.pageSize;
			} else if (this.readFlag) {
				params.pageNum = this.pageNum;
				params.messageStatus = 0;
				params.pageSize = this.unReadPageSize;
			} else {
				params.pageNum = this.readPageNum;
				params.messageStatus = 1;
				params.pageSize = this.pageSize;
			}
			this.$http.post(api["_47" /* queryMessageList */], params).then(function (res) {
				Object(bridgeAPI["l" /* endPullDown */])();
				// 是要返回数组不为空，将最后一条id赋值给lastPageLastId
				if (res.resData.resultList.length) {
					_this4.lastPageLastId = res.resData.resultList[res.resData.resultList.length - 1].id;
				}
				// 判断是否是处理新消息
				if (_this4.readFlag) {
					_this4.pageTotal = res.resData.pageTotal;
					_this4.total = res.resData.total;
					_this4.queryDataLoading = false;
					// 置已读
					_this4.setMessageRead();
				} else if (_this4.readFlag == null) {
					// 是否从历史按钮点进来
					if (_this4.totalPageNum == 1) {
						if (res.resData.resultList.length == 0) {
							_this4.noDataFlag = true;
						}
					} else {
						if (res.resData.pageTotal <= _this4.totalPageNum) {
							_this4.noMoreFlag = true;
						}
					}
				} else {
					if (res.resData.resultList.length == 0) {
						_this4.noMoreFlag = true;
					}
					if (res.resData.pageTotal <= _this4.readPageNum) {
						_this4.noMoreFlag = true;
					} else {
						_this4.queryDataLoading = false;
					}
				}
				if (res.resData.pageTotal >= params.pageNum) {
					_this4.messageList = _this.messageList.concat(res.resData.resultList);
				}
			});
		}
	}
});
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/messageList/messageList.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//




/* harmony default export */ var messageList_messageList = ({
  mixins: [messageList],
  data: function data() {
    return {
      messageList: [],
      disScrollFlag: false, //是否禁止无限滚动
      readFlag: true, //readFlag: 请求消息类型 true未读 false 已读
      checkMoreFlag: false, // 控制查看更多按钮的显示
      pageNum: 1, //未读分页的页数
      readPageNum: 0, // 已读分页的页数
      totalPageNum: 1,
      pageTotal: 0, // 未读消息总页数
      total: 0, // 未读消息总记录数
      lastPageLastId: "", // 第二页必传最后一条记录id
      endTime: '', // 设置此时间之前的消息已读
      noDataFlag: false,
      noMoreFlag: false,
      queryDataLoading: false,
      pageSize: 10,
      unReadPageSize: 999
    };
  },

  components: { listComponents: listComponents["a" /* default */] }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-0cdbf8c3","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/messageList/messageList.vue
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"mv-message-list"},[_c('list-components',{attrs:{"queryDataLoading":_vm.queryDataLoading,"listData":_vm.messageList,"noData":"暂无消息记录~","noDataFlag":_vm.noDataFlag,"noMoreFlag":_vm.noMoreFlag,"infiniteScroll":_vm.disScrollFlag},on:{"loadMore":_vm.loadMore},scopedSlots:_vm._u([{key:"default",fn:function(slotProps){return _c('div',{staticClass:"class-item border-bottom-1px",on:{"click":function($event){_vm.toMessageDetail(slotProps.item.messageData.subjectId, slotProps.item.messageData.subjectType, slotProps.item.messageData.isDelete)}}},[_c('div',{directives:[{name:"lazy",rawName:"v-lazy:background-image",value:(_vm.checkHeadImg(slotProps.item.messageData.replyHeadUrl)),expression:"checkHeadImg(slotProps.item.messageData.replyHeadUrl)",arg:"background-image"}],staticClass:"class-user-header"}),_vm._v(" "),_c('div',{staticClass:"mv-message-content",class:{'mv-no-pic': !slotProps.item.messageData.imageUrl}},[_c('p',{staticClass:"mv-message-name",domProps:{"textContent":_vm._s(slotProps.item.messageData.replyShowName)}}),_vm._v(" "),(slotProps.item.messageData.type == 1 || slotProps.item.messageData.isDelete)?_c('p',{staticClass:"mv-message-des",class:{'mv-delete-comment': slotProps.item.messageData.isDelete},domProps:{"textContent":_vm._s(_vm.returnComment(slotProps.item.messageData.isDelete, slotProps.item.messageData.replyContent))}}):_vm._e(),_vm._v(" "),(slotProps.item.messageData.type == 2)?_c('p',{staticClass:"mv-message-des mv-message-praise"}):_vm._e(),_vm._v(" "),_c('p',{staticClass:"mv-message-time",domProps:{"textContent":_vm._s(slotProps.item.createTimeDesc)}})]),_vm._v(" "),(slotProps.item.messageData.imageUrl)?_c('div',{directives:[{name:"lazy",rawName:"v-lazy:background-image",value:(slotProps.item.messageData.imageUrl),expression:"slotProps.item.messageData.imageUrl",arg:"background-image"}],staticClass:"mv-dynamic-img"}):_vm._e()])}}])}),_vm._v(" "),(_vm.messageList.length && _vm.checkMoreFlag)?_c('p',{staticClass:"mv-check-more",on:{"click":_vm.checkMoreMessage}},[_vm._v("查看更早消息...")]):_vm._e()],1)}
var staticRenderFns = []
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ var pages_messageList_messageList = (esExports);
// CONCATENATED MODULE: ./src/pages/messageList/messageList.vue
function injectStyle (ssrContext) {
  __webpack_require__("xEMY")
}
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-0cdbf8c3"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  messageList_messageList,
  pages_messageList_messageList,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var src_pages_messageList_messageList = __webpack_exports__["default"] = (Component.exports);


/***/ }),

/***/ "xEMY":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })

});