webpackJsonp([9],{

/***/ "3WyN":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "DtRx":
/***/ (function(module, exports, __webpack_require__) {

var rng = __webpack_require__("i4uy");
var bytesToUuid = __webpack_require__("MAlW");

function v4(options, buf, offset) {
  var i = buf && offset || 0;

  if (typeof(options) == 'string') {
    buf = options === 'binary' ? new Array(16) : null;
    options = null;
  }
  options = options || {};

  var rnds = options.random || (options.rng || rng)();

  // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
  rnds[6] = (rnds[6] & 0x0f) | 0x40;
  rnds[8] = (rnds[8] & 0x3f) | 0x80;

  // Copy bytes to buffer, if provided
  if (buf) {
    for (var ii = 0; ii < 16; ++ii) {
      buf[i + ii] = rnds[ii];
    }
  }

  return buf || bytesToUuid(rnds);
}

module.exports = v4;


/***/ }),

/***/ "MAlW":
/***/ (function(module, exports) {

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
var byteToHex = [];
for (var i = 0; i < 256; ++i) {
  byteToHex[i] = (i + 0x100).toString(16).substr(1);
}

function bytesToUuid(buf, offset) {
  var i = offset || 0;
  var bth = byteToHex;
  return bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] + '-' +
          bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]] +
          bth[buf[i++]] + bth[buf[i++]];
}

module.exports = bytesToUuid;


/***/ }),

/***/ "Nekn":
/***/ (function(module, exports) {

~function () {
  var EOF = -1;
  var BITS = 12;
  var HSIZE = 5003;
  var masks = [0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767, 65535];
  var remaining, curPixel, n_bits;
  function LZWEncoder(width, height, pixels, colorDepth) {
    var initCodeSize = Math.max(2, colorDepth);
    var accum = new Uint8Array(256);
    var htab = new Int32Array(HSIZE);
    var codetab = new Int32Array(HSIZE);
    var cur_accum,
        cur_bits = 0;
    var a_count;
    var free_ent = 0;
    var maxcode;
    var clear_flg = false;
    var g_init_bits, ClearCode, EOFCode;
    function char_out(c, outs) {
      accum[a_count++] = c;
      if (a_count >= 254) flush_char(outs);
    }
    function cl_block(outs) {
      cl_hash(HSIZE);
      free_ent = ClearCode + 2;
      clear_flg = true;
      output(ClearCode, outs);
    }
    function cl_hash(hsize) {
      for (var i = 0; i < hsize; ++i) {
        htab[i] = -1;
      }
    }
    function compress(init_bits, outs) {
      var fcode, c, i, ent, disp, hsize_reg, hshift;
      g_init_bits = init_bits;
      clear_flg = false;
      n_bits = g_init_bits;
      maxcode = MAXCODE(n_bits);
      ClearCode = 1 << init_bits - 1;
      EOFCode = ClearCode + 1;
      free_ent = ClearCode + 2;
      a_count = 0;
      ent = nextPixel();
      hshift = 0;
      for (fcode = HSIZE; fcode < 65536; fcode *= 2) {
        ++hshift;
      }hshift = 8 - hshift;
      hsize_reg = HSIZE;
      cl_hash(hsize_reg);
      output(ClearCode, outs);
      outer_loop: while ((c = nextPixel()) != EOF) {
        fcode = (c << BITS) + ent;
        i = c << hshift ^ ent;
        if (htab[i] === fcode) {
          ent = codetab[i];
          continue;
        } else if (htab[i] >= 0) {
          disp = hsize_reg - i;
          if (i === 0) disp = 1;
          do {
            if ((i -= disp) < 0) i += hsize_reg;
            if (htab[i] === fcode) {
              ent = codetab[i];
              continue outer_loop;
            }
          } while (htab[i] >= 0);
        }
        output(ent, outs);
        ent = c;
        if (free_ent < 1 << BITS) {
          codetab[i] = free_ent++;
          htab[i] = fcode;
        } else {
          cl_block(outs);
        }
      }
      output(ent, outs);
      output(EOFCode, outs);
    }
    function encode(outs) {
      outs.writeByte(initCodeSize);
      remaining = width * height;
      curPixel = 0;
      compress(initCodeSize + 1, outs);
      outs.writeByte(0);
    }
    function flush_char(outs) {
      if (a_count > 0) {
        outs.writeByte(a_count);
        outs.writeBytes(accum, 0, a_count);
        a_count = 0;
      }
    }
    function MAXCODE(n_bits) {
      return (1 << n_bits) - 1;
    }
    function nextPixel() {
      if (remaining === 0) return EOF;
      --remaining;
      var pix = pixels[curPixel++];
      return pix & 255;
    }
    function output(code, outs) {
      cur_accum &= masks[cur_bits];
      if (cur_bits > 0) cur_accum |= code << cur_bits;else cur_accum = code;
      cur_bits += n_bits;
      while (cur_bits >= 8) {
        char_out(cur_accum & 255, outs);
        cur_accum >>= 8;
        cur_bits -= 8;
      }
      if (free_ent > maxcode || clear_flg) {
        if (clear_flg) {
          maxcode = MAXCODE(n_bits = g_init_bits);
          clear_flg = false;
        } else {
          ++n_bits;
          if (n_bits == BITS) maxcode = 1 << BITS;else maxcode = MAXCODE(n_bits);
        }
      }
      if (code == EOFCode) {
        while (cur_bits > 0) {
          char_out(cur_accum & 255, outs);
          cur_accum >>= 8;
          cur_bits -= 8;
        }
        flush_char(outs);
      }
    }
    this.encode = encode;
  }
  var ncycles = 100;
  var netsize = 256;
  var maxnetpos = netsize - 1;
  var netbiasshift = 4;
  var intbiasshift = 16;
  var intbias = 1 << intbiasshift;
  var gammashift = 10;
  var gamma = 1 << gammashift;
  var betashift = 10;
  var beta = intbias >> betashift;
  var betagamma = intbias << gammashift - betashift;
  var initrad = netsize >> 3;
  var radiusbiasshift = 6;
  var radiusbias = 1 << radiusbiasshift;
  var initradius = initrad * radiusbias;
  var radiusdec = 30;
  var alphabiasshift = 10;
  var initalpha = 1 << alphabiasshift;
  var alphadec;
  var radbiasshift = 8;
  var radbias = 1 << radbiasshift;
  var alpharadbshift = alphabiasshift + radbiasshift;
  var alpharadbias = 1 << alpharadbshift;
  var prime1 = 499;
  var prime2 = 491;
  var prime3 = 487;
  var prime4 = 503;
  var minpicturebytes = 3 * prime4;
  function NeuQuant(pixels, samplefac) {
    var network;
    var netindex;
    var bias;
    var freq;
    var radpower;
    function init() {
      network = [];
      netindex = new Int32Array(256);
      bias = new Int32Array(netsize);
      freq = new Int32Array(netsize);
      radpower = new Int32Array(netsize >> 3);
      var i, v;
      for (i = 0; i < netsize; i++) {
        v = (i << netbiasshift + 8) / netsize;
        network[i] = new Float64Array([v, v, v, 0]);
        freq[i] = intbias / netsize;
        bias[i] = 0;
      }
    }
    function unbiasnet() {
      for (var i = 0; i < netsize; i++) {
        network[i][0] >>= netbiasshift;
        network[i][1] >>= netbiasshift;
        network[i][2] >>= netbiasshift;
        network[i][3] = i;
      }
    }
    function altersingle(alpha, i, b, g, r) {
      network[i][0] -= alpha * (network[i][0] - b) / initalpha;
      network[i][1] -= alpha * (network[i][1] - g) / initalpha;
      network[i][2] -= alpha * (network[i][2] - r) / initalpha;
    }
    function alterneigh(radius, i, b, g, r) {
      var lo = Math.abs(i - radius);
      var hi = Math.min(i + radius, netsize);
      var j = i + 1;
      var k = i - 1;
      var m = 1;
      var p, a;
      while (j < hi || k > lo) {
        a = radpower[m++];
        if (j < hi) {
          p = network[j++];
          p[0] -= a * (p[0] - b) / alpharadbias;
          p[1] -= a * (p[1] - g) / alpharadbias;
          p[2] -= a * (p[2] - r) / alpharadbias;
        }
        if (k > lo) {
          p = network[k--];
          p[0] -= a * (p[0] - b) / alpharadbias;
          p[1] -= a * (p[1] - g) / alpharadbias;
          p[2] -= a * (p[2] - r) / alpharadbias;
        }
      }
    }
    function contest(b, g, r) {
      var bestd = ~(1 << 31);
      var bestbiasd = bestd;
      var bestpos = -1;
      var bestbiaspos = bestpos;
      var i, n, dist, biasdist, betafreq;
      for (i = 0; i < netsize; i++) {
        n = network[i];
        dist = Math.abs(n[0] - b) + Math.abs(n[1] - g) + Math.abs(n[2] - r);
        if (dist < bestd) {
          bestd = dist;
          bestpos = i;
        }
        biasdist = dist - (bias[i] >> intbiasshift - netbiasshift);
        if (biasdist < bestbiasd) {
          bestbiasd = biasdist;
          bestbiaspos = i;
        }
        betafreq = freq[i] >> betashift;
        freq[i] -= betafreq;
        bias[i] += betafreq << gammashift;
      }
      freq[bestpos] += beta;
      bias[bestpos] -= betagamma;
      return bestbiaspos;
    }
    function inxbuild() {
      var i,
          j,
          p,
          q,
          smallpos,
          smallval,
          previouscol = 0,
          startpos = 0;
      for (i = 0; i < netsize; i++) {
        p = network[i];
        smallpos = i;
        smallval = p[1];
        for (j = i + 1; j < netsize; j++) {
          q = network[j];
          if (q[1] < smallval) {
            smallpos = j;
            smallval = q[1];
          }
        }
        q = network[smallpos];
        if (i != smallpos) {
          j = q[0];
          q[0] = p[0];
          p[0] = j;
          j = q[1];
          q[1] = p[1];
          p[1] = j;
          j = q[2];
          q[2] = p[2];
          p[2] = j;
          j = q[3];
          q[3] = p[3];
          p[3] = j;
        }
        if (smallval != previouscol) {
          netindex[previouscol] = startpos + i >> 1;
          for (j = previouscol + 1; j < smallval; j++) {
            netindex[j] = i;
          }previouscol = smallval;
          startpos = i;
        }
      }
      netindex[previouscol] = startpos + maxnetpos >> 1;
      for (j = previouscol + 1; j < 256; j++) {
        netindex[j] = maxnetpos;
      }
    }
    function inxsearch(b, g, r) {
      var a, p, dist;
      var bestd = 1e3;
      var best = -1;
      var i = netindex[g];
      var j = i - 1;
      while (i < netsize || j >= 0) {
        if (i < netsize) {
          p = network[i];
          dist = p[1] - g;
          if (dist >= bestd) i = netsize;else {
            i++;
            if (dist < 0) dist = -dist;
            a = p[0] - b;
            if (a < 0) a = -a;
            dist += a;
            if (dist < bestd) {
              a = p[2] - r;
              if (a < 0) a = -a;
              dist += a;
              if (dist < bestd) {
                bestd = dist;
                best = p[3];
              }
            }
          }
        }
        if (j >= 0) {
          p = network[j];
          dist = g - p[1];
          if (dist >= bestd) j = -1;else {
            j--;
            if (dist < 0) dist = -dist;
            a = p[0] - b;
            if (a < 0) a = -a;
            dist += a;
            if (dist < bestd) {
              a = p[2] - r;
              if (a < 0) a = -a;
              dist += a;
              if (dist < bestd) {
                bestd = dist;
                best = p[3];
              }
            }
          }
        }
      }
      return best;
    }
    function learn() {
      var i;
      var lengthcount = pixels.length;
      var alphadec = 30 + (samplefac - 1) / 3;
      var samplepixels = lengthcount / (3 * samplefac);
      var delta = ~~(samplepixels / ncycles);
      var alpha = initalpha;
      var radius = initradius;
      var rad = radius >> radiusbiasshift;
      if (rad <= 1) rad = 0;
      for (i = 0; i < rad; i++) {
        radpower[i] = alpha * ((rad * rad - i * i) * radbias / (rad * rad));
      }var step;
      if (lengthcount < minpicturebytes) {
        samplefac = 1;
        step = 3;
      } else if (lengthcount % prime1 !== 0) {
        step = 3 * prime1;
      } else if (lengthcount % prime2 !== 0) {
        step = 3 * prime2;
      } else if (lengthcount % prime3 !== 0) {
        step = 3 * prime3;
      } else {
        step = 3 * prime4;
      }
      var b, g, r, j;
      var pix = 0;
      i = 0;
      while (i < samplepixels) {
        b = (pixels[pix] & 255) << netbiasshift;
        g = (pixels[pix + 1] & 255) << netbiasshift;
        r = (pixels[pix + 2] & 255) << netbiasshift;
        j = contest(b, g, r);
        altersingle(alpha, j, b, g, r);
        if (rad !== 0) alterneigh(rad, j, b, g, r);
        pix += step;
        if (pix >= lengthcount) pix -= lengthcount;
        i++;
        if (delta === 0) delta = 1;
        if (i % delta === 0) {
          alpha -= alpha / alphadec;
          radius -= radius / radiusdec;
          rad = radius >> radiusbiasshift;
          if (rad <= 1) rad = 0;
          for (j = 0; j < rad; j++) {
            radpower[j] = alpha * ((rad * rad - j * j) * radbias / (rad * rad));
          }
        }
      }
    }
    function buildColormap() {
      init();
      learn();
      unbiasnet();
      inxbuild();
    }
    this.buildColormap = buildColormap;
    function getColormap() {
      var map = [];
      var index = [];
      for (var i = 0; i < netsize; i++) {
        index[network[i][3]] = i;
      }var k = 0;
      for (var l = 0; l < netsize; l++) {
        var j = index[l];
        map[k++] = network[j][0];
        map[k++] = network[j][1];
        map[k++] = network[j][2];
      }
      return map;
    }
    this.getColormap = getColormap;
    this.lookupRGB = inxsearch;
  }
  var renderFrame;
  renderFrame = function renderFrame(frame) {
    var encoder, page, stream, transfer;
    encoder = new GIFEncoder(frame.width, frame.height);
    if (frame.index === 0) {
      encoder.writeHeader();
    } else {
      encoder.firstFrame = false;
    }
    encoder.setTransparent(frame.transparent);
    encoder.setRepeat(frame.repeat);
    encoder.setDelay(frame.delay);
    encoder.setQuality(frame.quality);
    encoder.setDither(frame.dither);
    encoder.setGlobalPalette(frame.globalPalette);
    encoder.addFrame(frame.data);
    if (frame.last) {
      encoder.finish();
    }
    if (frame.globalPalette === true) {
      frame.globalPalette = encoder.getGlobalPalette();
    }
    stream = encoder.stream();
    frame.data = stream.pages;
    frame.cursor = stream.cursor;
    frame.pageSize = stream.constructor.pageSize;
    if (frame.canTransfer) {
      transfer = function () {
        var i, len, ref, results;
        ref = frame.data;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          page = ref[i];
          results.push(page.buffer);
        }
        return results;
      }();
      return self.postMessage(frame, transfer);
    } else {
      return self.postMessage(frame);
    }
  };
  self.onmessage = function (event) {
    return renderFrame(event.data);
  };
  function ByteArray() {
    this.page = -1;
    this.pages = [];
    this.newPage();
  }
  ByteArray.pageSize = 4096;
  ByteArray.charMap = {};
  for (var i = 0; i < 256; i++) {
    ByteArray.charMap[i] = String.fromCharCode(i);
  }ByteArray.prototype.newPage = function () {
    this.pages[++this.page] = new Uint8Array(ByteArray.pageSize);
    this.cursor = 0;
  };
  ByteArray.prototype.getData = function () {
    var rv = "";
    for (var p = 0; p < this.pages.length; p++) {
      for (var i = 0; i < ByteArray.pageSize; i++) {
        rv += ByteArray.charMap[this.pages[p][i]];
      }
    }
    return rv;
  };
  ByteArray.prototype.writeByte = function (val) {
    if (this.cursor >= ByteArray.pageSize) this.newPage();
    this.pages[this.page][this.cursor++] = val;
  };
  ByteArray.prototype.writeUTFBytes = function (string) {
    for (var l = string.length, i = 0; i < l; i++) {
      this.writeByte(string.charCodeAt(i));
    }
  };
  ByteArray.prototype.writeBytes = function (array, offset, length) {
    for (var l = length || array.length, i = offset || 0; i < l; i++) {
      this.writeByte(array[i]);
    }
  };
  function GIFEncoder(width, height) {
    this.width = ~~width;
    this.height = ~~height;
    this.transparent = null;
    this.transIndex = 0;
    this.repeat = -1;
    this.delay = 0;
    this.image = null;
    this.pixels = null;
    this.indexedPixels = null;
    this.colorDepth = null;
    this.colorTab = null;
    this.neuQuant = null;
    this.usedEntry = new Array();
    this.palSize = 7;
    this.dispose = -1;
    this.firstFrame = true;
    this.sample = 10;
    this.dither = false;
    this.globalPalette = false;
    this.out = new ByteArray();
  }
  GIFEncoder.prototype.setDelay = function (milliseconds) {
    this.delay = Math.round(milliseconds / 10);
  };
  GIFEncoder.prototype.setFrameRate = function (fps) {
    this.delay = Math.round(100 / fps);
  };
  GIFEncoder.prototype.setDispose = function (disposalCode) {
    if (disposalCode >= 0) this.dispose = disposalCode;
  };
  GIFEncoder.prototype.setRepeat = function (repeat) {
    this.repeat = repeat;
  };
  GIFEncoder.prototype.setTransparent = function (color) {
    this.transparent = color;
  };
  GIFEncoder.prototype.addFrame = function (imageData) {
    this.image = imageData;
    this.colorTab = this.globalPalette && this.globalPalette.slice ? this.globalPalette : null;
    this.getImagePixels();
    this.analyzePixels();
    if (this.globalPalette === true) this.globalPalette = this.colorTab;
    if (this.firstFrame) {
      this.writeLSD();
      this.writePalette();
      if (this.repeat >= 0) {
        this.writeNetscapeExt();
      }
    }
    this.writeGraphicCtrlExt();
    this.writeImageDesc();
    if (!this.firstFrame && !this.globalPalette) this.writePalette();
    this.writePixels();
    this.firstFrame = false;
  };
  GIFEncoder.prototype.finish = function () {
    this.out.writeByte(59);
  };
  GIFEncoder.prototype.setQuality = function (quality) {
    if (quality < 1) quality = 1;
    this.sample = quality;
  };
  GIFEncoder.prototype.setDither = function (dither) {
    if (dither === true) dither = "FloydSteinberg";
    this.dither = dither;
  };
  GIFEncoder.prototype.setGlobalPalette = function (palette) {
    this.globalPalette = palette;
  };
  GIFEncoder.prototype.getGlobalPalette = function () {
    return this.globalPalette && this.globalPalette.slice && this.globalPalette.slice(0) || this.globalPalette;
  };
  GIFEncoder.prototype.writeHeader = function () {
    this.out.writeUTFBytes("GIF89a");
  };
  GIFEncoder.prototype.analyzePixels = function () {
    if (!this.colorTab) {
      this.neuQuant = new NeuQuant(this.pixels, this.sample);
      this.neuQuant.buildColormap();
      this.colorTab = this.neuQuant.getColormap();
    }
    if (this.dither) {
      this.ditherPixels(this.dither.replace("-serpentine", ""), this.dither.match(/-serpentine/) !== null);
    } else {
      this.indexPixels();
    }
    this.pixels = null;
    this.colorDepth = 8;
    this.palSize = 7;
    if (this.transparent !== null) {
      this.transIndex = this.findClosest(this.transparent, true);
    }
  };
  GIFEncoder.prototype.indexPixels = function (imgq) {
    var nPix = this.pixels.length / 3;
    this.indexedPixels = new Uint8Array(nPix);
    var k = 0;
    for (var j = 0; j < nPix; j++) {
      var index = this.findClosestRGB(this.pixels[k++] & 255, this.pixels[k++] & 255, this.pixels[k++] & 255);
      this.usedEntry[index] = true;
      this.indexedPixels[j] = index;
    }
  };
  GIFEncoder.prototype.ditherPixels = function (kernel, serpentine) {
    var kernels = {
      FalseFloydSteinberg: [[3 / 8, 1, 0], [3 / 8, 0, 1], [2 / 8, 1, 1]],
      FloydSteinberg: [[7 / 16, 1, 0], [3 / 16, -1, 1], [5 / 16, 0, 1], [1 / 16, 1, 1]],
      Stucki: [[8 / 42, 1, 0], [4 / 42, 2, 0], [2 / 42, -2, 1], [4 / 42, -1, 1], [8 / 42, 0, 1], [4 / 42, 1, 1], [2 / 42, 2, 1], [1 / 42, -2, 2], [2 / 42, -1, 2], [4 / 42, 0, 2], [2 / 42, 1, 2], [1 / 42, 2, 2]],
      Atkinson: [[1 / 8, 1, 0], [1 / 8, 2, 0], [1 / 8, -1, 1], [1 / 8, 0, 1], [1 / 8, 1, 1], [1 / 8, 0, 2]]
    };
    if (!kernel || !kernels[kernel]) {
      throw "Unknown dithering kernel: " + kernel;
    }
    var ds = kernels[kernel];
    var index = 0,
        height = this.height,
        width = this.width,
        data = this.pixels;
    var direction = serpentine ? -1 : 1;
    this.indexedPixels = new Uint8Array(this.pixels.length / 3);
    for (var y = 0; y < height; y++) {
      if (serpentine) direction = direction * -1;
      for (var x = direction == 1 ? 0 : width - 1, xend = direction == 1 ? width : 0; x !== xend; x += direction) {
        index = y * width + x;
        var idx = index * 3;
        var r1 = data[idx];
        var g1 = data[idx + 1];
        var b1 = data[idx + 2];
        idx = this.findClosestRGB(r1, g1, b1);
        this.usedEntry[idx] = true;
        this.indexedPixels[index] = idx;
        idx *= 3;
        var r2 = this.colorTab[idx];
        var g2 = this.colorTab[idx + 1];
        var b2 = this.colorTab[idx + 2];
        var er = r1 - r2;
        var eg = g1 - g2;
        var eb = b1 - b2;
        for (var i = direction == 1 ? 0 : ds.length - 1, end = direction == 1 ? ds.length : 0; i !== end; i += direction) {
          var x1 = ds[i][1];
          var y1 = ds[i][2];
          if (x1 + x >= 0 && x1 + x < width && y1 + y >= 0 && y1 + y < height) {
            var d = ds[i][0];
            idx = index + x1 + y1 * width;
            idx *= 3;
            data[idx] = Math.max(0, Math.min(255, data[idx] + er * d));
            data[idx + 1] = Math.max(0, Math.min(255, data[idx + 1] + eg * d));
            data[idx + 2] = Math.max(0, Math.min(255, data[idx + 2] + eb * d));
          }
        }
      }
    }
  };
  GIFEncoder.prototype.findClosest = function (c, used) {
    return this.findClosestRGB((c & 16711680) >> 16, (c & 65280) >> 8, c & 255, used);
  };
  GIFEncoder.prototype.findClosestRGB = function (r, g, b, used) {
    if (this.colorTab === null) return -1;
    if (this.neuQuant && !used) {
      return this.neuQuant.lookupRGB(r, g, b);
    }
    var c = b | g << 8 | r << 16;
    var minpos = 0;
    var dmin = 256 * 256 * 256;
    var len = this.colorTab.length;
    for (var i = 0, index = 0; i < len; index++) {
      var dr = r - (this.colorTab[i++] & 255);
      var dg = g - (this.colorTab[i++] & 255);
      var db = b - (this.colorTab[i++] & 255);
      var d = dr * dr + dg * dg + db * db;
      if ((!used || this.usedEntry[index]) && d < dmin) {
        dmin = d;
        minpos = index;
      }
    }
    return minpos;
  };
  GIFEncoder.prototype.getImagePixels = function () {
    var w = this.width;
    var h = this.height;
    this.pixels = new Uint8Array(w * h * 3);
    var data = this.image;
    var srcPos = 0;
    var count = 0;
    for (var i = 0; i < h; i++) {
      for (var j = 0; j < w; j++) {
        this.pixels[count++] = data[srcPos++];
        this.pixels[count++] = data[srcPos++];
        this.pixels[count++] = data[srcPos++];
        srcPos++;
      }
    }
  };
  GIFEncoder.prototype.writeGraphicCtrlExt = function () {
    this.out.writeByte(33);
    this.out.writeByte(249);
    this.out.writeByte(4);
    var transp, disp;
    if (this.transparent === null) {
      transp = 0;
      disp = 0;
    } else {
      transp = 1;
      disp = 2;
    }
    if (this.dispose >= 0) {
      disp = dispose & 7;
    }
    disp <<= 2;
    this.out.writeByte(0 | disp | 0 | transp);
    this.writeShort(this.delay);
    this.out.writeByte(this.transIndex);
    this.out.writeByte(0);
  };
  GIFEncoder.prototype.writeImageDesc = function () {
    this.out.writeByte(44);
    this.writeShort(0);
    this.writeShort(0);
    this.writeShort(this.width);
    this.writeShort(this.height);
    if (this.firstFrame || this.globalPalette) {
      this.out.writeByte(0);
    } else {
      this.out.writeByte(128 | 0 | 0 | 0 | this.palSize);
    }
  };
  GIFEncoder.prototype.writeLSD = function () {
    this.writeShort(this.width);
    this.writeShort(this.height);
    this.out.writeByte(128 | 112 | 0 | this.palSize);
    this.out.writeByte(0);
    this.out.writeByte(0);
  };
  GIFEncoder.prototype.writeNetscapeExt = function () {
    this.out.writeByte(33);
    this.out.writeByte(255);
    this.out.writeByte(11);
    this.out.writeUTFBytes("NETSCAPE2.0");
    this.out.writeByte(3);
    this.out.writeByte(1);
    this.writeShort(this.repeat);
    this.out.writeByte(0);
  };
  GIFEncoder.prototype.writePalette = function () {
    this.out.writeBytes(this.colorTab);
    var n = 3 * 256 - this.colorTab.length;
    for (var i = 0; i < n; i++) {
      this.out.writeByte(0);
    }
  };
  GIFEncoder.prototype.writeShort = function (pValue) {
    this.out.writeByte(pValue & 255);
    this.out.writeByte(pValue >> 8 & 255);
  };
  GIFEncoder.prototype.writePixels = function () {
    var enc = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
    enc.encode(this.out);
  };
  GIFEncoder.prototype.stream = function () {
    return this.out;
  };
}();

/***/ }),

/***/ "b3y+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./src/utils/bridgeAPI.js
var bridgeAPI = __webpack_require__("ubr6");

// EXTERNAL MODULE: ./src/utils/auth.js
var auth = __webpack_require__("TIfe");

// EXTERNAL MODULE: ./src/utils/api.js
var api = __webpack_require__("VsUZ");

// EXTERNAL MODULE: ./node_modules/babel-runtime/regenerator/index.js
var regenerator = __webpack_require__("Xxa5");
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/asyncToGenerator.js
var asyncToGenerator = __webpack_require__("exGp");
var asyncToGenerator_default = /*#__PURE__*/__webpack_require__.n(asyncToGenerator);

// EXTERNAL MODULE: ./node_modules/uuid/v4.js
var v4 = __webpack_require__("DtRx");
var v4_default = /*#__PURE__*/__webpack_require__.n(v4);

// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/util.js
function toBoolean(val) {
  if (val === '') return val;
  return val === 'true' || val == '1';
}
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/ByteStream.js
function ByteStream(data) {
  this.data = data;
  this.pos = 0;
}

// read the next byte off the stream
ByteStream.prototype.readByte = function () {
  return this.data[this.pos++];
};

// look at the next byte in the stream without updating the stream position
ByteStream.prototype.peekByte = function () {
  return this.data[this.pos];
};

// read an array of bytes
ByteStream.prototype.readBytes = function (n) {
  var bytes = new Array(n);
  for (var i = 0; i < n; i++) {
    bytes[i] = this.readByte();
  }
  return bytes;
};

// peek at an array of bytes without updating the stream position
ByteStream.prototype.peekBytes = function (n) {
  var bytes = new Array(n);
  for (var i = 0; i < n; i++) {
    bytes[i] = this.data[this.pos + i];
  }
  return bytes;
};

// read a string from a byte set
ByteStream.prototype.readString = function (len) {
  var str = "";
  for (var i = 0; i < len; i++) {
    str += String.fromCharCode(this.readByte());
  }
  return str;
};

// read a single byte and return an array of bit booleans
ByteStream.prototype.readBitArray = function () {
  var arr = [];
  var bite = this.readByte();
  for (var i = 7; i >= 0; i--) {
    arr.push(!!(bite & 1 << i));
  }
  return arr;
};

// read an unsigned int with endian option
ByteStream.prototype.readUnsigned = function (littleEndian) {
  var a = this.readBytes(2);
  if (littleEndian) {
    return (a[1] << 8) + a[0];
  } else {
    return (a[0] << 8) + a[1];
  }
};

/* harmony default export */ var dist_ByteStream = (ByteStream);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/DataParser.js

function DataParser(data) {
    this.stream = new dist_ByteStream(data);
    // the final parsed object from the data
    this.output = {};
}

DataParser.prototype.parse = function (schema) {
    // the top level schema is just the top level parts array
    this.parseParts(this.output, schema);
    return this.output;
};

// parse a set of hierarchy parts providing the parent object, and the subschema
DataParser.prototype.parseParts = function (obj, schema) {
    for (var i = 0; i < schema.length; i++) {
        var part = schema[i];
        this.parsePart(obj, part);
    }
};

DataParser.prototype.parsePart = function (obj, part) {
    var name = part.label;
    var value;

    // make sure the part meets any parse requirements
    if (part.requires && !part.requires(this.stream, this.output, obj)) {
        return;
    }

    if (part.loop) {
        // create a parse loop over the parts
        var items = [];
        while (part.loop(this.stream)) {
            var item = {};
            this.parseParts(item, part.parts);
            items.push(item);
        }
        obj[name] = items;
    } else if (part.parts) {
        // process any child parts
        value = {};
        this.parseParts(value, part.parts);
        obj[name] = value;
    } else if (part.parser) {
        // parse the value using a parser
        value = part.parser(this.stream, this.output, obj);
        if (!part.skip) {
            obj[name] = value;
        }
    } else if (part.bits) {
        // convert the next byte to a set of bit fields
        obj[name] = this.parseBits(part.bits);
    }
};

// combine bits to calculate value
function bitsToNum(bitArray) {
    return bitArray.reduce(function (s, n) {
        return s * 2 + n;
    }, 0);
}

// parse a byte as a bit set (flags and values)
DataParser.prototype.parseBits = function (details) {
    var out = {};
    var bits = this.stream.readBitArray();
    for (var key in details) {
        var item = details[key];
        if (item.length) {
            // convert the bit set to value
            out[key] = bitsToNum(bits.slice(item.index, item.index + item.length));
        } else {
            out[key] = bits[item.index];
        }
    }
    return out;
};

/* harmony default export */ var dist_DataParser = (DataParser);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/Parsers.js
var Parsers = {
    // read a byte
    readByte: function readByte() {
        return function (stream) {
            return stream.readByte();
        };
    },
    // read an array of bytes
    readBytes: function readBytes(length) {
        return function (stream) {
            return stream.readBytes(length);
        };
    },
    // read a string from bytes
    readString: function readString(length) {
        return function (stream) {
            return stream.readString(length);
        };
    },
    // read an unsigned int (with endian)
    readUnsigned: function readUnsigned(littleEndian) {
        return function (stream) {
            return stream.readUnsigned(littleEndian);
        };
    },
    // read an array of byte sets
    readArray: function readArray(size, countFunc) {
        return function (stream, obj, parent) {
            var count = countFunc(stream, obj, parent);
            var arr = new Array(count);
            for (var i = 0; i < count; i++) {
                arr[i] = stream.readBytes(size);
            }
            return arr;
        };
    }
};

/* harmony default export */ var dist_Parsers = (Parsers);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/schemaGIF.js

// a set of 0x00 terminated subblocks
var subBlocks = {
  label: "blocks",
  parser: function parser(stream) {
    var out = [];
    var terminator = 0x00;
    for (var size = stream.readByte(); size !== terminator; size = stream.readByte()) {
      out = out.concat(stream.readBytes(size));
    }
    return out;
  }
};

// global control extension
var gce = {
  label: "gce",
  requires: function requires(stream) {
    // just peek at the top two bytes, and if true do this
    var codes = stream.peekBytes(2);
    return codes[0] === 0x21 && codes[1] === 0xf9;
  },
  parts: [{ label: "codes", parser: dist_Parsers.readBytes(2), skip: true }, { label: "byteSize", parser: dist_Parsers.readByte() }, {
    label: "extras",
    bits: {
      future: { index: 0, length: 3 },
      disposal: { index: 3, length: 3 },
      userInput: { index: 6 },
      transparentColorGiven: { index: 7 }
    }
  }, { label: "delay", parser: dist_Parsers.readUnsigned(true) }, { label: "transparentColorIndex", parser: dist_Parsers.readByte() }, { label: "terminator", parser: dist_Parsers.readByte(), skip: true }]
};

// image pipeline block
var schemaGIF_image = {
  label: "image",
  requires: function requires(stream) {
    // peek at the next byte
    var code = stream.peekByte();
    return code === 0x2c;
  },
  parts: [{ label: "code", parser: dist_Parsers.readByte(), skip: true }, {
    label: "descriptor", // image descriptor
    parts: [{ label: "left", parser: dist_Parsers.readUnsigned(true) }, { label: "top", parser: dist_Parsers.readUnsigned(true) }, { label: "width", parser: dist_Parsers.readUnsigned(true) }, { label: "height", parser: dist_Parsers.readUnsigned(true) }, {
      label: "lct",
      bits: {
        exists: { index: 0 },
        interlaced: { index: 1 },
        sort: { index: 2 },
        future: { index: 3, length: 2 },
        size: { index: 5, length: 3 }
      }
    }]
  }, {
    label: "lct", // optional local color table
    requires: function requires(stream, obj, parent) {
      return parent.descriptor.lct.exists;
    },
    parser: dist_Parsers.readArray(3, function (stream, obj, parent) {
      return Math.pow(2, parent.descriptor.lct.size + 1);
    })
  }, {
    label: "data", // the image data blocks
    parts: [{ label: "minCodeSize", parser: dist_Parsers.readByte() }, subBlocks]
  }]
};

// plain text block
var schemaGIF_text = {
  label: "text",
  requires: function requires(stream) {
    // just peek at the top two bytes, and if true do this
    var codes = stream.peekBytes(2);
    return codes[0] === 0x21 && codes[1] === 0x01;
  },
  parts: [{ label: "codes", parser: dist_Parsers.readBytes(2), skip: true }, { label: "blockSize", parser: dist_Parsers.readByte() }, {
    label: "preData",
    parser: function parser(stream, obj, parent) {
      return stream.readBytes(parent.text.blockSize);
    }
  }, subBlocks]
};

// application block
var application = {
  label: "application",
  requires: function requires(stream, obj, parent) {
    // make sure this frame doesn't already have a gce, text, comment, or image
    // as that means this block should be attached to the next frame
    //if(parent.gce || parent.text || parent.image || parent.comment){ return false; }

    // peek at the top two bytes
    var codes = stream.peekBytes(2);
    return codes[0] === 0x21 && codes[1] === 0xff;
  },
  parts: [{ label: "codes", parser: dist_Parsers.readBytes(2), skip: true }, { label: "blockSize", parser: dist_Parsers.readByte() }, {
    label: "id",
    parser: function parser(stream, obj, parent) {
      return stream.readString(parent.blockSize);
    }
  }, subBlocks]
};

// comment block
var comment = {
  label: "comment",
  requires: function requires(stream, obj, parent) {
    // make sure this frame doesn't already have a gce, text, comment, or image
    // as that means this block should be attached to the next frame
    //if(parent.gce || parent.text || parent.image || parent.comment){ return false; }

    // peek at the top two bytes
    var codes = stream.peekBytes(2);
    return codes[0] === 0x21 && codes[1] === 0xfe;
  },
  parts: [{ label: "codes", parser: dist_Parsers.readBytes(2), skip: true }, subBlocks]
};

// frames of ext and image data
var schemaGIF_frames = {
  label: "frames",
  parts: [gce, application, comment, schemaGIF_image, schemaGIF_text],
  loop: function loop(stream) {
    var nextCode = stream.peekByte();
    // rather than check for a terminator, we should check for the existence
    // of an ext or image block to avoid infinite loops
    //var terminator = 0x3B;
    //return nextCode !== terminator;
    return nextCode === 0x21 || nextCode === 0x2c;
  }
};

// main GIF schema
var schemaGIF = [{
  label: "header", // gif header
  parts: [{ label: "signature", parser: dist_Parsers.readString(3) }, { label: "version", parser: dist_Parsers.readString(3) }]
}, {
  label: "lsd", // local screen descriptor
  parts: [{ label: "width", parser: dist_Parsers.readUnsigned(true) }, { label: "height", parser: dist_Parsers.readUnsigned(true) }, {
    label: "gct",
    bits: {
      exists: { index: 0 },
      resolution: { index: 1, length: 3 },
      sort: { index: 4 },
      size: { index: 5, length: 3 }
    }
  }, { label: "backgroundColorIndex", parser: dist_Parsers.readByte() }, { label: "pixelAspectRatio", parser: dist_Parsers.readByte() }]
}, {
  label: "gct", // global color table
  requires: function requires(stream, obj) {
    return obj.lsd.gct.exists;
  },
  parser: dist_Parsers.readArray(3, function (stream, obj) {
    return Math.pow(2, obj.lsd.gct.size + 1);
  })
}, schemaGIF_frames // content frames
];
/* harmony default export */ var dist_schemaGIF = (schemaGIF);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/Gif.js


function GIF(arrayBuffer) {
    // convert to byte array
    var byteData = new Uint8Array(arrayBuffer);
    var parser = new dist_DataParser(byteData);
    // parse the data
    this.raw = parser.parse(dist_schemaGIF);

    // set a flag to make sure the gif contains at least one image
    this.raw.hasImages = false;
    for (var f = 0; f < this.raw.frames.length; f++) {
        if (this.raw.frames[f].image) {
            this.raw.hasImages = true;
            break;
        }
    }
}

// process a single gif image frames data, decompressing it using LZW
// if buildPatch is true, the returned image will be a clamped 8 bit image patch
// for use directly with a canvas.
GIF.prototype.decompressFrame = function (index, buildPatch) {

    // make sure a valid frame is requested
    if (index >= this.raw.frames.length) {
        return null;
    }

    var frame = this.raw.frames[index];
    if (frame.image) {
        // get the number of pixels
        var totalPixels = frame.image.descriptor.width * frame.image.descriptor.height;

        // do lzw decompression
        var pixels = lzw(frame.image.data.minCodeSize, frame.image.data.blocks, totalPixels);

        // deal with interlacing if necessary
        if (frame.image.descriptor.lct.interlaced) {
            pixels = deinterlace(pixels, frame.image.descriptor.width);
        }

        // setup usable image object
        var image = {
            pixels: pixels,
            dims: {
                top: frame.image.descriptor.top,
                left: frame.image.descriptor.left,
                width: frame.image.descriptor.width,
                height: frame.image.descriptor.height
            }
        };

        // color table
        if (frame.image.descriptor.lct && frame.image.descriptor.lct.exists) {
            image.colorTable = frame.image.lct;
        } else {
            image.colorTable = this.raw.gct;
        }

        // add per frame relevant gce information
        if (frame.gce) {
            image.delay = (frame.gce.delay || 10) * 10; // convert to ms
            image.disposalType = frame.gce.extras.disposal;
            // transparency
            if (frame.gce.extras.transparentColorGiven) {
                image.transparentIndex = frame.gce.transparentColorIndex;
            }
        }

        // create canvas usable imagedata if desired
        if (buildPatch) {
            image.patch = generatePatch(image);
        }

        return image;
    }

    // frame does not contains image
    return null;

    /**
     * javascript port of java LZW decompression
     * Original java author url: https://gist.github.com/devunwired/4479231
     */
    function lzw(minCodeSize, data, pixelCount) {

        var MAX_STACK_SIZE = 4096;
        var nullCode = -1;

        var npix = pixelCount;
        var available, clear, code_mask, code_size, end_of_information, in_code, old_code, bits, code, i, datum, data_size, first, top, bi, pi;

        var dstPixels = new Array(pixelCount);
        var prefix = new Array(MAX_STACK_SIZE);
        var suffix = new Array(MAX_STACK_SIZE);
        var pixelStack = new Array(MAX_STACK_SIZE + 1);

        // Initialize GIF data stream decoder.
        data_size = minCodeSize;
        clear = 1 << data_size;
        end_of_information = clear + 1;
        available = clear + 2;
        old_code = nullCode;
        code_size = data_size + 1;
        code_mask = (1 << code_size) - 1;
        for (code = 0; code < clear; code++) {
            prefix[code] = 0;
            suffix[code] = code;
        }
        var count = void 0;
        // Decode GIF pixel stream.
        datum = bits = count = first = top = pi = bi = 0;
        for (i = 0; i < npix;) {
            if (top === 0) {
                if (bits < code_size) {

                    // get the next byte
                    datum += data[bi] << bits;

                    bits += 8;
                    bi++;
                    continue;
                }
                // Get the next code.
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                // Interpret the code
                if (code > available || code == end_of_information) {
                    break;
                }
                if (code == clear) {
                    // Reset decoder.
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = nullCode;
                    continue;
                }
                if (old_code == nullCode) {
                    pixelStack[top++] = suffix[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                in_code = code;
                if (code == available) {
                    pixelStack[top++] = first;
                    code = old_code;
                }
                while (code > clear) {
                    pixelStack[top++] = suffix[code];
                    code = prefix[code];
                }

                first = suffix[code] & 0xff;
                pixelStack[top++] = first;

                // add a new string to the table, but only if space is available
                // if not, just continue with current table until a clear code is found
                // (deferred clear code implementation as per GIF spec)
                if (available < MAX_STACK_SIZE) {
                    prefix[available] = old_code;
                    suffix[available] = first;
                    available++;
                    if ((available & code_mask) === 0 && available < MAX_STACK_SIZE) {
                        code_size++;
                        code_mask += available;
                    }
                }
                old_code = in_code;
            }
            // Pop a pixel off the pixel stack.
            top--;
            dstPixels[pi++] = pixelStack[top];
            i++;
        }

        for (i = pi; i < npix; i++) {
            dstPixels[i] = 0; // clear missing pixels
        }

        return dstPixels;
    }

    // deinterlace function from https://github.com/shachaf/jsgif
    function deinterlace(pixels, width) {

        var newPixels = new Array(pixels.length);
        var rows = pixels.length / width;
        var cpRow = function cpRow(toRow, fromRow) {
            var fromPixels = pixels.slice(fromRow * width, (fromRow + 1) * width);
            newPixels.splice.apply(newPixels, [toRow * width, width].concat(fromPixels));
        };

        // See appendix E.
        var offsets = [0, 4, 2, 1];
        var steps = [8, 8, 4, 2];

        var fromRow = 0;
        for (var pass = 0; pass < 4; pass++) {
            for (var toRow = offsets[pass]; toRow < rows; toRow += steps[pass]) {
                cpRow(toRow, fromRow);
                fromRow++;
            }
        }

        return newPixels;
    }

    // create a clamped byte array patch for the frame image to be used directly with a canvas
    // TODO: could potentially squeeze some performance by doing a direct 32bit write per iteration
    function generatePatch(image) {

        var totalPixels = image.pixels.length;
        var patchData = new Uint8ClampedArray(totalPixels * 4);
        for (var i = 0; i < totalPixels; i++) {
            var pos = i * 4;
            var colorIndex = image.pixels[i];
            var color = image.colorTable[colorIndex];
            patchData[pos] = color[0];
            patchData[pos + 1] = color[1];
            patchData[pos + 2] = color[2];
            patchData[pos + 3] = colorIndex !== image.transparentIndex ? 255 : 0;
        }

        return patchData;
    }
};

// returns all frames decompressed
GIF.prototype.decompressFrames = function (buildPatch) {
    var frames = [];
    for (var i = 0; i < this.raw.frames.length; i++) {
        var frame = this.raw.frames[i];
        if (frame.image) {
            frames.push(this.decompressFrame(i, buildPatch));
        }
    }
    return frames;
};

/* harmony default export */ var Gif = (GIF);
// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/typeof.js
var helpers_typeof = __webpack_require__("pFYg");
var typeof_default = /*#__PURE__*/__webpack_require__.n(helpers_typeof);

// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/gifjs.js

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}

EventEmitter.EventEmitter = EventEmitter;
EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;
EventEmitter.defaultMaxListeners = 10;
EventEmitter.prototype.setMaxListeners = function (n) {
  if (!isNumber(n) || n < 0 || isNaN(n)) throw TypeError("n must be a positive number");
  this._maxListeners = n;
  return this;
};
EventEmitter.prototype.emit = function (type) {
  var er, handler, len, args, i, listeners;
  if (!this._events) this._events = {};
  if (type === "error") {
    if (!this._events.error || isObject(this._events.error) && !this._events.error.length) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er;
      } else {
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ")");
        err.context = er;
        throw err;
      }
    }
  }
  handler = this._events[type];
  if (isUndefined(handler)) return false;
  if (isFunction(handler)) {
    switch (arguments.length) {
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++) {
      listeners[i].apply(this, args);
    }
  }
  return true;
};
EventEmitter.prototype.addListener = function (type, listener) {
  var m;
  if (!isFunction(listener)) throw TypeError("listener must be a function");
  if (!this._events) this._events = {};
  if (this._events.newListener) this.emit("newListener", type, isFunction(listener.listener) ? listener.listener : listener);
  if (!this._events[type]) this._events[type] = listener;else if (isObject(this._events[type])) this._events[type].push(listener);else this._events[type] = [this._events[type], listener];
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }
    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error("(node) warning: possible EventEmitter memory " + "leak detected. %d listeners added. " + "Use emitter.setMaxListeners() to increase limit.", this._events[type].length);
      if (typeof console.trace === "function") {
        console.trace();
      }
    }
  }
  return this;
};
EventEmitter.prototype.on = EventEmitter.prototype.addListener;
EventEmitter.prototype.once = function (type, listener) {
  if (!isFunction(listener)) throw TypeError("listener must be a function");
  var fired = false;
  function g() {
    this.removeListener(type, g);
    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }
  g.listener = listener;
  this.on(type, g);
  return this;
};
EventEmitter.prototype.removeListener = function (type, listener) {
  var list, position, length, i;
  if (!isFunction(listener)) throw TypeError("listener must be a function");
  if (!this._events || !this._events[type]) return this;
  list = this._events[type];
  length = list.length;
  position = -1;
  if (list === listener || isFunction(list.listener) && list.listener === listener) {
    delete this._events[type];
    if (this._events.removeListener) this.emit("removeListener", type, listener);
  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener || list[i].listener && list[i].listener === listener) {
        position = i;
        break;
      }
    }
    if (position < 0) return this;
    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }
    if (this._events.removeListener) this.emit("removeListener", type, listener);
  }
  return this;
};
EventEmitter.prototype.removeAllListeners = function (type) {
  var key, listeners;
  if (!this._events) return this;
  if (!this._events.removeListener) {
    if (arguments.length === 0) this._events = {};else if (this._events[type]) delete this._events[type];
    return this;
  }
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === "removeListener") continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners("removeListener");
    this._events = {};
    return this;
  }
  listeners = this._events[type];
  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    while (listeners.length) {
      this.removeListener(type, listeners[listeners.length - 1]);
    }
  }
  delete this._events[type];
  return this;
};
EventEmitter.prototype.listeners = function (type) {
  var ret;
  if (!this._events || !this._events[type]) ret = [];else if (isFunction(this._events[type])) ret = [this._events[type]];else ret = this._events[type].slice();
  return ret;
};
EventEmitter.prototype.listenerCount = function (type) {
  if (this._events) {
    var evlistener = this._events[type];
    if (isFunction(evlistener)) return 1;else if (evlistener) return evlistener.length;
  }
  return 0;
};
EventEmitter.listenerCount = function (emitter, type) {
  return emitter.listenerCount(type);
};
function isFunction(arg) {
  return typeof arg === "function";
}
function isNumber(arg) {
  return typeof arg === "number";
}
function isObject(arg) {
  return (typeof arg === "undefined" ? "undefined" : typeof_default()(arg)) === "object" && arg !== null;
}
function isUndefined(arg) {
  return arg === void 0;
}

var UA, browser, mode, platform, ua;
ua = navigator.userAgent.toLowerCase();
platform = navigator.platform.toLowerCase();
UA = ua.match(/(opera|ie|firefox|chrome|version)[\s\/:]([\w\d\.]+)?.*?(safari|version[\s\/:]([\w\d\.]+)|$)/) || [null, "unknown", 0];
mode = UA[1] === "ie" && document.documentMode;
browser = {
  name: UA[1] === "version" ? UA[3] : UA[1],
  version: mode || parseFloat(UA[1] === "opera" && UA[4] ? UA[4] : UA[2]),
  platform: {
    name: ua.match(/ip(?:ad|od|hone)/) ? "ios" : (ua.match(/(?:webos|android)/) || platform.match(/mac|win|linux/) || ["other"])[0]
  }
};
browser[browser.name] = true;
browser[browser.name + parseInt(browser.version, 10)] = true;
browser.platform[browser.platform.name] = true;

var extend = function extend(child, parent) {
  for (var key in parent) {
    if (hasProp.call(parent, key)) child[key] = parent[key];
  }
  function ctor() {
    this.constructor = child;
  }
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();
  child.__super__ = parent.prototype;
  return child;
},
    hasProp = {}.hasOwnProperty,
    indexOf = [].indexOf || function (item) {
  for (var i = 0, l = this.length; i < l; i++) {
    if (i in this && this[i] === item) return i;
  }
  return -1;
},
    slice = [].slice;
var gifjs_GIF = function (superClass) {
  var defaults, frameDefaults;
  extend(GIF, superClass);
  var gifWorker = __webpack_require__("Nekn");

  defaults = {
    workerScript: gifWorker,
    workers: 2,
    repeat: 0,
    background: "#fff",
    quality: 10,
    width: null,
    height: null,
    transparent: null,
    debug: false,
    dither: false
  };

  frameDefaults = { delay: 500, copy: false };
  function GIF(options) {
    var base, key, value;
    this.running = false;
    this.options = {};
    this.frames = [];
    this.freeWorkers = [];
    this.activeWorkers = [];
    this.setOptions(options);
    for (key in defaults) {
      value = defaults[key];
      if ((base = this.options)[key] == null) {
        base[key] = value;
      }
    }
  }
  GIF.prototype.setOption = function (key, value) {
    this.options[key] = value;
    if (this._canvas != null && (key === "width" || key === "height")) {
      return this._canvas[key] = value;
    }
  };
  GIF.prototype.setOptions = function (options) {
    var key, results, value;
    results = [];
    for (key in options) {
      if (!hasProp.call(options, key)) continue;
      value = options[key];
      results.push(this.setOption(key, value));
    }
    return results;
  };
  GIF.prototype.addFrame = function (image, options) {
    var frame, key;
    if (options == null) {
      options = {};
    }
    frame = {};
    frame.transparent = this.options.transparent;
    for (key in frameDefaults) {
      frame[key] = options[key] || frameDefaults[key];
    }
    if (this.options.width == null) {
      this.setOption("width", image.width);
    }
    if (this.options.height == null) {
      this.setOption("height", image.height);
    }
    if (typeof ImageData !== "undefined" && ImageData !== null && image instanceof ImageData) {
      frame.data = image.data;
    } else if (typeof CanvasRenderingContext2D !== "undefined" && CanvasRenderingContext2D !== null && image instanceof CanvasRenderingContext2D || typeof WebGLRenderingContext !== "undefined" && WebGLRenderingContext !== null && image instanceof WebGLRenderingContext) {
      if (options.copy) {
        frame.data = this.getContextData(image);
      } else {
        frame.context = image;
      }
    } else if (image.childNodes != null) {
      if (options.copy) {
        frame.data = this.getImageData(image);
      } else {
        frame.image = image;
      }
    } else {
      throw new Error("Invalid image");
    }
    return this.frames.push(frame);
  };
  GIF.prototype.render = function () {
    var i, j, numWorkers, ref;
    if (this.running) {
      throw new Error("Already running");
    }
    if (this.options.width == null || this.options.height == null) {
      throw new Error("Width and height must be set prior to rendering");
    }
    this.running = true;
    this.nextFrame = 0;
    this.finishedFrames = 0;
    this.imageParts = function () {
      var j, ref, results;
      results = [];
      for (i = j = 0, ref = this.frames.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        results.push(null);
      }
      return results;
    }.call(this);
    numWorkers = this.spawnWorkers();
    if (this.options.globalPalette === true) {
      this.renderNextFrame();
    } else {
      for (i = j = 0, ref = numWorkers; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        this.renderNextFrame();
      }
    }
    this.emit("start");
    return this.emit("progress", 0);
  };
  GIF.prototype.abort = function () {
    var worker;
    while (true) {
      worker = this.activeWorkers.shift();
      if (worker == null) {
        break;
      }
      this.log("killing active worker");
      worker.terminate();
    }
    this.running = false;
    return this.emit("abort");
  };
  GIF.prototype.spawnWorkers = function () {
    var j, numWorkers, ref, results;
    numWorkers = Math.min(this.options.workers, this.frames.length);
    (function () {
      results = [];
      for (var j = ref = this.freeWorkers.length; ref <= numWorkers ? j < numWorkers : j > numWorkers; ref <= numWorkers ? j++ : j--) {
        results.push(j);
      }
      return results;
    }).apply(this).forEach(function (_this) {
      return function (i) {
        var worker;
        _this.log("spawning worker " + i);
        var Worker = __webpack_require__("Nekn");
        worker = new Worker();
        // worker = new Worker(_this.options.workerScript);
        worker.onmessage = function (event) {
          _this.activeWorkers.splice(_this.activeWorkers.indexOf(worker), 1);
          _this.freeWorkers.push(worker);
          return _this.frameFinished(event.data);
        };
        return _this.freeWorkers.push(worker);
      };
    }(this));
    return numWorkers;
  };
  GIF.prototype.frameFinished = function (frame) {
    var i, j, ref;
    this.log("frame " + frame.index + " finished - " + this.activeWorkers.length + " active");
    this.finishedFrames++;
    this.emit("progress", this.finishedFrames / this.frames.length);
    this.imageParts[frame.index] = frame;
    if (this.options.globalPalette === true) {
      this.options.globalPalette = frame.globalPalette;
      this.log("global palette analyzed");
      if (this.frames.length > 2) {
        for (i = j = 1, ref = this.freeWorkers.length; 1 <= ref ? j < ref : j > ref; i = 1 <= ref ? ++j : --j) {
          this.renderNextFrame();
        }
      }
    }
    if (indexOf.call(this.imageParts, null) >= 0) {
      return this.renderNextFrame();
    } else {
      return this.finishRendering();
    }
  };
  GIF.prototype.finishRendering = function () {
    var data, frame, i, image, j, k, l, len, len1, len2, len3, offset, page, ref, ref1, ref2;
    len = 0;
    ref = this.imageParts;
    for (j = 0, len1 = ref.length; j < len1; j++) {
      frame = ref[j];
      len += (frame.data.length - 1) * frame.pageSize + frame.cursor;
    }
    len += frame.pageSize - frame.cursor;
    this.log("rendering finished - filesize " + Math.round(len / 1e3) + "kb");
    data = new Uint8Array(len);
    offset = 0;
    ref1 = this.imageParts;
    for (k = 0, len2 = ref1.length; k < len2; k++) {
      frame = ref1[k];
      ref2 = frame.data;
      for (i = l = 0, len3 = ref2.length; l < len3; i = ++l) {
        page = ref2[i];
        data.set(page, offset);
        if (i === frame.data.length - 1) {
          offset += frame.cursor;
        } else {
          offset += frame.pageSize;
        }
      }
    }
    image = new Blob([data], { type: "image/gif" });
    return this.emit("finished", image, data);
  };
  GIF.prototype.renderNextFrame = function () {
    var frame, task, worker;
    if (this.freeWorkers.length === 0) {
      throw new Error("No free workers");
    }
    if (this.nextFrame >= this.frames.length) {
      return;
    }
    frame = this.frames[this.nextFrame++];
    worker = this.freeWorkers.shift();
    task = this.getTask(frame);
    this.log("starting frame " + (task.index + 1) + " of " + this.frames.length);
    this.activeWorkers.push(worker);
    return worker.postMessage(task);
  };
  GIF.prototype.getContextData = function (ctx) {
    return ctx.getImageData(0, 0, this.options.width, this.options.height).data;
  };
  GIF.prototype.getImageData = function (image) {
    var ctx;
    if (this._canvas == null) {
      this._canvas = document.createElement("canvas");
      this._canvas.width = this.options.width;
      this._canvas.height = this.options.height;
    }
    ctx = this._canvas.getContext("2d");
    ctx.setFill = this.options.background;
    ctx.fillRect(0, 0, this.options.width, this.options.height);
    ctx.drawImage(image, 0, 0);
    return this.getContextData(ctx);
  };
  GIF.prototype.getTask = function (frame) {
    var index, task;
    index = this.frames.indexOf(frame);
    task = {
      index: index,
      last: index === this.frames.length - 1,
      delay: frame.delay,
      transparent: frame.transparent,
      width: this.options.width,
      height: this.options.height,
      quality: this.options.quality,
      dither: this.options.dither,
      globalPalette: this.options.globalPalette,
      repeat: this.options.repeat,
      canTransfer: browser.name === "chrome"
    };
    if (frame.data != null) {
      task.data = frame.data;
    } else if (frame.context != null) {
      task.data = this.getContextData(frame.context);
    } else if (frame.image != null) {
      task.data = this.getImageData(frame.image);
    } else {
      throw new Error("Invalid frame");
    }
    return task;
  };
  GIF.prototype.log = function () {
    var args;
    args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
    if (!this.options.debug) {
      return;
    }
    return console.log.apply(console, args);
  };
  return GIF;
}(EventEmitter);

/* harmony default export */ var gifjs = (gifjs_GIF);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/awesome-qr.js


var AwesomeQRCode;

function QR8bitByte(data) {
  this.mode = QRMode.MODE_8BIT_BYTE;
  this.data = data;
  this.parsedData = [];
  for (var i = 0, l = this.data.length; i < l; i++) {
    var byteArray = [];
    var code = this.data.charCodeAt(i);
    if (code > 0x10000) {
      byteArray[0] = 0xf0 | (code & 0x1c0000) >>> 18;
      byteArray[1] = 0x80 | (code & 0x3f000) >>> 12;
      byteArray[2] = 0x80 | (code & 0xfc0) >>> 6;
      byteArray[3] = 0x80 | code & 0x3f;
    } else if (code > 0x800) {
      byteArray[0] = 0xe0 | (code & 0xf000) >>> 12;
      byteArray[1] = 0x80 | (code & 0xfc0) >>> 6;
      byteArray[2] = 0x80 | code & 0x3f;
    } else if (code > 0x80) {
      byteArray[0] = 0xc0 | (code & 0x7c0) >>> 6;
      byteArray[1] = 0x80 | code & 0x3f;
    } else {
      byteArray[0] = code;
    }
    this.parsedData.push(byteArray);
  }
  this.parsedData = Array.prototype.concat.apply([], this.parsedData);
  if (this.parsedData.length != this.data.length) {
    this.parsedData.unshift(191);
    this.parsedData.unshift(187);
    this.parsedData.unshift(239);
  }
}

QR8bitByte.prototype = {
  getLength: function getLength(buffer) {
    return this.parsedData.length;
  },
  write: function write(buffer) {
    for (var i = 0, l = this.parsedData.length; i < l; i++) {
      buffer.put(this.parsedData[i], 8);
    }
  }
};

function QRCodeModel(typeNumber, errorCorrectLevel) {
  this.typeNumber = typeNumber;
  this.errorCorrectLevel = errorCorrectLevel;
  this.modules = null;
  this.moduleCount = 0;
  this.dataCache = null;
  this.dataList = [];
}

QRCodeModel.prototype = {
  addData: function addData(data) {
    var newData = new QR8bitByte(data);
    this.dataList.push(newData);
    this.dataCache = null;
  },
  isDark: function isDark(row, col) {
    if (row < 0 || this.moduleCount <= row || col < 0 || this.moduleCount <= col) {
      throw new Error(row + "," + col);
    }
    return this.modules[row][col];
  },
  getModuleCount: function getModuleCount() {
    return this.moduleCount;
  },
  make: function make() {
    /////////////////////////////////////////////
    if (this.typeNumber < 1) {
      var typeNumber = 1;
      for (typeNumber = 1; typeNumber < 40; typeNumber++) {
        var rsBlocks = QRRSBlock.getRSBlocks(typeNumber, this.errorCorrectLevel);

        var buffer = new QRBitBuffer();
        var totalDataCount = 0;
        for (var i = 0; i < rsBlocks.length; i++) {
          totalDataCount += rsBlocks[i].dataCount;
        }

        for (var i = 0; i < this.dataList.length; i++) {
          var data = this.dataList[i];
          buffer.put(data.mode, 4);
          buffer.put(data.getLength(), QRUtil.getLengthInBits(data.mode, typeNumber));
          data.write(buffer);
        }
        if (buffer.getLengthInBits() <= totalDataCount * 8) break;
      }
      this.typeNumber = typeNumber;
    }
    /////////////////////////////////////////////
    this.makeImpl(!1, this.getBestMaskPattern());
  },
  makeImpl: function makeImpl(test, maskPattern) {
    this.moduleCount = this.typeNumber * 4 + 17;
    this.modules = new Array(this.moduleCount);
    for (var row = 0; row < this.moduleCount; row++) {
      this.modules[row] = new Array(this.moduleCount);
      for (var col = 0; col < this.moduleCount; col++) {
        this.modules[row][col] = null;
      }
    }
    this.setupPositionProbePattern(0, 0);
    this.setupPositionProbePattern(this.moduleCount - 7, 0);
    this.setupPositionProbePattern(0, this.moduleCount - 7);
    this.setupPositionAdjustPattern();
    this.setupTimingPattern();
    this.setupTypeInfo(test, maskPattern);
    if (this.typeNumber >= 7) {
      this.setupTypeNumber(test);
    }
    if (this.dataCache == null) {
      this.dataCache = QRCodeModel.createData(this.typeNumber, this.errorCorrectLevel, this.dataList);
    }
    this.mapData(this.dataCache, maskPattern);
  },
  setupPositionProbePattern: function setupPositionProbePattern(row, col) {
    for (var r = -1; r <= 7; r++) {
      if (row + r <= -1 || this.moduleCount <= row + r) continue;
      for (var c = -1; c <= 7; c++) {
        if (col + c <= -1 || this.moduleCount <= col + c) continue;
        if (0 <= r && r <= 6 && (c == 0 || c == 6) || 0 <= c && c <= 6 && (r == 0 || r == 6) || 2 <= r && r <= 4 && 2 <= c && c <= 4) {
          this.modules[row + r][col + c] = !0;
        } else {
          this.modules[row + r][col + c] = !1;
        }
      }
    }
  },
  getBestMaskPattern: function getBestMaskPattern() {
    var minLostPoint = 0;
    var pattern = 0;
    for (var i = 0; i < 8; i++) {
      this.makeImpl(!0, i);
      var lostPoint = QRUtil.getLostPoint(this);
      if (i == 0 || minLostPoint > lostPoint) {
        minLostPoint = lostPoint;
        pattern = i;
      }
    }
    return pattern;
  },
  createMovieClip: function createMovieClip(target_mc, instance_name, depth) {
    var qr_mc = target_mc.createEmptyMovieClip(instance_name, depth);
    var cs = 1;
    this.make();
    for (var row = 0; row < this.modules.length; row++) {
      var y = row * cs;
      for (var col = 0; col < this.modules[row].length; col++) {
        var x = col * cs;
        var dark = this.modules[row][col];
        if (dark) {
          qr_mc.beginFill(0, 100);
          qr_mc.moveTo(x, y);
          qr_mc.lineTo(x + cs, y);
          qr_mc.lineTo(x + cs, y + cs);
          qr_mc.lineTo(x, y + cs);
          qr_mc.endFill();
        }
      }
    }
    return qr_mc;
  },
  setupTimingPattern: function setupTimingPattern() {
    for (var r = 8; r < this.moduleCount - 8; r++) {
      if (this.modules[r][6] != null) {
        continue;
      }
      this.modules[r][6] = r % 2 == 0;
    }
    for (var c = 8; c < this.moduleCount - 8; c++) {
      if (this.modules[6][c] != null) {
        continue;
      }
      this.modules[6][c] = c % 2 == 0;
    }
  },
  setupPositionAdjustPattern: function setupPositionAdjustPattern() {
    var pos = QRUtil.getPatternPosition(this.typeNumber);
    for (var i = 0; i < pos.length; i++) {
      for (var j = 0; j < pos.length; j++) {
        var row = pos[i];
        var col = pos[j];
        if (this.modules[row][col] != null) {
          continue;
        }
        for (var r = -2; r <= 2; r++) {
          for (var c = -2; c <= 2; c++) {
            if (r == -2 || r == 2 || c == -2 || c == 2 || r == 0 && c == 0) {
              this.modules[row + r][col + c] = !0;
            } else {
              this.modules[row + r][col + c] = !1;
            }
          }
        }
      }
    }
  },
  setupTypeNumber: function setupTypeNumber(test) {
    var bits = QRUtil.getBCHTypeNumber(this.typeNumber);
    for (var i = 0; i < 18; i++) {
      var mod = !test && (bits >> i & 1) == 1;
      this.modules[Math.floor(i / 3)][i % 3 + this.moduleCount - 8 - 3] = mod;
    }
    for (var i = 0; i < 18; i++) {
      var mod = !test && (bits >> i & 1) == 1;
      this.modules[i % 3 + this.moduleCount - 8 - 3][Math.floor(i / 3)] = mod;
    }
  },
  setupTypeInfo: function setupTypeInfo(test, maskPattern) {
    var data = this.errorCorrectLevel << 3 | maskPattern;
    var bits = QRUtil.getBCHTypeInfo(data);
    for (var i = 0; i < 15; i++) {
      var mod = !test && (bits >> i & 1) == 1;
      if (i < 6) {
        this.modules[i][8] = mod;
      } else if (i < 8) {
        this.modules[i + 1][8] = mod;
      } else {
        this.modules[this.moduleCount - 15 + i][8] = mod;
      }
    }
    for (var i = 0; i < 15; i++) {
      var mod = !test && (bits >> i & 1) == 1;
      if (i < 8) {
        this.modules[8][this.moduleCount - i - 1] = mod;
      } else if (i < 9) {
        this.modules[8][15 - i - 1 + 1] = mod;
      } else {
        this.modules[8][15 - i - 1] = mod;
      }
    }
    this.modules[this.moduleCount - 8][8] = !test;
  },
  mapData: function mapData(data, maskPattern) {
    var inc = -1;
    var row = this.moduleCount - 1;
    var bitIndex = 7;
    var byteIndex = 0;
    for (var col = this.moduleCount - 1; col > 0; col -= 2) {
      if (col == 6) col--;
      while (!0) {
        for (var c = 0; c < 2; c++) {
          if (this.modules[row][col - c] == null) {
            var dark = !1;
            if (byteIndex < data.length) {
              dark = (data[byteIndex] >>> bitIndex & 1) == 1;
            }
            var mask = QRUtil.getMask(maskPattern, row, col - c);
            if (mask) {
              dark = !dark;
            }
            this.modules[row][col - c] = dark;
            bitIndex--;
            if (bitIndex == -1) {
              byteIndex++;
              bitIndex = 7;
            }
          }
        }
        row += inc;
        if (row < 0 || this.moduleCount <= row) {
          row -= inc;
          inc = -inc;
          break;
        }
      }
    }
  }
};
QRCodeModel.PAD0 = 0xec;
QRCodeModel.PAD1 = 0x11;
QRCodeModel.createData = function (typeNumber, errorCorrectLevel, dataList) {
  var rsBlocks = QRRSBlock.getRSBlocks(typeNumber, errorCorrectLevel);
  var buffer = new QRBitBuffer();
  for (var i = 0; i < dataList.length; i++) {
    var data = dataList[i];
    buffer.put(data.mode, 4);
    buffer.put(data.getLength(), QRUtil.getLengthInBits(data.mode, typeNumber));
    data.write(buffer);
  }
  var totalDataCount = 0;
  for (var i = 0; i < rsBlocks.length; i++) {
    totalDataCount += rsBlocks[i].dataCount;
  }
  if (buffer.getLengthInBits() > totalDataCount * 8) {
    throw new Error("code length overflow. (" + buffer.getLengthInBits() + ">" + totalDataCount * 8 + ")");
  }
  if (buffer.getLengthInBits() + 4 <= totalDataCount * 8) {
    buffer.put(0, 4);
  }
  while (buffer.getLengthInBits() % 8 != 0) {
    buffer.putBit(!1);
  }
  while (!0) {
    if (buffer.getLengthInBits() >= totalDataCount * 8) {
      break;
    }
    buffer.put(QRCodeModel.PAD0, 8);
    if (buffer.getLengthInBits() >= totalDataCount * 8) {
      break;
    }
    buffer.put(QRCodeModel.PAD1, 8);
  }
  return QRCodeModel.createBytes(buffer, rsBlocks);
};
QRCodeModel.createBytes = function (buffer, rsBlocks) {
  var offset = 0;
  var maxDcCount = 0;
  var maxEcCount = 0;
  var dcdata = new Array(rsBlocks.length);
  var ecdata = new Array(rsBlocks.length);
  for (var r = 0; r < rsBlocks.length; r++) {
    var dcCount = rsBlocks[r].dataCount;
    var ecCount = rsBlocks[r].totalCount - dcCount;
    maxDcCount = Math.max(maxDcCount, dcCount);
    maxEcCount = Math.max(maxEcCount, ecCount);
    dcdata[r] = new Array(dcCount);
    for (var i = 0; i < dcdata[r].length; i++) {
      dcdata[r][i] = 0xff & buffer.buffer[i + offset];
    }
    offset += dcCount;
    var rsPoly = QRUtil.getErrorCorrectPolynomial(ecCount);
    var rawPoly = new QRPolynomial(dcdata[r], rsPoly.getLength() - 1);
    var modPoly = rawPoly.mod(rsPoly);
    ecdata[r] = new Array(rsPoly.getLength() - 1);
    for (var i = 0; i < ecdata[r].length; i++) {
      var modIndex = i + modPoly.getLength() - ecdata[r].length;
      ecdata[r][i] = modIndex >= 0 ? modPoly.get(modIndex) : 0;
    }
  }
  var totalCodeCount = 0;
  for (var i = 0; i < rsBlocks.length; i++) {
    totalCodeCount += rsBlocks[i].totalCount;
  }
  var data = new Array(totalCodeCount);
  var index = 0;
  for (var i = 0; i < maxDcCount; i++) {
    for (var r = 0; r < rsBlocks.length; r++) {
      if (i < dcdata[r].length) {
        data[index++] = dcdata[r][i];
      }
    }
  }
  for (var i = 0; i < maxEcCount; i++) {
    for (var r = 0; r < rsBlocks.length; r++) {
      if (i < ecdata[r].length) {
        data[index++] = ecdata[r][i];
      }
    }
  }
  return data;
};
var QRMode = {
  MODE_NUMBER: 1 << 0,
  MODE_ALPHA_NUM: 1 << 1,
  MODE_8BIT_BYTE: 1 << 2,
  MODE_KANJI: 1 << 3
};
var QRErrorCorrectLevel = { L: 1, M: 0, Q: 3, H: 2 };
var QRMaskPattern = {
  PATTERN000: 0,
  PATTERN001: 1,
  PATTERN010: 2,
  PATTERN011: 3,
  PATTERN100: 4,
  PATTERN101: 5,
  PATTERN110: 6,
  PATTERN111: 7
};
var QRUtil = {
  PATTERN_POSITION_TABLE: [[], [6, 18], [6, 22], [6, 26], [6, 30], [6, 34], [6, 22, 38], [6, 24, 42], [6, 26, 46], [6, 28, 50], [6, 30, 54], [6, 32, 58], [6, 34, 62], [6, 26, 46, 66], [6, 26, 48, 70], [6, 26, 50, 74], [6, 30, 54, 78], [6, 30, 56, 82], [6, 30, 58, 86], [6, 34, 62, 90], [6, 28, 50, 72, 94], [6, 26, 50, 74, 98], [6, 30, 54, 78, 102], [6, 28, 54, 80, 106], [6, 32, 58, 84, 110], [6, 30, 58, 86, 114], [6, 34, 62, 90, 118], [6, 26, 50, 74, 98, 122], [6, 30, 54, 78, 102, 126], [6, 26, 52, 78, 104, 130], [6, 30, 56, 82, 108, 134], [6, 34, 60, 86, 112, 138], [6, 30, 58, 86, 114, 142], [6, 34, 62, 90, 118, 146], [6, 30, 54, 78, 102, 126, 150], [6, 24, 50, 76, 102, 128, 154], [6, 28, 54, 80, 106, 132, 158], [6, 32, 58, 84, 110, 136, 162], [6, 26, 54, 82, 110, 138, 166], [6, 30, 58, 86, 114, 142, 170]],
  G15: 1 << 10 | 1 << 8 | 1 << 5 | 1 << 4 | 1 << 2 | 1 << 1 | 1 << 0,
  G18: 1 << 12 | 1 << 11 | 1 << 10 | 1 << 9 | 1 << 8 | 1 << 5 | 1 << 2 | 1 << 0,
  G15_MASK: 1 << 14 | 1 << 12 | 1 << 10 | 1 << 4 | 1 << 1,
  getBCHTypeInfo: function getBCHTypeInfo(data) {
    var d = data << 10;
    while (QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(QRUtil.G15) >= 0) {
      d ^= QRUtil.G15 << QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(QRUtil.G15);
    }
    return (data << 10 | d) ^ QRUtil.G15_MASK;
  },
  getBCHTypeNumber: function getBCHTypeNumber(data) {
    var d = data << 12;
    while (QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(QRUtil.G18) >= 0) {
      d ^= QRUtil.G18 << QRUtil.getBCHDigit(d) - QRUtil.getBCHDigit(QRUtil.G18);
    }
    return data << 12 | d;
  },
  getBCHDigit: function getBCHDigit(data) {
    var digit = 0;
    while (data != 0) {
      digit++;
      data >>>= 1;
    }
    return digit;
  },
  getPatternPosition: function getPatternPosition(typeNumber) {
    return QRUtil.PATTERN_POSITION_TABLE[typeNumber - 1];
  },
  getMask: function getMask(maskPattern, i, j) {
    switch (maskPattern) {
      case QRMaskPattern.PATTERN000:
        return (i + j) % 2 == 0;
      case QRMaskPattern.PATTERN001:
        return i % 2 == 0;
      case QRMaskPattern.PATTERN010:
        return j % 3 == 0;
      case QRMaskPattern.PATTERN011:
        return (i + j) % 3 == 0;
      case QRMaskPattern.PATTERN100:
        return (Math.floor(i / 2) + Math.floor(j / 3)) % 2 == 0;
      case QRMaskPattern.PATTERN101:
        return i * j % 2 + i * j % 3 == 0;
      case QRMaskPattern.PATTERN110:
        return (i * j % 2 + i * j % 3) % 2 == 0;
      case QRMaskPattern.PATTERN111:
        return (i * j % 3 + (i + j) % 2) % 2 == 0;
      default:
        throw new Error("bad maskPattern:" + maskPattern);
    }
  },
  getErrorCorrectPolynomial: function getErrorCorrectPolynomial(errorCorrectLength) {
    var a = new QRPolynomial([1], 0);
    for (var i = 0; i < errorCorrectLength; i++) {
      a = a.multiply(new QRPolynomial([1, QRMath.gexp(i)], 0));
    }
    return a;
  },
  getLengthInBits: function getLengthInBits(mode, type) {
    if (1 <= type && type < 10) {
      switch (mode) {
        case QRMode.MODE_NUMBER:
          return 10;
        case QRMode.MODE_ALPHA_NUM:
          return 9;
        case QRMode.MODE_8BIT_BYTE:
          return 8;
        case QRMode.MODE_KANJI:
          return 8;
        default:
          throw new Error("mode:" + mode);
      }
    } else if (type < 27) {
      switch (mode) {
        case QRMode.MODE_NUMBER:
          return 12;
        case QRMode.MODE_ALPHA_NUM:
          return 11;
        case QRMode.MODE_8BIT_BYTE:
          return 16;
        case QRMode.MODE_KANJI:
          return 10;
        default:
          throw new Error("mode:" + mode);
      }
    } else if (type < 41) {
      switch (mode) {
        case QRMode.MODE_NUMBER:
          return 14;
        case QRMode.MODE_ALPHA_NUM:
          return 13;
        case QRMode.MODE_8BIT_BYTE:
          return 16;
        case QRMode.MODE_KANJI:
          return 12;
        default:
          throw new Error("mode:" + mode);
      }
    } else {
      throw new Error("type:" + type);
    }
  },
  getLostPoint: function getLostPoint(qrCode) {
    var moduleCount = qrCode.getModuleCount();
    var lostPoint = 0;
    for (var row = 0; row < moduleCount; row++) {
      for (var col = 0; col < moduleCount; col++) {
        var sameCount = 0;
        var dark = qrCode.isDark(row, col);
        for (var r = -1; r <= 1; r++) {
          if (row + r < 0 || moduleCount <= row + r) {
            continue;
          }
          for (var c = -1; c <= 1; c++) {
            if (col + c < 0 || moduleCount <= col + c) {
              continue;
            }
            if (r == 0 && c == 0) {
              continue;
            }
            if (dark == qrCode.isDark(row + r, col + c)) {
              sameCount++;
            }
          }
        }
        if (sameCount > 5) {
          lostPoint += 3 + sameCount - 5;
        }
      }
    }
    for (var row = 0; row < moduleCount - 1; row++) {
      for (var col = 0; col < moduleCount - 1; col++) {
        var count = 0;
        if (qrCode.isDark(row, col)) count++;
        if (qrCode.isDark(row + 1, col)) count++;
        if (qrCode.isDark(row, col + 1)) count++;
        if (qrCode.isDark(row + 1, col + 1)) count++;
        if (count == 0 || count == 4) {
          lostPoint += 3;
        }
      }
    }
    for (var row = 0; row < moduleCount; row++) {
      for (var col = 0; col < moduleCount - 6; col++) {
        if (qrCode.isDark(row, col) && !qrCode.isDark(row, col + 1) && qrCode.isDark(row, col + 2) && qrCode.isDark(row, col + 3) && qrCode.isDark(row, col + 4) && !qrCode.isDark(row, col + 5) && qrCode.isDark(row, col + 6)) {
          lostPoint += 40;
        }
      }
    }
    for (var col = 0; col < moduleCount; col++) {
      for (var row = 0; row < moduleCount - 6; row++) {
        if (qrCode.isDark(row, col) && !qrCode.isDark(row + 1, col) && qrCode.isDark(row + 2, col) && qrCode.isDark(row + 3, col) && qrCode.isDark(row + 4, col) && !qrCode.isDark(row + 5, col) && qrCode.isDark(row + 6, col)) {
          lostPoint += 40;
        }
      }
    }
    var darkCount = 0;
    for (var col = 0; col < moduleCount; col++) {
      for (var row = 0; row < moduleCount; row++) {
        if (qrCode.isDark(row, col)) {
          darkCount++;
        }
      }
    }
    var ratio = Math.abs(100 * darkCount / moduleCount / moduleCount - 50) / 5;
    lostPoint += ratio * 10;
    return lostPoint;
  }
};
var QRMath = {
  glog: function glog(n) {
    if (n < 1) {
      throw new Error("glog(" + n + ")");
    }
    return QRMath.LOG_TABLE[n];
  },
  gexp: function gexp(n) {
    while (n < 0) {
      n += 255;
    }
    while (n >= 256) {
      n -= 255;
    }
    return QRMath.EXP_TABLE[n];
  },
  EXP_TABLE: new Array(256),
  LOG_TABLE: new Array(256)
};
for (var awesome_qr_i = 0; awesome_qr_i < 8; awesome_qr_i++) {
  QRMath.EXP_TABLE[awesome_qr_i] = 1 << awesome_qr_i;
}
for (var awesome_qr_i = 8; awesome_qr_i < 256; awesome_qr_i++) {
  QRMath.EXP_TABLE[awesome_qr_i] = QRMath.EXP_TABLE[awesome_qr_i - 4] ^ QRMath.EXP_TABLE[awesome_qr_i - 5] ^ QRMath.EXP_TABLE[awesome_qr_i - 6] ^ QRMath.EXP_TABLE[awesome_qr_i - 8];
}
for (var awesome_qr_i = 0; awesome_qr_i < 255; awesome_qr_i++) {
  QRMath.LOG_TABLE[QRMath.EXP_TABLE[awesome_qr_i]] = awesome_qr_i;
}

function QRPolynomial(num, shift) {
  if (num.length == undefined) {
    throw new Error(num.length + "/" + shift);
  }
  var offset = 0;
  while (offset < num.length && num[offset] == 0) {
    offset++;
  }
  this.num = new Array(num.length - offset + shift);
  for (var i = 0; i < num.length - offset; i++) {
    this.num[i] = num[i + offset];
  }
}

QRPolynomial.prototype = {
  get: function get(index) {
    return this.num[index];
  },
  getLength: function getLength() {
    return this.num.length;
  },
  multiply: function multiply(e) {
    var num = new Array(this.getLength() + e.getLength() - 1);
    for (var i = 0; i < this.getLength(); i++) {
      for (var j = 0; j < e.getLength(); j++) {
        num[i + j] ^= QRMath.gexp(QRMath.glog(this.get(i)) + QRMath.glog(e.get(j)));
      }
    }
    return new QRPolynomial(num, 0);
  },
  mod: function mod(e) {
    if (this.getLength() - e.getLength() < 0) {
      return this;
    }
    var ratio = QRMath.glog(this.get(0)) - QRMath.glog(e.get(0));
    var num = new Array(this.getLength());
    for (var i = 0; i < this.getLength(); i++) {
      num[i] = this.get(i);
    }
    for (var i = 0; i < e.getLength(); i++) {
      num[i] ^= QRMath.gexp(QRMath.glog(e.get(i)) + ratio);
    }
    return new QRPolynomial(num, 0).mod(e);
  }
};

function QRRSBlock(totalCount, dataCount) {
  this.totalCount = totalCount;
  this.dataCount = dataCount;
}

QRRSBlock.RS_BLOCK_TABLE = [[1, 26, 19], [1, 26, 16], [1, 26, 13], [1, 26, 9], [1, 44, 34], [1, 44, 28], [1, 44, 22], [1, 44, 16], [1, 70, 55], [1, 70, 44], [2, 35, 17], [2, 35, 13], [1, 100, 80], [2, 50, 32], [2, 50, 24], [4, 25, 9], [1, 134, 108], [2, 67, 43], [2, 33, 15, 2, 34, 16], [2, 33, 11, 2, 34, 12], [2, 86, 68], [4, 43, 27], [4, 43, 19], [4, 43, 15], [2, 98, 78], [4, 49, 31], [2, 32, 14, 4, 33, 15], [4, 39, 13, 1, 40, 14], [2, 121, 97], [2, 60, 38, 2, 61, 39], [4, 40, 18, 2, 41, 19], [4, 40, 14, 2, 41, 15], [2, 146, 116], [3, 58, 36, 2, 59, 37], [4, 36, 16, 4, 37, 17], [4, 36, 12, 4, 37, 13], [2, 86, 68, 2, 87, 69], [4, 69, 43, 1, 70, 44], [6, 43, 19, 2, 44, 20], [6, 43, 15, 2, 44, 16], [4, 101, 81], [1, 80, 50, 4, 81, 51], [4, 50, 22, 4, 51, 23], [3, 36, 12, 8, 37, 13], [2, 116, 92, 2, 117, 93], [6, 58, 36, 2, 59, 37], [4, 46, 20, 6, 47, 21], [7, 42, 14, 4, 43, 15], [4, 133, 107], [8, 59, 37, 1, 60, 38], [8, 44, 20, 4, 45, 21], [12, 33, 11, 4, 34, 12], [3, 145, 115, 1, 146, 116], [4, 64, 40, 5, 65, 41], [11, 36, 16, 5, 37, 17], [11, 36, 12, 5, 37, 13], [5, 109, 87, 1, 110, 88], [5, 65, 41, 5, 66, 42], [5, 54, 24, 7, 55, 25], [11, 36, 12], [5, 122, 98, 1, 123, 99], [7, 73, 45, 3, 74, 46], [15, 43, 19, 2, 44, 20], [3, 45, 15, 13, 46, 16], [1, 135, 107, 5, 136, 108], [10, 74, 46, 1, 75, 47], [1, 50, 22, 15, 51, 23], [2, 42, 14, 17, 43, 15], [5, 150, 120, 1, 151, 121], [9, 69, 43, 4, 70, 44], [17, 50, 22, 1, 51, 23], [2, 42, 14, 19, 43, 15], [3, 141, 113, 4, 142, 114], [3, 70, 44, 11, 71, 45], [17, 47, 21, 4, 48, 22], [9, 39, 13, 16, 40, 14], [3, 135, 107, 5, 136, 108], [3, 67, 41, 13, 68, 42], [15, 54, 24, 5, 55, 25], [15, 43, 15, 10, 44, 16], [4, 144, 116, 4, 145, 117], [17, 68, 42], [17, 50, 22, 6, 51, 23], [19, 46, 16, 6, 47, 17], [2, 139, 111, 7, 140, 112], [17, 74, 46], [7, 54, 24, 16, 55, 25], [34, 37, 13], [4, 151, 121, 5, 152, 122], [4, 75, 47, 14, 76, 48], [11, 54, 24, 14, 55, 25], [16, 45, 15, 14, 46, 16], [6, 147, 117, 4, 148, 118], [6, 73, 45, 14, 74, 46], [11, 54, 24, 16, 55, 25], [30, 46, 16, 2, 47, 17], [8, 132, 106, 4, 133, 107], [8, 75, 47, 13, 76, 48], [7, 54, 24, 22, 55, 25], [22, 45, 15, 13, 46, 16], [10, 142, 114, 2, 143, 115], [19, 74, 46, 4, 75, 47], [28, 50, 22, 6, 51, 23], [33, 46, 16, 4, 47, 17], [8, 152, 122, 4, 153, 123], [22, 73, 45, 3, 74, 46], [8, 53, 23, 26, 54, 24], [12, 45, 15, 28, 46, 16], [3, 147, 117, 10, 148, 118], [3, 73, 45, 23, 74, 46], [4, 54, 24, 31, 55, 25], [11, 45, 15, 31, 46, 16], [7, 146, 116, 7, 147, 117], [21, 73, 45, 7, 74, 46], [1, 53, 23, 37, 54, 24], [19, 45, 15, 26, 46, 16], [5, 145, 115, 10, 146, 116], [19, 75, 47, 10, 76, 48], [15, 54, 24, 25, 55, 25], [23, 45, 15, 25, 46, 16], [13, 145, 115, 3, 146, 116], [2, 74, 46, 29, 75, 47], [42, 54, 24, 1, 55, 25], [23, 45, 15, 28, 46, 16], [17, 145, 115], [10, 74, 46, 23, 75, 47], [10, 54, 24, 35, 55, 25], [19, 45, 15, 35, 46, 16], [17, 145, 115, 1, 146, 116], [14, 74, 46, 21, 75, 47], [29, 54, 24, 19, 55, 25], [11, 45, 15, 46, 46, 16], [13, 145, 115, 6, 146, 116], [14, 74, 46, 23, 75, 47], [44, 54, 24, 7, 55, 25], [59, 46, 16, 1, 47, 17], [12, 151, 121, 7, 152, 122], [12, 75, 47, 26, 76, 48], [39, 54, 24, 14, 55, 25], [22, 45, 15, 41, 46, 16], [6, 151, 121, 14, 152, 122], [6, 75, 47, 34, 76, 48], [46, 54, 24, 10, 55, 25], [2, 45, 15, 64, 46, 16], [17, 152, 122, 4, 153, 123], [29, 74, 46, 14, 75, 47], [49, 54, 24, 10, 55, 25], [24, 45, 15, 46, 46, 16], [4, 152, 122, 18, 153, 123], [13, 74, 46, 32, 75, 47], [48, 54, 24, 14, 55, 25], [42, 45, 15, 32, 46, 16], [20, 147, 117, 4, 148, 118], [40, 75, 47, 7, 76, 48], [43, 54, 24, 22, 55, 25], [10, 45, 15, 67, 46, 16], [19, 148, 118, 6, 149, 119], [18, 75, 47, 31, 76, 48], [34, 54, 24, 34, 55, 25], [20, 45, 15, 61, 46, 16]];
QRRSBlock.getRSBlocks = function (typeNumber, errorCorrectLevel) {
  var rsBlock = QRRSBlock.getRsBlockTable(typeNumber, errorCorrectLevel);
  if (rsBlock == undefined) {
    throw new Error("bad rs block @ typeNumber:" + typeNumber + "/errorCorrectLevel:" + errorCorrectLevel);
  }
  var length = rsBlock.length / 3;
  var list = [];
  for (var i = 0; i < length; i++) {
    var count = rsBlock[i * 3 + 0];
    var totalCount = rsBlock[i * 3 + 1];
    var dataCount = rsBlock[i * 3 + 2];
    for (var j = 0; j < count; j++) {
      list.push(new QRRSBlock(totalCount, dataCount));
    }
  }
  return list;
};
QRRSBlock.getRsBlockTable = function (typeNumber, errorCorrectLevel) {
  switch (errorCorrectLevel) {
    case QRErrorCorrectLevel.L:
      return QRRSBlock.RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 0];
    case QRErrorCorrectLevel.M:
      return QRRSBlock.RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 1];
    case QRErrorCorrectLevel.Q:
      return QRRSBlock.RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 2];
    case QRErrorCorrectLevel.H:
      return QRRSBlock.RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 3];
    default:
      return undefined;
  }
};

function QRBitBuffer() {
  this.buffer = [];
  this.length = 0;
}

QRBitBuffer.prototype = {
  get: function get(index) {
    var bufIndex = Math.floor(index / 8);
    return (this.buffer[bufIndex] >>> 7 - index % 8 & 1) == 1;
  },
  put: function put(num, length) {
    for (var i = 0; i < length; i++) {
      this.putBit((num >>> length - i - 1 & 1) == 1);
    }
  },
  getLengthInBits: function getLengthInBits() {
    return this.length;
  },
  putBit: function putBit(bit) {
    var bufIndex = Math.floor(this.length / 8);
    if (this.buffer.length <= bufIndex) {
      this.buffer.push(0);
    }
    if (bit) {
      this.buffer[bufIndex] |= 0x80 >>> this.length % 8;
    }
    this.length++;
  }
};
var QRCodeLimitLength = [[17, 14, 11, 7], [32, 26, 20, 14], [53, 42, 32, 24], [78, 62, 46, 34], [106, 84, 60, 44], [134, 106, 74, 58], [154, 122, 86, 64], [192, 152, 108, 84], [230, 180, 130, 98], [271, 213, 151, 119], [321, 251, 177, 137], [367, 287, 203, 155], [425, 331, 241, 177], [458, 362, 258, 194], [520, 412, 292, 220], [586, 450, 322, 250], [644, 504, 364, 280], [718, 560, 394, 310], [792, 624, 442, 338], [858, 666, 482, 382], [929, 711, 509, 403], [1003, 779, 565, 439], [1091, 857, 611, 461], [1171, 911, 661, 511], [1273, 997, 715, 535], [1367, 1059, 751, 593], [1465, 1125, 805, 625], [1528, 1190, 868, 658], [1628, 1264, 908, 698], [1732, 1370, 982, 742], [1840, 1452, 1030, 790], [1952, 1538, 1112, 842], [2068, 1628, 1168, 898], [2188, 1722, 1228, 958], [2303, 1809, 1283, 983], [2431, 1911, 1351, 1051], [2563, 1989, 1423, 1093], [2699, 2099, 1499, 1139], [2809, 2213, 1579, 1219], [2953, 2331, 1663, 1273]];

// END OF QR CODE CORE LIBRARY DEFINITION

var awesome_qr_Drawing = function () {
  // Drawing in Canvas
  function _onMakeImage() {
    this._elImage.src = this._elCanvas.toDataURL("image/png");
    this._elImage.style.display = "block";
    this._elCanvas.style.display = "none";
  }

  function _safeSetDataURI(fSuccess, fFail) {
    var self = this;
    self._fFail = fFail;
    self._fSuccess = fSuccess;

    // Check it just once
    if (self._bSupportDataURI === null) {
      var el = document.createElement("img");
      var fOnError = function fOnError() {
        self._bSupportDataURI = false;

        if (self._fFail) {
          self._fFail.call(self);
        }
      };
      var fOnSuccess = function fOnSuccess() {
        self._bSupportDataURI = true;

        if (self._fSuccess) {
          self._fSuccess.call(self);
        }
      };

      el.onabort = fOnError;
      el.onerror = fOnError;
      el.onload = fOnSuccess;
      el.src = "data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg=="; // the Image contains 1px data.
      return;
    } else if (self._bSupportDataURI === true && self._fSuccess) {
      self._fSuccess.call(self);
    } else if (self._bSupportDataURI === false && self._fFail) {
      self._fFail.call(self);
    }
  }

  var Drawing = function Drawing(htOption) {
    this._bIsPainted = false;

    this._htOption = htOption;
    this._elCanvas = document.createElement("canvas");
    this._elCanvas.width = htOption.size;
    this._elCanvas.height = htOption.size;
    this._oContext = this._elCanvas.getContext("2d");
    this._bIsPainted = false;
    this._elImage = document.createElement("img");
    this._elImage.alt = "Scan me!";
    this._elImage.style.display = "none";
    this._bSupportDataURI = null;
    this._callback = htOption.callback;
    this._bindElement = htOption.bindElement;
  };

  Drawing.prototype.draw = function (oQRCode) {
    var _elImage = this._elImage;
    var _tCanvas = document.createElement("canvas");
    var _oContext = _tCanvas.getContext("2d");
    // var _oContext = this._oContext;
    var _htOption = this._htOption;

    var nCount = oQRCode.getModuleCount();
    var rawSize = _htOption.size;
    var rawMargin = _htOption.margin;

    if (rawMargin < 0 || rawMargin * 2 >= rawSize) {
      rawMargin = 0;
    }

    var margin = Math.ceil(rawMargin);

    var rawViewportSize = rawSize - 2 * rawMargin;

    var whiteMargin = _htOption.whiteMargin;
    var backgroundDimming = _htOption.backgroundDimming;
    var nSize = Math.ceil(rawViewportSize / nCount);
    var viewportSize = nSize * nCount;
    var size = viewportSize + 2 * margin;

    var gifBackground = undefined;
    var gifFrames = undefined;

    _tCanvas.width = size;
    _tCanvas.height = size;

    var dotScale = _htOption.dotScale;
    _elImage.style.display = "none";
    this.clear();

    if (dotScale <= 0 || dotScale > 1) {
      throw new Error("Scale should be in range (0, 1).");
    }

    // Leave room for margin
    _oContext.save();
    _oContext.translate(margin, margin);

    var _bkgCanvas = document.createElement("canvas");
    _bkgCanvas.width = size;
    _bkgCanvas.height = size;
    var _bContext = _bkgCanvas.getContext("2d");

    var _maskCanvas = undefined;
    var _mContext = undefined;

    if (_htOption.gifBackground !== undefined) {
      var gif = new Gif(_htOption.gifBackground);

      if (!gif.raw.hasImages) {
        throw new Error("An invalid gif has been selected as the background.");
      }
      gifBackground = gif;
      gifFrames = gif.decompressFrames(true);
      // console.log(gifFrames);
      if (_htOption.autoColor) {
        var r = 0,
            g = 0,
            b = 0;
        var count = 0;
        for (var i = 0; i < gifFrames[0].colorTable.length; i++) {
          var c = gifFrames[0].colorTable[i];
          if (c[0] > 200 || c[1] > 200 || c[2] > 200) continue;
          if (c[0] === 0 && c[1] === 0 && c[2] === 0) continue;
          count++;
          r += c[0];
          g += c[1];
          b += c[2];
        }

        r = ~~(r / count);
        g = ~~(g / count);
        b = ~~(b / count);
        // console.log("rgb(" + r + ", " + g + ", " + b + ")");
        _htOption.colorDark = "rgb(" + r + ", " + g + ", " + b + ")";
      }
    } else if (_htOption.backgroundImage !== undefined) {
      if (_htOption.autoColor) {
        var avgRGB = getAverageRGB(_htOption.backgroundImage);
        _htOption.colorDark = "rgb(" + avgRGB.r + ", " + avgRGB.g + ", " + avgRGB.b + ")";
      }

      if (_htOption.maskedDots) {
        _maskCanvas = document.createElement("canvas");
        _maskCanvas.width = size;
        _maskCanvas.height = size;
        _mContext = _maskCanvas.getContext("2d");
        /*
                     _mContext.drawImage(_htOption.backgroundImage,
                     0, 0, _htOption.backgroundImage.width, _htOption.backgroundImage.height,
                     whiteMargin ? 0 : -margin, whiteMargin ? 0 : -margin, whiteMargin ? viewportSize : size, whiteMargin ? viewportSize : size);
                     */
        _mContext.drawImage(_htOption.backgroundImage, 0, 0, _htOption.backgroundImage.width, _htOption.backgroundImage.height, 0, 0, size, size);

        _bContext.rect(0, 0, size, size);
        _bContext.fillStyle = "#ffffff";
        _bContext.fill();
      } else {
        /*
                     _bContext.drawImage(_htOption.backgroundImage,
                     0, 0, _htOption.backgroundImage.width, _htOption.backgroundImage.height,
                     whiteMargin ? 0 : -margin, whiteMargin ? 0 : -margin, whiteMargin ? viewportSize : size, whiteMargin ? viewportSize : size);
                     */
        _bContext.drawImage(_htOption.backgroundImage, 0, 0, _htOption.backgroundImage.width, _htOption.backgroundImage.height, 0, 0, size, size);
        _bContext.rect(0, 0, size, size);
        _bContext.fillStyle = backgroundDimming;
        _bContext.fill();
      }
    } else {
      _bContext.rect(0, 0, size, size);
      _bContext.fillStyle = _htOption.backgroundColor;
      _bContext.fill();
    }

    if (_htOption.binarize) {
      _htOption.colorDark = "#000000";
      _htOption.colorLight = "#FFFFFF";
    }

    var agnPatternCenter = QRUtil.getPatternPosition(oQRCode.typeNumber);
    var xyOffset = (1 - dotScale) * 0.5;
    for (var row = 0; row < nCount; row++) {
      for (var col = 0; col < nCount; col++) {
        var bIsDark = oQRCode.isDark(row, col);

        // var isBlkPosCtr = ((col < 8 && (row < 8 || row >= nCount - 8)) || (col >= nCount - 8 && row < 8) || (col < nCount - 4 && col >= nCount - 4 - 5 && row < nCount - 4 && row >= nCount - 4 - 5));
        var isBlkPosCtr = col < 8 && (row < 8 || row >= nCount - 8) || col >= nCount - 8 && row < 8;
        var isBlkPos = col < 7 && (row < 7 || row >= nCount - 7) || col >= nCount - 7 && row < 7;
        var bProtected = row === 6 || col === 6 || isBlkPosCtr;

        for (var i = 0; i < agnPatternCenter.length - 1; i++) {
          bProtected = bProtected || row >= agnPatternCenter[i] - 2 && row <= agnPatternCenter[i] + 2 && col >= agnPatternCenter[i] - 2 && col <= agnPatternCenter[i] + 2;
        }

        var nLeft = col * nSize + (bProtected ? 0 : xyOffset * nSize);
        var nTop = row * nSize + (bProtected ? 0 : xyOffset * nSize);
        _oContext.strokeStyle = bIsDark ? _htOption.colorDark : _htOption.colorLight;
        _oContext.lineWidth = 0.5;
        _oContext.fillStyle = bIsDark ? _htOption.colorDark : _htOption.colorLight; //_htOption.colorLight;
        if (agnPatternCenter.length === 0) {
          // if align pattern list is empty, then it means that we don't need to leave room for the align patterns
          if (!bProtected) {
            _fillRectWithMask(_oContext, nLeft, nTop, (bProtected ? isBlkPosCtr ? 1 : 1 : dotScale) * nSize, (bProtected ? isBlkPosCtr ? 1 : 1 : dotScale) * nSize, _maskCanvas, bIsDark);
          }
        } else {
          var inAgnRange = col < nCount - 4 && col >= nCount - 4 - 5 && row < nCount - 4 && row >= nCount - 4 - 5;
          if (!bProtected && !inAgnRange) _fillRectWithMask(_oContext, nLeft, nTop, (bProtected ? isBlkPosCtr ? 1 : 1 : dotScale) * nSize, (bProtected ? isBlkPosCtr ? 1 : 1 : dotScale) * nSize, _maskCanvas, bIsDark);
        }
      }
    }

    // Draw POSITION protectors
    var protectorStyle = _htOption.colorLight;
    _oContext.fillStyle = protectorStyle;
    _oContext.fillRect(0, 0, 8 * nSize, 8 * nSize);
    _oContext.fillRect(0, (nCount - 8) * nSize, 8 * nSize, 8 * nSize);
    _oContext.fillRect((nCount - 8) * nSize, 0, 8 * nSize, 8 * nSize);
    _oContext.fillRect(8 * nSize, 6 * nSize, (nCount - 8 - 8) * nSize, nSize);
    _oContext.fillRect(6 * nSize, 8 * nSize, nSize, (nCount - 8 - 8) * nSize);

    // Draw ALIGN protectors
    var edgeCenter = agnPatternCenter[agnPatternCenter.length - 1];
    for (var i = 0; i < agnPatternCenter.length; i++) {
      for (var j = 0; j < agnPatternCenter.length; j++) {
        var agnX = agnPatternCenter[j];
        var agnY = agnPatternCenter[i];
        if (agnX === 6 && (agnY === 6 || agnY === edgeCenter)) {
          continue;
        } else if (agnY === 6 && (agnX === 6 || agnX === edgeCenter)) {
          continue;
        } else if (agnX !== 6 && agnX !== edgeCenter && agnY !== 6 && agnY !== edgeCenter) {
          _drawAlignProtector(_oContext, agnX, agnY, nSize, nSize);
        } else {
          _drawAlignProtector(_oContext, agnX, agnY, nSize, nSize);
        }
        // console.log("agnX=" + agnX + ", agnY=" + agnX);
      }
    }

    // Draw POSITION patterns
    _oContext.fillStyle = _htOption.colorDark;
    _oContext.fillRect(0, 0, 7 * nSize, nSize);
    _oContext.fillRect((nCount - 7) * nSize, 0, 7 * nSize, nSize);
    _oContext.fillRect(0, 6 * nSize, 7 * nSize, nSize);
    _oContext.fillRect((nCount - 7) * nSize, 6 * nSize, 7 * nSize, nSize);
    _oContext.fillRect(0, (nCount - 7) * nSize, 7 * nSize, nSize);
    _oContext.fillRect(0, (nCount - 7 + 6) * nSize, 7 * nSize, nSize);
    _oContext.fillRect(0, 0, nSize, 7 * nSize);
    _oContext.fillRect(6 * nSize, 0, nSize, 7 * nSize);
    _oContext.fillRect((nCount - 7) * nSize, 0, nSize, 7 * nSize);
    _oContext.fillRect((nCount - 7 + 6) * nSize, 0, nSize, 7 * nSize);
    _oContext.fillRect(0, (nCount - 7) * nSize, nSize, 7 * nSize);
    _oContext.fillRect(6 * nSize, (nCount - 7) * nSize, nSize, 7 * nSize);

    _oContext.fillRect(2 * nSize, 2 * nSize, 3 * nSize, 3 * nSize);
    _oContext.fillRect((nCount - 7 + 2) * nSize, 2 * nSize, 3 * nSize, 3 * nSize);
    _oContext.fillRect(2 * nSize, (nCount - 7 + 2) * nSize, 3 * nSize, 3 * nSize);

    for (var i = 0; i < nCount - 8; i += 2) {
      _oContext.fillRect((8 + i) * nSize, 6 * nSize, nSize, nSize);
      _oContext.fillRect(6 * nSize, (8 + i) * nSize, nSize, nSize);
    }
    for (var i = 0; i < agnPatternCenter.length; i++) {
      for (var j = 0; j < agnPatternCenter.length; j++) {
        var agnX = agnPatternCenter[j];
        var agnY = agnPatternCenter[i];
        if (agnX === 6 && (agnY === 6 || agnY === edgeCenter)) {
          continue;
        } else if (agnY === 6 && (agnX === 6 || agnX === edgeCenter)) {
          continue;
        } else if (agnX !== 6 && agnX !== edgeCenter && agnY !== 6 && agnY !== edgeCenter) {
          _oContext.fillStyle = _htOption.colorLight;
          _drawAlign(_oContext, agnX, agnY, nSize, nSize);
        } else {
          _oContext.fillStyle = _htOption.colorDark;
          _drawAlign(_oContext, agnX, agnY, nSize, nSize);
        }
      }
    }

    // Fill the margin
    if (whiteMargin) {
      _oContext.fillStyle = _htOption.backgroundColor;
      _oContext.fillRect(-margin, -margin, size, margin);
      _oContext.fillRect(-margin, viewportSize, size, margin);
      _oContext.fillRect(viewportSize, -margin, margin, size);
      _oContext.fillRect(-margin, -margin, margin, size);
    }

    if (_htOption.logoImage !== undefined) {
      var logoScale = _htOption.logoScale;
      var logoMargin = _htOption.logoMargin;
      var logoCornerRadius = _htOption.logoCornerRadius;
      if (logoScale <= 0 || logoScale >= 1.0) {
        logoScale = 0.2;
      }
      if (logoMargin < 0) {
        logoMargin = 0;
      }
      if (logoCornerRadius < 0) {
        logoCornerRadius = 0;
      }

      _oContext.restore();
      _oContext.translate(margin, margin);
      var logoSize = viewportSize * logoScale;
      var x = 0.5 * (viewportSize - logoSize);
      var y = x;

      _oContext.fillStyle = _htOption.logoBackgroundColor;
      _oContext.save();
      _prepareRoundedCornerClip(_oContext, x - logoMargin, y - logoMargin, logoSize + 2 * logoMargin, logoSize + 2 * logoMargin, logoCornerRadius);
      _oContext.clip();
      _oContext.fill();
      _oContext.restore();

      _oContext.save();
      _prepareRoundedCornerClip(_oContext, x, y, logoSize, logoSize, logoCornerRadius);
      _oContext.clip();
      _oContext.drawImage(_htOption.logoImage, x, y, logoSize, logoSize);
      _oContext.restore();
    }

    if (gifBackground === undefined) {
      // Swap and merge the foreground and the background
      _bContext.drawImage(_tCanvas, 0, 0, size, size);
      _oContext.drawImage(_bkgCanvas, -margin, -margin, size, size);

      // Binarize the final image
      if (_htOption.binarize) {
        var pixels = _oContext.getImageData(0, 0, size, size);
        var threshold = 128;
        if (parseInt(_htOption.binarizeThreshold) > 0 && parseInt(_htOption.binarizeThreshold) < 255) {
          threshold = parseInt(_htOption.binarizeThreshold);
        }
        for (var i = 0; i < pixels.data.length; i += 4) {
          // rgb in [0, 255]
          var R = pixels.data[i];
          var G = pixels.data[i + 1];
          var B = pixels.data[i + 2];
          var sum = _greyscale(R, G, B);
          if (sum > threshold) {
            pixels.data[i] = 255;
            pixels.data[i + 1] = 255;
            pixels.data[i + 2] = 255;
          } else {
            pixels.data[i] = 0;
            pixels.data[i + 1] = 0;
            pixels.data[i + 2] = 0;
          }
        }
        _oContext.putImageData(pixels, 0, 0);
      }

      // Scale the final image
      var _fCanvas = document.createElement("canvas");
      var _fContext = _fCanvas.getContext("2d");
      _fCanvas.width = rawSize;
      _fCanvas.height = rawSize;
      _fContext.drawImage(_tCanvas, 0, 0, rawSize, rawSize);
      this._elCanvas = _fCanvas;

      // Painting work completed
      this._bIsPainted = true;
      if (this._callback !== undefined) {
        this._callback(this._elCanvas.toDataURL());
      }
      if (this._bindElement !== undefined) {
        try {
          var el = document.getElementById(this._bindElement);
          if (el.nodeName === "IMG") {
            el.src = this._elCanvas.toDataURL();
          } else {
            var elStyle = el.style;
            elStyle["background-image"] = "url(" + this._elCanvas.toDataURL() + ")";
            elStyle["background-size"] = "contain";
            elStyle["background-repeat"] = "no-repeat";
          }
        } catch (e) {
          console.error(e);
        }
      }
    } else {
      var gifOutput;

      // Reuse in order to apply the patch
      var rawBkg;
      var hRawBkg;

      var patchCanvas = document.createElement("canvas");
      var hPatchCanvas = patchCanvas.getContext("2d");
      var patchData;

      gifFrames.forEach(function (frame) {
        // console.log(frame);
        if (gifOutput === undefined) {
          gifOutput = new gifjs({
            workers: 4,
            quality: 10,
            width: rawSize,
            height: rawSize
          });
        }

        if (rawBkg === undefined) {
          rawBkg = document.createElement("canvas");
          hRawBkg = rawBkg.getContext("2d");
          rawBkg.width = frame.dims.width;
          rawBkg.height = frame.dims.height;
          hRawBkg.rect(0, 0, rawBkg.width, rawBkg.height);
          hRawBkg.fillStyle = "#ffffff";
          hRawBkg.fill();
          // console.log(rawBkg);
        }

        if (!patchData || frame.dims.width !== patchCanvas.width || frame.dims.height !== patchCanvas.height) {
          patchCanvas.width = frame.dims.width;
          patchCanvas.height = frame.dims.height;
          patchData = hPatchCanvas.createImageData(frame.dims.width, frame.dims.height);
        }

        patchData.data.set(frame.patch);
        hPatchCanvas.putImageData(patchData, 0, 0);

        hRawBkg.drawImage(patchCanvas, frame.dims.left, frame.dims.top);

        var stdCanvas = document.createElement("canvas");
        stdCanvas.width = size;
        stdCanvas.height = size;
        var hStdCanvas = stdCanvas.getContext("2d");

        hStdCanvas.drawImage(rawBkg, 0, 0, size, size);
        hStdCanvas.drawImage(_tCanvas, 0, 0, size, size);

        // Scale the final image
        var _fCanvas = document.createElement("canvas");
        var _fContext = _fCanvas.getContext("2d");
        _fCanvas.width = rawSize;
        _fCanvas.height = rawSize;
        _fContext.drawImage(stdCanvas, 0, 0, rawSize, rawSize);
        // console.log(_fContext);
        gifOutput.addFrame(_fContext, { copy: true, delay: frame.delay });
      });

      if (gifOutput === undefined) {
        throw new Error("No frames.");
      }
      var ref = this;
      gifOutput.on("finished", function (blob) {
        // Painting work completed
        var r = new FileReader();
        r.onload = function (e) {
          var data = e.target.result;
          ref._bIsPainted = true;
          if (ref._callback !== undefined) {
            ref._callback(data);
          }
          if (ref._bindElement !== undefined) {
            try {
              var el = document.getElementById(ref._bindElement);
              if (el.nodeName === "IMG") {
                el.src = data;
              } else {
                var elStyle = el.style;
                elStyle["background-image"] = "url(" + data + ")";
                elStyle["background-size"] = "contain";
                elStyle["background-repeat"] = "no-repeat";
              }
            } catch (e) {
              console.error(e);
            }
          }
        };
        r.readAsDataURL(blob);
      });

      gifOutput.render();
    }
  };

  Drawing.prototype.makeImage = function () {
    if (this._bIsPainted) {
      _safeSetDataURI.call(this, _onMakeImage);
    }
  };

  Drawing.prototype.isPainted = function () {
    return this._bIsPainted;
  };

  Drawing.prototype.clear = function () {
    this._oContext.clearRect(0, 0, this._elCanvas.width, this._elCanvas.height);
    this._bIsPainted = false;
  };

  Drawing.prototype.round = function (nNumber) {
    if (!nNumber) {
      return nNumber;
    }

    return Math.floor(nNumber * 1000) / 1000;
  };

  return Drawing;
}();

// Utilities and useful helpers

function _getUTF8Length(sText) {
  var replacedText = encodeURI(sText).toString().replace(/\%[0-9a-fA-F]{2}/g, "a");
  return replacedText.length + (replacedText.length != sText ? 3 : 0);
}

function _prepareRoundedCornerClip(ctx, x, y, w, h, r) {
  ctx.beginPath();
  ctx.moveTo(x, y);
  ctx.arcTo(x + w, y, x + w, y + h, r);
  ctx.arcTo(x + w, y + h, x, y + h, r);
  ctx.arcTo(x, y + h, x, y, r);
  ctx.arcTo(x, y, x + w, y, r);
  ctx.closePath();
}

function _setPixel(imageData, p, r, g, b, a) {
  var index = p * 4;
  imageData.data[index + 0] = r;
  imageData.data[index + 1] = g;
  imageData.data[index + 2] = b;
  imageData.data[index + 3] = a;
}

function _greyscale(r, g, b) {
  return 0.3 * r + 0.59 * b + 0.11 * b;
}

function _fillRectWithMask(canvas, x, y, w, h, maskSrc, bDark) {
  //console.log("maskSrc=" + maskSrc);
  if (maskSrc === undefined) {
    canvas.fillRect(x, y, w, h);
  } else {
    canvas.drawImage(maskSrc, x, y, w, h, x, y, w, h);
    var fill_ = canvas.fillStyle;
    canvas.fillStyle = bDark ? "rgba(0, 0, 0, .5)" : "rgba(255, 255, 255, .7)";
    canvas.fillRect(x, y, w, h);
    canvas.fillStyle = fill_;
  }
}

function _drawAlignProtector(context, centerX, centerY, nWidth, nHeight) {
  context.clearRect((centerX - 2) * nWidth, (centerY - 2) * nHeight, 5 * nWidth, 5 * nHeight);
  context.fillRect((centerX - 2) * nWidth, (centerY - 2) * nHeight, 5 * nWidth, 5 * nHeight);
}

function _drawAlign(context, centerX, centerY, nWidth, nHeight) {
  context.fillRect((centerX - 2) * nWidth, (centerY - 2) * nHeight, nWidth, 4 * nHeight);
  context.fillRect((centerX + 2) * nWidth, (centerY - 2 + 1) * nHeight, nWidth, 4 * nHeight);
  context.fillRect((centerX - 2 + 1) * nWidth, (centerY - 2) * nHeight, 4 * nWidth, nHeight);
  context.fillRect((centerX - 2) * nWidth, (centerY + 2) * nHeight, 4 * nWidth, nHeight);
  context.fillRect(centerX * nWidth, centerY * nHeight, nWidth, nHeight);
}

AwesomeQRCode = function AwesomeQRCode() {};

AwesomeQRCode.prototype.create = function (vOption) {
  this._htOption = {
    size: 800,
    margin: 20,
    typeNumber: 4,
    colorDark: "#000000",
    colorLight: "rgba(255, 255, 255, 0.6)",
    logoBackgroundColor: '#ffffff',
    correctLevel: QRErrorCorrectLevel.M,
    backgroundImage: undefined,
    backgroundDimming: "rgba(0,0,0,0)",
    logoImage: undefined,
    logoScale: 0.2,
    logoMargin: 6,
    logoCornerRadius: 8,
    whiteMargin: true,
    dotScale: 0.35,
    maskedDots: false,
    autoColor: true,
    binarize: false,
    binarizeThreshold: 128,
    gifBackground: undefined,
    callback: undefined,
    bindElement: undefined,
    backgroundColor: '#ffffff'
  };

  if (typeof vOption === "string") {
    vOption = {
      text: vOption
    };
  }

  if (vOption) {
    for (var i in vOption) {
      this._htOption[i] = vOption[i];
    }
  }

  this._oQRCode = null;
  this._oDrawing = new awesome_qr_Drawing(this._htOption);

  if (this._htOption.text) {
    this.makeCode(this._htOption.text);
  }
};

function _getTypeNumber(sText, nCorrectLevel) {
  var nType = 1;
  var length = _getUTF8Length(sText);

  for (var i = 0, len = QRCodeLimitLength.length; i <= len; i++) {
    var nLimit = 0;

    switch (nCorrectLevel) {
      case QRErrorCorrectLevel.L:
        nLimit = QRCodeLimitLength[i][0];
        break;
      case QRErrorCorrectLevel.M:
        nLimit = QRCodeLimitLength[i][1];
        break;
      case QRErrorCorrectLevel.Q:
        nLimit = QRCodeLimitLength[i][2];
        break;
      case QRErrorCorrectLevel.H:
        nLimit = QRCodeLimitLength[i][3];
        break;
    }

    if (length <= nLimit) {
      break;
    } else {
      nType++;
    }
  }

  if (nType > QRCodeLimitLength.length) {
    throw new Error("Too long data");
  }

  return nType;
}

AwesomeQRCode.prototype.makeCode = function (sText) {
  //this._oQRCode = new QRCodeModel(_getTypeNumber(sText, this._htOption.correctLevel), this._htOption.correctLevel);
  this._oQRCode = new QRCodeModel(-1, this._htOption.correctLevel);
  this._oQRCode.addData(sText);
  this._oQRCode.make();
  this._oDrawing.draw(this._oQRCode);
  this.makeImage();
};

AwesomeQRCode.prototype.makeImage = function () {
  if (typeof this._oDrawing.makeImage == "function") {
    this._oDrawing.makeImage();
  }
};

AwesomeQRCode.prototype.clear = function () {
  this._oDrawing.clear();
};

AwesomeQRCode.CorrectLevel = QRErrorCorrectLevel;

function getAverageRGB(imgEl) {
  var blockSize = 5,
      defaultRGB = {
    r: 0,
    g: 0,
    b: 0
  },
      canvas = document.createElement("canvas"),
      context = canvas.getContext && canvas.getContext("2d"),
      data,
      width,
      height,
      i = -4,
      length,
      rgb = {
    r: 0,
    g: 0,
    b: 0
  },
      count = 0;

  if (!context) {
    return defaultRGB;
  }

  height = canvas.height = imgEl.naturalHeight || imgEl.offsetHeight || imgEl.height;
  width = canvas.width = imgEl.naturalWidth || imgEl.offsetWidth || imgEl.width;

  context.drawImage(imgEl, 0, 0);

  try {
    data = context.getImageData(0, 0, width, height);
  } catch (e) {
    return defaultRGB;
  }

  length = data.data.length;

  while ((i += blockSize * 4) < length) {
    if (data.data[i] > 200 || data.data[i + 1] > 200 || data.data[i + 2] > 200) continue;
    ++count;
    rgb.r += data.data[i];
    rgb.g += data.data[i + 1];
    rgb.b += data.data[i + 2];
  }

  rgb.r = ~~(rgb.r / count);
  rgb.g = ~~(rgb.g / count);
  rgb.b = ~~(rgb.b / count);

  return rgb;
}
// module.exports=AwesomeQRCode
/* harmony default export */ var awesome_qr = (AwesomeQRCode);
// EXTERNAL MODULE: ./node_modules/babel-runtime/core-js/promise.js
var promise = __webpack_require__("//Fk");
var promise_default = /*#__PURE__*/__webpack_require__.n(promise);

// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/imgLoaded.js

function imgLoaded(url) {
  if (!url) {
    return undefined;
  }
  return new promise_default.a(function (resolve, reject) {
    if (url.slice(0, 4) == 'data') {
      var _img = new Image();
      _img.onload = function () {
        resolve(_img);
      };
      _img.onerror = function () {
        reject('Image load error');
      };
      _img.src = url;
      return;
    }
    var img = new Image();
    img.setAttribute("crossOrigin", 'Anonymous');
    img.onload = function () {
      resolve(img);
    };
    img.onerror = function () {
      reject('Image load error');
    };
    img.src = url;
  });
}
/* harmony default export */ var dist_imgLoaded = (imgLoaded);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/readAsArrayBuffer.js

function readAsArrayBuffer(url, callback) {
  return new promise_default.a(function (resolve, reject) {
    var xhr = new XMLHttpRequest();
    xhr.responseType = "blob"; //设定返回数据类型为Blob
    xhr.onload = function () {
      var reader = new FileReader();
      reader.onloadend = function () {
        resolve(reader.result);
      };
      reader.readAsArrayBuffer(xhr.response); //xhr.response就是一个Blob，用FileReader读取
    };
    xhr.open("GET", url);
    xhr.send();
  });
}
/* harmony default export */ var dist_readAsArrayBuffer = (readAsArrayBuffer);
// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/schoolQrcode/dist/vue-qr.vue


//
//
//
//






/* harmony default export */ var vue_qr = ({
    props: {
        text: {
            type: String,
            required: true
        },
        qid: {
            type: String
        },
        correctLevel: {
            type: Number,
            default: 1
        },
        size: {
            type: Number,
            default: 200
        },
        margin: {
            type: Number,
            default: 20
        },
        colorDark: {
            type: String,
            default: "#000000"
        },
        colorLight: {
            type: String,
            default: "#FFFFFF"
        },
        bgSrc: {
            type: String,
            default: undefined
        },
        background: {
            type: String,
            default: "rgba(0,0,0,0)"
        },
        backgroundDimming: {
            type: String,
            default: "rgba(0,0,0,0)"
        },
        logoSrc: {
            type: String,
            default: undefined
        },
        logoBackgroundColor: {
            type: String,
            default: "rgba(0,0,0,0)"
        },
        gifBgSrc: {
            type: String,
            default: undefined
        },
        logoScale: {
            type: Number,
            default: 0.2
        },
        logoMargin: {
            type: Number,
            default: 0
        },
        logoCornerRadius: {
            type: Number,
            default: 8
        },
        whiteMargin: {
            type: [Boolean, String],
            default: true
        },
        dotScale: {
            type: Number,
            default: 0.35
        },
        autoColor: {
            type: [Boolean, String],
            default: true
        },
        binarize: {
            type: [Boolean, String],
            default: false
        },
        binarizeThreshold: {
            type: Number,
            default: 128
        },
        callback: {
            type: Function,
            default: function _default() {
                return undefined;
            }
        },
        bindElement: {
            type: Boolean,
            default: true
        },
        backgroundColor: {
            type: String,
            default: "#FFFFFF"
        }
    },
    name: "vue-qr",
    data: function data() {
        return {
            uuid: ""
        };
    },

    watch: {
        $props: {
            deep: true,
            handler: function handler() {
                this.main();
            }
        }
    },
    mounted: function mounted() {
        this.uuid = v4_default()();
        this.main();
    },

    methods: {
        main: function main() {
            var _this = this;

            return asyncToGenerator_default()( /*#__PURE__*/regenerator_default.a.mark(function _callee() {
                var that, gifImg, _logoImg, bgImg, logoImg;

                return regenerator_default.a.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                                that = _this;

                                if (!_this.gifBgSrc) {
                                    _context.next = 10;
                                    break;
                                }

                                _context.next = 4;
                                return dist_readAsArrayBuffer(_this.gifBgSrc);

                            case 4:
                                gifImg = _context.sent;
                                _context.next = 7;
                                return dist_imgLoaded(_this.logoSrc);

                            case 7:
                                _logoImg = _context.sent;


                                _this.render(undefined, _logoImg, gifImg);
                                return _context.abrupt("return");

                            case 10:
                                _context.next = 12;
                                return dist_imgLoaded(_this.bgSrc);

                            case 12:
                                bgImg = _context.sent;
                                _context.next = 15;
                                return dist_imgLoaded(_this.logoSrc);

                            case 15:
                                logoImg = _context.sent;

                                _this.render(bgImg, logoImg);

                            case 17:
                            case "end":
                                return _context.stop();
                        }
                    }
                }, _callee, _this);
            }))();
        },
        render: function render(img, logoImg, gifBgSrc) {
            var that = this;
            new awesome_qr().create({
                gifBackground: gifBgSrc,
                text: that.text,
                size: that.size,
                margin: that.margin,
                colorDark: that.colorDark,
                colorLight: that.colorLight,
                backgroundColor: that.backgroundColor,
                backgroundImage: img,
                backgroundDimming: that.backgroundDimming,
                logoImage: logoImg,
                logoScale: that.logoScale,
                logoBackgroundColor: that.logoBackgroundColor,
                correctLevel: that.correctLevel,
                logoMargin: that.logoMargin,
                logoCornerRadius: that.logoCornerRadius,
                whiteMargin: toBoolean(that.whiteMargin),
                dotScale: that.dotScale,
                autoColor: toBoolean(that.autoColor),
                binarize: toBoolean(that.binarize),
                binarizeThreshold: that.binarizeThreshold,
                callback: function callback(dataURI) {
                    that.callback && that.callback(dataURI, that.qid);
                },
                bindElement: that.bindElement ? that.uuid : undefined
            });
        }
    }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-b756a392","hasScoped":false,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/schoolQrcode/dist/vue-qr.vue
var vue_qr_render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return (_vm.bindElement)?_c('img',_vm._b({staticStyle:{"display":"inline-block"}},'img',{id:_vm.uuid},false)):_vm._e()}
var staticRenderFns = []
var esExports = { render: vue_qr_render, staticRenderFns: staticRenderFns }
/* harmony default export */ var dist_vue_qr = (esExports);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/dist/vue-qr.vue
var normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  vue_qr,
  dist_vue_qr,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)

/* harmony default export */ var schoolQrcode_dist_vue_qr = (Component.exports);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib!./node_modules/vue-loader/lib/selector.js?type=script&index=0!./src/pages/schoolQrcode/schoolQrcode.vue
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//





/* harmony default export */ var schoolQrcode = ({
  components: {
    vueQr: schoolQrcode_dist_vue_qr
  },
  data: function data() {
    return {
      title: '新生扫码入园',
      teacherMSG: null,
      downloadData: {
        url: api["_76" /* shareUrl */] + "regist/#/index",
        icon: __webpack_require__("3WyN")
      },
      schoolName: '', //学校名称
      className: '' //班级名称
    };
  },
  created: function created() {
    this.teacherMSG = JSON.parse(Object(auth["h" /* getData */])('teacherMSG'));
    this.className = this.teacherMSG.className;
    this.schoolName = this.teacherMSG.schoolName;
    this.downloadData.url = api["_76" /* shareUrl */] + "regist/#/index?classId=" + this.teacherMSG.classId + "&schoolId=" + this.teacherMSG.schoolId;
    console.log(this.downloadData.url);
  },
  mounted: function mounted() {
    Object(bridgeAPI["l" /* endPullDown */])();
  },

  methods: {
    /**
     * 保存本地
     */
    saveLocal: function saveLocal() {
      this.draw(function (base64) {
        var url = base64.replace(/^data:image\/(png|jpg|jpeg);base64,/, "");
        Object(bridgeAPI["i" /* commonPost */])('shareOrSave', {
          type: 0, // 0 保存本地 1 微信  2 朋友圈  3 qq好友   4 QQ空间  5  微博
          img: url
        });
      });
    },

    /**
     * 微信分享
     */
    wxShare: function wxShare() {
      this.draw(function (base64) {
        var url = base64.replace(/^data:image\/(png|jpg|jpeg);base64,/, "");
        Object(bridgeAPI["i" /* commonPost */])('shareOrSave', {
          type: 1, // 0 保存本地 1 微信  2 朋友圈  3 qq好友   4 QQ空间  5  微博
          img: url
        });
      });
    },
    draw: function draw(fn) {
      var oQrcode = document.querySelectorAll('.mv-qrcode-block img')[0],
          url = oQrcode.src,
          _this = this;
      var canvas = document.createElement('canvas'),
          ctx = canvas.getContext('2d');
      // 生成图片的大小
      canvas.width = 375;
      canvas.height = 490;
      ctx.rect(0, 0, canvas.width, canvas.height);
      ctx.fillStyle = '#F2F2F2';
      ctx.fill();
      var img = new Image();
      img.crossOrigin = '';
      img.src = url;
      img.onload = function () {
        // 二维码图
        ctx.drawImage(img, 37.5, 80, 300, 300);
        ctx.fillStyle = '#333333';
        ctx.font = "normal normal bold 20px Arial";
        // 大日期
        ctx.textAlign = "center";
        ctx.textBaseline = "middle";
        ctx.fillText(_this.title, 187.5, 40);
        ctx.font = "normal normal bold 16px Arial";
        //fillText(text,x,y)
        // 年月日
        ctx.fillText(_this.schoolName, 187.5, 420);
        // 名称
        ctx.fillStyle = '#666666';
        ctx.font = "normal normal normal 16px Arial";
        ctx.fillText(_this.className, 187.5, 450);
        // 二维码信息
        // ctx.fillText(_this.code,30,460);
        // ctx.drawImage(img,0,0,canvas.width,canvas.height);
        //保存生成作品图片
        // _this.base64 = (canvas.toDataURL("image/jpeg",1));
        //alert(JSON.stringify(base64));
        // console.log(_this.base64);
        fn(canvas.toDataURL("image/jpeg", 1));
      };
    }
  }
});
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/template-compiler?{"id":"data-v-78382608","hasScoped":true,"transformToRequire":{"video":["src","poster"],"source":"src","img":"src","image":"xlink:href"},"buble":{"transforms":{}}}!./node_modules/vue-loader/lib/selector.js?type=template&index=0!./src/pages/schoolQrcode/schoolQrcode.vue
var schoolQrcode_render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"schoolQrcode"},[_c('div',{staticClass:"mv-qrcode-block"},[_c('span',{staticClass:"title",domProps:{"textContent":_vm._s(_vm.title)}}),_vm._v(" "),_c('vue-qr',{staticClass:"mv-qrcode",attrs:{"dotScale":1,"text":_vm.downloadData.url,"margin":0,"logoCornerRadius":"50","logoScale":"0.22","logoMargin":"1000","logoSrc":_vm.downloadData.icon,"size":1000}}),_vm._v(" "),_c('span',{staticClass:"school",domProps:{"textContent":_vm._s(_vm.schoolName)}}),_vm._v(" "),_c('span',{staticClass:"class",domProps:{"textContent":_vm._s(_vm.className)}})],1),_vm._v(" "),_c('div',{staticClass:"mv-save-btn",on:{"click":_vm.saveLocal}},[_vm._v("\n    保存本地\n  ")]),_vm._v(" "),_c('div',{staticClass:"mv-wx-share"},[_vm._m(0),_vm._v(" "),_c('i',{staticClass:"icon-wx",on:{"click":_vm.wxShare}}),_vm._v(" "),_c('span',{staticClass:"text"},[_vm._v("微信好友")])])])}
var schoolQrcode_staticRenderFns = [function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"cut-off-rule"},[_c('div',{staticClass:"hr"}),_vm._v(" "),_c('span',[_vm._v("分享至")])])}]
var schoolQrcode_esExports = { render: schoolQrcode_render, staticRenderFns: schoolQrcode_staticRenderFns }
/* harmony default export */ var schoolQrcode_schoolQrcode = (schoolQrcode_esExports);
// CONCATENATED MODULE: ./src/pages/schoolQrcode/schoolQrcode.vue
function injectStyle (ssrContext) {
  __webpack_require__("gDX4")
}
var schoolQrcode_normalizeComponent = __webpack_require__("VU/8")
/* script */


/* template */

/* template functional */
var schoolQrcode___vue_template_functional__ = false
/* styles */
var schoolQrcode___vue_styles__ = injectStyle
/* scopeId */
var schoolQrcode___vue_scopeId__ = "data-v-78382608"
/* moduleIdentifier (server only) */
var schoolQrcode___vue_module_identifier__ = null
var schoolQrcode_Component = schoolQrcode_normalizeComponent(
  schoolQrcode,
  schoolQrcode_schoolQrcode,
  schoolQrcode___vue_template_functional__,
  schoolQrcode___vue_styles__,
  schoolQrcode___vue_scopeId__,
  schoolQrcode___vue_module_identifier__
)

/* harmony default export */ var pages_schoolQrcode_schoolQrcode = __webpack_exports__["default"] = (schoolQrcode_Component.exports);


/***/ }),

/***/ "gDX4":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "i4uy":
/***/ (function(module, exports) {

// Unique ID creation requires a high quality random # generator.  In the
// browser this is a little complicated due to unknown quality of Math.random()
// and inconsistent support for the `crypto` API.  We do the best we can via
// feature-detection

// getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
var getRandomValues = (typeof(crypto) != 'undefined' && crypto.getRandomValues.bind(crypto)) ||
                      (typeof(msCrypto) != 'undefined' && msCrypto.getRandomValues.bind(msCrypto));
if (getRandomValues) {
  // WHATWG crypto RNG - http://wiki.whatwg.org/wiki/Crypto
  var rnds8 = new Uint8Array(16); // eslint-disable-line no-undef

  module.exports = function whatwgRNG() {
    getRandomValues(rnds8);
    return rnds8;
  };
} else {
  // Math.random()-based (RNG)
  //
  // If all else fails, use Math.random().  It's fast, but is of unspecified
  // quality.
  var rnds = new Array(16);

  module.exports = function mathRNG() {
    for (var i = 0, r; i < 16; i++) {
      if ((i & 0x03) === 0) r = Math.random() * 0x100000000;
      rnds[i] = r >>> ((i & 0x03) << 3) & 0xff;
    }

    return rnds;
  };
}


/***/ })

});