/**
 * 自定义基本类库，依赖于zepto或jquery
 * */
(function () {
    /* ！定义 module 和基本方法*/
    var config = {
            version: '1.0.0',
            debug: true
        },
        params = {
            alertTime: null, //记录alert 时间
            deviceReady: false, // cordova 加载状态
            optionsArray: [], //cordova 加载未完成前的事件
            newWindow: [] //cordova 加载未完成前的事件
        },
        module = {
            EVENT: {
                BACKDROP: 'BACKDROP' //点击了背景
            },
            NATIVE: {
                PULL: {
                    startPullDown: 'startPullDown', //开始下拉刷新
                    endPullDown: 'endPullDown', //结束下拉刷新
                    startPullUp: 'startPullUp', //开始上拉刷新
                    endPullUp: 'endPullUp', //结束上拉刷新
                    noData: 'noData' //没有上拉刷新，无数据
                },
                BACK: {
                    registerBack: 'registerBack', //注册返回键
                    releaseBack: 'releaseBack' //释放返回键
                },
                MESSAGE: {
                    TOAST: 'toast' /* ! toast 提示 */
                }
            },
            TOSELF: {
                PULL: {
                    pullDown: 'pullDown', //下拉刷新触发
                    pullUp: 'pullUp' //上拉刷新触发
                },
                back: 'back' //返回键回调
            },
            /* ! 设置config */
            setConfig: function (a, b) {
                if (typeof a == 'string') {
                    if (config[a]) {
                        config[a] = b;
                    }
                } else {
                    for (var configKey in a) {
                        module.setConfig(configKey, a[configKey]);
                    }
                }
            },
            /*消息执行函数*/
            messageCallBack: {},
            /* ! 模块方法继承函数*/
            extend: function (a, b) {
                if (typeof a == 'string') {
                    module[a] = b;
                } else {
                    for (var funcName in a) {
                        module.extend(funcName, a[funcName]);
                    }
                }
            },
            init: function () {
                //处理 IOS 双击上滑问题 问题
                (function () {
                    var agent = navigator.userAgent.toLowerCase();
                    var iLastTouch = null; //缓存上一次tap的时间
                    if (agent.indexOf('iphone') >= 0 || agent.indexOf('ipad') >= 0) //检测是否是ios
                    {
                        document.addEventListener('touchend', function (event) {
                            var iNow = new Date().getTime();
                            iLastTouch = iLastTouch || iNow + 1 /** 第一次时将iLastTouch设为当前时间+1 */ ;
                            var delta = iNow - iLastTouch;
                            if (delta < 500 && delta > 0) {
                                event.preventDefault();
                                return false;
                            }
                            iLastTouch = iNow;
                        }, false);
                    }
                })();
            }
        };

    /* ！ 使用extend 继承扩展方法 */
    module.extend({
        postMessage: function (op) {
            if (op.call && module.messageCallBack[op.call] && typeof (module.messageCallBack[op.call]) === "function") {
                module.messageCallBack[op.call].call(op);
            }
        },
        postToNativeMessage: function (op) {
            if (typeof viewModule != 'undefined' && params.deviceReady) {
                viewModule.postMessage(null, null, op);
            } else {
                params.optionsArray.push(op);
            }
        },
        /* * native 方法*/
        closeToWindow: function (op) {
            var options = {
                reload: false,
                step: 1
            }
            Object.assign(options, op);
            if (typeof viewModule != 'undefined') {
                viewModule.closeToWindow(null, null, options);
            } else {
                window.history.go(-options.step);
            }
        },
        loading: {
            show: function () {
                var loading = $('.loading');

                if (loading.length < 1) {
                    module.backdrop.show(true);
                    $('body').append('<div class="loading animated zoom active"></div>');
                }
            },
            hide: function () {
                var loading = $('.loading').removeClass('active');
                module.backdrop.hide();
                module.timeToRemove(loading, 600);
            }
        },
        backdrop: {
            show: function (nobg) {
                var backdrop = $('.backdrop');

                if (backdrop.length) {
                    if (nobg == true) {
                        backdrop.addClass('no-bg');
                    } else {
                        backdrop.removeClass('no-bg')
                    }
                } else {
                    var html = nobg ? '<div class="backdrop no-bg"></div>' : '<div class="backdrop"></div>';

                    backdrop = $(html);
                    $('body').append(backdrop);
                }
                /* ！ 点击抛出事件 */
                backdrop.off('tap').on('tap', function () {
                    $(document).trigger(module.EVENT.BACKDROP);
                });
            },
            hide: function () {
                $('.backdrop').remove();
            }
        },
        timeToRemove: function (el, time) {
            setTimeout(function () {
                el.remove();
            }, time);
        },
        fileManage: {
            imgUrl2Blob: function (url, cb) {
                var xhr = new XMLHttpRequest();
                xhr.open("get", url, true);
                xhr.responseType = "blob";
                xhr.onload = function () {
                    if (this.status == 200 || this.status == 0) {
                        cb.call(this.response);
                    }
                }
                xhr.send();
            },
            formatDataByUrl: function (url, cb) {
                module.fileManage.imgUrl2Blob(url, function () {
                    var formData = new FormData();
                    formData.append('file', this, 'file_' + Date.parse(new Date()) + '.jpeg');
                    cb.call(formData);
                });
            }
        }
    });
    /* ! 初始化 */
    module.init();

    //处理cordova 默认 元素加载完成事件
    document.addEventListener('deviceready', function () {
        params.deviceReady = true; //设置 device 加载完成
        for (var i = 0; i < params.optionsArray.length; i++) {
            module.postToNativeMessage(params.optionsArray[i]);
        }
        for (var i = 0; i < params.newWindow.length; i++) {
            viewModule.newWindow(null, null, params.newWindow[i]);
        }
    }, false);

    /* *
     * 定义window全局变量module
     * */
    window.module = module;
}())