/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.iig.shai.detect;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import com.iqiyi.iig.shai.detect.bean.BodySegmentBean;
import com.iqiyi.iig.shai.detect.bean.BodySkeletonBean;
import com.iqiyi.iig.shai.detect.bean.Face106Bean;
import com.iqiyi.iig.shai.detect.bean.Face240;
import com.iqiyi.iig.shai.detect.bean.FaceMesh;
import com.iqiyi.iig.shai.detect.bean.FaceShapeBean;
import com.iqiyi.iig.shai.detect.bean.HandStaticGestureBean;
import com.iqiyi.iig.shai.detect.bean.HumanAttribuate;
import com.iqiyi.iig.shai.detect.bean.HumanDetectResult;
import com.iqiyi.iig.shai.detect.bean.ObjectDetectionBean;
import com.iqiyi.iig.shai.detect.bean.ScanBean;
import com.iqiyi.iig.shai.detect.bean.Vector3f;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParseDetectResult {
    public static List<HandStaticGestureBean> getHandStaticGesture(String string) {
        ArrayList<HandStaticGestureBean> arrayList = new ArrayList<HandStaticGestureBean>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getHandStaticGesture(jSONObject);
        }
        catch (Exception exception) {
            return arrayList;
        }
    }

    public static List<HandStaticGestureBean> getHandStaticGesture(JSONObject jSONObject) {
        ArrayList<HandStaticGestureBean> arrayList = new ArrayList<HandStaticGestureBean>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("hands");
            if (jSONArray == null || jSONArray.length() == 0) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2;
                HandStaticGestureBean handStaticGestureBean = new HandStaticGestureBean();
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                handStaticGestureBean.handID = jSONObject3.optInt("ID", 0);
                handStaticGestureBean.score = Float.valueOf(jSONObject3.optString("score", "0")).floatValue();
                handStaticGestureBean.keyPointCount = jSONObject3.optInt("key_points_count", 0);
                JSONArray jSONArray2 = jSONObject3.optJSONArray("key_points");
                handStaticGestureBean.keyPoints = new ArrayList<PointF>();
                if (jSONArray2 != null && jSONArray2.length() > 0) {
                    for (int j = 0; j < jSONArray2.length(); ++j) {
                        JSONArray jSONArray3 = jSONArray2.optJSONArray(j);
                        if (jSONArray3 == null || jSONArray3.length() != 2) continue;
                        PointF pointF = new PointF(Float.valueOf(jSONArray3.optString(0)).floatValue(), Float.valueOf(jSONArray3.optString(1)).floatValue());
                        handStaticGestureBean.keyPoints.add(pointF);
                    }
                }
                if ((jSONObject2 = jSONObject3.optJSONObject("rect")) != null) {
                    handStaticGestureBean.rect = new RectF(Float.valueOf(jSONObject2.optString("l", "0")).floatValue(), Float.valueOf(jSONObject2.optString("t", "0")).floatValue(), Float.valueOf(jSONObject2.optString("r", "0")).floatValue(), Float.valueOf(jSONObject2.optString("b", "0")).floatValue());
                }
                handStaticGestureBean.handAction = jSONObject3.optLong("hand_action", 0L);
                handStaticGestureBean.classId = jSONObject3.optInt("classId", -1);
                arrayList.add(handStaticGestureBean);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static List<ScanBean> getScans(String string) {
        ArrayList<ScanBean> arrayList = new ArrayList<ScanBean>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getScans(jSONObject);
        }
        catch (Exception exception) {
            return arrayList;
        }
    }

    public static List<ObjectDetectionBean> getObjectDetection(String string) {
        ArrayList<ObjectDetectionBean> arrayList = new ArrayList<ObjectDetectionBean>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getObjectDetection(jSONObject);
        }
        catch (Exception exception) {
            return arrayList;
        }
    }

    public static List<ScanBean> getScans(JSONObject jSONObject) {
        ArrayList<ScanBean> arrayList = new ArrayList<ScanBean>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("scans");
            if (jSONArray == null || jSONArray.length() == 0) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                ScanBean scanBean = new ScanBean();
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                scanBean.score = Float.valueOf(jSONObject2.optString("score", "0")).floatValue();
                scanBean.classId = jSONObject2.optInt("classId", -1);
                arrayList.add(scanBean);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static List<ObjectDetectionBean> getObjectDetection(JSONObject jSONObject) {
        ArrayList<ObjectDetectionBean> arrayList = new ArrayList<ObjectDetectionBean>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("objects");
            if (jSONArray == null || jSONArray.length() == 0) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                ObjectDetectionBean objectDetectionBean = new ObjectDetectionBean();
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                objectDetectionBean.id = jSONObject2.optInt("ID", 0);
                objectDetectionBean.score = Float.valueOf(jSONObject2.optString("score", "0")).floatValue();
                JSONObject jSONObject3 = jSONObject2.optJSONObject("rect");
                if (jSONObject3 != null) {
                    objectDetectionBean.rect = new RectF(Float.valueOf(jSONObject3.optString("l", "0")).floatValue(), Float.valueOf(jSONObject3.optString("t", "0")).floatValue(), Float.valueOf(jSONObject3.optString("r", "0")).floatValue(), Float.valueOf(jSONObject3.optString("b", "0")).floatValue());
                }
                objectDetectionBean.classId = jSONObject2.optInt("classId", -1);
                arrayList.add(objectDetectionBean);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static List<BodySkeletonBean> getBodySkeleton(String string) {
        ArrayList<BodySkeletonBean> arrayList = new ArrayList<BodySkeletonBean>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getBodySkeleton(jSONObject);
        }
        catch (Exception exception) {
            return arrayList;
        }
    }

    public static List<BodySkeletonBean> getBodySkeleton(JSONObject jSONObject) {
        ArrayList<BodySkeletonBean> arrayList = new ArrayList<BodySkeletonBean>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("bodies");
            if (jSONArray == null || jSONArray.length() == 0) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                BodySkeletonBean bodySkeletonBean = new BodySkeletonBean();
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                bodySkeletonBean.id = jSONObject2.optInt("ID", 0);
                bodySkeletonBean.actionId = jSONObject2.optInt("actionId", -1);
                JSONArray jSONArray2 = jSONObject2.optJSONArray("skeleton_positions");
                JSONArray jSONArray3 = jSONObject2.optJSONArray("skeleton_scores");
                if (jSONArray2 == null || jSONArray2.length() != 14 || jSONArray3 == null || jSONArray3.length() != 14) continue;
                bodySkeletonBean.positions = new BodySkeletonBean.SkeletonPosition[14];
                for (int j = 0; j < 14; ++j) {
                    JSONArray jSONArray4 = jSONArray2.optJSONArray(j);
                    bodySkeletonBean.positions[j] = new BodySkeletonBean.SkeletonPosition();
                    if (jSONArray4 == null || jSONArray4.length() != 2) continue;
                    bodySkeletonBean.positions[j].position = new PointF(Float.valueOf(jSONArray4.optString(0, "0")).floatValue(), Float.valueOf(jSONArray4.optString(1, "0")).floatValue());
                    bodySkeletonBean.positions[j].score = Float.valueOf(jSONArray3.optString(j, "0")).floatValue();
                }
                arrayList.add(bodySkeletonBean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<Face106Bean> getFaceBean(String string) {
        ArrayList<Face106Bean> arrayList = new ArrayList<Face106Bean>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getFaceBean(jSONObject);
        }
        catch (Exception exception) {
            return arrayList;
        }
    }

    public static List<Face106Bean> getFaceBean(JSONObject jSONObject) {
        ArrayList<Face106Bean> arrayList = new ArrayList<Face106Bean>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("faces");
            if (jSONArray == null || jSONArray.length() == 0) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONArray jSONArray2;
                JSONArray jSONArray3;
                HumanAttribuate humanAttribuate;
                Face106Bean face106Bean = new Face106Bean();
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                JSONArray jSONArray4 = jSONObject2.optJSONArray("pos");
                JSONArray jSONArray5 = jSONObject2.optJSONArray("vis");
                if (jSONArray4.length() != 106) continue;
                for (int j = 0; j < jSONArray4.length(); ++j) {
                    face106Bean.landmark[j] = new Point();
                    face106Bean.landmark[j].x = jSONArray4.getJSONArray(j).getInt(0);
                    face106Bean.landmark[j].y = jSONArray4.getJSONArray(j).getInt(1);
                    face106Bean.visibility[j] = jSONArray5.optDouble(j, 0.0) > 0.5;
                }
                JSONObject jSONObject3 = jSONObject2.optJSONObject("rect");
                if (jSONObject3 != null) {
                    face106Bean.rect = new RectF(Float.valueOf(jSONObject3.optString("l", "0")).floatValue(), Float.valueOf(jSONObject3.optString("t", "0")).floatValue(), Float.valueOf(jSONObject3.optString("r", "0")).floatValue(), Float.valueOf(jSONObject3.optString("b", "0")).floatValue());
                }
                face106Bean.eyeDist = Float.valueOf(jSONObject2.optString("eye_dist", "0")).floatValue();
                face106Bean.yaw = Float.valueOf(jSONObject2.optString("yaw", "0")).floatValue();
                face106Bean.pitch = Float.valueOf(jSONObject2.optString("pitch", "0")).floatValue();
                face106Bean.roll = Float.valueOf(jSONObject2.optString("roll", "0")).floatValue();
                face106Bean.score = Float.valueOf(jSONObject2.optString("score", "0")).floatValue();
                face106Bean.faceId = jSONObject2.optInt("ID", 0);
                face106Bean.action = jSONObject2.optInt("face_action", 0);
                JSONObject jSONObject4 = jSONObject2.optJSONObject("attribute");
                if (jSONObject4 != null) {
                    humanAttribuate = new HumanAttribuate();
                    humanAttribuate.age = Float.valueOf(jSONObject4.optString("age", "-1")).floatValue();
                    humanAttribuate.gender = jSONObject4.optInt("gender", -1);
                    face106Bean.attribuate = humanAttribuate;
                }
                humanAttribuate = jSONObject2.optJSONArray("pos240");
                JSONArray jSONArray6 = jSONObject2.optJSONArray("vis240");
                face106Bean.face240 = new Face240();
                if (humanAttribuate != null && humanAttribuate.length() == face106Bean.face240.extra_face_points_count) {
                    for (int j = 0; j < humanAttribuate.length(); ++j) {
                        face106Bean.face240.landmark[j] = new Point();
                        face106Bean.face240.landmark[j].x = humanAttribuate.getJSONArray(j).getInt(0);
                        face106Bean.face240.landmark[j].y = humanAttribuate.getJSONArray(j).getInt(1);
                        face106Bean.face240.visibility[j] = jSONArray6.optDouble(j, 0.0) > 0.5;
                    }
                }
                if ((jSONArray3 = jSONObject2.optJSONArray("facemesh")) != null && jSONArray3.length() == 568) {
                    face106Bean.faceMesh = new FaceMesh();
                    for (int j = 0; j < 568; ++j) {
                        face106Bean.faceMesh.face568[j] = new Vector3f();
                        face106Bean.faceMesh.face568[j].x = jSONArray3.getJSONArray(j).getInt(0);
                        face106Bean.faceMesh.face568[j].y = jSONArray3.getJSONArray(j).getInt(1);
                        face106Bean.faceMesh.face568[j].z = jSONArray3.getJSONArray(j).getInt(2);
                    }
                }
                if ((jSONArray2 = jSONObject2.optJSONArray("faceshape")) != null && jSONArray2.length() == FaceShapeBean.SHAPE_KEY.length) {
                    face106Bean.faceShape = new FaceShapeBean();
                    face106Bean.faceShape.shapeCount = jSONArray2.length();
                    for (int j = 0; j < face106Bean.faceShape.shapeCount; ++j) {
                        face106Bean.faceShape.shape[j] = Float.valueOf(jSONArray2.optString(j, "0")).floatValue();
                    }
                }
                arrayList.add(face106Bean);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static BodySegmentBean getBodySegment(String string) {
        BodySegmentBean bodySegmentBean = new BodySegmentBean();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getBodySegment(jSONObject);
        }
        catch (Exception exception) {
            return bodySegmentBean;
        }
    }

    public static BodySegmentBean getBodySegment(JSONObject jSONObject) {
        BodySegmentBean bodySegmentBean = new BodySegmentBean();
        try {
            JSONObject jSONObject2 = jSONObject.optJSONObject("body_segment");
            if (jSONObject2 == null) {
                return null;
            }
            bodySegmentBean.width = jSONObject2.optInt("width", 0);
            bodySegmentBean.height = jSONObject2.optInt("height", 0);
            bodySegmentBean.dataPtr = jSONObject2.optLong("data", 0L);
            bodySegmentBean.pixelFormat = jSONObject2.optInt("pixel_format", 0);
            bodySegmentBean.stride = jSONObject2.optInt("stride", 0);
            bodySegmentBean.rotation = jSONObject2.optInt("rotation", 0);
            bodySegmentBean.vflip = (short)jSONObject2.optInt("vflip", 0);
            bodySegmentBean.hflip = (short)jSONObject2.optInt("hflip", 0);
            if (bodySegmentBean.width == 0 || bodySegmentBean.height == 0 || bodySegmentBean.dataPtr == 0L) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return bodySegmentBean;
    }

    public static BodySegmentBean getHeadSegment(String string) {
        BodySegmentBean bodySegmentBean = new BodySegmentBean();
        try {
            JSONObject jSONObject = new JSONObject(string);
            return ParseDetectResult.getHeadSegment(jSONObject);
        }
        catch (Exception exception) {
            return bodySegmentBean;
        }
    }

    public static BodySegmentBean getHeadSegment(JSONObject jSONObject) {
        BodySegmentBean bodySegmentBean = new BodySegmentBean();
        try {
            JSONObject jSONObject2 = jSONObject.optJSONObject("head_segment");
            if (jSONObject2 == null) {
                return null;
            }
            bodySegmentBean.width = jSONObject2.optInt("width", 0);
            bodySegmentBean.height = jSONObject2.optInt("height", 0);
            bodySegmentBean.dataPtr = jSONObject2.optLong("data", 0L);
            bodySegmentBean.pixelFormat = jSONObject2.optInt("pixel_format", 0);
            bodySegmentBean.stride = jSONObject2.optInt("stride", 0);
            bodySegmentBean.rotation = jSONObject2.optInt("rotation", 0);
            bodySegmentBean.vflip = (short)jSONObject2.optInt("vflip", 0);
            bodySegmentBean.hflip = (short)jSONObject2.optInt("hflip", 0);
            bodySegmentBean.id = jSONObject2.optInt("id", 0);
            bodySegmentBean.left = jSONObject2.optInt("left", 0);
            bodySegmentBean.right = jSONObject2.optInt("right", 0);
            bodySegmentBean.bottom = jSONObject2.optInt("bottom", 0);
            bodySegmentBean.top = jSONObject2.optInt("top", 0);
            if (bodySegmentBean.width == 0 || bodySegmentBean.height == 0 || bodySegmentBean.dataPtr == 0L) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return bodySegmentBean;
    }

    public static HumanDetectResult getHuamDetectResult(String string) {
        HumanDetectResult humanDetectResult = new HumanDetectResult();
        try {
            JSONObject jSONObject = new JSONObject(string);
            humanDetectResult.faces = ParseDetectResult.getFaceBean(jSONObject);
            humanDetectResult.bodySkeletons = ParseDetectResult.getBodySkeleton(jSONObject);
            humanDetectResult.handStaticGestures = ParseDetectResult.getHandStaticGesture(jSONObject);
            humanDetectResult.bodySegment = ParseDetectResult.getBodySegment(jSONObject);
            humanDetectResult.headSegment = ParseDetectResult.getHeadSegment(jSONObject);
            humanDetectResult.scanBeans = ParseDetectResult.getScans(jSONObject);
            humanDetectResult.objectDetections = ParseDetectResult.getObjectDetection(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return humanDetectResult;
    }
}

