/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.iig.shai.scan;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.text.TextUtils;
import com.iqiyi.iig.shai.detect.DetectionModule;
import com.iqiyi.iig.shai.scan.IScanCallBack;
import com.iqiyi.iig.shai.scan.UploadHelper;
import com.iqiyi.iig.shai.scan.bean.ARResponse;
import com.iqiyi.iig.shai.scan.bean.ClipImageParam;
import com.iqiyi.iig.shai.scan.bean.RequestBean;
import com.iqiyi.iig.shai.scan.bean.RequestPara;
import com.iqiyi.iig.shai.scan.bean.ResponseBean;
import com.iqiyi.iig.shai.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class FaceTrackHelper
implements IScanCallBack {
    public static Bitmap bitmaptest;
    private UploadHelper mUploadHelper;
    private static int MAX_RETRY;
    ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    Map<String, ResponseBean.FaceScanBean> mTrackFace = new HashMap<String, ResponseBean.FaceScanBean>();
    private boolean isProcess = false;
    long lastUploadTime = System.currentTimeMillis();
    long lastTime = System.currentTimeMillis();

    public FaceTrackHelper(Context context, UploadHelper uploadHelper) {
        this.mUploadHelper = uploadHelper;
    }

    List<ResponseBean.FaceScanBean> getStarFace() {
        ArrayList<ResponseBean.FaceScanBean> arrayList = new ArrayList<ResponseBean.FaceScanBean>();
        if (this.mTrackFace != null) {
            for (String string : this.mTrackFace.keySet()) {
                ResponseBean.FaceScanBean faceScanBean = this.mTrackFace.get(string);
                if (faceScanBean == null || TextUtils.isEmpty((CharSequence)faceScanBean.qipuId)) continue;
                arrayList.add(faceScanBean);
            }
        }
        return arrayList;
    }

    void updateTrackFace(List<ResponseBean.FaceScanBean> list, byte[] byArray, String string) {
        Map.Entry<String, ResponseBean.FaceScanBean> entry;
        if (list == null || list.size() == 0) {
            this.mTrackFace.clear();
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            entry = list.get(i);
            String string2 = ((ResponseBean.FaceScanBean)((Object)entry)).faceId + "";
            hashSet.add(string2);
            if (this.mTrackFace.containsKey(string2)) {
                this.mTrackFace.get((Object)string2).faceRect = new RectF(((ResponseBean.FaceScanBean)((Object)entry)).faceRect);
                this.mTrackFace.get((Object)string2).faceRectDisplay = new RectF(((ResponseBean.FaceScanBean)((Object)entry)).faceRectDisplay);
                this.mTrackFace.get((Object)string2).score = ((ResponseBean.FaceScanBean)((Object)entry)).score;
                continue;
            }
            ((ResponseBean.FaceScanBean)((Object)entry)).isStar = ResponseBean.SCAN_STATU.NOT_SURE;
            this.mTrackFace.put(string2, (ResponseBean.FaceScanBean)((Object)entry));
        }
        Iterator<Map.Entry<String, ResponseBean.FaceScanBean>> iterator = this.mTrackFace.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (hashSet.contains(entry.getKey())) continue;
            iterator.remove();
        }
        this.handleStarPost(byArray, string);
    }

    private void handleStarPost(final byte[] byArray, String string) {
        if (System.currentTimeMillis() - this.lastTime > 50000L) {
            this.lastTime = System.currentTimeMillis();
            this.isProcess = false;
            this.onError();
            return;
        }
        if (this.isProcess) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUploadTime < 400L) {
            LogUtil.LogE("QYAR", "interl is less 400,det=" + (System.currentTimeMillis() - this.lastUploadTime));
            return;
        }
        this.isProcess = true;
        this.lastTime = System.currentTimeMillis();
        final ArrayList<ResponseBean.FaceScanBean> arrayList = new ArrayList<ResponseBean.FaceScanBean>();
        final ClipImageParam clipImageParam = new ClipImageParam();
        try {
            ResponseBean.FaceScanBean faceScanBean;
            JSONObject jSONObject = new JSONObject(string);
            clipImageParam.detectionParam.orientation = jSONObject.optInt("orientation", -1);
            clipImageParam.detectionParam.front = jSONObject.optInt("front", -1);
            clipImageParam.detectionParam.formatType = jSONObject.optInt("formatType", -1);
            clipImageParam.detectionParam.cameraOrientation = jSONObject.optInt("camera_orientation", -1);
            clipImageParam.detectionParam.sensorX = Float.valueOf(jSONObject.optString("sensorX", "0")).floatValue();
            clipImageParam.detectionParam.sensorY = Float.valueOf(jSONObject.optString("sensorY", "0")).floatValue();
            clipImageParam.detectionParam.sensorZ = Float.valueOf(jSONObject.optString("sensorZ", "0")).floatValue();
            clipImageParam.detectionParam.displayOrientation = jSONObject.optInt("displayOrientation", 0);
            clipImageParam.detectionParam.width = jSONObject.optInt("w", -1);
            clipImageParam.detectionParam.height = jSONObject.optInt("h", -1);
            for (String string2 : this.mTrackFace.keySet()) {
                faceScanBean = this.mTrackFace.get(string2);
                if (faceScanBean.isStar != ResponseBean.SCAN_STATU.NOT_SURE) continue;
                this.mTrackFace.get((Object)string2).isStar = ResponseBean.SCAN_STATU.IS_PROCESSING;
                arrayList.add(this.mTrackFace.get(string2));
            }
            if (arrayList == null || arrayList.size() == 0) {
                this.isProcess = false;
                return;
            }
            for (String string2 : this.mTrackFace.keySet()) {
                faceScanBean = this.mTrackFace.get(string2);
                if (faceScanBean.isStar != ResponseBean.SCAN_STATU.NO) continue;
                this.mTrackFace.get((Object)string2).isStar = ResponseBean.SCAN_STATU.IS_PROCESSING;
                arrayList.add(this.mTrackFace.get(string2));
            }
        }
        catch (Exception exception) {
            this.isProcess = false;
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                RequestPara requestPara = new RequestPara();
                requestPara.flag = ((ResponseBean.FaceScanBean)arrayList.get((int)0)).faceId + "";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Bitmap bitmap;
                    ResponseBean.FaceScanBean faceScanBean = (ResponseBean.FaceScanBean)arrayList.get(i);
                    int n = (int)(faceScanBean.faceRect.right - faceScanBean.faceRect.left);
                    int n2 = (int)(faceScanBean.faceRect.bottom - faceScanBean.faceRect.top);
                    int[] nArray = new int[n * n2];
                    clipImageParam.clipRectF = faceScanBean.faceRect;
                    nArray = DetectionModule.nativeGetClipImage(byArray, clipImageParam);
                    if (nArray == null) {
                        FaceTrackHelper.this.isProcess = false;
                        return;
                    }
                    RequestBean requestBean = new RequestBean();
                    requestBean.fileName = faceScanBean.faceId + "";
                    requestBean.identify = "images";
                    bitmaptest = bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.setPixels(nArray, 0, n, 0, 0, n, n2);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
                    requestBean.fileContent = byteArrayOutputStream.toByteArray();
                    requestPara.fileInfo.add(requestBean);
                }
                FaceTrackHelper.this.mUploadHelper.request(requestPara, FaceTrackHelper.this);
            }
        }).start();
    }

    void updateQipuId(Map<String, String> map, boolean bl) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            if (!this.mTrackFace.containsKey(string + "")) continue;
            if (bl) {
                this.mTrackFace.get((Object)string).qipuId = map.get(string);
                this.mTrackFace.get((Object)string).isStar = TextUtils.isEmpty((CharSequence)map.get(string)) ? ResponseBean.SCAN_STATU.NO : ResponseBean.SCAN_STATU.YES;
                continue;
            }
            this.mTrackFace.get((Object)string).isStar = ResponseBean.SCAN_STATU.NOT_SURE;
        }
    }

    public void clearUnsureFaceWhenFocuse() {
        for (String string : this.mTrackFace.keySet()) {
            if (this.mTrackFace.get((Object)string).isStar == ResponseBean.SCAN_STATU.YES) continue;
            this.mTrackFace.get((Object)string).isStar = ResponseBean.SCAN_STATU.NOT_SURE;
            this.mTrackFace.get((Object)string).retryNum = 0;
        }
    }

    void updateQipuId(List<ARResponse> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ARResponse aRResponse = list.get(i);
            String string = aRResponse.filename;
            this.updateStarItem(string, aRResponse);
        }
    }

    void updateStarItem(String string, ARResponse aRResponse) {
        if (this.mTrackFace.containsKey(string + "")) {
            if (aRResponse.recognizeCode == ARResponse.CODE_SUCCESS) {
                this.mTrackFace.get((Object)string).retryNum = 0;
                this.mTrackFace.get((Object)string).birthday = aRResponse.birthday;
                this.mTrackFace.get((Object)string).circleId = aRResponse.circleId;
                this.mTrackFace.get((Object)string).imageUrl = aRResponse.image;
                this.mTrackFace.get((Object)string).isStar = TextUtils.isEmpty((CharSequence)aRResponse.id) && aRResponse.type != ARResponse.TYPE_STAR ? ResponseBean.SCAN_STATU.NO : ResponseBean.SCAN_STATU.YES;
                this.mTrackFace.get((Object)string).name = aRResponse.name;
                this.mTrackFace.get((Object)string).occupation = aRResponse.occupation;
                this.mTrackFace.get((Object)string).relateVideos = aRResponse.relatedVideos;
                this.mTrackFace.get((Object)string).confidence = aRResponse.confidence;
                this.mTrackFace.get((Object)string).result = aRResponse.result;
                this.mTrackFace.get((Object)string).qipuId = aRResponse.id;
            } else if (aRResponse.recognizeCode == ARResponse.CODE_EMPTY || aRResponse.recognizeCode == ARResponse.CODE_LOW) {
                ++this.mTrackFace.get((Object)string).retryNum;
                this.mTrackFace.get((Object)string).isStar = this.mTrackFace.get((Object)string).retryNum > MAX_RETRY ? ResponseBean.SCAN_STATU.NO : ResponseBean.SCAN_STATU.NOT_SURE;
            } else {
                this.mTrackFace.get((Object)string).isStar = ResponseBean.SCAN_STATU.NO;
            }
        }
        this.clearStatus(false);
    }

    void clearStatus(boolean bl) {
        for (String string : this.mTrackFace.keySet()) {
            if (this.mTrackFace.get((Object)string).isStar != ResponseBean.SCAN_STATU.IS_PROCESSING) continue;
            this.mTrackFace.get((Object)string).isStar = ResponseBean.SCAN_STATU.NOT_SURE;
            if (bl) continue;
            ++this.mTrackFace.get((Object)string).retryNum;
            if (this.mTrackFace.get((Object)string).retryNum <= MAX_RETRY) continue;
            this.mTrackFace.get((Object)string).isStar = ResponseBean.SCAN_STATU.NO;
        }
    }

    @Override
    public void onSucess(String string, List<String> list) {
        this.lastUploadTime = System.currentTimeMillis();
        this.isProcess = false;
        List<ARResponse> list2 = ARResponse.getArResponse(string);
        if (list2 == null || list2.size() == 0) {
            this.clearStatus(false);
            return;
        }
        this.updateQipuId(list2);
    }

    @Override
    public void onError() {
        this.isProcess = false;
        this.lastUploadTime = System.currentTimeMillis();
        this.clearStatus(true);
    }

    static {
        MAX_RETRY = 4;
    }
}

