/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.iig.shai.scan;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.Log;
import com.iqiyi.iig.shai.a.b;
import com.iqiyi.iig.shai.detect.DetectionFeature;
import com.iqiyi.iig.shai.detect.DetectionManager;
import com.iqiyi.iig.shai.detect.DetectionMode;
import com.iqiyi.iig.shai.detect.bean.DetectionConfig;
import com.iqiyi.iig.shai.detect.bean.PixFormat;
import com.iqiyi.iig.shai.scan.CameraHelper;
import com.iqiyi.iig.shai.scan.FaceTrackHelper;
import com.iqiyi.iig.shai.scan.SensorHelper;
import com.iqiyi.iig.shai.scan.ServerTask;
import com.iqiyi.iig.shai.scan.UploadHelper;
import com.iqiyi.iig.shai.scan.bean.ResponseBean;
import com.iqiyi.iig.shai.scan.bean.ScanConfig;
import com.iqiyi.iig.shai.util.LogUtil;
import com.iqiyi.iig.shai.util.a;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScanMananger {
    private ScanConfig mScanConfigs;
    private Context mContext;
    private SensorHelper mSensorHelper;
    private CameraHelper mCameraHelper;
    private DetectionManager mDetectionManager;
    private UploadHelper mUploadHelper;
    private FaceTrackHelper mFaceTrackHelper;
    private ServerTask mServerTask;
    private long lastFocusedTime = System.currentTimeMillis();
    public static String faceResult;

    public ScanMananger(Context context, SensorHelper sensorHelper, CameraHelper cameraHelper, String string) {
        this.mContext = context;
        this.mSensorHelper = sensorHelper;
        this.mCameraHelper = cameraHelper;
        this.mDetectionManager = new DetectionManager();
        this.mUploadHelper = new UploadHelper(context);
        boolean bl = this.mDetectionManager.initLibrary(string);
        this.mFaceTrackHelper = new FaceTrackHelper(context, this.mUploadHelper);
        this.mServerTask = new ServerTask(context);
        if (!bl) {
            Log.e((String)"qyar", (String)"init detectionLib fail");
        }
    }

    public void enableDebugServer() {
        this.mUploadHelper.enableDebugServer();
        this.mServerTask.enableDebugServer();
    }

    public boolean setScanConfig(ScanConfig scanConfig) {
        this.mScanConfigs = scanConfig;
        DetectionConfig detectionConfig = new DetectionConfig();
        detectionConfig.faceScale = scanConfig.faceScale;
        detectionConfig.faceTrackNum = scanConfig.maxFaceNum;
        this.mDetectionManager.setDetectionConfig(detectionConfig);
        this.mDetectionManager.setDetectionMode(DetectionMode.VIDEO_BOX);
        this.initDetection();
        this.mDetectionManager.enable(true);
        this.mUploadHelper.setDeviceId(scanConfig.devicesId);
        return true;
    }

    public boolean open() {
        b.a(a.b(this.mContext));
        HashSet<DetectionFeature> hashSet = new HashSet<DetectionFeature>();
        hashSet.add(DetectionFeature.QYAR_SCAN);
        b.a().a(hashSet, "", true);
        this.mDetectionManager.Open(this.mContext);
        this.mDetectionManager.setLogLevel(3);
        return true;
    }

    public boolean close() {
        this.mSensorHelper.closeSensor();
        this.mDetectionManager.Close();
        return true;
    }

    public void clearData() {
        this.mServerTask.clearData();
        this.mDetectionManager.clearCache();
    }

    private String getBitmapJsonPara(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("w", n);
            jSONObject.put("h", n2);
            if (bl2) {
                jSONObject.put("camera_orientation", this.mCameraHelper.getOrientation());
                jSONObject.put("orientation", this.mCameraHelper.getCameraOrientation());
                jSONObject.put("front", this.mCameraHelper.getisFront());
            } else {
                jSONObject.put("orientation", 0);
                jSONObject.put("camera_orientation", 0);
                jSONObject.put("front", 0);
            }
            jSONObject.put("formatType", bl3 ? 1 : 0);
            if (bl) {
                jSONObject.put("sensorX", (double)this.mSensorHelper.getSensorX());
                jSONObject.put("sensorY", (double)this.mSensorHelper.getSensorY());
                jSONObject.put("sensorZ", (double)this.mSensorHelper.getSensorZ());
            } else {
                jSONObject.put("sensorX", 0);
                jSONObject.put("sensorY", 10);
                jSONObject.put("sensorZ", 0);
            }
            return jSONObject.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void handleStar(byte[] byArray, String string, List<ResponseBean> list) {
        if (list == null) {
            this.mFaceTrackHelper.updateTrackFace(null, byArray, string);
            return;
        }
        ArrayList<ResponseBean.FaceScanBean> arrayList = new ArrayList<ResponseBean.FaceScanBean>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).feature != DetectionFeature.QYAR_HUMAN_FACE_BASE || list.get((int)i).faceScanBeans == null || list.get((int)i).faceScanBeans.size() <= 0) continue;
            arrayList.addAll(list.get((int)i).faceScanBeans);
        }
        this.mFaceTrackHelper.updateTrackFace(arrayList, byArray, string);
    }

    private List<ResponseBean> detection(Bitmap bitmap, boolean bl, boolean bl2) {
        int n = bitmap.getRowBytes() * bitmap.getHeight();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        byte[] byArray = byteBuffer.array();
        return this.detection(byArray, PixFormat.QYAR_PIXEL_RGBA8888, bitmap.getWidth(), bitmap.getHeight(), bl2, bl, true);
    }

    public List<ResponseBean> detection(byte[] byArray, int n, int n2, int n3, boolean bl, boolean bl2) {
        List<ResponseBean> list = this.detection(byArray, n, n2, n3);
        if (bl2 && bl) {
            this.mServerTask.request(byArray, this.getBitmapJsonPara(n2, n3, true, true, false));
        }
        if (bl2) {
            LogUtil.LogD("qyar", "fouced time = " + System.currentTimeMillis() + " last = " + this.lastFocusedTime + " delta = " + (System.currentTimeMillis() - this.lastFocusedTime));
            if (System.currentTimeMillis() - this.lastFocusedTime < 1000L) {
                LogUtil.LogE("qyar", "focued is too mach delta = " + (System.currentTimeMillis() - this.lastFocusedTime));
            }
            this.lastFocusedTime = System.currentTimeMillis();
            this.mFaceTrackHelper.clearUnsureFaceWhenFocuse();
        }
        return list;
    }

    public List<ResponseBean> detection(byte[] byArray, int n, int n2, int n3) {
        if (this.mCameraHelper == null || this.mSensorHelper == null) {
            Log.e((String)"qyar", (String)"scan detection is mCameraHelper == null || mSensorHelper == null");
            return null;
        }
        return this.detection(byArray, n, n2, n3, true, true, false);
    }

    private List<ResponseBean> detection(byte[] byArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        String string;
        String string2 = this.getBitmapJsonPara(n2, n3, bl, bl2, bl3);
        faceResult = string = this.mDetectionManager.detectSync(byArray, string2);
        List<ResponseBean> list = this.transferJsonToResponse(string);
        this.handleStar(byArray, string2, list);
        return this.getDetectResult(list);
    }

    private List<ResponseBean> getDetectResult(List<ResponseBean> list) {
        ResponseBean responseBean;
        ArrayList<ResponseBean> arrayList = new ArrayList<ResponseBean>();
        List<ResponseBean.ServerTaskBean> list2 = this.mServerTask.getmServerResult();
        if (list2 != null && list2.size() > 0) {
            for (int i = 0; i < list2.size(); ++i) {
                ResponseBean.ServerTaskBean serverTaskBean = list2.get(i);
                responseBean = new ResponseBean();
                responseBean.feature = DetectionFeature.QYAR_SCAN_UPLOAD_SERVER;
                responseBean.uploadServer = serverTaskBean;
                arrayList.add(responseBean);
            }
        }
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        List<ResponseBean.FaceScanBean> list3 = this.mFaceTrackHelper.getStarFace();
        for (int i = 0; i < list.size(); ++i) {
            responseBean = list.get(i);
            if (responseBean.feature == DetectionFeature.QYAR_HUMAN_FACE_BASE) continue;
            arrayList.add(responseBean);
        }
        if (list3 != null && list3.size() > 0) {
            ResponseBean responseBean2 = new ResponseBean();
            responseBean2.feature = DetectionFeature.QYAR_HUMAN_FACE_BASE;
            responseBean2.faceScanBeans = list3;
            arrayList.add(responseBean2);
        }
        return arrayList;
    }

    private List<ResponseBean> transferJsonToResponse(String string) {
        try {
            JSONArray jSONArray;
            JSONArray jSONArray2;
            JSONObject jSONObject;
            Object object;
            Object object2;
            ArrayList<ResponseBean> arrayList = new ArrayList<ResponseBean>();
            JSONObject jSONObject2 = new JSONObject(string);
            JSONArray jSONArray3 = jSONObject2.optJSONArray("hands");
            if (jSONArray3 != null && jSONArray3.length() > 0) {
                object2 = new ResponseBean();
                object2.feature = DetectionFeature.QYAR_HUMAN_HAND_STATIC_GESTURE;
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    ResponseBean.ObjectDetectionBean objectDetectionBean = new ResponseBean.ObjectDetectionBean();
                    object = jSONArray3.getJSONObject(i);
                    objectDetectionBean.score = Float.valueOf(object.optString("score", "0")).floatValue();
                    jSONObject = object.optJSONObject("rect");
                    if (jSONObject != null) {
                        objectDetectionBean.objectRect = new RectF(Float.valueOf(jSONObject.optString("l", "0")).floatValue(), Float.valueOf(jSONObject.optString("t", "0")).floatValue(), Float.valueOf(jSONObject.optString("r", "0")).floatValue(), Float.valueOf(jSONObject.optString("b", "0")).floatValue());
                    }
                    objectDetectionBean.classId = object.optInt("classId", -1);
                    object2.gestures.add(objectDetectionBean);
                }
                arrayList.add((ResponseBean)object2);
            }
            if ((object2 = jSONObject2.optJSONArray("faces")) != null && object2.length() != 0) {
                ResponseBean responseBean = new ResponseBean();
                responseBean.feature = DetectionFeature.QYAR_HUMAN_FACE_BASE;
                for (int i = 0; i < object2.length(); ++i) {
                    object = new ResponseBean.FaceScanBean();
                    jSONObject = object2.optJSONObject(i);
                    JSONArray jSONArray4 = jSONObject.optJSONArray("pos");
                    if (jSONArray4.length() != 106) continue;
                    JSONObject jSONObject3 = jSONObject.optJSONObject("rect_detect");
                    if (jSONObject3 != null) {
                        object.faceRect = new RectF(Float.valueOf(jSONObject3.optString("l", "0")).floatValue(), Float.valueOf(jSONObject3.optString("t", "0")).floatValue(), Float.valueOf(jSONObject3.optString("r", "0")).floatValue(), Float.valueOf(jSONObject3.optString("b", "0")).floatValue());
                    }
                    JSONObject jSONObject4 = jSONObject.optJSONObject("rect");
                    if (jSONObject3 != null) {
                        object.faceRectDisplay = new RectF(Float.valueOf(jSONObject4.optString("l", "0")).floatValue(), Float.valueOf(jSONObject4.optString("t", "0")).floatValue(), Float.valueOf(jSONObject4.optString("r", "0")).floatValue(), Float.valueOf(jSONObject4.optString("b", "0")).floatValue());
                    }
                    object.faceId = jSONObject.optInt("ID", 0);
                    responseBean.faceScanBeans.add((ResponseBean.FaceScanBean)object);
                }
                arrayList.add(responseBean);
            }
            if ((jSONArray2 = jSONObject2.optJSONArray("scans")) != null && jSONArray2.length() == 1) {
                ResponseBean responseBean = new ResponseBean();
                responseBean.feature = DetectionFeature.QYAR_SCAN;
                object = jSONArray2.getJSONObject(0);
                responseBean.classificationBean.score = Float.valueOf(object.optString("score", "0")).floatValue();
                responseBean.classificationBean.classId = object.optInt("classId", -1);
                arrayList.add(responseBean);
            }
            if ((jSONArray = jSONObject2.optJSONArray("scans")) != null && jSONArray.length() == 1) {
                object = new ResponseBean();
                object.feature = DetectionFeature.QYAR_SCENE_IMAGE2D;
                jSONObject = jSONArray.getJSONObject(0);
                object.image2D.score = Float.valueOf(jSONObject.optString("score", "0")).floatValue();
                object.image2D.classId = jSONObject.optInt("classId", -1);
                arrayList.add((ResponseBean)object);
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void afterDetection() {
    }

    private boolean initDetection() {
        if (!this.checkScanConfigs()) {
            Log.e((String)"qyar", (String)(this.getClass().getSimpleName() + " : initDetecgtion is null"));
            return false;
        }
        this.mDetectionManager.checkLicence(this.mScanConfigs.licensePath);
        this.mDetectionManager.addSubModelPath(this.mScanConfigs.modelPath, this.mScanConfigs.feature);
        if (this.mScanConfigs.modelBuffer != null) {
            for (DetectionFeature detectionFeature : this.mScanConfigs.modelBuffer.keySet()) {
                List<ByteBuffer> list = this.mScanConfigs.modelBuffer.get((Object)detectionFeature);
                if (list.size() == 0) continue;
                if (detectionFeature != DetectionFeature.QYAR_SCENE_IMAGE2D) {
                    if (list.size() > 1) {
                        LogUtil.LogE("QYAR", "feature = " + detectionFeature.getName() + " has mutil buffer size = " + list.size());
                    }
                    this.mDetectionManager.addSubModelBuffer(this.mContext, list.get(0), detectionFeature);
                    continue;
                }
                for (int i = 0; i < list.size(); ++i) {
                    this.mDetectionManager.addSubModelBuffer(this.mContext, list.get(i), detectionFeature);
                }
            }
        }
        return true;
    }

    private boolean checkScanConfigs() {
        boolean bl;
        if (this.mScanConfigs == null) {
            return false;
        }
        boolean bl2 = this.mScanConfigs.modelBuffer != null && this.mScanConfigs.modelBuffer.size() > 0;
        boolean bl3 = bl = this.mScanConfigs.feature != null && !TextUtils.isEmpty((CharSequence)this.mScanConfigs.modelPath);
        if (!bl2 && !bl) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)this.mScanConfigs.licensePath);
    }
}

