/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.iig.shai.scan;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class SensorHelper {
    private float sensorX = 0.0f;
    private float sensorY = 0.0f;
    private float sensorZ = 0.0f;
    private int sensorOrientation = 0;
    private SensorManager sensorManager;
    private boolean isWorking = false;
    private SensorEventListener accListener = new SensorEventListener(){

        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        public void onSensorChanged(SensorEvent sensorEvent) {
            int n = 0;
            if (sensorEvent.sensor.getType() == 1) {
                int n2;
                float f2 = sensorEvent.values[0];
                float f3 = sensorEvent.values[1];
                float f4 = sensorEvent.values[2];
                SensorHelper.this.sensorX = f2;
                SensorHelper.this.sensorY = f3;
                SensorHelper.this.sensorZ = f4;
                if (Math.abs(f2) > 6.0f || Math.abs(f3) > 6.0f) {
                    n = Math.abs(f2) > Math.abs(f3) ? (f2 > 0.0f ? 0 : 2) : (f3 > 0.0f ? 1 : 3);
                }
                if ((n2 = n - 1) < 0) {
                    n2 = n ^ 3;
                }
                SensorHelper.this.sensorOrientation = n2;
            }
        }
    };

    public SensorHelper(Context context) {
        this.openSensor(context);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    private void openSensor(Context context) {
        if (this.sensorManager == null) {
            this.sensorManager = (SensorManager)context.getSystemService("sensor");
        }
        this.sensorManager.registerListener(this.accListener, this.sensorManager.getDefaultSensor(1), 3);
        this.isWorking = true;
    }

    public void closeSensor() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener(this.accListener);
            this.isWorking = false;
        }
    }

    public float getSensorX() {
        if (!this.isWorking) {
            return 0.0f;
        }
        return this.sensorX;
    }

    public float getSensorY() {
        if (!this.isWorking) {
            return 0.0f;
        }
        return this.sensorY;
    }

    public float getSensorZ() {
        if (!this.isWorking) {
            return 0.0f;
        }
        return this.sensorZ;
    }
}

