/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.iig.shai.scan;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.iqiyi.iig.shai.detect.DetectionModule;
import com.iqiyi.iig.shai.scan.bean.ResponseBean;
import com.iqiyi.iig.shai.util.LogUtil;
import com.iqiyi.iig.shai.util.f;
import com.qiyi.net.adapter.INetworkInitiator;
import com.qiyi.net.adapter.INetworkOperator;
import com.qiyi.net.adapter.NetworkManager;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.qiyi.baseline.adapter.QYNetworkInitiator;
import org.qiyi.baseline.adapter.QYNetworkOperator;
import org.qiyi.net.Request;
import org.qiyi.net.callback.IHttpCallback;
import org.qiyi.net.entity.IBody;
import org.qiyi.net.exception.HttpException;
import org.qiyi.net.postfile.MultipartBody;
import org.qiyi.net.postfile.MultipartEntity;

public class ServerTask {
    private static final String source = "baseline";
    private String postUrl = "https://homeai-bsl.iqiyi.com/apis/public/gateway/ar/focused";
    private String postUrl_debug = "http://10.19.28.214/apis/public/gateway/ar/focused";
    private boolean onGoing = false;
    private long lastUploadTime = System.currentTimeMillis();
    private long MAX_WAITING_TIME = 8000L;
    private long MIN_UPLOAD_TIME = 500L;
    private List<ResponseBean.ServerTaskBean> mServerResult = new ArrayList<ResponseBean.ServerTaskBean>();
    private String mDeviceId = UUID.randomUUID() + "_" + System.currentTimeMillis();
    private String mSessionId = UUID.randomUUID() + "_" + System.currentTimeMillis();
    private boolean isValidData = true;

    public ServerTask(Context context) {
        if (!NetworkManager.getInstance().isInit()) {
            QYNetworkInitiator.Builder builder = new QYNetworkInitiator.Builder();
            builder.netThreadPoolSize(2, 4).pingbackThreadPoolSize(2, 4);
            NetworkManager.getInstance().networkOperate((INetworkOperator)new QYNetworkOperator()).networkInit((INetworkInitiator)builder.build()).init(context);
        }
    }

    public void setDeviceId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mDeviceId = string;
            this.mSessionId = this.mDeviceId + System.currentTimeMillis();
        }
    }

    public void clearData() {
        this.mServerResult.clear();
        this.isValidData = false;
    }

    public void enableDebugServer() {
        this.postUrl = this.postUrl_debug;
    }

    public void request(final byte[] byArray, final String string) {
        this.isValidData = true;
        if (byArray == null || byArray.length <= 0) {
            this.mServerResult.clear();
            return;
        }
        if (System.currentTimeMillis() - this.lastUploadTime > this.MAX_WAITING_TIME) {
            this.onGoing = false;
        }
        if (this.onGoing || System.currentTimeMillis() - this.lastUploadTime < this.MIN_UPLOAD_TIME) {
            return;
        }
        this.onGoing = true;
        this.lastUploadTime = System.currentTimeMillis();
        f.a().a(new Runnable(){

            @Override
            public void run() {
                try {
                    int n;
                    JSONObject jSONObject = new JSONObject(string);
                    int n2 = jSONObject.optInt("w", -1);
                    int n3 = jSONObject.optInt("h", -1);
                    float f2 = Float.valueOf(jSONObject.optString("sensorX", "0")).floatValue();
                    float f3 = Float.valueOf(jSONObject.optString("sensorY", "0")).floatValue();
                    float f4 = Float.valueOf(jSONObject.optString("sensorX", "0")).floatValue();
                    int n4 = jSONObject.optInt("front", -1);
                    JSONArray jSONArray = new JSONArray();
                    jSONArray.put((double)f2);
                    jSONArray.put((double)f3);
                    jSONArray.put((double)f4);
                    int n5 = n = n4 == 1 ? 1 : 2;
                    if (n2 <= 0 || n3 <= 0) {
                        ServerTask.this.onGoing = false;
                        return;
                    }
                    int[] nArray = DetectionModule.nativeNv21ToRgba(byArray, n2, n3);
                    Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.setPixels(nArray, 0, n2, 0, 0, n2, n3);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream);
                    ServerTask.this.request(byteArrayOutputStream.toByteArray(), jSONArray.toString(), n);
                }
                catch (Exception exception) {
                    ServerTask.this.onGoing = false;
                    exception.printStackTrace();
                }
            }
        });
    }

    private void request(byte[] byArray, String string, int n) {
        try {
            String string2 = this.mDeviceId + System.currentTimeMillis();
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.addParams("source", source);
            builder.addParams("deviceid", this.mDeviceId);
            builder.addParams("sessionid", this.mSessionId);
            builder.addParams("msgid", string2);
            builder.addParams("featureFlag", "0");
            builder.addParams("accl", string);
            builder.addParams("camera", n + "");
            MultipartBody multipartBody = builder.build();
            ((MultipartEntity)multipartBody.getBody()).addFileInfo("image", "file", byArray);
            multipartBody.setContentType("image/jpeg");
            Request request = new Request.Builder().method(Request.Method.POST).addParam("source", source).addParam("deviceid", this.mDeviceId).addParam("msgid", string2).addParam("featureFlag", "0").addParam("sessionid", this.mSessionId).addParam("accl", string).addParam("camera", n + "").setBody((IBody)multipartBody).url(this.postUrl).callBackOnWorkThread().maxRetry(3).build(String.class);
            request.sendRequest((IHttpCallback)new IHttpCallback<String>(){

                public void onResponse(String string) {
                    ServerTask.this.onGoing = false;
                    if (ServerTask.this.isValidData) {
                        ServerTask.this.transfer(string);
                        LogUtil.LogE("qyar", "success =" + string);
                    } else {
                        LogUtil.LogE("qyar", "loss data because validData =" + string);
                    }
                }

                public void onErrorResponse(HttpException httpException) {
                    ServerTask.this.onGoing = false;
                    httpException.printStackTrace();
                    LogUtil.LogE("qyar", "error =" + httpException.toString());
                    ServerTask.this.mServerResult.clear();
                }
            });
        }
        catch (Exception exception) {
            this.onGoing = false;
            exception.printStackTrace();
            LogUtil.LogE("qyae", "error = excepton");
            this.mServerResult.clear();
        }
    }

    private void transfer(String string) {
        this.mServerResult.clear();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.optString("code", "");
            if (!"A00000".equalsIgnoreCase(string2)) {
                return;
            }
            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
            if (jSONObject2 == null) {
                return;
            }
            JSONArray jSONArray = jSONObject2.optJSONArray("recognization");
            if (jSONArray == null || jSONArray.length() == 0) {
                return;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                ResponseBean.ServerTaskBean serverTaskBean = new ResponseBean.ServerTaskBean();
                serverTaskBean.origin = jSONObject3.toString();
                serverTaskBean.confidence = jSONObject3.optLong("confidence", 0L);
                serverTaskBean.feature = jSONObject3.optInt("feature", -1);
                serverTaskBean.label = jSONObject3.optString("label", "");
                serverTaskBean.result = new ArrayList<String>();
                JSONArray jSONArray2 = jSONObject3.optJSONArray("result");
                if (jSONArray2 != null && jSONArray2.length() > 0) {
                    for (int j = 0; j < jSONArray2.length(); ++j) {
                        serverTaskBean.result.add(jSONArray2.optString(j));
                    }
                }
                this.mServerResult.add(serverTaskBean);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mServerResult.clear();
        }
    }

    public List<ResponseBean.ServerTaskBean> getmServerResult() {
        return this.mServerResult;
    }
}

