/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.iig.shai.scan;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.iqiyi.iig.shai.scan.IScanCallBack;
import com.iqiyi.iig.shai.scan.bean.RequestBean;
import com.iqiyi.iig.shai.scan.bean.RequestPara;
import com.qiyi.net.adapter.INetworkInitiator;
import com.qiyi.net.adapter.INetworkOperator;
import com.qiyi.net.adapter.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qiyi.baseline.adapter.QYNetworkInitiator;
import org.qiyi.baseline.adapter.QYNetworkOperator;
import org.qiyi.net.Request;
import org.qiyi.net.callback.IHttpCallback;
import org.qiyi.net.entity.IBody;
import org.qiyi.net.exception.HttpException;
import org.qiyi.net.postfile.MultipartBody;
import org.qiyi.net.postfile.MultipartEntity;

public class UploadHelper {
    private static final String source = "baseline";
    private static String postUrl = "https://homeai-bsl.iqiyi.com/apis/public/gateway/ar";
    private static String postUrl_debug = "http://10.19.28.214/apis/public/gateway/ar";
    private Map<String, String> onGoing = new HashMap<String, String>();
    List<String> flags = new ArrayList<String>();
    private String mDeviceId = UUID.randomUUID() + "_" + System.currentTimeMillis();
    private String mSessionId = UUID.randomUUID() + "_" + System.currentTimeMillis();

    public UploadHelper(Context context) {
        if (!NetworkManager.getInstance().isInit()) {
            QYNetworkInitiator.Builder builder = new QYNetworkInitiator.Builder();
            builder.netThreadPoolSize(2, 4).pingbackThreadPoolSize(2, 4);
            NetworkManager.getInstance().networkOperate((INetworkOperator)new QYNetworkOperator()).networkInit((INetworkInitiator)builder.build()).init(context);
        }
    }

    public void setDeviceId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mDeviceId = string;
            this.mSessionId = this.mDeviceId + System.currentTimeMillis();
        }
    }

    public void enableDebugServer() {
        postUrl = postUrl_debug;
    }

    public void request(final RequestPara requestPara, final IScanCallBack iScanCallBack) {
        block4: {
            if (requestPara == null || iScanCallBack == null || requestPara.fileInfo == null || requestPara.fileInfo.size() == 0 || this.onGoing.containsKey(requestPara.flag)) {
                return;
            }
            this.onGoing.put(requestPara.flag, requestPara.flag);
            this.flags.clear();
            try {
                String string = this.mDeviceId + System.currentTimeMillis();
                MultipartBody.Builder builder = new MultipartBody.Builder();
                builder.addParams("source", source);
                builder.addParams("deviceid", this.mDeviceId);
                builder.addParams("sessionid", this.mSessionId);
                builder.addParams("msgid", string);
                MultipartBody multipartBody = builder.build();
                for (RequestBean requestBean : requestPara.fileInfo) {
                    ((MultipartEntity)multipartBody.getBody()).addFileInfo(requestBean.identify, requestBean.fileName, requestBean.fileContent);
                    this.flags.add(requestBean.fileName);
                }
                multipartBody.setContentType("image/jpeg");
                Request request = new Request.Builder().method(Request.Method.POST).addParam("source", source).addParam("deviceid", this.mDeviceId).addParam("msgid", string).addParam("sessionid", this.mSessionId).setBody((IBody)multipartBody).url(postUrl).callBackOnWorkThread().maxRetry(3).build(String.class);
                request.sendRequest((IHttpCallback)new IHttpCallback<String>(){

                    public void onResponse(String string) {
                        Log.e((String)"qyar", (String)("success =" + string));
                        if (iScanCallBack != null) {
                            iScanCallBack.onSucess(string, UploadHelper.this.flags);
                            UploadHelper.this.onGoing.remove(requestPara.flag);
                        }
                    }

                    public void onErrorResponse(HttpException httpException) {
                        Log.e((String)"qyar", (String)("error =" + httpException.toString()));
                        if (iScanCallBack != null) {
                            iScanCallBack.onError();
                            UploadHelper.this.onGoing.remove(requestPara.flag);
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.e((String)"qyae", (String)"error = excepton");
                if (iScanCallBack == null) break block4;
                iScanCallBack.onError();
                this.onGoing.remove(requestPara.flag);
            }
        }
    }
}

