precision mediump float;
varying vec2 textureCoordinate;
uniform sampler2D vTexture;
void main() {
    vec4 left = texture2D(vTexture, vec2(textureCoordinate.x - 0.005, textureCoordinate.y));
    vec4 right = texture2D(vTexture, vec2(textureCoordinate.x + 0.005, textureCoordinate.y));
    vec4 top = texture2D(vTexture, vec2(textureCoordinate.x , textureCoordinate.y + 0.005));
    vec4 bottom = texture2D(vTexture, vec2(textureCoordinate.x , textureCoordinate.y - 0.005));

    gl_FragColor = texture2D( vTexture, textureCoordinate);
    if(gl_FragColor.g > 0.8 && gl_FragColor.b < 0.2 && gl_FragColor.r < 0.2){
        gl_FragColor = vec4(0.0, 1.0, 0.0, 0.0);
    }
    if(left.g > 0.8 && left.b < 0.2 && left.r < 0.2){
        gl_FragColor = vec4(0.0, 1.0, 0.0, 0.0);
    }
    if(right.g > 0.8 && right.b < 0.2 && right.r < 0.2){
        gl_FragColor = vec4(0.0, 1.0, 0.0, 0.0);
    }
    if(top.g > 0.8 && top.b < 0.2 && top.r < 0.2){
        gl_FragColor = vec4(0.0, 1.0, 0.0, 0.0);
    }
    if(bottom.g > 0.8 && bottom.b < 0.2 && bottom.r < 0.2){
        gl_FragColor = vec4(0.0, 1.0, 0.0, 0.0);
    }
}