precision mediump float;

varying mediump vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform vec2 singleStepOffset;
uniform mediump float params;
uniform mediump float ratio;

void main(){
    vec3 centralColor = texture2D(inputImageTexture, textureCoordinate).rgb;
    gl_FragColor = vec4(centralColor.r * 0.5  , centralColor.g * 0.5 , centralColor.b * 0.5 , texture2D(inputImageTexture, textureCoordinate).a);

    highp float textureRadiusx = textureCoordinate.x - 0.5;
    highp float textureRadiusy = textureCoordinate.y - 0.5 + 0.05;
	highp float textureRadius = sqrt((textureRadiusx * textureRadiusx) + (textureRadiusy * textureRadiusy * ratio * ratio));

	highp float displayRadius = 0.3;

	if(textureRadius > displayRadius - singleStepOffset.x * 4.0 && textureRadius < displayRadius){
	    if(params < 3.0) {
            highp float headThelta = params ;
            highp float tailThelta  = 0.0;
            if(params > 0.5){
               tailThelta = headThelta -0.5;
            }
            if(params > 2.5){
                 headThelta = 2.5;
            }
            if(params > 2.0){
                headThelta = headThelta - 1.0;
                tailThelta = tailThelta - 1.0;
            }
            if(params > 1.0){
                headThelta = headThelta - 1.0;
                tailThelta = tailThelta - 1.0;
            }

            highp float currentThelta = atan(textureRadiusy * ratio,  textureRadiusx);
            currentThelta = (currentThelta / 1.5708 + 1.0) / 2.0;
            highp float currentMirrorThelta = atan(- textureRadiusy * ratio,  - textureRadiusx);
            currentMirrorThelta = (currentMirrorThelta / 1.5708 + 1.0) / 2.0;
            if(currentThelta < headThelta && currentThelta > tailThelta) {
                gl_FragColor = vec4(1.0, 1.0, 1.0, texture2D(inputImageTexture, textureCoordinate).a);
            }
            if(currentMirrorThelta < headThelta && currentMirrorThelta > tailThelta) {
                gl_FragColor = vec4(1.0 , 1.0, 1.0, texture2D(inputImageTexture, textureCoordinate).a);
            }
        } else {
            //params = params - 3.0;
        }
    }
}