precision mediump float;

varying mediump vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform vec2 singleStepOffset;
uniform mediump float params;
uniform mediump float ratio;

float hardLight(float color) {
	if(color <= 0.5)
		color = color * color * 2.0;
	else
		color = 1.0 - ((1.0 - color)*(1.0 - color) * 2.0);
	return color;
}

void main(){
    vec3 centralColor = texture2D(inputImageTexture, textureCoordinate).rgb;

    highp float textureRadiusx = textureCoordinate.x - 0.5;
    highp float textureRadiusy = textureCoordinate.y - 0.5 + 0.05;
	highp float textureRadius = sqrt((textureRadiusx * textureRadiusx) + (textureRadiusy * textureRadiusy * ratio * ratio));

	highp float displayRadius;
	highp float outterDisplayRadius;

    // angle y to y
    highp float thelta = (params - 1.2075) * 2.58568;
    highp float sinThelta = sin(thelta);
    highp float cosThelta = cos(thelta);

	if(params < 0.5) {
        displayRadius = 0.37 * params * 2.0;
    } else {
        displayRadius = 0.37;
        outterDisplayRadius = 0.4;
    }
    if(params > 0.4 &&  params < 0.6){
       //go out from inner ring
       outterDisplayRadius = (params - displayRadius) * 0.03 / 0.2 + displayRadius;
    }

    if(textureRadius > displayRadius){
        highp float satelliteDeltax = cosThelta * outterDisplayRadius - textureRadiusx;
        highp float satelliteDeltay = sinThelta * outterDisplayRadius - textureRadiusy * ratio;
        highp float satelliteRadius = sqrt (satelliteDeltax * satelliteDeltax + satelliteDeltay * satelliteDeltay);
        satelliteDeltax = cosThelta * outterDisplayRadius + textureRadiusx;
        highp float satelliteRadius2 = sqrt (satelliteDeltax * satelliteDeltax + satelliteDeltay * satelliteDeltay);
        satelliteRadius = min(satelliteRadius, satelliteRadius2);
        gl_FragColor = vec4(centralColor.r * 0.5 , centralColor.g * 0.5 , centralColor.b * 0.5 , texture2D(inputImageTexture, textureCoordinate ).a);
        if(textureRadius < outterDisplayRadius + singleStepOffset.x * 2.0  && textureRadius > outterDisplayRadius - singleStepOffset.x * 2.0  ) {
           gl_FragColor = vec4(gl_FragColor.r * 0.6 + 0.4 , gl_FragColor.g * 0.6 + 0.4  , gl_FragColor.b * 0.6 + 0.4  , texture2D(inputImageTexture, textureCoordinate ).a);
        }
        //show satellite
        if(params > 0.6) {
            if(satelliteRadius < singleStepOffset.x * 4.0) {
                gl_FragColor = vec4(1.0 , 1.0 , 1.0 , texture2D(inputImageTexture, textureCoordinate ).a);
            } else {
                if(satelliteRadius < singleStepOffset.x * 15.0) {
                    gl_FragColor = vec4(gl_FragColor.r * 0.7 + 0.3 , gl_FragColor.g * 0.7 + 0.3  , gl_FragColor.b * 0.7 + 0.3 , texture2D(inputImageTexture, textureCoordinate ).a);
                }
            }
        }
    } else {
        if(textureRadius > displayRadius - singleStepOffset.x * 4.0){
            //inner white ring
            gl_FragColor = vec4(centralColor.r + 0.7 , centralColor.g +0.7  ,centralColor.b + 0.7, texture2D(inputImageTexture, textureCoordinate).a);
        } else {
            gl_FragColor = vec4(centralColor.r , centralColor.g, centralColor.b, texture2D(inputImageTexture, textureCoordinate).a);
        }
    }
}