precision mediump float;

varying mediump vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform vec2 singleStepOffset;
uniform mediump float params;
uniform mediump float removed;

const highp vec3 W = vec3(0.333,0.333,0.333);
vec2 blurCoordinates[20];

float hardLight(float color)
{
	if(color <= 0.5)
		color = color * color * 2.0;
	else
		color = 1.0 - ((1.0 - color)*(1.0 - color) * 2.0);
	return color;
}

void main(){
    vec3 centralColor = texture2D(inputImageTexture, textureCoordinate).rgb;
    //soble edge
    vec4 horizEdge = vec4( 0.0 );
    float x = singleStepOffset.x;
    float y = singleStepOffset.y;
    horizEdge -= texture2D( inputImageTexture, vec2( textureCoordinate.x - x, textureCoordinate.y - y ) ) * 1.0;
    horizEdge -= texture2D( inputImageTexture, vec2( textureCoordinate.x - x, textureCoordinate.y     ) ) * 2.0;
    horizEdge -= texture2D( inputImageTexture, vec2( textureCoordinate.x - x, textureCoordinate.y + y ) ) * 1.0;
    horizEdge += texture2D( inputImageTexture, vec2( textureCoordinate.x + x, textureCoordinate.y - y ) ) * 1.0;
    horizEdge += texture2D( inputImageTexture, vec2( textureCoordinate.x + x, textureCoordinate.y     ) ) * 2.0;
    horizEdge += texture2D( inputImageTexture, vec2( textureCoordinate.x + x, textureCoordinate.y + y ) ) * 1.0;

    vec4 vertEdge = vec4( 0.0 );
    vertEdge -= texture2D( inputImageTexture, vec2( textureCoordinate.x - x, textureCoordinate.y - y ) ) * 1.0;
    vertEdge -= texture2D( inputImageTexture, vec2( textureCoordinate.x    , textureCoordinate.y - y ) ) * 2.0;
    vertEdge -= texture2D( inputImageTexture, vec2( textureCoordinate.x + x, textureCoordinate.y - y ) ) * 1.0;
    vertEdge += texture2D( inputImageTexture, vec2( textureCoordinate.x - x, textureCoordinate.y + y ) ) * 1.0;
    vertEdge += texture2D( inputImageTexture, vec2( textureCoordinate.x    , textureCoordinate.y + y ) ) * 2.0;
    vertEdge += texture2D( inputImageTexture, vec2( textureCoordinate.x + x, textureCoordinate.y + y ) ) * 1.0;

    vec3 edge = sqrt((horizEdge.rgb * horizEdge.rgb) + (vertEdge.rgb * vertEdge.rgb));
    float edgelumi = dot(edge, W);

    float timeSpace =  ((1.0 - textureCoordinate.y) + params) * 3.1415 *2.0;
    float cosTimeSpace = cos(timeSpace);
    float sinTimeSpace = sin(timeSpace);

    if(cosTimeSpace > 0.0 && sinTimeSpace > 0.0 && removed < 0.5){
        //scan line
        if(cosTimeSpace > 0.95 && sinTimeSpace < 0.05){
            edgelumi = edgelumi * 2.0 * (1.0 - abs(sin(timeSpace)));
            centralColor = centralColor *(1.0 - edgelumi);
            gl_FragColor = vec4(centralColor.r + edgelumi * 0.5 , centralColor.g + edgelumi * 0.5, centralColor.b + edgelumi * 2.0, texture2D(inputImageTexture, textureCoordinate ).a );
        } else {
            if(edgelumi > 0.2){
                edgelumi = edgelumi * 2.0 * (1.0 - abs(sin(timeSpace)));
                centralColor = centralColor *(1.0 - edgelumi);
                gl_FragColor = vec4(centralColor.r + edgelumi * 0.5 , centralColor.g + edgelumi * 0.5, centralColor.b + edgelumi * 2.0, texture2D(inputImageTexture, textureCoordinate ).a );
            } else {
                gl_FragColor = vec4(centralColor.r, centralColor.g, centralColor.b, texture2D(inputImageTexture, textureCoordinate ).a );
            }
        }
    } else {
        gl_FragColor = vec4(centralColor.r, centralColor.g, centralColor.b, texture2D(inputImageTexture, textureCoordinate ).a );
    }
}