/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzk;
import com.google.android.gms.internal.measurement.zzl;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.internal.measurement.zzt;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgn;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class zzz {
    private static volatile zzz zzab;
    private final String zzu;
    protected final Clock zzac;
    private final ExecutorService zzad;
    private final AppMeasurementSdk zzae;
    private List<Pair<zzgn, zzd>> zzaf;
    private int zzag;
    private static Boolean zzah;
    private static Boolean zzai;
    private static boolean zzaj;
    private static Boolean zzak;
    @VisibleForTesting
    private static String zzal;
    @VisibleForTesting
    private static String zzam;
    private static boolean zzan;
    private static boolean zzao;
    private boolean zzap;
    private String zzaq;
    private zzk zzar;

    public static zzz zza(@NonNull Context context) {
        return zzz.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzz zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzab != null) return zzab;
        Class<zzz> clazz = zzz.class;
        synchronized (zzz.class) {
            if (zzab != null) return zzab;
            zzab = new zzz(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzab;
        }
    }

    public final AppMeasurementSdk zzg() {
        return this.zzae;
    }

    private zzz(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzu = string == null || !zzz.zza(string2, string3) ? "FA" : string;
        this.zzac = DefaultClock.getInstance();
        this.zzad = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.zzae = new AppMeasurementSdk(this);
        Context context2 = context;
        if (!(!zzz.zzb(context2) || zzz.zzh())) {
            this.zzaq = null;
            this.zzap = true;
            Log.w((String)this.zzu, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!zzz.zza(string2, string3)) {
            this.zzaq = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzu, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                this.zzap = true;
                return;
            }
            if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzu, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzaq = string2;
        }
        this.zza(new zzy(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzz zzz2 = this;
        if (context2 == null) {
            Log.w((String)zzz2.zzu, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzz2.new zzc());
    }

    private static boolean zzb(Context context) {
        try {
            GoogleServices.initialize((Context)context);
            return GoogleServices.getGoogleAppId() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zza(String string, String string2) {
        return string2 != null && string != null && !zzz.zzh();
    }

    private final void zza(zzb zzb2) {
        this.zzad.execute(zzb2);
    }

    protected final zzk zza(Context context, boolean bl) {
        try {
            return zzn.asInterface(DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)(bl ? DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION : DynamiteModule.PREFER_LOCAL), (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzc(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzd(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzap |= bl;
        if (bl) {
            Log.w((String)this.zzu, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzu, (String)string, (Throwable)exception);
    }

    private static boolean zzh() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void zza(zzgk zzgk2) {
        this.zza(new zzal(this, zzgk2));
    }

    public final void zza(zzgn zzgn2) {
        Preconditions.checkNotNull((Object)zzgn2);
        this.zza(new zzau(this, zzgn2));
    }

    public final void zzb(zzgn zzgn2) {
        Preconditions.checkNotNull((Object)zzgn2);
        this.zza(new zzaz(this, zzgn2));
    }

    public final void logEvent(@NonNull String string, Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void logEventInternal(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzay(this, l, string, string2, bundle, bl, bl2));
    }

    public final void setUserProperty(String string, String string2) {
        this.zza(null, string, string2, false);
    }

    public final void setUserPropertyInternal(String string, String string2, Object object) {
        this.zza(string, string2, object, true);
    }

    private final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzbb(this, string, string2, object, bl));
    }

    public final void setConditionalUserProperty(Bundle bundle) {
        this.zza(new zzba(this, bundle));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(new zzab(this, string, string2, bundle));
    }

    public final List<Bundle> getConditionalUserProperties(String string, String string2) {
        zzl zzl2 = new zzl();
        this.zza(new zzaa(this, string, string2, zzl2));
        List list = (List)zzl.zza((Bundle)zzl2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void setUserId(String string) {
        this.zza(new zzad(this, string));
    }

    public final void setCurrentScreen(Activity activity, String string, String string2) {
        this.zza(new zzac(this, activity, string, string2));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zza(new zzaf(this, bl));
    }

    public final void resetAnalyticsData() {
        this.zza(new zzae(this));
    }

    public final void setMinimumSessionDuration(long l) {
        this.zza(new zzah(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        this.zza(new zzag(this, l));
    }

    public final void beginAdUnitExposure(String string) {
        this.zza(new zzaj(this, string));
    }

    public final void endAdUnitExposure(String string) {
        this.zza(new zzai(this, string));
    }

    public final String getGmpAppId() {
        zzl zzl2 = new zzl();
        this.zza(new zzak(this, zzl2));
        return zzl2.zza(500L);
    }

    public final String zzi() {
        zzl zzl2 = new zzl();
        this.zza(new zzan(this, zzl2));
        return zzl2.zza(50L);
    }

    public final long generateEventId() {
        zzl zzl2 = new zzl();
        this.zza(new zzam(this, zzl2));
        Long l = (Long)zzl.zza((Bundle)zzl2.zzb(500L), Long.class);
        if (l == null) {
            zzz zzz2 = this;
            return new Random(System.nanoTime() ^ zzz2.zzac.currentTimeMillis()).nextLong() + (long)(++zzz2.zzag);
        }
        return l;
    }

    public final String getCurrentScreenName() {
        zzl zzl2 = new zzl();
        this.zza(new zzap(this, zzl2));
        return zzl2.zza(500L);
    }

    public final String getCurrentScreenClass() {
        zzl zzl2 = new zzl();
        this.zza(new zzao(this, zzl2));
        return zzl2.zza(500L);
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        zzl zzl2 = new zzl();
        this.zza(new zzar(this, string, string2, bl, zzl2));
        Bundle bundle = zzl2.zzb(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zza(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzaq(this, false, 5, string, object, null, null));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zzl zzl2 = new zzl();
        this.zza(new zzat(this, bundle, zzl2));
        if (bl) {
            return zzl2.zzb(5000L);
        }
        return null;
    }

    public final int getMaxUserProperties(String string) {
        zzl zzl2 = new zzl();
        this.zza(new zzas(this, string, zzl2));
        Integer n = (Integer)zzl.zza((Bundle)zzl2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String getAppInstanceId() {
        zzl zzl2 = new zzl();
        this.zza(new zzav(this, zzl2));
        return zzl2.zza(120000L);
    }

    public final String getAppIdOrigin() {
        return this.zzaq;
    }

    public final Object zzb(int n) {
        zzl zzl2 = new zzl();
        this.zza(new zzax(this, zzl2, n));
        return zzl.zza((Bundle)zzl2.zzb(15000L), Object.class);
    }

    public final void setDataCollectionEnabled(boolean bl) {
        this.zza(new zzaw(this, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zze(Context context) {
        Class<zzz> clazz = zzz.class;
        synchronized (zzz.class) {
            try {
                if (zzah != null && zzai != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (zzz.zza(context, "app_measurement_internal_disable_startup_flags")) {
                    zzah = false;
                    zzai = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
                zzah = sharedPreferences.getBoolean(zzal, false);
                zzai = sharedPreferences.getBoolean(zzam, false);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.remove(zzal);
                editor.remove(zzam);
                editor.apply();
            }
            catch (ClassCastException | IllegalStateException | NullPointerException runtimeException) {
                Log.e((String)"FA", (String)"Exception reading flag from SharedPreferences.", (Throwable)runtimeException);
                zzah = false;
                zzai = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzf(Context context) {
        zzz.zze(context);
        Class<zzz> clazz = zzz.class;
        synchronized (zzz.class) {
            block9: {
                if (zzaj) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    break block9;
                }
                try {
                    String string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "measurement.dynamite.enabled", "");
                    zzak = "true".equals(string) ? Boolean.valueOf(true) : ("false".equals(string) ? Boolean.valueOf(false) : null);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    Log.e((String)"FA", (String)"Unable to call SystemProperties.get()", (Throwable)reflectiveOperationException);
                    zzak = null;
                }
                finally {
                    zzaj = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return zzak == null ? zzah : zzak;
        }
    }

    private static boolean zza(Context context, @Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)context).getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo == null || applicationInfo.metaData == null) {
                return false;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ List zza(zzz zzz2, List list) {
        zzz2.zzaf = list;
        return zzz2.zzaf;
    }

    static /* synthetic */ boolean zza(zzz zzz2, String string, String string2) {
        return zzz.zza(string, string2);
    }

    static /* synthetic */ String zzb(zzz zzz2) {
        return zzz2.zzu;
    }

    static /* synthetic */ void zzg(Context context) {
        zzz.zze(context);
    }

    static /* synthetic */ Boolean zzj() {
        return zzai;
    }

    static /* synthetic */ zzk zza(zzz zzz2, zzk zzk2) {
        zzz2.zzar = zzk2;
        return zzz2.zzar;
    }

    static /* synthetic */ zzk zzc(zzz zzz2) {
        return zzz2.zzar;
    }

    static /* synthetic */ int zzh(Context context) {
        return zzz.zzd(context);
    }

    static /* synthetic */ int zzi(Context context) {
        return zzz.zzc(context);
    }

    static /* synthetic */ List zzd(zzz zzz2) {
        return zzz2.zzaf;
    }

    static {
        zzah = null;
        zzai = null;
        zzaj = false;
        zzak = null;
        zzal = "use_dynamite_api";
        zzam = "allow_remote_dynamite";
        zzan = false;
        zzao = false;
    }

    final class zzc
    implements Application.ActivityLifecycleCallbacks {
        zzc() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzz.this.zza(new zzbd(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzz.this.zza(new zzbc(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzz.this.zza(new zzbf(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzz.this.zza(new zzbe(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzz.this.zza(new zzbh(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzl zzl2 = new zzl();
            zzz.this.zza(new zzbg(this, activity, zzl2));
            Bundle bundle2 = zzl2.zzb(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzz.this.zza(new zzbi(this, activity));
        }
    }

    static final class zza
    extends zzt {
        private final zzgk zzbs;

        zza(zzgk zzgk2) {
            this.zzbs = zzgk2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzbs.interceptEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return System.identityHashCode(this.zzbs);
        }
    }

    static final class zzd
    extends zzt {
        private final zzgn zzbv;

        zzd(zzgn zzgn2) {
            this.zzbv = zzgn2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzbv.onEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return System.identityHashCode(this.zzbv);
        }
    }

    abstract class zzb
    implements Runnable {
        final long timestamp;
        final long zzbt;
        private final boolean zzbu;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.timestamp = zzz.this.zzac.currentTimeMillis();
            this.zzbt = zzz.this.zzac.elapsedRealtime();
            this.zzbu = bl;
        }

        @Override
        public void run() {
            if (zzz.this.zzap) {
                this.zzk();
                return;
            }
            try {
                this.zzf();
                return;
            }
            catch (Exception exception) {
                zzz.this.zza(exception, false, this.zzbu);
                this.zzk();
                return;
            }
        }

        protected void zzk() {
        }

        abstract void zzf() throws RemoteException;
    }
}

