/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzs;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class zzhp
extends zzjh {
    public zzhp(zzjg zzjg2) {
        super(zzjg2);
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    @WorkerThread
    public final byte[] zzb(@NonNull zzai zzai2, @Size(min=1L) String string) {
        this.zzo();
        this.zzj.zzl();
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotEmpty((String)string);
        if (!this.zzad().zze(string, zzak.zzio)) {
            this.zzab().zzgr().zza("Generating ScionPayload disabled. packageName", (Object)string);
            return new byte[0];
        }
        if (!"_iap".equals(zzai2.name) && !"_iapx".equals(zzai2.name)) {
            this.zzab().zzgr().zza("Generating a payload for this event is not available. package_name, event_name", (Object)string, (Object)zzai2.name);
            return null;
        }
        zzbs.zzf.zza zza2 = zzbs.zzf.zznj();
        this.zzgy().beginTransaction();
        try {
            long l;
            long l2;
            zzae zzae2;
            long l3;
            zzae zzae3;
            zzf zzf2 = this.zzgy().zzab(string);
            if (zzf2 == null) {
                this.zzab().zzgr().zza("Log and bundle not available. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzf2.isMeasurementEnabled()) {
                this.zzab().zzgr().zza("Log and bundle disabled. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            zzbs.zzg.zza zza3 = zzbs.zzg.zzpr().zzp(1).zzcc("android");
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzag())) {
                zza3.zzch(zzf2.zzag());
            }
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzan())) {
                zza3.zzcg(zzf2.zzan());
            }
            if (!TextUtils.isEmpty((CharSequence)zzf2.zzal())) {
                zza3.zzci(zzf2.zzal());
            }
            if (zzf2.zzam() != Integer.MIN_VALUE) {
                zza3.zzv((int)zzf2.zzam());
            }
            zza3.zzas(zzf2.zzao()).zzax(zzf2.zzaq());
            if (!TextUtils.isEmpty((CharSequence)zzf2.getGmpAppId())) {
                zza3.zzcm(zzf2.getGmpAppId());
            } else if (!TextUtils.isEmpty((CharSequence)zzf2.zzah())) {
                zza3.zzcq(zzf2.zzah());
            }
            zza3.zzau(zzf2.zzap());
            if (this.zzj.isEnabled() && zzs.zzbv() && this.zzad().zzl(zza3.zzag())) {
                zza3.zzag();
                if (!TextUtils.isEmpty(null)) {
                    zza3.zzcp(null);
                }
            }
            Pair pair = this.zzac().zzap(zzf2.zzag());
            if (zzf2.zzbe() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                try {
                    zza3.zzcj(zzhp.zzo((String)pair.first, Long.toString(zzai2.zzfu)));
                }
                catch (SecurityException securityException) {
                    this.zzab().zzgr().zza("Resettable device id encryption failed", (Object)securityException.getMessage());
                    byte[] byArray = new byte[]{};
                    this.zzgy().endTransaction();
                    return byArray;
                }
                if (pair.second != null) {
                    zza3.zzm((Boolean)pair.second);
                }
            }
            this.zzw().zzbi();
            zzbs.zzg.zza zza4 = zza3.zzce(Build.MODEL);
            this.zzw().zzbi();
            zza4.zzcd(Build.VERSION.RELEASE).zzt((int)this.zzw().zzcq()).zzcf(this.zzw().zzcr());
            try {
                zza3.zzck(zzhp.zzo(zzf2.getAppInstanceId(), Long.toString(zzai2.zzfu)));
            }
            catch (SecurityException securityException) {
                this.zzab().zzgr().zza("app instance id encryption failed", (Object)securityException.getMessage());
                byte[] byArray = new byte[]{};
                this.zzgy().endTransaction();
                return byArray;
            }
            if (!TextUtils.isEmpty((CharSequence)zzf2.getFirebaseInstanceId())) {
                zza3.zzcn(zzf2.getFirebaseInstanceId());
            }
            zzf zzf3 = zzf2;
            zzhp zzhp2 = this;
            String string2 = zzf3.zzag();
            List<zzjp> list = zzhp2.zzgy().zzaa(string2);
            zzjp zzjp2 = null;
            for (zzjp zzjp3 : list) {
                if (!"_lte".equals(zzjp3.name)) continue;
                zzjp2 = zzjp3;
                break;
            }
            if (zzjp2 == null || zzjp2.value == null) {
                zzjp2 = new zzjp(string2, "auto", "_lte", zzhp2.zzx().currentTimeMillis(), (Object)0L);
                list.add(zzjp2);
                zzhp2.zzgy().zza(zzjp2);
            }
            if (zzhp2.zzad().zze(string2, zzak.zzij)) {
                List<zzjp> list2 = list;
                zzf zzf4 = zzf3;
                zzjo zzjo2 = zzhp2.zzgw();
                zzjo2.zzab().zzgs().zzao("Checking account type status for ad personalization signals");
                if (zzjo2.zzw().zzcu()) {
                    String string3 = zzf4.zzag();
                    if (zzf4.zzbe() && ((zzje)zzjo2).zzgz().zzba(string3)) {
                        zzjp zzjp4;
                        zzjo2.zzab().zzgr().zzao("Turning off ad personalization due to account type");
                        Iterator<zzjp> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            zzjp4 = iterator.next();
                            if (!"_npa".equals(zzjp4.name)) continue;
                            iterator.remove();
                            break;
                        }
                        zzjp4 = new zzjp(string3, "auto", "_npa", zzjo2.zzx().currentTimeMillis(), (Object)1L);
                        list2.add(zzjp4);
                    }
                }
            }
            zzbs.zzk[] zzkArray = new zzbs.zzk[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                zzbs.zzk.zza zza5 = zzbs.zzk.zzqu().zzdb(list.get((int)i).name).zzbk(list.get((int)i).zztr);
                zzhp2.zzgw().zza(zza5, list.get((int)i).value);
                zzkArray[i] = (zzbs.zzk)((zzey)zza5.zzug());
            }
            zza3.zzb(Arrays.asList(zzkArray));
            Bundle bundle = zzai2.zzfq.zzcv();
            bundle.putLong("_c", 1L);
            this.zzab().zzgr().zzao("Marking in-app purchase as real-time");
            bundle.putLong("_r", 1L);
            bundle.putString("_o", zzai2.origin);
            if (this.zzz().zzbr(zza3.zzag())) {
                this.zzz().zza(bundle, "_dbg", (Object)1L);
                this.zzz().zza(bundle, "_r", (Object)1L);
            }
            if ((zzae3 = this.zzgy().zzc(string, zzai2.name)) == null) {
                l3 = 0L;
                zzae2 = new zzae(string, zzai2.name, 0L, 0L, zzai2.zzfu, 0L, null, null, null, null);
            } else {
                l3 = zzae3.zzfj;
                zzae2 = zzae3.zzw(zzai2.zzfu);
            }
            this.zzgy().zza(zzae2);
            zzaf zzaf2 = new zzaf(this.zzj, zzai2.origin, string, zzai2.name, zzai2.zzfu, l3, bundle);
            zzbs.zzc.zza zza6 = zzbs.zzc.zzmq().zzag(zzaf2.timestamp).zzbx(zzaf2.name).zzah(zzaf2.zzfp);
            for (String string4 : zzaf2.zzfq) {
                zzbs.zze.zza zza7 = zzbs.zze.zzng().zzbz(string4);
                Object object = zzaf2.zzfq.get(string4);
                this.zzgw().zza(zza7, object);
                zza6.zza(zza7);
            }
            zza3.zza(zza6).zza(zzbs.zzh.zzpt().zza(zzbs.zzd.zzms().zzak(zzae2.zzfg).zzby(zzai2.name)));
            zza3.zzc(this.zzgx().zza(zzf2.zzag(), Collections.emptyList(), zza3.zzno()));
            if (zza6.zzml()) {
                zza3.zzao(zza6.getTimestampMillis()).zzap(zza6.getTimestampMillis());
            }
            if ((l2 = zzf2.zzak()) != 0L) {
                zza3.zzar(l2);
            }
            if ((l = zzf2.zzaj()) != 0L) {
                zza3.zzaq(l);
            } else if (l2 != 0L) {
                zza3.zzaq(l2);
            }
            zzf2.zzau();
            zza3.zzu((int)zzf2.zzar()).zzat(this.zzad().zzao()).zzan(this.zzx().currentTimeMillis()).zzn(Boolean.TRUE);
            zza2.zza(zza3);
            zzf2.zze(zza3.zznq());
            zzf2.zzf(zza3.zznr());
            this.zzgy().zza(zzf2);
            this.zzgy().setTransactionSuccessful();
        }
        finally {
            this.zzgy().endTransaction();
        }
        try {
            return this.zzgw().zzc(((zzbs.zzf)((zzey)zza2.zzug())).toByteArray());
        }
        catch (IOException iOException) {
            this.zzab().zzgk().zza("Data loss. Failed to bundle and serialize. appId", zzef.zzam((String)string), (Object)iOException);
            return null;
        }
    }

    private static String zzo(String string, String string2) {
        throw new SecurityException("This implementation should not be used.");
    }
}

