/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdom;
import com.google.android.gms.internal.ads.zzdoq;
import com.google.android.gms.internal.ads.zzdot;
import com.google.android.gms.internal.ads.zzdou;
import com.google.android.gms.internal.ads.zzdpl;
import com.google.android.gms.internal.ads.zzdpn;
import com.google.android.gms.internal.ads.zzdqe;
import com.google.android.gms.internal.ads.zzdqs;
import com.google.android.gms.internal.ads.zzdrn;
import com.google.android.gms.internal.ads.zzdsc;
import com.google.android.gms.internal.ads.zzdta;
import com.google.android.gms.internal.ads.zzdtd;
import com.google.android.gms.internal.ads.zzdtg;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzdpm
extends zzdou {
    private static final Logger logger = Logger.getLogger(zzdpm.class.getName());
    private static final boolean zzhgj = zzdta.zzbbv();
    zzdpn zzhgk;

    public static zzdpm zzaa(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zzb(byArray2, 0, n);
    }

    public static zzdpm zzm(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zza(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzdta.zzbbw()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzc(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzdpm() {
    }

    public abstract void zzz(int var1, int var2) throws IOException;

    public abstract void zzaa(int var1, int var2) throws IOException;

    public abstract void zzab(int var1, int var2) throws IOException;

    public final void zzac(int n, int n2) throws IOException {
        this.zzab(n, zzdpm.zzgl(n2));
    }

    public abstract void zzad(int var1, int var2) throws IOException;

    public abstract void zzg(int var1, long var2) throws IOException;

    public final void zzh(int n, long l) throws IOException {
        this.zzg(n, zzdpm.zzfi(l));
    }

    public abstract void zzi(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzad(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzi(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzh(int var1, boolean var2) throws IOException;

    public abstract void zzg(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdot var2) throws IOException;

    public abstract void zza(int var1, zzdrn var2) throws IOException;

    abstract void zza(int var1, zzdrn var2, zzdsc var3) throws IOException;

    public abstract void zzb(int var1, zzdrn var2) throws IOException;

    public abstract void zzb(int var1, zzdot var2) throws IOException;

    public abstract void zzga(int var1) throws IOException;

    public abstract void zzgb(int var1) throws IOException;

    public final void zzgc(int n) throws IOException {
        this.zzgb(zzdpm.zzgl(n));
    }

    public abstract void zzgd(int var1) throws IOException;

    public abstract void zzfa(long var1) throws IOException;

    public final void zzfb(long l) throws IOException {
        this.zzfa(zzdpm.zzfi(l));
    }

    public abstract void zzfc(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzgd(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzfc(Double.doubleToRawLongBits(d));
    }

    public final void zzbh(boolean bl) throws IOException {
        this.zzd((byte)(bl ? 1 : 0));
    }

    public abstract void zzhi(String var1) throws IOException;

    public abstract void zzcz(zzdot var1) throws IOException;

    public abstract void zzj(zzdrn var1) throws IOException;

    abstract void zza(zzdrn var1, zzdsc var2) throws IOException;

    public abstract void zzd(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzae(int n, int n2) {
        return zzdpm.zzge(n) + zzdpm.zzgf(n2);
    }

    public static int zzaf(int n, int n2) {
        return zzdpm.zzge(n) + zzdpm.zzgg(n2);
    }

    public static int zzag(int n, int n2) {
        return zzdpm.zzge(n) + zzdpm.zzgg(zzdpm.zzgl(n2));
    }

    public static int zzah(int n, int n2) {
        return zzdpm.zzge(n) + 4;
    }

    public static int zzai(int n, int n2) {
        return zzdpm.zzge(n) + 4;
    }

    public static int zzj(int n, long l) {
        return zzdpm.zzge(n) + zzdpm.zzfe(l);
    }

    public static int zzk(int n, long l) {
        return zzdpm.zzge(n) + zzdpm.zzfe(l);
    }

    public static int zzl(int n, long l) {
        return zzdpm.zzge(n) + zzdpm.zzfe(zzdpm.zzfi(l));
    }

    public static int zzm(int n, long l) {
        return zzdpm.zzge(n) + 8;
    }

    public static int zzn(int n, long l) {
        return zzdpm.zzge(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzdpm.zzge(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzdpm.zzge(n) + 8;
    }

    public static int zzi(int n, boolean bl) {
        return zzdpm.zzge(n) + 1;
    }

    public static int zzaj(int n, int n2) {
        return zzdpm.zzge(n) + zzdpm.zzgf(n2);
    }

    public static int zzh(int n, String string) {
        return zzdpm.zzge(n) + zzdpm.zzhj(string);
    }

    public static int zzc(int n, zzdot zzdot2) {
        int n2 = zzdot2.size();
        return zzdpm.zzge(n) + (zzdpm.zzgg(n2) + n2);
    }

    public static int zza(int n, zzdqs zzdqs2) {
        int n2 = zzdqs2.zzazp();
        return zzdpm.zzge(n) + (zzdpm.zzgg(n2) + n2);
    }

    public static int zzc(int n, zzdrn zzdrn2) {
        return zzdpm.zzge(n) + zzdpm.zzk(zzdrn2);
    }

    static int zzb(int n, zzdrn zzdrn2, zzdsc zzdsc2) {
        return zzdpm.zzge(n) + zzdpm.zzb(zzdrn2, zzdsc2);
    }

    public static int zzd(int n, zzdrn zzdrn2) {
        return (zzdpm.zzge(1) << 1) + zzdpm.zzaf(2, n) + zzdpm.zzc(3, zzdrn2);
    }

    public static int zzd(int n, zzdot zzdot2) {
        return (zzdpm.zzge(1) << 1) + zzdpm.zzaf(2, n) + zzdpm.zzc(3, zzdot2);
    }

    public static int zzb(int n, zzdqs zzdqs2) {
        return (zzdpm.zzge(1) << 1) + zzdpm.zzaf(2, n) + zzdpm.zza(3, zzdqs2);
    }

    public static int zzge(int n) {
        return zzdpm.zzgg(n << 3);
    }

    public static int zzgf(int n) {
        if (n >= 0) {
            return zzdpm.zzgg(n);
        }
        return 10;
    }

    public static int zzgg(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzgh(int n) {
        return zzdpm.zzgg(zzdpm.zzgl(n));
    }

    public static int zzgi(int n) {
        return 4;
    }

    public static int zzgj(int n) {
        return 4;
    }

    public static int zzfd(long l) {
        return zzdpm.zzfe(l);
    }

    public static int zzfe(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzff(long l) {
        return zzdpm.zzfe(zzdpm.zzfi(l));
    }

    public static int zzfg(long l) {
        return 8;
    }

    public static int zzfh(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzbi(boolean bl) {
        return 1;
    }

    public static int zzgk(int n) {
        return zzdpm.zzgf(n);
    }

    public static int zzhj(String string) {
        int n;
        try {
            n = zzdtd.zza(string);
        }
        catch (zzdtg zzdtg2) {
            n = string.getBytes(zzdqe.UTF_8).length;
        }
        int n2 = n;
        return zzdpm.zzgg(n2) + n2;
    }

    public static int zza(zzdqs zzdqs2) {
        int n = zzdqs2.zzazp();
        return zzdpm.zzgg(n) + n;
    }

    public static int zzda(zzdot zzdot2) {
        int n = zzdot2.size();
        return zzdpm.zzgg(n) + n;
    }

    public static int zzab(byte[] byArray) {
        int n = byArray.length;
        return zzdpm.zzgg(n) + n;
    }

    public static int zzk(zzdrn zzdrn2) {
        int n = zzdrn2.zzazp();
        return zzdpm.zzgg(n) + n;
    }

    static int zzb(zzdrn zzdrn2, zzdsc zzdsc2) {
        zzdsc zzdsc3 = zzdsc2;
        zzdom zzdom2 = (zzdom)zzdrn2;
        int n = zzdom2.zzaxc();
        if (n == -1) {
            n = zzdsc3.zzau(zzdom2);
            zzdom2.zzfj(n);
        }
        int n2 = n;
        return zzdpm.zzgg(n2) + n2;
    }

    private static int zzgl(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzfi(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzayp();

    public final void zzayq() {
        if (this.zzayp() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzk(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzdtg zzdtg2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzdtg2);
        byte[] byArray = string.getBytes(zzdqe.UTF_8);
        try {
            this.zzgb(byArray.length);
            this.zzi(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzd(indexOutOfBoundsException);
        }
        catch (zzd zzd2) {
            throw zzd2;
        }
    }

    @Deprecated
    static int zzc(int n, zzdrn zzdrn2, zzdsc zzdsc2) {
        zzdsc zzdsc3;
        int n2 = zzdpm.zzge(n) << 1;
        zzdsc zzdsc4 = zzdsc3 = zzdsc2;
        zzdom zzdom2 = (zzdom)zzdrn2;
        int n3 = zzdom2.zzaxc();
        if (n3 == -1) {
            n3 = zzdsc4.zzau(zzdom2);
            zzdom2.zzfj(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzl(zzdrn zzdrn2) {
        return zzdrn2.zzazp();
    }

    @Deprecated
    public static int zzgm(int n) {
        return zzdpm.zzgg(n);
    }

    /* synthetic */ zzdpm(zzdpl zzdpl2) {
        this();
    }

    static final class zze
    extends zzdpm {
        private final ByteBuffer zzhgn;
        private final ByteBuffer zzakh;
        private final long zzhgo;
        private final long zzhgp;
        private final long zzhgq;
        private final long zzhgr;
        private long zzams;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzhgn = byteBuffer;
            this.zzakh = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhgo = zzdta.zzn(byteBuffer);
            this.zzhgp = this.zzhgo + (long)byteBuffer.position();
            this.zzhgq = this.zzhgo + (long)byteBuffer.limit();
            this.zzhgr = this.zzhgq - 10L;
            this.zzams = this.zzhgp;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdpm)this).zzgb(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzga(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzgb(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 5);
            ((zzdpm)this).zzgd(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdpm)this).zzz(n, 1);
            ((zzdpm)this).zzfc(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzcz(zzdot2);
        }

        @Override
        public final void zza(int n, zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzj(zzdrn2);
        }

        @Override
        final void zza(int n, zzdrn zzdrn2, zzdsc zzdsc2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zza(zzdrn2, zzdsc2);
        }

        @Override
        public final void zzb(int n, zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzz(1, 3);
            ((zzdpm)this).zzab(2, n);
            ((zzdpm)this).zza(3, zzdrn2);
            ((zzdpm)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzz(1, 3);
            ((zzdpm)this).zzab(2, n);
            ((zzdpm)this).zza(3, zzdot2);
            ((zzdpm)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzgb(zzdrn2.zzazp());
            zzdrn2.zzb(this);
        }

        @Override
        final void zza(zzdrn zzdrn2, zzdsc zzdsc2) throws IOException {
            zzdsc zzdsc3 = zzdsc2;
            zzdom zzdom2 = (zzdom)zzdrn2;
            int n = zzdom2.zzaxc();
            if (n == -1) {
                n = zzdsc3.zzau(zzdom2);
                zzdom2.zzfj(n);
            }
            ((zzdpm)this).zzgb(n);
            zzdsc2.zza(zzdrn2, this.zzhgk);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            if (this.zzams >= this.zzhgq) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, 1));
            }
            zzdta.zza(this.zzams++, by);
        }

        @Override
        public final void zzcz(zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzgb(zzdot2.size());
            zzdot2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpm)this).zzgb(n2);
            ((zzdpm)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (n >= 0) {
                ((zzdpm)this).zzgb(n);
                return;
            }
            ((zzdpm)this).zzfa(n);
        }

        @Override
        public final void zzgb(int n) throws IOException {
            if (this.zzams <= this.zzhgr) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzdta.zza(this.zzams++, (byte)n);
                        return;
                    }
                    zzdta.zza(this.zzams++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzams < this.zzhgq) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdta.zza(this.zzams++, (byte)n);
                    return;
                }
                zzdta.zza(this.zzams++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, 1));
        }

        @Override
        public final void zzgd(int n) throws IOException {
            long l = this.zzams;
            zze zze2 = this;
            this.zzakh.putInt((int)(l - zze2.zzhgo), n);
            this.zzams += 4L;
        }

        @Override
        public final void zzfa(long l) throws IOException {
            if (this.zzams <= this.zzhgr) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdta.zza(this.zzams++, (byte)l);
                        return;
                    }
                    zzdta.zza(this.zzams++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzams < this.zzhgq) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzdta.zza(this.zzams++, (byte)l);
                    return;
                }
                zzdta.zza(this.zzams++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, 1));
        }

        @Override
        public final void zzfc(long l) throws IOException {
            long l2 = this.zzams;
            zze zze2 = this;
            this.zzakh.putLong((int)(l2 - zze2.zzhgo), l);
            this.zzams += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzhgq - (long)n2 < this.zzams) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, n2));
            }
            zzdta.zza(byArray, n, this.zzams, n2);
            this.zzams += (long)n2;
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpm)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            long l = this.zzams;
            try {
                int n = zze.zzgg(string.length() * 3);
                int n2 = zze.zzgg(string.length());
                if (n2 == n) {
                    long l2 = this.zzams;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzhgo) + n2;
                    this.zzakh.position(n3);
                    zzdtd.zza(string, this.zzakh);
                    int n4 = this.zzakh.position() - n3;
                    ((zzdpm)this).zzgb(n4);
                    this.zzams += (long)n4;
                    return;
                }
                int n5 = zzdtd.zza(string);
                ((zzdpm)this).zzgb(n5);
                this.zzfj(this.zzams);
                zzdtd.zza(string, this.zzakh);
                this.zzams += (long)n5;
                return;
            }
            catch (zzdtg zzdtg2) {
                this.zzams = l;
                this.zzfj(this.zzams);
                this.zza(string, zzdtg2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzams;
            zze zze2 = this;
            this.zzhgn.position((int)(l - zze2.zzhgo));
        }

        @Override
        public final int zzayp() {
            return (int)(this.zzhgq - this.zzams);
        }

        private final void zzfj(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzakh.position((int)(l2 - zze2.zzhgo));
        }
    }

    static final class zzc
    extends zzdpm {
        private final ByteBuffer zzhgn;
        private final ByteBuffer zzakh;
        private final int zzhgm;

        zzc(ByteBuffer byteBuffer) {
            super(null);
            this.zzhgn = byteBuffer;
            this.zzakh = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhgm = byteBuffer.position();
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdpm)this).zzgb(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzga(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzgb(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 5);
            ((zzdpm)this).zzgd(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdpm)this).zzz(n, 1);
            ((zzdpm)this).zzfc(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzcz(zzdot2);
        }

        @Override
        public final void zza(int n, zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzj(zzdrn2);
        }

        @Override
        final void zza(int n, zzdrn zzdrn2, zzdsc zzdsc2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zza(zzdrn2, zzdsc2);
        }

        @Override
        public final void zzb(int n, zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzz(1, 3);
            ((zzdpm)this).zzab(2, n);
            ((zzdpm)this).zza(3, zzdrn2);
            ((zzdpm)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzz(1, 3);
            ((zzdpm)this).zzab(2, n);
            ((zzdpm)this).zza(3, zzdot2);
            ((zzdpm)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzgb(zzdrn2.zzazp());
            zzdrn2.zzb(this);
        }

        @Override
        final void zza(zzdrn zzdrn2, zzdsc zzdsc2) throws IOException {
            zzdsc zzdsc3 = zzdsc2;
            zzdom zzdom2 = (zzdom)zzdrn2;
            int n = zzdom2.zzaxc();
            if (n == -1) {
                n = zzdsc3.zzau(zzdom2);
                zzdom2.zzfj(n);
            }
            ((zzdpm)this).zzgb(n);
            zzdsc2.zza(zzdrn2, this.zzhgk);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.zzakh.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzcz(zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzgb(zzdot2.size());
            zzdot2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpm)this).zzgb(n2);
            ((zzdpm)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (n >= 0) {
                ((zzdpm)this).zzgb(n);
                return;
            }
            ((zzdpm)this).zzfa(n);
        }

        @Override
        public final void zzgb(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzakh.put((byte)n);
                        return;
                    }
                    this.zzakh.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzgd(int n) throws IOException {
            try {
                this.zzakh.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfa(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzakh.put((byte)l);
                        return;
                    }
                    this.zzakh.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfc(long l) throws IOException {
            try {
                this.zzakh.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzakh.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpm)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            int n = this.zzakh.position();
            try {
                int n2 = zzc.zzgg(string.length() * 3);
                int n3 = zzc.zzgg(string.length());
                if (n3 == n2) {
                    int n4 = this.zzakh.position() + n3;
                    this.zzakh.position(n4);
                    this.zzhk(string);
                    int n5 = this.zzakh.position();
                    this.zzakh.position(n);
                    ((zzdpm)this).zzgb(n5 - n4);
                    this.zzakh.position(n5);
                    return;
                }
                int n6 = zzdtd.zza(string);
                ((zzdpm)this).zzgb(n6);
                this.zzhk(string);
                return;
            }
            catch (zzdtg zzdtg2) {
                this.zzakh.position(n);
                this.zza(string, zzdtg2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzhgn.position(this.zzakh.position());
        }

        @Override
        public final int zzayp() {
            return this.zzakh.remaining();
        }

        private final void zzhk(String string) throws IOException {
            try {
                zzdtd.zza(string, this.zzakh);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }
    }

    static final class zza
    extends zzb {
        private final ByteBuffer zzhgl;
        private int zzhgm;

        zza(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzhgl = byteBuffer;
            this.zzhgm = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzhgl.position(this.zzhgm + this.zzays());
        }
    }

    static class zzb
    extends zzdpm {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zzb(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdpm)this).zzgb(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzga(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzgb(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdpm)this).zzz(n, 5);
            ((zzdpm)this).zzgd(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdpm)this).zzz(n, 1);
            ((zzdpm)this).zzfc(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdpm)this).zzz(n, 0);
            ((zzdpm)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzcz(zzdot2);
        }

        @Override
        public final void zzcz(zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzgb(zzdot2.size());
            zzdot2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpm)this).zzgb(n2);
            ((zzdpm)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            ((zzdpm)this).zzj(zzdrn2);
        }

        @Override
        final void zza(int n, zzdrn zzdrn2, zzdsc zzdsc2) throws IOException {
            ((zzdpm)this).zzz(n, 2);
            zzdsc zzdsc3 = zzdsc2;
            zzdom zzdom2 = (zzdom)zzdrn2;
            int n2 = zzdom2.zzaxc();
            if (n2 == -1) {
                n2 = zzdsc3.zzau(zzdom2);
                zzdom2.zzfj(n2);
            }
            ((zzdpm)this).zzgb(n2);
            zzdsc2.zza(zzdrn2, this.zzhgk);
        }

        @Override
        public final void zzb(int n, zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzz(1, 3);
            ((zzdpm)this).zzab(2, n);
            ((zzdpm)this).zza(3, zzdrn2);
            ((zzdpm)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdot zzdot2) throws IOException {
            ((zzdpm)this).zzz(1, 3);
            ((zzdpm)this).zzab(2, n);
            ((zzdpm)this).zza(3, zzdot2);
            ((zzdpm)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdrn zzdrn2) throws IOException {
            ((zzdpm)this).zzgb(zzdrn2.zzazp());
            zzdrn2.zzb(this);
        }

        @Override
        final void zza(zzdrn zzdrn2, zzdsc zzdsc2) throws IOException {
            zzdsc zzdsc3 = zzdsc2;
            zzdom zzdom2 = (zzdom)zzdrn2;
            int n = zzdom2.zzaxc();
            if (n == -1) {
                n = zzdsc3.zzau(zzdom2);
                zzdom2.zzfj(n);
            }
            ((zzdpm)this).zzgb(n);
            zzdsc2.zza(zzdrn2, this.zzhgk);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (n >= 0) {
                ((zzdpm)this).zzgb(n);
                return;
            }
            ((zzdpm)this).zzfa(n);
        }

        @Override
        public final void zzgb(int n) throws IOException {
            if (zzhgj && !zzdoq.zzaxg() && ((zzdpm)this).zzayp() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdta.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdta.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdta.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdta.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdta.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdta.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdta.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdta.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                zzdta.zza(this.buffer, (long)this.position++, (byte)(n >>>= 7));
                return;
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzgd(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfa(long l) throws IOException {
            if (zzhgj && ((zzdpm)this).zzayp() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdta.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzdta.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfc(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpm)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zzb.zzgg(string.length() * 3);
                int n3 = zzb.zzgg(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzdtd.zza(string, this.buffer, this.position, ((zzdpm)this).zzayp());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzdpm)this).zzgb(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzdtd.zza(string);
                ((zzdpm)this).zzgb(n6);
                this.position = zzdtd.zza(string, this.buffer, this.position, ((zzdpm)this).zzayp());
                return;
            }
            catch (zzdtg zzdtg2) {
                this.position = n;
                this.zza(string, zzdtg2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzayp() {
            return this.limit - this.position;
        }

        public final int zzays() {
            return this.position - this.offset;
        }
    }

    public static final class zzd
    extends IOException {
        zzd() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzd(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzd(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzd(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

