/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.RewardResponseListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import java.util.Collections;
import java.util.List;

class BillingClientNativeCallback
implements AcknowledgePurchaseResponseListener,
BillingClientStateListener,
ConsumeResponseListener,
PriceChangeConfirmationListener,
PurchaseHistoryResponseListener,
PurchasesUpdatedListener,
RewardResponseListener,
SkuDetailsResponseListener {
    private final long futureHandle;

    BillingClientNativeCallback() {
        this.futureHandle = 0L;
    }

    BillingClientNativeCallback(long futureHandle) {
        this.futureHandle = futureHandle;
    }

    @Override
    public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList) {
        if (skuDetailsList == null) {
            skuDetailsList = Collections.emptyList();
        }
        SkuDetails[] skuDetailsArray = skuDetailsList.toArray(new SkuDetails[skuDetailsList.size()]);
        BillingClientNativeCallback.nativeOnSkuDetailsResponse(billingResult.getResponseCode(), billingResult.getDebugMessage(), skuDetailsArray, this.futureHandle);
    }

    @Override
    public void onAcknowledgePurchaseResponse(BillingResult billingResult) {
        BillingClientNativeCallback.nativeOnAcknowledgePurchaseResponse(billingResult.getResponseCode(), billingResult.getDebugMessage(), this.futureHandle);
    }

    @Override
    public void onBillingSetupFinished(BillingResult billingResult) {
        BillingClientNativeCallback.nativeOnBillingSetupFinished(billingResult.getResponseCode(), billingResult.getDebugMessage(), this.futureHandle);
    }

    @Override
    public void onBillingServiceDisconnected() {
        BillingClientNativeCallback.nativeOnBillingServiceDisconnected();
    }

    @Override
    public void onConsumeResponse(BillingResult billingResult, String purchaseToken) {
        BillingClientNativeCallback.nativeOnConsumePurchaseResponse(billingResult.getResponseCode(), billingResult.getDebugMessage(), purchaseToken, this.futureHandle);
    }

    @Override
    public void onPriceChangeConfirmationResult(BillingResult billingResult) {
        BillingClientNativeCallback.nativeOnPriceChangeConfirmationResult(billingResult.getResponseCode(), billingResult.getDebugMessage(), this.futureHandle);
    }

    @Override
    public void onPurchaseHistoryResponse(BillingResult billingResult, List<PurchaseHistoryRecord> purchaseHistoryRecordList) {
        if (purchaseHistoryRecordList == null) {
            purchaseHistoryRecordList = Collections.emptyList();
        }
        PurchaseHistoryRecord[] purchaseHistoryArray = purchaseHistoryRecordList.toArray(new PurchaseHistoryRecord[purchaseHistoryRecordList.size()]);
        BillingClientNativeCallback.nativeOnPurchaseHistoryResponse(billingResult.getResponseCode(), billingResult.getDebugMessage(), purchaseHistoryArray, this.futureHandle);
    }

    @Override
    public void onPurchasesUpdated(BillingResult billingResult, List<Purchase> purchases) {
        if (purchases == null) {
            purchases = Collections.emptyList();
        }
        Purchase[] purchaseArray = purchases.toArray(new Purchase[purchases.size()]);
        BillingClientNativeCallback.nativeOnPurchasesUpdated(billingResult.getResponseCode(), billingResult.getDebugMessage(), purchaseArray);
    }

    @Override
    public void onRewardResponse(BillingResult billingResult) {
        BillingClientNativeCallback.nativeOnRewardResponse(billingResult.getResponseCode(), billingResult.getDebugMessage(), this.futureHandle);
    }

    void onQueryPurchasesResponse(BillingResult billingResult, List<Purchase> purchases) {
        if (purchases == null) {
            purchases = Collections.emptyList();
        }
        Purchase[] purchaseArray = purchases.toArray(new Purchase[purchases.size()]);
        BillingClientNativeCallback.nativeOnQueryPurchasesResponse(billingResult.getResponseCode(), billingResult.getDebugMessage(), purchaseArray, this.futureHandle);
    }

    public static native void nativeOnAcknowledgePurchaseResponse(int var0, String var1, long var2);

    public static native void nativeOnConsumePurchaseResponse(int var0, String var1, String var2, long var3);

    public static native void nativeOnBillingSetupFinished(int var0, String var1, long var2);

    public static native void nativeOnBillingServiceDisconnected();

    public static native void nativeOnPurchasesUpdated(int var0, String var1, Purchase[] var2);

    public static native void nativeOnPurchaseHistoryResponse(int var0, String var1, PurchaseHistoryRecord[] var2, long var3);

    public static native void nativeOnQueryPurchasesResponse(int var0, String var1, Purchase[] var2, long var3);

    public static native void nativeOnSkuDetailsResponse(int var0, String var1, SkuDetails[] var2, long var3);

    public static native void nativeOnPriceChangeConfirmationResult(int var0, String var1, long var2);

    public static native void nativeOnRewardResponse(int var0, String var1, long var2);
}

