/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.android.billingclient.api.BillingResult;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String mOriginalJson;
    private final String mSignature;
    private final JSONObject mParsedJson;

    public Purchase(String jsonPurchaseInfo, String signature) throws JSONException {
        this.mOriginalJson = jsonPurchaseInfo;
        this.mSignature = signature;
        this.mParsedJson = new JSONObject(this.mOriginalJson);
    }

    public String getOrderId() {
        return this.mParsedJson.optString("orderId");
    }

    public String getPackageName() {
        return this.mParsedJson.optString("packageName");
    }

    public String getSku() {
        return this.mParsedJson.optString("productId");
    }

    public long getPurchaseTime() {
        return this.mParsedJson.optLong("purchaseTime");
    }

    public String getPurchaseToken() {
        return this.mParsedJson.optString("token", this.mParsedJson.optString("purchaseToken"));
    }

    public int getPurchaseState() {
        switch (this.mParsedJson.optInt("purchaseState", 1)) {
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    @Nullable
    public String getDeveloperPayload() {
        return this.mParsedJson.optString("developerPayload");
    }

    public boolean isAcknowledged() {
        return this.mParsedJson.optBoolean("acknowledged", true);
    }

    public boolean isAutoRenewing() {
        return this.mParsedJson.optBoolean("autoRenewing");
    }

    public String getOriginalJson() {
        return this.mOriginalJson;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return "Purchase. Json: " + this.mOriginalJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Purchase)) {
            return false;
        }
        Purchase purchase = (Purchase)o;
        return TextUtils.equals((CharSequence)this.mOriginalJson, (CharSequence)purchase.getOriginalJson()) && TextUtils.equals((CharSequence)this.mSignature, (CharSequence)purchase.getSignature());
    }

    public int hashCode() {
        return this.mOriginalJson.hashCode();
    }

    public static class PurchasesResult {
        private List<Purchase> mPurchaseList;
        private BillingResult mBillingResult;

        public PurchasesResult(BillingResult mBillingResult, List<Purchase> purchasesList) {
            this.mPurchaseList = purchasesList;
            this.mBillingResult = mBillingResult;
        }

        public BillingResult getBillingResult() {
            return this.mBillingResult;
        }

        public int getResponseCode() {
            return this.getBillingResult().getResponseCode();
        }

        public List<Purchase> getPurchasesList() {
            return this.mPurchaseList;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PurchaseState {
        public static final int UNSPECIFIED_STATE = 0;
        public static final int PURCHASED = 1;
        public static final int PENDING = 2;
    }
}

