/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzib;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzee
extends zzdm {
    private static final Logger logger = Logger.getLogger(zzee.class.getName());
    private static final boolean zzaec = zzhv.zzwt();
    zzei zzaed;

    public static zzee zzf(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzee zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzc(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzhv.zzwu()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zzd(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zze(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzee() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzee.zzbp(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzee.zzbv(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zzb(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdp var2) throws IOException;

    public abstract void zza(int var1, zzgi var2) throws IOException;

    abstract void zza(int var1, zzgi var2, zzgx var3) throws IOException;

    public abstract void zzb(int var1, zzgi var2) throws IOException;

    public abstract void zzb(int var1, zzdp var2) throws IOException;

    public abstract void zzbe(int var1) throws IOException;

    public abstract void zzbf(int var1) throws IOException;

    public final void zzbg(int n) throws IOException {
        this.zzbf(zzee.zzbp(n));
    }

    public abstract void zzbh(int var1) throws IOException;

    public abstract void zzbn(long var1) throws IOException;

    public final void zzbo(long l) throws IOException {
        this.zzbn(zzee.zzbv(l));
    }

    public abstract void zzbp(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzbh(Float.floatToRawIntBits(f));
    }

    public final void zzd(double d) throws IOException {
        this.zzbp(Double.doubleToRawLongBits(d));
    }

    public final void zzq(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzdr(String var1) throws IOException;

    public abstract void zza(zzdp var1) throws IOException;

    public abstract void zzb(zzgi var1) throws IOException;

    abstract void zza(zzgi var1, zzgx var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzee.zzbi(n) + zzee.zzbj(n2);
    }

    public static int zzh(int n, int n2) {
        return zzee.zzbi(n) + zzee.zzbk(n2);
    }

    public static int zzi(int n, int n2) {
        return zzee.zzbi(n) + zzee.zzbk(zzee.zzbp(n2));
    }

    public static int zzj(int n, int n2) {
        return zzee.zzbi(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzee.zzbi(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzee.zzbi(n) + zzee.zzbr(l);
    }

    public static int zze(int n, long l) {
        return zzee.zzbi(n) + zzee.zzbr(l);
    }

    public static int zzf(int n, long l) {
        return zzee.zzbi(n) + zzee.zzbr(zzee.zzbv(l));
    }

    public static int zzg(int n, long l) {
        return zzee.zzbi(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzee.zzbi(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzee.zzbi(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzee.zzbi(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzee.zzbi(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzee.zzbi(n) + zzee.zzbj(n2);
    }

    public static int zzc(int n, String string) {
        return zzee.zzbi(n) + zzee.zzds(string);
    }

    public static int zzc(int n, zzdp zzdp2) {
        int n2 = zzdp2.size();
        return zzee.zzbi(n) + (zzee.zzbk(n2) + n2);
    }

    public static int zza(int n, zzfn zzfn2) {
        int n2 = zzfn2.zzuk();
        return zzee.zzbi(n) + (zzee.zzbk(n2) + n2);
    }

    public static int zzc(int n, zzgi zzgi2) {
        return zzee.zzbi(n) + zzee.zzc(zzgi2);
    }

    static int zzb(int n, zzgi zzgi2, zzgx zzgx2) {
        return zzee.zzbi(n) + zzee.zzb(zzgi2, zzgx2);
    }

    public static int zzd(int n, zzgi zzgi2) {
        return (zzee.zzbi(1) << 1) + zzee.zzh(2, n) + zzee.zzc(3, zzgi2);
    }

    public static int zzd(int n, zzdp zzdp2) {
        return (zzee.zzbi(1) << 1) + zzee.zzh(2, n) + zzee.zzc(3, zzdp2);
    }

    public static int zzb(int n, zzfn zzfn2) {
        return (zzee.zzbi(1) << 1) + zzee.zzh(2, n) + zzee.zza(3, zzfn2);
    }

    public static int zzbi(int n) {
        return zzee.zzbk(n << 3);
    }

    public static int zzbj(int n) {
        if (n >= 0) {
            return zzee.zzbk(n);
        }
        return 10;
    }

    public static int zzbk(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzbl(int n) {
        return zzee.zzbk(zzee.zzbp(n));
    }

    public static int zzbm(int n) {
        return 4;
    }

    public static int zzbn(int n) {
        return 4;
    }

    public static int zzbq(long l) {
        return zzee.zzbr(l);
    }

    public static int zzbr(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzbs(long l) {
        return zzee.zzbr(zzee.zzbv(l));
    }

    public static int zzbt(long l) {
        return 8;
    }

    public static int zzbu(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zze(double d) {
        return 8;
    }

    public static int zzr(boolean bl) {
        return 1;
    }

    public static int zzbo(int n) {
        return zzee.zzbj(n);
    }

    public static int zzds(String string) {
        int n;
        try {
            n = zzhy.zza(string);
        }
        catch (zzib zzib2) {
            n = string.getBytes(zzez.UTF_8).length;
        }
        int n2 = n;
        return zzee.zzbk(n2) + n2;
    }

    public static int zza(zzfn zzfn2) {
        int n = zzfn2.zzuk();
        return zzee.zzbk(n) + n;
    }

    public static int zzb(zzdp zzdp2) {
        int n = zzdp2.size();
        return zzee.zzbk(n) + n;
    }

    public static int zzg(byte[] byArray) {
        int n = byArray.length;
        return zzee.zzbk(n) + n;
    }

    public static int zzc(zzgi zzgi2) {
        int n = zzgi2.zzuk();
        return zzee.zzbk(n) + n;
    }

    static int zzb(zzgi zzgi2, zzgx zzgx2) {
        zzgx zzgx3 = zzgx2;
        zzdf zzdf2 = (zzdf)zzgi2;
        int n = zzdf2.zzrt();
        if (n == -1) {
            n = zzgx3.zzt(zzdf2);
            zzdf2.zzam(n);
        }
        int n2 = n;
        return zzee.zzbk(n2) + n2;
    }

    private static int zzbp(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzbv(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zztg();

    public final void zzth() {
        if (this.zztg() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzib zzib2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzib2);
        byte[] byArray = string.getBytes(zzez.UTF_8);
        try {
            this.zzbf(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzb(indexOutOfBoundsException);
        }
        catch (zzb zzb2) {
            throw zzb2;
        }
    }

    @Deprecated
    static int zzc(int n, zzgi zzgi2, zzgx zzgx2) {
        zzgx zzgx3;
        int n2 = zzee.zzbi(n) << 1;
        zzgx zzgx4 = zzgx3 = zzgx2;
        zzdf zzdf2 = (zzdf)zzgi2;
        int n3 = zzdf2.zzrt();
        if (n3 == -1) {
            n3 = zzgx4.zzt(zzdf2);
            zzdf2.zzam(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzgi zzgi2) {
        return zzgi2.zzuk();
    }

    @Deprecated
    public static int zzbq(int n) {
        return zzee.zzbk(n);
    }

    /* synthetic */ zzee(zzeg zzeg2) {
        this();
    }

    static final class zzd
    extends zzee {
        private final ByteBuffer zzaeh;
        private final ByteBuffer zzaei;
        private final long zzaej;
        private final long zzaek;
        private final long zzael;
        private final long zzaem;
        private long zzaen;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzaeh = byteBuffer;
            this.zzaei = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzaej = zzhv.zzb(byteBuffer);
            this.zzaek = this.zzaej + (long)byteBuffer.position();
            this.zzael = this.zzaej + (long)byteBuffer.limit();
            this.zzaem = this.zzael - 10L;
            this.zzaen = this.zzaek;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzee)this).zzbf(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbe(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbf(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 5);
            ((zzee)this).zzbh(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbn(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzee)this).zzb(n, 1);
            ((zzee)this).zzbp(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zzdr(string);
        }

        @Override
        public final void zza(int n, zzdp zzdp2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zza(zzdp2);
        }

        @Override
        public final void zza(int n, zzgi zzgi2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zzb(zzgi2);
        }

        @Override
        final void zza(int n, zzgi zzgi2, zzgx zzgx2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zza(zzgi2, zzgx2);
        }

        @Override
        public final void zzb(int n, zzgi zzgi2) throws IOException {
            ((zzee)this).zzb(1, 3);
            ((zzee)this).zzd(2, n);
            ((zzee)this).zza(3, zzgi2);
            ((zzee)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzdp zzdp2) throws IOException {
            ((zzee)this).zzb(1, 3);
            ((zzee)this).zzd(2, n);
            ((zzee)this).zza(3, zzdp2);
            ((zzee)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzgi zzgi2) throws IOException {
            ((zzee)this).zzbf(zzgi2.zzuk());
            zzgi2.zzb(this);
        }

        @Override
        final void zza(zzgi zzgi2, zzgx zzgx2) throws IOException {
            zzgx zzgx3 = zzgx2;
            zzdf zzdf2 = (zzdf)zzgi2;
            int n = zzdf2.zzrt();
            if (n == -1) {
                n = zzgx3.zzt(zzdf2);
                zzdf2.zzam(n);
            }
            ((zzee)this).zzbf(n);
            zzgx2.zza(zzgi2, this.zzaed);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzaen >= this.zzael) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.zzaen, this.zzael, 1));
            }
            zzhv.zza(this.zzaen++, by);
        }

        @Override
        public final void zza(zzdp zzdp2) throws IOException {
            ((zzee)this).zzbf(zzdp2.size());
            zzdp2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzee)this).zzbf(n2);
            ((zzee)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzbe(int n) throws IOException {
            if (n >= 0) {
                ((zzee)this).zzbf(n);
                return;
            }
            ((zzee)this).zzbn(n);
        }

        @Override
        public final void zzbf(int n) throws IOException {
            if (this.zzaen <= this.zzaem) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzhv.zza(this.zzaen++, (byte)n);
                        return;
                    }
                    zzhv.zza(this.zzaen++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzaen < this.zzael) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzhv.zza(this.zzaen++, (byte)n);
                    return;
                }
                zzhv.zza(this.zzaen++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.zzaen, this.zzael, 1));
        }

        @Override
        public final void zzbh(int n) throws IOException {
            long l = this.zzaen;
            zzd zzd2 = this;
            this.zzaei.putInt((int)(l - zzd2.zzaej), n);
            this.zzaen += 4L;
        }

        @Override
        public final void zzbn(long l) throws IOException {
            if (this.zzaen <= this.zzaem) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzhv.zza(this.zzaen++, (byte)l);
                        return;
                    }
                    zzhv.zza(this.zzaen++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzaen < this.zzael) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzhv.zza(this.zzaen++, (byte)l);
                    return;
                }
                zzhv.zza(this.zzaen++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.zzaen, this.zzael, 1));
        }

        @Override
        public final void zzbp(long l) throws IOException {
            long l2 = this.zzaen;
            zzd zzd2 = this;
            this.zzaei.putLong((int)(l2 - zzd2.zzaej), l);
            this.zzaen += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzael - (long)n2 < this.zzaen) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.zzaen, this.zzael, n2));
            }
            zzhv.zza(byArray, n, this.zzaen, n2);
            this.zzaen += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzee)this).write(byArray, n, n2);
        }

        @Override
        public final void zzdr(String string) throws IOException {
            long l = this.zzaen;
            try {
                int n = zzd.zzbk(string.length() * 3);
                int n2 = zzd.zzbk(string.length());
                if (n2 == n) {
                    long l2 = this.zzaen;
                    zzd zzd2 = this;
                    int n3 = (int)(l2 - zzd2.zzaej) + n2;
                    this.zzaei.position(n3);
                    zzhy.zza(string, this.zzaei);
                    int n4 = this.zzaei.position() - n3;
                    ((zzee)this).zzbf(n4);
                    this.zzaen += (long)n4;
                    return;
                }
                int n5 = zzhy.zza(string);
                ((zzee)this).zzbf(n5);
                this.zzbw(this.zzaen);
                zzhy.zza(string, this.zzaei);
                this.zzaen += (long)n5;
                return;
            }
            catch (zzib zzib2) {
                this.zzaen = l;
                this.zzbw(this.zzaen);
                this.zza(string, zzib2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzb(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzaen;
            zzd zzd2 = this;
            this.zzaeh.position((int)(l - zzd2.zzaej));
        }

        @Override
        public final int zztg() {
            return (int)(this.zzael - this.zzaen);
        }

        private final void zzbw(long l) {
            long l2 = l;
            zzd zzd2 = this;
            this.zzaei.position((int)(l2 - zzd2.zzaej));
        }
    }

    static final class zze
    extends zzee {
        private final ByteBuffer zzaeh;
        private final ByteBuffer zzaei;
        private final int zzaeg;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzaeh = byteBuffer;
            this.zzaei = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzaeg = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzee)this).zzbf(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbe(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbf(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 5);
            ((zzee)this).zzbh(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbn(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzee)this).zzb(n, 1);
            ((zzee)this).zzbp(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zzdr(string);
        }

        @Override
        public final void zza(int n, zzdp zzdp2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zza(zzdp2);
        }

        @Override
        public final void zza(int n, zzgi zzgi2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zzb(zzgi2);
        }

        @Override
        final void zza(int n, zzgi zzgi2, zzgx zzgx2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zza(zzgi2, zzgx2);
        }

        @Override
        public final void zzb(int n, zzgi zzgi2) throws IOException {
            ((zzee)this).zzb(1, 3);
            ((zzee)this).zzd(2, n);
            ((zzee)this).zza(3, zzgi2);
            ((zzee)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzdp zzdp2) throws IOException {
            ((zzee)this).zzb(1, 3);
            ((zzee)this).zzd(2, n);
            ((zzee)this).zza(3, zzdp2);
            ((zzee)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzgi zzgi2) throws IOException {
            ((zzee)this).zzbf(zzgi2.zzuk());
            zzgi2.zzb(this);
        }

        @Override
        final void zza(zzgi zzgi2, zzgx zzgx2) throws IOException {
            zzgx zzgx3 = zzgx2;
            zzdf zzdf2 = (zzdf)zzgi2;
            int n = zzdf2.zzrt();
            if (n == -1) {
                n = zzgx3.zzt(zzdf2);
                zzdf2.zzam(n);
            }
            ((zzee)this).zzbf(n);
            zzgx2.zza(zzgi2, this.zzaed);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzaei.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzb(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzdp zzdp2) throws IOException {
            ((zzee)this).zzbf(zzdp2.size());
            zzdp2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzee)this).zzbf(n2);
            ((zzee)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzbe(int n) throws IOException {
            if (n >= 0) {
                ((zzee)this).zzbf(n);
                return;
            }
            ((zzee)this).zzbn(n);
        }

        @Override
        public final void zzbf(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzaei.put((byte)n);
                        return;
                    }
                    this.zzaei.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzb(bufferOverflowException);
            }
        }

        @Override
        public final void zzbh(int n) throws IOException {
            try {
                this.zzaei.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzb(bufferOverflowException);
            }
        }

        @Override
        public final void zzbn(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzaei.put((byte)l);
                        return;
                    }
                    this.zzaei.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzb(bufferOverflowException);
            }
        }

        @Override
        public final void zzbp(long l) throws IOException {
            try {
                this.zzaei.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzb(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzaei.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzb(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzee)this).write(byArray, n, n2);
        }

        @Override
        public final void zzdr(String string) throws IOException {
            int n = this.zzaei.position();
            try {
                int n2 = zze.zzbk(string.length() * 3);
                int n3 = zze.zzbk(string.length());
                if (n3 == n2) {
                    int n4 = this.zzaei.position() + n3;
                    this.zzaei.position(n4);
                    this.zzdt(string);
                    int n5 = this.zzaei.position();
                    this.zzaei.position(n);
                    ((zzee)this).zzbf(n5 - n4);
                    this.zzaei.position(n5);
                    return;
                }
                int n6 = zzhy.zza(string);
                ((zzee)this).zzbf(n6);
                this.zzdt(string);
                return;
            }
            catch (zzib zzib2) {
                this.zzaei.position(n);
                this.zza(string, zzib2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzb(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzaeh.position(this.zzaei.position());
        }

        @Override
        public final int zztg() {
            return this.zzaei.remaining();
        }

        private final void zzdt(String string) throws IOException {
            try {
                zzhy.zza(string, this.zzaei);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(indexOutOfBoundsException);
            }
        }
    }

    static final class zzc
    extends zza {
        private final ByteBuffer zzaef;
        private int zzaeg;

        zzc(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzaef = byteBuffer;
            this.zzaeg = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzaef.position(this.zzaeg + this.zztj());
        }
    }

    static class zza
    extends zzee {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzee)this).zzbf(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbe(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbf(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzee)this).zzb(n, 5);
            ((zzee)this).zzbh(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzbn(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzee)this).zzb(n, 1);
            ((zzee)this).zzbp(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzee)this).zzb(n, 0);
            ((zzee)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zzdr(string);
        }

        @Override
        public final void zza(int n, zzdp zzdp2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zza(zzdp2);
        }

        @Override
        public final void zza(zzdp zzdp2) throws IOException {
            ((zzee)this).zzbf(zzdp2.size());
            zzdp2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzee)this).zzbf(n2);
            ((zzee)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzgi zzgi2) throws IOException {
            ((zzee)this).zzb(n, 2);
            ((zzee)this).zzb(zzgi2);
        }

        @Override
        final void zza(int n, zzgi zzgi2, zzgx zzgx2) throws IOException {
            ((zzee)this).zzb(n, 2);
            zzgx zzgx3 = zzgx2;
            zzdf zzdf2 = (zzdf)zzgi2;
            int n2 = zzdf2.zzrt();
            if (n2 == -1) {
                n2 = zzgx3.zzt(zzdf2);
                zzdf2.zzam(n2);
            }
            ((zzee)this).zzbf(n2);
            zzgx2.zza(zzgi2, this.zzaed);
        }

        @Override
        public final void zzb(int n, zzgi zzgi2) throws IOException {
            ((zzee)this).zzb(1, 3);
            ((zzee)this).zzd(2, n);
            ((zzee)this).zza(3, zzgi2);
            ((zzee)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzdp zzdp2) throws IOException {
            ((zzee)this).zzb(1, 3);
            ((zzee)this).zzd(2, n);
            ((zzee)this).zza(3, zzdp2);
            ((zzee)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzgi zzgi2) throws IOException {
            ((zzee)this).zzbf(zzgi2.zzuk());
            zzgi2.zzb(this);
        }

        @Override
        final void zza(zzgi zzgi2, zzgx zzgx2) throws IOException {
            zzgx zzgx3 = zzgx2;
            zzdf zzdf2 = (zzdf)zzgi2;
            int n = zzdf2.zzrt();
            if (n == -1) {
                n = zzgx3.zzt(zzdf2);
                zzdf2.zzam(n);
            }
            ((zzee)this).zzbf(n);
            zzgx2.zza(zzgi2, this.zzaed);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzbe(int n) throws IOException {
            if (n >= 0) {
                ((zzee)this).zzbf(n);
                return;
            }
            ((zzee)this).zzbn(n);
        }

        @Override
        public final void zzbf(int n) throws IOException {
            if (zzaec && !zzdi.zzrv() && ((zzee)this).zztg() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzhv.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzhv.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzhv.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzhv.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzhv.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzhv.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzhv.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzhv.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                zzhv.zza(this.buffer, (long)this.position++, (byte)(n >>>= 7));
                return;
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzbh(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzbn(long l) throws IOException {
            if (zzaec && ((zzee)this).zztg() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzhv.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzhv.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzbp(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzee)this).write(byArray, n, n2);
        }

        @Override
        public final void zzdr(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzbk(string.length() * 3);
                int n3 = zza.zzbk(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzhy.zza(string, this.buffer, this.position, ((zzee)this).zztg());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzee)this).zzbf(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzhy.zza(string);
                ((zzee)this).zzbf(n6);
                this.position = zzhy.zza(string, this.buffer, this.position, ((zzee)this).zztg());
                return;
            }
            catch (zzib zzib2) {
                this.position = n;
                this.zza(string, zzib2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zztg() {
            return this.limit - this.position;
        }

        public final int zztj() {
            return this.position - this.offset;
        }
    }

    public static final class zzb
    extends IOException {
        zzb() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzb(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzb(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzb(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

