/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzr;

public final class zzez {
    private final zzfa zzmw;

    public zzez(zzfa zzfa2) {
        Preconditions.checkNotNull((Object)zzfa2);
        this.zzmw = zzfa2;
    }

    public static boolean zzl(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzfj zzfj2 = zzfj.zza(context, null);
        zzef zzef2 = zzfj2.zzab();
        if (intent == null) {
            zzef2.zzgn().zzao("Receiver called with null intent");
            return;
        }
        zzr zzr2 = zzfj2.zzae();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzef2.zzgs().zza("Device receiver got", string);
        } else {
            zzef2.zzgs().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzef2.zzgs().zzao("Starting wakeful intent.");
            this.zzmw.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzfj2.zzaa().zza(new zzey(this, zzfj2, zzef2));
            }
            catch (Exception exception) {
                zzef2.zzgn().zza("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzmw.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzef2.zzgs().zzao("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzef2.zzgq().zza("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzfj2.zzz().zza(uri);
            if (bundle == null) {
                zzef2.zzgs().zzao("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzef2.zzgn().zzao("Install referrer is missing timestamp");
                }
                zzfj2.zzaa().zza(new zzfb(this, zzfj2, l, bundle, context, zzef2, pendingResult));
            }
        }
    }
}

