/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfc
extends zzge {
    private zzfg zzna;
    private zzfg zznb;
    private final PriorityBlockingQueue<zzfh<?>> zznc;
    private final BlockingQueue<zzfh<?>> zznd;
    private final Thread.UncaughtExceptionHandler zzne;
    private final Thread.UncaughtExceptionHandler zznf;
    private final Object zzng = new Object();
    private final Semaphore zznh = new Semaphore(2);
    private volatile boolean zzni;
    private static final AtomicLong zznj = new AtomicLong(Long.MIN_VALUE);

    zzfc(zzfj zzfj2) {
        super(zzfj2);
        this.zznc = new PriorityBlockingQueue();
        this.zznd = new LinkedBlockingQueue();
        this.zzne = new zzfe(this, "Thread death: Uncaught exception on worker thread");
        this.zznf = new zzfe(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    @Override
    public final void zzo() {
        if (Thread.currentThread() != this.zzna) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzn() {
        if (Thread.currentThread() != this.zznb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzhp() {
        return Thread.currentThread() == this.zzna;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzbi();
        Preconditions.checkNotNull(callable);
        zzfh zzfh2 = new zzfh(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzna) {
            if (!this.zznc.isEmpty()) {
                ((zzgf)this).zzab().zzgn().zzao("Callable skipped the worker queue.");
            }
            zzfh2.run();
        } else {
            this.zza(zzfh2);
        }
        return zzfh2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzbi();
        Preconditions.checkNotNull(callable);
        zzfh zzfh2 = new zzfh(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzna) {
            zzfh2.run();
        } else {
            this.zza(zzfh2);
        }
        return zzfh2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzbi();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfh(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgf)this).zzaa().zza(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgf)this).zzab().zzgn().zzao(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgf)this).zzab().zzgn().zzao(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfh<?> zzfh2) {
        Object object = this.zzng;
        synchronized (object) {
            this.zznc.add(zzfh2);
            if (this.zzna == null) {
                this.zzna = new zzfg(this, "Measurement Worker", this.zznc);
                this.zzna.setUncaughtExceptionHandler(this.zzne);
                this.zzna.start();
            } else {
                this.zzna.zzhr();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzbi();
        Preconditions.checkNotNull((Object)runnable);
        zzfh zzfh2 = new zzfh(this, runnable, false, "Task exception on network thread");
        zzfc zzfc2 = this;
        Object object = zzfc2.zzng;
        synchronized (object) {
            zzfc2.zznd.add(zzfh2);
            if (zzfc2.zznb == null) {
                zzfc2.zznb = new zzfg(zzfc2, "Measurement Network", zzfc2.zznd);
                zzfc2.zznb.setUncaughtExceptionHandler(zzfc2.zznf);
                zzfc2.zznb.start();
            } else {
                zzfc2.zznb.zzhr();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfc zzfc2) {
        return zzfc2.zznh;
    }

    static /* synthetic */ boolean zzb(zzfc zzfc2) {
        return zzfc2.zzni;
    }

    static /* synthetic */ Object zzc(zzfc zzfc2) {
        return zzfc2.zzng;
    }

    static /* synthetic */ zzfg zzd(zzfc zzfc2) {
        return zzfc2.zzna;
    }

    static /* synthetic */ zzfg zza(zzfc zzfc2, zzfg zzfg2) {
        zzfc2.zzna = null;
        return null;
    }

    static /* synthetic */ zzfg zze(zzfc zzfc2) {
        return zzfc2.zznb;
    }

    static /* synthetic */ zzfg zzb(zzfc zzfc2, zzfg zzfg2) {
        zzfc2.zznb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzhq() {
        return zznj;
    }
}

