/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzr;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzamx;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzaub;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbbl;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzrz;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.Collections;

public class zze
extends zzamx
implements zzw {
    @VisibleForTesting
    private static final int zzdgn = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity zzzr;
    @VisibleForTesting
    AdOverlayInfoParcel zzdgo;
    @VisibleForTesting
    zzbbc zzcyx;
    @VisibleForTesting
    private zzk zzdgp;
    @VisibleForTesting
    private zzo zzdgq;
    @VisibleForTesting
    private boolean zzdgr = false;
    @VisibleForTesting
    private FrameLayout zzdgs;
    @VisibleForTesting
    private WebChromeClient.CustomViewCallback zzdgt;
    @VisibleForTesting
    private boolean zzdgu = false;
    @VisibleForTesting
    private boolean zzbky = false;
    @VisibleForTesting
    private zzh zzdgv;
    @VisibleForTesting
    private boolean zzdgw = false;
    @VisibleForTesting
    int zzdgx = 0;
    private final Object zzdgy = new Object();
    private Runnable zzdgz;
    private boolean zzdha;
    private boolean zzdhb;
    private boolean zzdhc = false;
    private boolean zzdhd = false;
    private boolean zzdhe = true;

    public zze(Activity activity) {
        this.zzzr = activity;
    }

    public final void close() {
        this.zzdgx = 2;
        this.zzzr.finish();
    }

    public final void zzsj() {
        if (this.zzdgo != null && this.zzdgr) {
            this.setRequestedOrientation(this.zzdgo.orientation);
        }
        if (this.zzdgs != null) {
            this.zzzr.setContentView((View)this.zzdgv);
            this.zzdhb = true;
            this.zzdgs.removeAllViews();
            this.zzdgs = null;
        }
        if (this.zzdgt != null) {
            this.zzdgt.onCustomViewHidden();
            this.zzdgt = null;
        }
        this.zzdgr = false;
    }

    @Override
    public final void zzsk() {
        this.zzdgx = 1;
        this.zzzr.finish();
    }

    public final void onBackPressed() {
        this.zzdgx = 0;
    }

    public final boolean zzsl() {
        this.zzdgx = 0;
        if (this.zzcyx == null) {
            return true;
        }
        boolean bl = this.zzcyx.zzzf();
        if (!bl) {
            this.zzcyx.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.zzzr.requestWindowFeature(1);
        this.zzdgu = bundle != null && bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false);
        try {
            this.zzdgo = AdOverlayInfoParcel.zzc(this.zzzr.getIntent());
            if (this.zzdgo == null) {
                throw new zzi("Could not get info for ad overlay.");
            }
            if (this.zzdgo.zzblh.zzdvt > 7500000) {
                this.zzdgx = 3;
            }
            if (this.zzzr.getIntent() != null) {
                this.zzdhe = this.zzzr.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzbky = this.zzdgo.zzdht != null ? this.zzdgo.zzdht.zzbky : false;
            if (this.zzbky && this.zzdgo.zzdht.zzbld != -1) {
                new zzj(this, null).zzup();
            }
            if (bundle == null) {
                if (this.zzdgo.zzdhm != null && this.zzdhe) {
                    this.zzdgo.zzdhm.zzsf();
                }
                if (this.zzdgo.zzdhr != 1 && this.zzdgo.zzcbl != null) {
                    this.zzdgo.zzcbl.onAdClicked();
                }
            }
            this.zzdgv = new zzh((Context)this.zzzr, this.zzdgo.zzdhs, this.zzdgo.zzblh.zzbnh);
            this.zzdgv.setId(1000);
            zzp.zzka().zzg(this.zzzr);
            switch (this.zzdgo.zzdhr) {
                case 1: {
                    this.zzad(false);
                    return;
                }
                case 2: {
                    this.zzdgp = new zzk(this.zzdgo.zzcyx);
                    this.zzad(false);
                    return;
                }
                case 3: {
                    this.zzad(true);
                    return;
                }
            }
            throw new zzi("Could not determine ad overlay type.");
        }
        catch (zzi zzi2) {
            zzatm.zzeu((String)zzi2.getMessage());
            this.zzdgx = 3;
            this.zzzr.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzyi zzyi2 = zzyt.zzcqa;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            if (this.zzcyx != null && !this.zzcyx.isDestroyed()) {
                zzp.zzka();
                zzaub.zzb(this.zzcyx);
                return;
            }
            zzatm.zzeu((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzdgo.zzdhm != null) {
            this.zzdgo.zzdhm.onResume();
        }
        this.zza(this.zzzr.getResources().getConfiguration());
        zzyi zzyi2 = zzyt.zzcqa;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            if (this.zzcyx != null && !this.zzcyx.isDestroyed()) {
                zzp.zzka();
                zzaub.zzb(this.zzcyx);
                return;
            }
            zzatm.zzeu((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzsj();
        if (this.zzdgo.zzdhm != null) {
            this.zzdgo.zzdhm.onPause();
        }
        zzyi zzyi2 = zzyt.zzcqa;
        if (!(((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue() || this.zzcyx == null || this.zzzr.isFinishing() && this.zzdgp != null)) {
            zzp.zzka();
            zzaub.zza(this.zzcyx);
        }
        this.zzsn();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzag(IObjectWrapper iObjectWrapper) {
        Configuration configuration = (Configuration)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza(configuration);
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzdgu);
    }

    public final void onStop() {
        zzyi zzyi2 = zzyt.zzcqa;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue() && this.zzcyx != null && (!this.zzzr.isFinishing() || this.zzdgp == null)) {
            zzp.zzka();
            zzaub.zza(this.zzcyx);
        }
        this.zzsn();
    }

    public final void onDestroy() {
        if (this.zzcyx != null) {
            this.zzdgv.removeView(this.zzcyx.getView());
        }
        this.zzsn();
    }

    private final void zzac(boolean bl) {
        zzyi zzyi2 = zzyt.zzcqc;
        int n = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzr zzr2 = new zzr();
        new zzr().size = 50;
        zzr2.paddingLeft = bl ? n : 0;
        zzr2.paddingRight = bl ? 0 : n;
        zzr2.paddingTop = 0;
        zzr2.paddingBottom = n;
        this.zzdgq = new zzo((Context)this.zzzr, zzr2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzdgo.zzdho);
        this.zzdgv.addView((View)this.zzdgq, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzcz() {
        this.zzdhb = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzyi zzyi2 = zzyt.zzcko;
        boolean bl4 = (Boolean)zzuo.zzoj().zzd(zzyi2) != false && this.zzdgo != null && this.zzdgo.zzdht != null && this.zzdgo.zzdht.zzblf;
        zzyi2 = zzyt.zzckp;
        boolean bl5 = bl3 = (Boolean)zzuo.zzoj().zzd(zzyi2) != false && this.zzdgo != null && this.zzdgo.zzdht != null && this.zzdgo.zzdht.zzblg;
        if (bl && bl2 && bl4 && !bl3) {
            new zzamp(this.zzcyx, "useCustomClose").zzdn("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzdgq != null) {
            this.zzdgq.zzae(bl3 || bl2 && !bl4);
        }
    }

    public final void zzsm() {
        this.zzdgv.removeView((View)this.zzdgq);
        this.zzac(true);
    }

    public final void setRequestedOrientation(int n) {
        zzyi zzyi2 = zzyt.zzcse;
        if (this.zzzr.getApplicationInfo().targetSdkVersion >= (Integer)zzuo.zzoj().zzd(zzyi2)) {
            zzyi2 = zzyt.zzcsf;
            if (this.zzzr.getApplicationInfo().targetSdkVersion <= (Integer)zzuo.zzoj().zzd(zzyi2)) {
                zzyi2 = zzyt.zzcsg;
                if (Build.VERSION.SDK_INT >= (Integer)zzuo.zzoj().zzd(zzyi2)) {
                    zzyi2 = zzyt.zzcsh;
                    if (Build.VERSION.SDK_INT <= (Integer)zzuo.zzoj().zzd(zzyi2)) {
                        return;
                    }
                }
            }
        }
        try {
            this.zzzr.setRequestedOrientation(n);
            return;
        }
        catch (Throwable throwable) {
            zzp.zzkc().zzb(throwable, "AdOverlay.setRequestedOrientation");
            return;
        }
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzdgs = new FrameLayout((Context)this.zzzr);
        this.zzdgs.setBackgroundColor(-16777216);
        this.zzdgs.addView(view, -1, -1);
        this.zzzr.setContentView((View)this.zzdgs);
        this.zzdhb = true;
        this.zzdgt = customViewCallback;
        this.zzdgr = true;
    }

    private final void zzad(boolean bl) throws zzi {
        ViewParent viewParent;
        Window window;
        if (!this.zzdhb) {
            this.zzzr.requestWindowFeature(1);
        }
        if ((window = this.zzzr.getWindow()) == null) {
            throw new zzi("Invalid activity, no window available.");
        }
        zzbcm zzbcm2 = this.zzdgo.zzcyx != null ? this.zzdgo.zzcyx.zzyy() : null;
        boolean bl2 = zzbcm2 != null && zzbcm2.zzzr();
        this.zzdgw = false;
        if (bl2) {
            int n = this.zzdgo.orientation;
            zzp.zzka();
            if (n == 6) {
                this.zzdgw = this.zzzr.getResources().getConfiguration().orientation == 1;
            } else {
                int n2 = this.zzdgo.orientation;
                zzp.zzka();
                if (n2 == 7) {
                    this.zzdgw = this.zzzr.getResources().getConfiguration().orientation == 2;
                }
            }
        }
        boolean bl3 = this.zzdgw;
        zzatm.zzdv((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzdgo.orientation);
        zzp.zzka();
        window.setFlags(0x1000000, 0x1000000);
        zzatm.zzdv((String)"Hardware acceleration on the AdActivity window enabled.");
        if (!this.zzbky) {
            this.zzdgv.setBackgroundColor(-16777216);
        } else {
            this.zzdgv.setBackgroundColor(zzdgn);
        }
        this.zzzr.setContentView((View)this.zzdgv);
        this.zzdhb = true;
        if (bl) {
            try {
                zzp.zzjz();
                this.zzcyx = zzbbl.zza((Context)this.zzzr, this.zzdgo.zzcyx != null ? this.zzdgo.zzcyx.zzyw() : null, this.zzdgo.zzcyx != null ? this.zzdgo.zzcyx.zzyx() : null, true, bl2, null, this.zzdgo.zzblh, null, null, this.zzdgo.zzcyx != null ? this.zzdgo.zzcyx.zzxm() : null, zzrz.zzmk(), null, false);
            }
            catch (Exception exception) {
                zzatm.zzc((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzi("Could not obtain webview for the overlay.");
            }
            this.zzcyx.zzyy().zza(null, this.zzdgo.zzcwp, null, this.zzdgo.zzcwr, this.zzdgo.zzdhq, true, null, this.zzdgo.zzcyx != null ? this.zzdgo.zzcyx.zzyy().zzzq() : null, null, null);
            this.zzcyx.zzyy().zza(new zzd(this));
            if (this.zzdgo.url != null) {
                this.zzcyx.loadUrl(this.zzdgo.url);
            } else if (this.zzdgo.zzdhp != null) {
                this.zzcyx.loadDataWithBaseURL(this.zzdgo.zzdhn, this.zzdgo.zzdhp, "text/html", "UTF-8", null);
            } else {
                throw new zzi("No URL or HTML to display in ad overlay.");
            }
            if (this.zzdgo.zzcyx != null) {
                this.zzdgo.zzcyx.zzb(this);
            }
        } else {
            this.zzcyx = this.zzdgo.zzcyx;
            this.zzcyx.zzbq((Context)this.zzzr);
        }
        this.zzcyx.zza(this);
        if (this.zzdgo.zzcyx != null) {
            zze.zzc(this.zzdgo.zzcyx.zzzc(), (View)this.zzdgv);
        }
        if ((viewParent = this.zzcyx.getParent()) != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzcyx.getView());
        }
        if (this.zzbky) {
            this.zzcyx.zzzk();
        }
        this.zzcyx.zza(null, this.zzzr, this.zzdgo.zzdhn, this.zzdgo.zzdhp);
        this.zzdgv.addView(this.zzcyx.getView(), -1, -1);
        if (!bl && !this.zzdgw) {
            this.zzsq();
        }
        this.zzac(bl2);
        if (this.zzcyx.zzza()) {
            this.zza(bl2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzsn() {
        if (!this.zzzr.isFinishing() || this.zzdhc) {
            return;
        }
        this.zzdhc = true;
        if (this.zzcyx != null) {
            int n = this.zzdgx;
            this.zzcyx.zzdc(n);
            Object object = this.zzdgy;
            synchronized (object) {
                if (!this.zzdha && this.zzcyx.zzzg()) {
                    this.zzdgz = new zzg(this);
                    zzyi zzyi2 = zzyt.zzckn;
                    zzatv.zzdsk.postDelayed(this.zzdgz, ((Long)zzuo.zzoj().zzd(zzyi2)).longValue());
                    return;
                }
            }
        }
        this.zzso();
    }

    @VisibleForTesting
    final void zzso() {
        if (this.zzdhd) {
            return;
        }
        this.zzdhd = true;
        if (this.zzcyx != null) {
            this.zzdgv.removeView(this.zzcyx.getView());
            if (this.zzdgp != null) {
                this.zzcyx.zzbq(this.zzdgp.zzlk);
                this.zzcyx.zzaq(false);
                this.zzdgp.parent.addView(this.zzcyx.getView(), this.zzdgp.index, this.zzdgp.zzdhi);
                this.zzdgp = null;
            } else if (this.zzzr.getApplicationContext() != null) {
                this.zzcyx.zzbq(this.zzzr.getApplicationContext());
            }
            this.zzcyx = null;
        }
        if (this.zzdgo != null && this.zzdgo.zzdhm != null) {
            this.zzdgo.zzdhm.zzse();
        }
        if (this.zzdgo != null && this.zzdgo.zzcyx != null) {
            zze.zzc(this.zzdgo.zzcyx.zzzc(), this.zzdgo.zzcyx.getView());
        }
    }

    private static void zzc(@Nullable IObjectWrapper iObjectWrapper, @Nullable View view) {
        if (iObjectWrapper != null && view != null) {
            zzp.zzkn().zza(iObjectWrapper, view);
        }
    }

    public final void zzsp() {
        if (this.zzdgw) {
            this.zzdgw = false;
            this.zzsq();
        }
    }

    private final void zzsq() {
        this.zzcyx.zzsq();
    }

    public final void zzsr() {
        this.zzdgv.zzdhg = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzss() {
        Object object = this.zzdgy;
        synchronized (object) {
            this.zzdha = true;
            if (this.zzdgz != null) {
                zzatv.zzdsk.removeCallbacks(this.zzdgz);
                zzatv.zzdsk.post(this.zzdgz);
            }
            return;
        }
    }

    private final void zza(Configuration configuration) {
        boolean bl = this.zzdgo != null && this.zzdgo.zzdht != null && this.zzdgo.zzdht.zzbkz;
        boolean bl2 = zzp.zzka().zza(this.zzzr, configuration);
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(this.zzbky && !bl || bl2)) {
            bl3 = true;
            if (Build.VERSION.SDK_INT >= 19 && this.zzdgo != null && this.zzdgo.zzdht != null && this.zzdgo.zzdht.zzble) {
                bl4 = true;
            }
        }
        Window window = this.zzzr.getWindow();
        zzyi zzyi2 = zzyt.zzckq;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue() && Build.VERSION.SDK_INT >= 19) {
            View view = window.getDecorView();
            int n = 256;
            if (bl3) {
                n = 5380;
                if (bl4) {
                    n = 5894;
                }
            }
            view.setSystemUiVisibility(n);
            return;
        }
        if (bl3) {
            window.addFlags(1024);
            window.clearFlags(2048);
            if (Build.VERSION.SDK_INT >= 19 && bl4) {
                window.getDecorView().setSystemUiVisibility(4098);
                return;
            }
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
    }
}

