/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzahv;
import com.google.android.gms.internal.ads.zzaic;
import com.google.android.gms.internal.ads.zzasy;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzaxb;
import com.google.android.gms.internal.ads.zzdcf;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zze {
    private Context zzlk;
    private long zzbkt = 0L;

    public final void zza(Context context, zzawv zzawv2, String string2, @Nullable Runnable runnable) {
        this.zza(context, zzawv2, true, null, string2, null, runnable);
    }

    public final void zza(Context context, zzawv zzawv2, String string2, zzasy zzasy2) {
        String string3 = zzasy2 != null ? zzasy2.zztx() : null;
        this.zza(context, zzawv2, false, zzasy2, string3, string2, null);
    }

    @VisibleForTesting
    private final void zza(Context context, zzawv zzawv2, boolean bl, @Nullable zzasy zzasy2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        boolean bl2;
        if (zzp.zzkf().elapsedRealtime() - this.zzbkt < 5000L) {
            zzatm.zzeu((String)"Not retrying to fetch app settings");
            return;
        }
        this.zzbkt = zzp.zzkf().elapsedRealtime();
        zzasy zzasy3 = zzasy2;
        if (zzasy3 == null) {
            bl2 = true;
        } else {
            long l = zzasy3.zztu();
            zzyi zzyi2 = zzyt.zzcoq;
            bl2 = zzp.zzkf().currentTimeMillis() - l > (Long)zzuo.zzoj().zzd(zzyi2) || !zzasy3.zztv();
        }
        if (!bl2) {
            return;
        }
        if (context == null) {
            zzatm.zzeu((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            zzatm.zzeu((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        Context context2 = context.getApplicationContext();
        this.zzlk = context2 != null ? context2 : context;
        zzahv<JSONObject, JSONObject> zzahv2 = zzp.zzkl().zzb(this.zzlk, zzawv2).zza("google.afma.config.fetchAppSettings", zzaic.zzdan, zzaic.zzdan);
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_id", (Object)string2);
            } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("ad_unit_id", (Object)string3);
            }
            jSONObject.put("is_init", bl);
            jSONObject.put("pn", (Object)context.getPackageName());
            zzdcp<JSONObject> zzdcp2 = zzahv2.zzi(jSONObject);
            zzdcp zzdcp3 = zzdcf.zzb(zzdcp2, zzd.zzbks, (Executor)zzawx.zzdwb);
            if (runnable != null) {
                zzdcp2.addListener(runnable, zzawx.zzdwb);
            }
            zzaxb.zza(zzdcp3, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

