/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzl;
import com.google.android.gms.ads.internal.zzm;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzand;
import com.google.android.gms.internal.ads.zzanj;
import com.google.android.gms.internal.ads.zzapo;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzqu;
import com.google.android.gms.internal.ads.zztp;
import com.google.android.gms.internal.ads.zztw;
import com.google.android.gms.internal.ads.zztx;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzuq;
import com.google.android.gms.internal.ads.zzur;
import com.google.android.gms.internal.ads.zzvd;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzvm;
import com.google.android.gms.internal.ads.zzvs;
import com.google.android.gms.internal.ads.zzwk;
import com.google.android.gms.internal.ads.zzwq;
import com.google.android.gms.internal.ads.zzyc;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzn;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzj
extends zzvd {
    private final zzawv zzblh;
    private final zztw zzbli;
    private final Future<zzdf> zzblj;
    private final Context zzlk;
    private final zzq zzblk;
    @Nullable
    private WebView zzbll;
    @Nullable
    private zzur zzblm;
    @Nullable
    private zzdf zzbln;
    private AsyncTask<Void, Void, String> zzblo;

    public zzj(Context context, zztw zztw2, String string2, zzawv zzawv2) {
        this.zzlk = context;
        this.zzblh = zzawv2;
        this.zzbli = zztw2;
        this.zzbll = new WebView(this.zzlk);
        zzj zzj2 = this;
        this.zzblj = zzawx.zzdvx.zzd(new zzo(zzj2));
        this.zzblk = new zzq(string2);
        zzj2 = this;
        zzj2.zzbl(0);
        zzj2.zzbll.setVerticalScrollBarEnabled(false);
        zzj2.zzbll.getSettings().setJavaScriptEnabled(true);
        zzj2.zzbll.setWebViewClient((WebViewClient)new zzm(zzj2));
        zzj2.zzbll.setOnTouchListener((View.OnTouchListener)new zzl(zzj2));
    }

    public final IObjectWrapper zzjm() throws RemoteException {
        Preconditions.checkMainThread((String)"getAdFrame must be called on the main UI thread.");
        return ObjectWrapper.wrap((Object)this.zzbll);
    }

    public final void destroy() throws RemoteException {
        Preconditions.checkMainThread((String)"destroy must be called on the main UI thread.");
        this.zzblo.cancel(true);
        this.zzblj.cancel(true);
        this.zzbll.destroy();
        this.zzbll = null;
    }

    public final boolean isReady() throws RemoteException {
        return false;
    }

    public final boolean zza(zztp zztp2) throws RemoteException {
        Preconditions.checkNotNull((Object)this.zzbll, (Object)"This Search Ad has already been torn down");
        this.zzblk.zza(zztp2, this.zzblh);
        this.zzblo = new zzn(this, null).execute(new Void[0]);
        return true;
    }

    public final void pause() throws RemoteException {
        Preconditions.checkMainThread((String)"pause must be called on the main UI thread.");
    }

    public final void resume() throws RemoteException {
        Preconditions.checkMainThread((String)"resume must be called on the main UI thread.");
    }

    public final void zza(zzur zzur2) throws RemoteException {
        this.zzblm = zzur2;
    }

    public final void zza(zzvm zzvm2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzvh zzvh2) {
        throw new IllegalStateException("Unused method");
    }

    public final Bundle getAdMetadata() {
        throw new IllegalStateException("Unused method");
    }

    public final void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void stopLoading() throws RemoteException {
    }

    public final void zzjn() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final zztw zzjo() throws RemoteException {
        return this.zzbli;
    }

    public final void zza(zztw zztw2) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public final void zza(zzand zzand2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzanj zzanj2, String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public final String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    @Nullable
    public final String zzjp() throws RemoteException {
        return null;
    }

    public final String getAdUnitId() {
        throw new IllegalStateException("getAdUnitId not implemented");
    }

    public final zzvm zzjq() {
        throw new IllegalStateException("getIAppEventListener not implemented");
    }

    public final zzur zzjr() {
        throw new IllegalStateException("getIAdListener not implemented");
    }

    public final void zza(zzzn zzzn2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzuq zzuq2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzvs zzvs2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public final boolean isLoading() throws RemoteException {
        return false;
    }

    public final void zza(zzapo zzapo2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setUserId(String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zzbm(String string2) {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public final zzwk getVideoController() {
        return null;
    }

    public final void zza(zzyc zzyc2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzwq zzwq2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zztx zztx2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzqu zzqu2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setImmersiveMode(boolean bl) {
        throw new IllegalStateException("Unused method");
    }

    @VisibleForTesting
    final int zzbn(String string2) {
        String string3 = Uri.parse((String)string2).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return 0;
        }
        try {
            zzuo.zzof();
            return zzawe.zza((Context)this.zzlk, (int)Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @VisibleForTesting
    final void zzbl(int n) {
        if (this.zzbll == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n);
        this.zzbll.setLayoutParams(layoutParams);
    }

    @VisibleForTesting
    final String zzjs() {
        String string22;
        Uri.Builder builder = new Uri.Builder();
        zzyi zzyi2 = zzyt.zzcov;
        builder.scheme("https://").appendEncodedPath((String)zzuo.zzoj().zzd(zzyi2));
        builder.appendQueryParameter("query", this.zzblk.getQuery());
        builder.appendQueryParameter("pubId", this.zzblk.zzky());
        Map<String, String> map = this.zzblk.zzkz();
        for (String string22 : map.keySet()) {
            builder.appendQueryParameter(string22, map.get(string22));
        }
        Uri uri = builder.build();
        if (this.zzbln != null) {
            try {
                uri = this.zzbln.zza(uri, this.zzlk);
            }
            catch (zzdi zzdi2) {
                zzatm.zzd((String)"Unable to process ad data", (Throwable)zzdi2);
            }
        }
        string22 = this.zzjt();
        String string3 = uri.getEncodedQuery();
        return new StringBuilder(1 + String.valueOf(string22).length() + String.valueOf(string3).length()).append(string22).append("#").append(string3).toString();
    }

    @VisibleForTesting
    final String zzjt() {
        String string2 = this.zzblk.zzkx();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "www.google.com";
        }
        String string3 = string2;
        zzyi zzyi2 = zzyt.zzcov;
        String string4 = (String)zzuo.zzoj().zzd(zzyi2);
        return new StringBuilder(8 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("https://").append(string3).append(string4).toString();
    }

    private final String zzbo(String string2) {
        if (this.zzbln == null) {
            return string2;
        }
        Uri uri = Uri.parse((String)string2);
        try {
            uri = this.zzbln.zzb(uri, this.zzlk);
        }
        catch (zzdi zzdi2) {
            zzatm.zzd((String)"Unable to process ad data", (Throwable)zzdi2);
        }
        return uri.toString();
    }

    private final void zzbp(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        this.zzlk.startActivity(intent);
    }

    static /* synthetic */ zzur zza(zzj zzj2) {
        return zzj2.zzblm;
    }

    static /* synthetic */ String zza(zzj zzj2, String string2) {
        return zzj2.zzbo(string2);
    }

    static /* synthetic */ void zzb(zzj zzj2, String string2) {
        zzj2.zzbp(string2);
    }

    static /* synthetic */ zzdf zzb(zzj zzj2) {
        return zzj2.zzbln;
    }

    static /* synthetic */ zzawv zzc(zzj zzj2) {
        return zzj2.zzblh;
    }

    static /* synthetic */ Context zzd(zzj zzj2) {
        return zzj2.zzlk;
    }

    static /* synthetic */ zzdf zza(zzj zzj2, zzdf zzdf2) {
        zzj2.zzbln = zzdf2;
        return zzj2.zzbln;
    }

    static /* synthetic */ Future zze(zzj zzj2) {
        return zzj2.zzblj;
    }

    static /* synthetic */ WebView zzf(zzj zzj2) {
        return zzj2.zzbll;
    }
}

