/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.SystemClock;
import com.google.android.gms.internal.ads.zzac;
import com.google.android.gms.internal.ads.zzad;
import com.google.android.gms.internal.ads.zzae;
import com.google.android.gms.internal.ads.zzaf;
import com.google.android.gms.internal.ads.zzag;
import com.google.android.gms.internal.ads.zzah;
import com.google.android.gms.internal.ads.zzaj;
import com.google.android.gms.internal.ads.zzap;
import com.google.android.gms.internal.ads.zzaq;
import com.google.android.gms.internal.ads.zzas;
import com.google.android.gms.internal.ads.zzaw;
import com.google.android.gms.internal.ads.zzb;
import com.google.android.gms.internal.ads.zzd;
import com.google.android.gms.internal.ads.zzh;
import com.google.android.gms.internal.ads.zzk;
import com.google.android.gms.internal.ads.zzn;
import com.google.android.gms.internal.ads.zzo;
import com.google.android.gms.internal.ads.zzp;
import com.google.android.gms.internal.ads.zzq;
import com.google.android.gms.internal.ads.zzr;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class zzak
implements zzn {
    private static final boolean DEBUG = zzag.DEBUG;
    @Deprecated
    private final zzas zzbu;
    private final zzah zzbv;
    private final zzaj zzbw;

    public zzak(zzah zzah2) {
        this(zzah2, new zzaj(4096));
    }

    private zzak(zzah zzah2, zzaj zzaj2) {
        this.zzbv = zzah2;
        this.zzbu = zzah2;
        this.zzbw = zzaj2;
    }

    @Override
    public zzo zzc(zzq<?> zzq2) throws zzae {
        long l = SystemClock.elapsedRealtime();
        while (true) {
            Object object;
            int n;
            zzap zzap2 = null;
            byte[] byArray = null;
            List<zzk> list = Collections.emptyList();
            try {
                Object object2;
                Map<String, String> map;
                Object object3 = zzq2.zze();
                if (object3 == null) {
                    map = Collections.emptyMap();
                } else {
                    object2 = new HashMap<String, String>();
                    if (((zzd)object3).zzg != null) {
                        object2.put("If-None-Match", ((zzd)object3).zzg);
                    }
                    if (((zzd)object3).zzi > 0L) {
                        object2.put((String)"If-Modified-Since", (String)zzaq.zzb(((zzd)object3).zzi));
                    }
                    map = object2;
                }
                Map<String, String> map2 = map;
                zzap2 = this.zzbv.zza(zzq2, map2);
                n = zzap2.getStatusCode();
                list = zzap2.zzo();
                if (n == 304) {
                    Object object4;
                    object = zzq2.zze();
                    if (object == null) {
                        return new zzo(304, null, true, SystemClock.elapsedRealtime() - l, list);
                    }
                    Object object5 = object;
                    object3 = list;
                    object2 = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    if (!object3.isEmpty()) {
                        object4 = object3.iterator();
                        while (object4.hasNext()) {
                            Iterator<Map.Entry<String, String>> iterator = (zzk)object4.next();
                            object2.add(((zzk)((Object)iterator)).getName());
                        }
                    }
                    object4 = new ArrayList(object3);
                    if (((zzd)object5).zzm != null) {
                        if (!((zzd)object5).zzm.isEmpty()) {
                            for (zzk zzk2 : ((zzd)object5).zzm) {
                                if (object2.contains(zzk2.getName())) continue;
                                object4.add(zzk2);
                            }
                        }
                    } else if (!((zzd)object5).zzl.isEmpty()) {
                        for (Map.Entry<String, String> entry : ((zzd)object5).zzl.entrySet()) {
                            if (object2.contains(entry.getKey())) continue;
                            object4.add(new zzk(entry.getKey(), entry.getValue()));
                        }
                    }
                    Object object6 = object4;
                    return new zzo(304, ((zzd)object).data, true, SystemClock.elapsedRealtime() - l, (List<zzk>)object6);
                }
                object = zzap2.getContent();
                byArray = object != null ? this.zza((InputStream)object, zzap2.getContentLength()) : new byte[]{};
                int n2 = n;
                byte[] byArray2 = byArray;
                object2 = zzq2;
                long l2 = SystemClock.elapsedRealtime() - l;
                if (DEBUG || l2 > 3000L) {
                    zzag.d("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", object2, l2, byArray2 != null ? Integer.valueOf(byArray2.length) : "null", n2, ((zzq)object2).zzi().zzb());
                }
                if (n < 200 || n > 299) {
                    throw new IOException();
                }
                return new zzo(n, byArray, false, SystemClock.elapsedRealtime() - l, list);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzak.zza("socket", zzq2, new zzaf());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = String.valueOf(zzq2.getUrl());
                throw new RuntimeException(string2.length() != 0 ? "Bad URL ".concat(string2) : new String("Bad URL "), malformedURLException);
            }
            catch (IOException iOException) {
                if (zzap2 == null) {
                    throw new zzr(iOException);
                }
                n = zzap2.getStatusCode();
                zzag.e("Unexpected response code %d for %s", n, zzq2.getUrl());
                if (byArray != null) {
                    object = new zzo(n, byArray, false, SystemClock.elapsedRealtime() - l, list);
                    if (n == 401 || n == 403) {
                        zzak.zza("auth", zzq2, new zzb((zzo)object));
                        continue;
                    }
                    if (n >= 400 && n <= 499) {
                        throw new zzh((zzo)object);
                    }
                    if (n >= 500 && n <= 599) {
                        throw new zzac((zzo)object);
                    }
                    throw new zzac((zzo)object);
                }
                zzak.zza("network", zzq2, new zzp());
                continue;
            }
            break;
        }
    }

    private static void zza(String string2, zzq<?> zzq2, zzae zzae2) throws zzae {
        zzad zzad2 = zzq2.zzi();
        int n = zzq2.zzh();
        try {
            zzad2.zza(zzae2);
        }
        catch (zzae zzae3) {
            zzq2.zzb(String.format("%s-timeout-giveup [timeout=%s]", string2, n));
            throw zzae3;
        }
        zzq2.zzb(String.format("%s-retry [timeout=%s]", string2, n));
    }

    private final byte[] zza(InputStream inputStream, int n) throws IOException, zzac {
        byte[] byArray;
        zzaw zzaw2 = new zzaw(this.zzbw, n);
        byte[] byArray2 = null;
        try {
            int n2;
            if (inputStream == null) {
                throw new zzac();
            }
            byArray2 = this.zzbw.zzc(1024);
            while ((n2 = inputStream.read(byArray2)) != -1) {
                zzaw2.write(byArray2, 0, n2);
            }
            byArray = zzaw2.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                zzag.v("Error occurred when closing InputStream", new Object[0]);
            }
            this.zzbw.zza(byArray2);
            zzaw2.close();
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            zzag.v("Error occurred when closing InputStream", new Object[0]);
        }
        this.zzbw.zza(byArray2);
        zzaw2.close();
        return byArray;
    }
}

