/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzamd;
import com.google.android.gms.internal.ads.zzamg;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzbbc;
import java.util.Map;

public final class zzame
extends zzamp {
    private final Map<String, String> zzcue;
    private final Context zzlk;
    private String zzdex;
    private long zzdey;
    private long zzdez;
    private String zzdfa;
    private String zzdfb;

    public zzame(zzbbc zzbbc2, Map<String, String> map) {
        super(zzbbc2, "createCalendarEvent");
        this.zzcue = map;
        this.zzlk = zzbbc2.zzxl();
        zzame zzame2 = this;
        zzame2.zzdex = zzame2.zzdl("description");
        zzame2.zzdfa = zzame2.zzdl("summary");
        zzame2.zzdey = zzame2.zzdm("start_ticks");
        zzame2.zzdez = zzame2.zzdm("end_ticks");
        zzame2.zzdfb = zzame2.zzdl("location");
    }

    private final String zzdl(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzcue.get(string2))) {
            return "";
        }
        return this.zzcue.get(string2);
    }

    private final long zzdm(String string2) {
        String string3 = this.zzcue.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.zzlk == null) {
            this.zzdn("Activity context is not available.");
            return;
        }
        zzp.zzjy();
        if (!zzatv.zzar(this.zzlk).zzpl()) {
            this.zzdn("This feature is not available on the device.");
            return;
        }
        zzp.zzjy();
        AlertDialog.Builder builder = zzatv.zzaq(this.zzlk);
        Resources resources = zzp.zzkc().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzamd(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzamg(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzdex);
        intent.putExtra("eventLocation", this.zzdfb);
        intent.putExtra("description", this.zzdfa);
        if (this.zzdey > -1L) {
            intent.putExtra("beginTime", this.zzdey);
        }
        if (this.zzdez > -1L) {
            intent.putExtra("endTime", this.zzdez);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzame zzame2) {
        return zzame2.zzlk;
    }
}

