/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzamm;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzbbc;
import java.util.Map;

public final class zzamk
extends zzamp {
    private final Map<String, String> zzcue;
    private final Context zzlk;

    public zzamk(zzbbc zzbbc2, Map<String, String> map) {
        super(zzbbc2, "storePicture");
        this.zzcue = map;
        this.zzlk = zzbbc2.zzxl();
    }

    public final void execute() {
        if (this.zzlk == null) {
            this.zzdn("Activity context is not available");
            return;
        }
        zzp.zzjy();
        if (!zzatv.zzar(this.zzlk).zzpk()) {
            this.zzdn("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzcue.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzdn("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzdn(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzp.zzjy();
        if (!zzatv.zzee(string4)) {
            String string5 = String.valueOf(string4);
            this.zzdn(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzp.zzkc().getResources();
        zzp.zzjy();
        AlertDialog.Builder builder = zzatv.zzaq(this.zzlk);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzamj(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzamm(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzamk zzamk2) {
        return zzamk2.zzlk;
    }
}

